/***************************************************************************
**
**  Name: trigdlg.c
**
**  Description: This is a setting dialog box
**
**  Status: PRELIMINARY
**
**  $Log:   S:/tbird/mt2_amd/trace/trigdlg.c_v  $
** 
**    Rev 1.0   20 Mar 1998 11:00:02   Eric
** Initial revision.
** 
**    Rev 1.1   27 May 1997 15:29:06   Judy
** No change.
** 
**    Rev 1.0   16 Dec 1996 15:25:28   Judy
** Initial revision.
** 
**    Rev 1.0   27 Aug 1996 15:23:10   Judy
** Initial revision.
** 
**    Rev 1.0   27 Aug 1996 14:55:48   Judy
** Initial revision.
** 
**    Rev 1.0   14 Jun 1996 17:04:54   Judy
** Initial revision.
** 
**    Rev 1.0   14 Mar 1995 13:19:12   kevin
** Initial revision.
**
**  $Header:   S:/tbird/mt2_amd/trace/trigdlg.c_v   1.0   20 Mar 1998 11:00:02   Eric  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef __STRING_H
#include <string.h>
#endif

#ifndef __COMMDLG_H
#include <commdlg.h>
#endif

#ifndef __DLGS_H
#include <dlgs.h>
#endif

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _TRIGDLG_
#include "trigdlg.h"
#endif


                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
extern HANDLE hInst;
extern DESCRIPTOR trigId;
RETCODE EXPORT TrigExtEventSet(DESCRIPTOR id, U8 bitNo, BOOLEAN enable);
RETCODE EXPORT TrigExtEventGet(DESCRIPTOR id, U8 *bitNo, BOOLEAN *enable);
                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

BOOL FAR PASCAL DlgExtSettingProc(HWND, UINT, WPARAM, LPARAM);
RETCODE PRIVATE bDialog(HWND, U16, FARPROC, DWORD);
RETCODE PRIVATE ResAddStrings(HWND, U16, U16, LPSTR, ...);
RETCODE PRIVATE ResSetDefault(HWND, U16, U16);

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/**************************************************************************
**
**  TrigExtSettingDlg
**
***************************************************************************/
RETCODE EXPORT TrigExtSettingDlg(HWND hWnd)
{
   return(bDialog(hWnd, IDD_EXTSETTING, (FARPROC) DlgExtSettingProc, NULL));
}

/**************************************************************************
**
**  DlgExtSettingProc
**  Description: the main function for trig presenter to deal with messages
**
**  hDlg    (in): handle of the dialog box
**  message (in): window message
**  wParam  (in): depends on window message
**  lParam  (in): depends on window message
**
***************************************************************************/
BOOL FAR PASCAL DlgExtSettingProc(HWND hDlg, UINT message,
                                  WPARAM wParam, LPARAM lParam)
{
   BOOLEAN bRetCode;
   U8      bitNo;
   BOOLEAN state;

   bRetCode = TRUE;
   switch (message) {
      case WM_INITDIALOG:
         EnableWindow(GetDlgItem(hDlg, IDC_BITNUMBER), TRUE);
         EnableWindow(GetDlgItem(hDlg, IDC_STATE), TRUE);
         ResAddStrings(hDlg, CB_ADDSTRING, IDC_BITNUMBER,
                       "Bit 0", "Bit 1", "Bit 2", "Bit 3",
                       "Bit 4", "Bit 5", "Bit 6", "Bit 7");
         ResAddStrings(hDlg, CB_ADDSTRING, IDC_STATE,
                       "Low", "High");
         TrigExtEventGet(trigId, &bitNo, &state);
         if (bitNo != 0xFF) {
            CheckRadioButton(hDlg, IDC_SELSET, IDC_SELCLEAR, IDC_SELSET);
            ResSetDefault(hDlg, IDC_BITNUMBER, bitNo);
            ResSetDefault(hDlg, IDC_STATE, state);
         }
         else {
            CheckRadioButton(hDlg, IDC_SELSET, IDC_SELCLEAR, IDC_SELCLEAR);
            EnableWindow(GetDlgItem(hDlg, IDC_BITNUMBER), FALSE);
            EnableWindow(GetDlgItem(hDlg, IDC_STATE), FALSE);
         }
         break;
      case WM_COMMAND:
         switch (wParam) {
            case IDOK:
               if (SendDlgItemMessage(hDlg, IDC_SELSET, BM_GETCHECK,
                  NULL, NULL) != (DWORD)0) {
                  bitNo = (U8) SendDlgItemMessage(hDlg, IDC_BITNUMBER, 
                     CB_GETCURSEL, NULL, NULL);
                  state = (BOOL) SendDlgItemMessage(hDlg, IDC_STATE,
                     CB_GETCURSEL, NULL, NULL);
               }
               else {
                  bitNo = 0xFF;
               }
               TrigExtEventSet(trigId, bitNo, state);
               EndDialog (hDlg, wParam);
               break;
            case IDCANCEL:
               EndDialog (hDlg, wParam);
               break;
            case IDC_SELSET:
               EnableWindow(GetDlgItem(hDlg, IDC_BITNUMBER), TRUE);
               EnableWindow(GetDlgItem(hDlg, IDC_STATE), TRUE);
               TrigExtEventGet(trigId, &bitNo, &state);
               if (bitNo != 0xFF) {
                  CheckRadioButton(hDlg, IDC_SELSET, IDC_SELCLEAR, IDC_SELSET);
                  ResSetDefault(hDlg, IDC_BITNUMBER, bitNo);
                  ResSetDefault(hDlg, IDC_STATE, state);
               }
               else {
                  ResSetDefault(hDlg, IDC_BITNUMBER, 0);
                  ResSetDefault(hDlg, IDC_STATE, 0);
               }
               break;
            case IDC_SELCLEAR:
               EnableWindow(GetDlgItem(hDlg, IDC_BITNUMBER), FALSE);
               EnableWindow(GetDlgItem(hDlg, IDC_STATE), FALSE);
               break;
            default:
                bRetCode = FALSE;
               break;
         }
          break;
      default:
          bRetCode = FALSE;
   }
   return(bRetCode);   // have done something if TRUE
}

/**************************************************************************
**
**  bDialog
**
**  hDlg   (in): handle of the dialog box
**  nDlgID (in): ID of the dialog box
**  fpProc (in): message processor of the dialog
**  lParam (in): long parameter for the dialog
**
***************************************************************************/
RETCODE PRIVATE bDialog(HWND hWnd, U16 nDlgID, FARPROC fpProc, DWORD lParam)
{
   BOOLEAN bRetCode;
   FARPROC fpFunction;

   fpFunction = MakeProcInstance(fpProc, hInst);
   bRetCode = DialogBoxParam(hInst, MAKEINTRESOURCE(nDlgID), hWnd, 
                             fpFunction, lParam);
   FreeProcInstance(fpFunction);
   if (bRetCode)
      return(GOOD);
   else
      return(!GOOD);
}


/**************************************************************************
**
**  ResAddStrings
**
**  Purpose: add strings into combo box
**
**  hDlg    (in): handle of the dialog box
**  uMsg    (in): control message
**  nCltID  (in): ID of item
**  lpszStr (in): list of strings
**
***************************************************************************/
RETCODE PRIVATE ResAddStrings(HWND hDlg, U16 uMsg, U16 nCltID,
                              LPSTR lpszStr, ...)
{
   HWND hItem;
   U16  i;

   hItem = GetDlgItem(hDlg, nCltID);
   for (i=0; lstrlen(*(&lpszStr+i)); i++)
      SendMessage(hItem, uMsg, NULL, (LPARAM)*(&lpszStr+i));
   return (GOOD);
}

/**************************************************************************
**
**  ResSetDefault
**
**  Purpose: set the default item for a combo box
**
**  hDlg   (in): handle of the dialog box
**  uMsg   (in): control message
**  nCltID (in): ID of item
**  nSel   (in): specified item
**
***************************************************************************/
RETCODE PRIVATE ResSetDefault(HWND hDlg, U16 nCltID, U16 nSel)
{
   SendDlgItemMessage(hDlg, nCltID, CB_SETCURSEL, (WPARAM)nSel, NULL);

   return (GOOD);
}

/******************************** E O F ***********************************/
