/*****************************************************************************
** Name:  textgen.h
**
** Description:
**    Routines to access the CLI for the variable server.
**
** Status:   PRELIMINARY
**
** $Log:   S:/tbird/mt2_amd/varsrv/textgen.h_v  $
** 
**    Rev 1.0   20 Mar 1998 10:35:20   Eric
** Initial revision.
** 
**    Rev 1.0   16 Dec 1996 14:48:10   Judy
** Initial revision.
** 
**    Rev 1.3   12 May 1993 16:35:46   ron
** variable window enhancements: pass position of edit text
** 
**    Rev 1.2   28 May 1992 16:39:36   marilyn
** Added parameter frameNum to GetFormattedType.
** 
**    Rev 1.1   17 Apr 1992 16:22:06   marilyn
** Moved prototype of MakeCompositeVarName from textgen.c
** 
**    Rev 1.0   23 Mar 1992 11:02:48   marilyn
** Initial revision.
** 
** $Header:   S:/tbird/mt2_amd/varsrv/textgen.h_v   1.0   20 Mar 1998 10:35:20   Eric  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _TEXTGEN_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _VARSERVR_
#include "varservr.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/


                       /****************************
                        *                          *
                        *   EXTERNAL PROTOTYPES    *
                        *                          *
                        ****************************/

RETCODE GetFormattedType(DESCRIPTOR rootVarId,
                      STRING *textptr,
                      U32 linesForThisBuf,
                      U32 startLine,
                      DESCRIPTOR bufferNum,
                      U8 frameNum);


RETCODE GetCharSetBuf(DESCRIPTOR VSVarId,
                      DESCRIPTOR bufferNum,
                      U16 lineNum,
                      U16 *fieldWidth,
                      U16 startCol);

RETCODE  EditValueField(DESCRIPTOR varId,
                        DESCRIPTOR bufferNum,
                        U16 lineNum,
                        U16 editFieldCharOffset,
                        LPSTR newValueText,
                        VS_DISPLAY_PTR *displayBufPtr);


/******************************** E O F ***********************************/
