/**************************************************************************
**
**  Name:  emucomm.c
**
**  Description:
**     Michelle command or data communication routines( UART ).
**     include:
**
**  Status:  preliminary
**
**    Rev 1.0   10 May 1996 10:06:04   jacky
** Get file from ATL. V1.3
** 
** Initial revision.
**
**  $Header:   S:/tbird/arcmtat2/am186/emucomm.c_v   1.0   20 Mar 1998 09:20:52   Eric  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
***************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _EMU_COMM_
#include "emucomm.h"
#endif

#ifndef _EMU_LIB_
#include "emulib.h"
#endif

#ifndef _EMU_EXTERNAL_
#include "emuext.h"
#endif

#ifndef _COMM_DATA_
#include "commdata.h"
#endif

#ifndef _LLFW_
#include "emullfw.h"
#endif

#include <conio.h>
#include <string.h>

VOID SPAHandleStatus(U16 runMode);
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
#define CR             0x0D
#define LF             0x0A
#define LEAD_CODE      ':'
#define DMA0TC         0xffc8
#define IMASK          0Xff28  // Interrupt Mask Register
#define EOI            0Xff22  // End-of-Interrupt Register
#define RBR            0Xf000  // UART port
#define IER            0Xf001
#define IIR            0xf002
#define MCR            0Xf004
#define LSR            0Xf005
#define MSR            0Xf006
#define T0CNT          0Xff50
#define T2CNT          0Xff60
#define enUartRxInt()  outp(IER,1)
#define enUartTxInt()  outp(IER,2)
#define disCpExt1Int()  outp(IMASK,((U8)inp(IMASK)|0X20))
#define enCpExt1Int() outp(IMASK,((U8)inp(IMASK)&0XDF))
#define enCpExt1_TimeInt()      outp(IMASK,((U8)inp(IMASK)&0XDE))
#define disUartInt()   outp(IER,0)
#define RejRxData()    outp(MCR,0)
#define ReadyRxData()  outp(MCR,1)
#define InitUart()     inp(MSR);\
                       inp(LSR);\
                       outpw(EOI,0x8000);\
                       inp(IIR)

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

static U8 *inBufadr;
                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                         /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/
/****************************************************************************
**  ReceiveByte
**  Description: Receive one byte from communication.
**  Parameters:
**     input:
**     output: data from inBuf
*****************************************************************************/
// U8 ReceiveByte(VOID) ;

/****************************************************************************
**  TransmitByte
**  Description: Transmit one byte from communication.
**  Parameters:
**     input:
**     output:
*****************************************************************************/
// VOID TransmitByte(U8 c) ;

/****************************************************************************
**
**  WaitStringEnd
**
**  Description: Wait for the end of the command string and put data into
**               inBuf.
**
**  Parameters:
**     input:
**     output:clear DTR
**
*****************************************************************************/

VOID WaitStreamEnd(VOID)
{
U8 ch;
//U8 *chptr;
static U8 i;
   i= 0 ;
   for(;;) {
          SetWatchDog(5) ;
          ch=ReceiveByte();
          HltWatchDog();
          if (timeOut)  {
             return;
          }
    } // for(;;)
}
/****************************************************************************
**
**  ReceiveStream
**
**  Description: Receive data from communication and check the length and
**               checksum, the data format is :       XXXXxxx....xxxX
**                                                  length   data   checksum
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
VOID ReceiveStream(VOID) {
U8 mice[4] = {'M','I','C','E'};
static U8 aa[4],checksum;
static U16 len;
//register lp;
static U16 lp;
U16 runMode;
U8  RxErr  ;
//   inBufadr=(U8 *)&inBuf;
   dwnldfwfg=timeOut=0;
   RxErr = FALSE ;


   for (;;) {
      if ( RxErr == TRUE ) {         // do it ,if err occur in loop
         WaitStreamEnd();
         TransmitByte(NACK);
         RxErr = FALSE ;
      }
      AccessIceFlag(READ_ONE,MODE_FLAG,&runMode);
      timeOut = 0 ;
      checksum= 0 ;
      if ((runMode == SPA_MA_RUN) || (runMode == SPA_TA_RUN) ||
          (runMode == SPA_CC_RUN) ) {
            SetWatchDog(5);
            aa[0] =ReceiveByte();
            HltWatchDog();
            if (timeOut){
                SPAHandleStatus(runMode);
                continue;
            }
            if ((aa[0]!=':') && (aa[0]!='M')) //goto RxError;
                { RxErr = TRUE ; continue ; }
      }
      else {
            aa[0] = ReceiveByte();
            if ((aa[0]!=':') && (aa[0]!='M')) //goto RxError;
               { RxErr = TRUE ; continue ; }

      };

     // above will receive one byte and put into a[0] , =======

      if (aa[0]==':') {

         for (lp =1; lp < 4; lp++)   {

             SetWatchDog( 40 );
             aa[lp] = ReceiveByte();
             HltWatchDog();

             checksum += aa[lp];
             if( timeOut )   // goto RxError;
                break ;
         };
         if ( timeOut || checksum || ( (len = *(U16 *)&aa[1]) > MAX_BUF_SIZE) )
             { RxErr = TRUE ; continue ; }

      } //if (aa[0]==':')

      if (aa[0] == 'M') {
         SetWatchDog( 40*3 );
         if ((aa[1]=ReceiveByte())!='I') //goto RxError;
              { RxErr = TRUE ; continue ; }
         if ((aa[2]=ReceiveByte())!='C') //goto RxError;
              { RxErr = TRUE ; continue ; }
         if ((aa[3]=ReceiveByte())!='E') //goto RxError;
              { RxErr = TRUE ; continue ; }
         HltWatchDog();

         TransmitByte(LEAD_CODE);
         continue;                      // RxErr = FALSE
      };

      for (lp = 0; (U16)lp < len; lp++)  {
         SetWatchDog(40);
         commandStream[lp] = ReceiveByte();
         HltWatchDog();
         checksum += commandStream[lp];
         if ( timeOut ) //goto RxError;
                break ;
      };

      if ( timeOut )  { RxErr = TRUE ; continue ; }

      if ( !checksum )  {              // checksum = 0 ?
            TransmitByte(ACK);
            commandStreamLen = len;
            return;
      }
      else
      {
//            TransmitByte(NACK);
            RxErr = TRUE ; continue ;
      }
   } //for (;;)
}


/****************************************************************************
**
**  TransmitStream
**
**  Description: Transmit data(length + data + checksum) to
**               communication port.
**               the data format is :  XXXXxxx....xxxX
**                                   length   data   checksum
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
/*
   Transmit data(length + data + checksum) to communication port.
   the data format is : LENGTH(2 bytes)DATA(number of length)CHECKSUM(1 byte)
*/
VOID TransmitStream(VOID) {
//register lp;
static U16 lp;
//static U32 lpcnt;
U8 highLen,lowLen,aa,trchecksum;
//U8 finalFlag,ch;

   trchecksum = 0;
   for (lp = 0; (U16)lp < (U16)outputStreamLen; lp++)
      trchecksum += outputStream[lp];
   outputStream[outputStreamLen] = (U8)((~trchecksum)+1);
   outputStreamLen++;

   lowLen = LowByte(outputStreamLen);
   highLen = HighByte(outputStreamLen);
   trchecksum = (U8)((~(lowLen+highLen)) + 1);

   for (;;) {
      TransmitByte(LEAD_CODE);
      TransmitByte(lowLen);
      TransmitByte(highLen);
      TransmitByte(trchecksum);
      for (lp = 0; (U16)lp < (U16)outputStreamLen; lp++) {
          TransmitByte(outputStream[lp]);
      }
      SetWatchDog( 0x96 );   // 9*16+6 = 150
      aa = ReceiveByte();
      HltWatchDog();

      if ( timeOut || (aa== NACK) )
                continue ;
      return ;

   }    // for (;;)
}
/********************************* EOF *************************************/
