/***************************************************************************
**
**  Name:  emuemul.c
**
**  Description:
**     Michelle emulation-group routines.
**     include:
**     "Read/write registers",
**     "Reset the emulator",
**     "Instruction step(s)"
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcmtat2/am186/emuemul.c_v  $
** 
**    Rev 1.0   20 Mar 1998 09:20:52   Eric
** Initial revision.
** 
**    Rev 1.0   03 Dec 1996 09:27:32   gene
** Initial revision.
**
**    Rev 1.0   10 May 1996 10:05:38   jacky
** Get file from ATL. V1.3
** 
** 
**  $Header:   S:/tbird/arcmtat2/am186/emuemul.c_v   1.0   20 Mar 1998 09:20:52   Eric  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _TRCTMAN_
#include "trctman.h"
#endif

#ifndef _EMU_EMUL_
#include "emuemul.h"
#endif

#ifndef _EMU_TRACE_
#include "emutrace.h"
#endif

#ifndef _EMU_LLFW_
#include "emullfw.h"
#endif

#ifndef _EMU_EXTERNAL_
#include "emuext.h"
#endif

#include <string.h>
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
enum SPEC_INST {PUSHF = 0x9c, CLI = 0xfa, STI = 0xfb, IRET = 0xcf, POPF = 0x9d, INT3 = 0xcc};
                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/
                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/



/***************************************************************************
**
**  CheckInst
**
**  Description:
**
**
**
**  Parameters:
**     input:
**        none
**
**     output:
**
**
****************************************************************************/
U16 CheckInst(U16 cs, U16 ip) {
U16 i86Reg[MAX_CPU_REG_NO];
U8 buff[32];

   //addr = cs;
   //addr = (addr << 16) + ip;
   StopRun();
   AccessCpuReg(READ_ALL,noUse,i86Reg);
   DumpByteMem(ip,cs,(U32)1,buff,ON);
   AccessCpuReg(WRITE_ALL,noUse,i86Reg);
   return((U16)buff[0]);
}

/***************************************************************************
**
**  RecoverSpData
**
**  Description:
**
**
**
**  Parameters:
**     input:
**        none
**
**     output:
**
**
****************************************************************************/
VOID RecoverSpData(U16 instType, U16 ss, U16 sp, U16 oldSp, U16 intFlag) {
STATUS status;
U16 i86Reg[MAX_CPU_REG_NO];
U8 buff[32];

   status = GOOD;
   //addr = ss;
   //addr = (addr << 16) + sp;
   StopRun();
   AccessCpuReg(READ_ALL,noUse,i86Reg);
   switch (instType) {
      case PUSHF :
         DumpByteMem(sp+1,ss,(U32)1,buff,ON);
         buff[0] &= 0xfe;
         if (intFlag) buff[0] |= 2;
         else buff[0] &= 0xfd;
         status = FillByteMem(sp+1,ss,(U32)1,1,buff,OFF,ON);
         break;
      case INT3 :
         DumpByteMem(sp+5,ss,(U32)1,buff,ON);
         buff[0] &= 0xfe;
         status = FillByteMem(sp+5,ss,(U32)1,1,buff,OFF,ON);
   }
   AccessCpuReg(WRITE_ALL,noUse,i86Reg);
}


/***************************************************************************
**
**  EmuReset
**
**  Description: Michelle reset routine, to reset the CPU and set the
**               certain important registers to be default values.
**               such as "PC", "SP" ....
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
**
****************************************************************************/
VOID EmuReset(VOID) {
STATUS vccFlag,brokeReason;
U16 baseReg[MAX_BASE_REG_NO],traceing;
U32 cnt0,cnt1;
U16 tmpCnt;

   vccFlag = GOOD;
   if (!CheckEpStop()) {
      brokeReason = BROKE;
      AccessBaseReg(READ_ALL,noUse,baseReg);
      GoEnd(baseReg);
      AccessBaseReg(WRITE_ALL,noUse,baseReg);
      AccessIceFlag(WRITE_ONE,RUNNING,&C_OFF);
      AccessIceFlag(WRITE_ONE,FLYING,&C_OFF);
      AccessIceFlag(WRITE_ONE,BROKE_REASON,&brokeReason);
      AccessIceFlag(READ_ONE,TRACEING,&traceing);
      if (mtatExist && traceing) {
         ReadTimerCounter(&cnt0,&cnt1);
         tmpCnt = LowWord(cnt1);
         AccessIceFlag(WRITE_ONE,CNT1_LOW,&tmpCnt);
         tmpCnt = HighWord(cnt1);
         AccessIceFlag(WRITE_ONE,CNT1_HIGH,&tmpCnt);
         tmpCnt = LowWord(cnt0);
         AccessIceFlag(WRITE_ONE,CNT0_LOW,&tmpCnt);
         tmpCnt = HighWord(cnt0);
         AccessIceFlag(WRITE_ONE,CNT0_HIGH,&tmpCnt);
         AccessIceFlag(WRITE_ONE,TRACEING,&C_OFF);
//         AccessIceFlag(WRITE_ONE,TRACED_BUFF_NO,&traceBufNo);
      }
   }
   //EmuAbort();

   vccFlag = Reset(baseReg);
   AccessBaseReg(WRITE_ALL,noUse,baseReg);

   if(vccFlag != GOOD) {
      AccessSignals(CLEAR_ALL,noUse,&noUse);
      OutputStatus(NO_VCC,ON);
   }
   else OutputStatus(vccFlag,ON);
}


/***************************************************************************
**
**  EmuGetCopRegs
**
**  Description: Michelle Emulation routine, to get values of all registers.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
****************************************************************************/
/*VOID EmuGetAllCoReg(VOID) {
U8 dataLen;
U16 *regPtr;

   StopRun();
   regPtr = r187Buf;
   Get187Reg();
   if (exceptBreak == GOOD) {
      OutputStatus(GOOD,OFF);
      dataLen = 14;  //each register length 
      OutData(dataLen,regPtr,ON);
      regPtr += 7;
      dataLen = 80; // each register length 
      OutData(dataLen,regPtr,ON);
      OutEnd();
   }
   else OutputExceptReason(ON);
}
*/
/***************************************************************************
**
**  EmuGeIntRegs
**
**  Description: Michelle Emulation routine, to get values of all registers.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
****************************************************************************/
U16 far intRegHead[16] =
{ 0xff00, 0xff10, 0xff20, 0xff30, 0xff40, 0xff50, 0xff60, 0xff70,
  0xff80, 0xff90, 0xffa0, 0xffb0, 0xffc0, 0xffd0, 0xffe0, 0xfff0};

U16 far xlEaIntRegPos[16] =
{      0,      0,   0xfa,   0xff,      0,   0xff,   0x0b,      0,
       0,      0,   0x01,      0,   0x3f,   0x3f,   0x07,   0x81};

U16 far xlEaIntRegPosSlave[16] =
{      0,      0,   0xfb,   0x3f,      0,   0xff,   0x0b,      0,
       0,      0,   0x01,      0,   0x3f,   0x3f,   0x07,   0x81};

U16 far ebIntRegPos[16] =
{   0xfa,   0xff,      0,   0xff,   0x0b,   0xff,   0x3f,   0x3f,
    0xff,   0xff,   0x1f,   0x5f,      0,      0,      0,      0};

U16 far ecIntRegPos[16] =
{   0xef,      0,   0x0f,   0xff,   0x0b,   0xff,   0x3f,   0x3f,
    0xff,   0xff,   0x1f,   0x7f,   0xff,   0x3f,   0x3f,   0x3f};

U16 far *locHead;
U16 far *locPos;
U8 far bitPos = 1;
VOID EmuGetAllIntReg(VOID) {
STATUS status;
U16 *intRegPtr,intReg[128],i86Reg[MAX_CPU_REG_NO];
U16 timerFlag,lp,timeValue,phyCpu;
U8 dataLen;

   StopRun();
   status = GOOD;
   intRegPtr = &intReg[0];
   locHead = intRegHead;
   AccessCpuReg(READ_ALL,noUse,i86Reg);
   IntRegister(0xfff0,0,0x80,intRegPtr); // read RELREG register
   AccessCpuReg(WRITE_ALL,noUse,i86Reg);
   AccessIceFlag(READ_ONE,PHY_CPU_TYPE,&phyCpu);
   switch (phyCpu) {
       case XL_EA :
          if (intRegPtr[7] & 0x4000) locPos = xlEaIntRegPosSlave;
          else locPos = xlEaIntRegPos;
          break;
       case EB :
          locPos = ebIntRegPos;
          break;
       case EC :
          locPos = ecIntRegPos;
          break;
       default :
          locPos = xlEaIntRegPos;
          break;
   }
   AccessCpuReg(READ_ALL,noUse,i86Reg);
   for (lp = 0; lp < 16; lp++) {
      if (locPos[lp]) IntRegister(locHead[lp],0,locPos[lp],intRegPtr);
      intRegPtr += 8;
   }
   AccessCpuReg(WRITE_ALL,noUse,i86Reg);
   AccessIceFlag(READ_ONE,TIMER_FLAG,&timerFlag);
   if (timerFlag < 3) {
      AccessBaseReg(READ_ONE,timerFlag+MAX_BASE_REG_NO,&timeValue);
      switch (timerFlag) {
         case 0:
            intReg[0x2b] = timeValue; // timer 0
            break;
         case 1:
            intReg[0x2f] = timeValue;// timer 1
            break;
         case 2:
            intReg[0x33] = timeValue;// timer 2
      }
   }

   if (exceptBreak == GOOD) {
      status = status & 0x00ff;
      OutputStatus(status,OFF);
      if (status == OK) {
         dataLen = 128;
         OutMultipleData(dataLen,intReg,2);
      }
      OutEnd();
   }
   else OutputExceptReason(ON);
}

/***************************************************************************
**
**  EmuGetAllRegs
**
**  Description: Michelle Emulation routine, to get values of all registers.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
****************************************************************************/
VOID EmuGetAllReg(VOID) {
STATUS status;
U16 i86Reg[MAX_CPU_REG_NO];
U8 dataLen;


   status = GOOD;
   StopRun();
   status = AccessBaseReg(READ_ALL,noUse,i86Reg);
   status = AccessCpuReg(READ_ALL,noUse,&i86Reg[BASE_REG_NO]);

   if (exceptBreak == GOOD) {
      status = status & 0x00ff;
      OutputStatus(status,OFF);
      if (status == OK) {
         dataLen = MAX_CPU_REG_NO * 2; /* each register length */
         OutData(dataLen,i86Reg,ON);
      }
      OutEnd();
   }
   else OutputExceptReason(ON);
}

/***************************************************************************
**
**  EmuGetReg
**
**  Description: Michelle Emulation routine, to get values of all registers.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
****************************************************************************/
VOID EmuGetReg(REG_MODE regMode,U16 regId) {
STATUS status;
U16 regValue,phyCpu;
U8 dataLen;

   status = GOOD;
   StopRun();
   /* Maybe add InitLam function */
   switch (regMode) {
      case I86_REG :
         switch (regId) {
            case R_CS :
            case R_IP :
            case R_SS :
            case R_SP :
            case R_FS :
               status = AccessBaseReg(READ_ONE,regId,&regValue);
               break;
            default :
               status = AccessCpuReg(READ_ONE,regId,&regValue);
         }
         break;
      case INTERNAL_REG :
         AccessIceFlag(READ_ONE,PHY_CPU_TYPE,&phyCpu);
         switch (phyCpu) {
           case EB :
           case EC :
              if ((regId == B_T0CON) && (stpTimFlg == STOP_TIMER0))
                 AccessBaseReg(READ_ONE,R_TIMER0,&regValue);
              else if ((regId == B_T1CON) && (stpTimFlg == STOP_TIMER1))
                 AccessBaseReg(READ_ONE,R_TIMER1,&regValue);
              else if ((regId == B_T2CON) && (stpTimFlg == STOP_TIMER2))
                 AccessBaseReg(READ_ONE,R_TIMER2,&regValue);
              else AccessInternalReg(READ_ONE,regId,&regValue);
              break;
           case XL_EA :
           default :
              if ((regId == T0CON) && (stpTimFlg == STOP_TIMER0))
                 AccessBaseReg(READ_ONE,R_TIMER0,&regValue);
              else if ((regId == T1CON) && (stpTimFlg == STOP_TIMER1))
                 AccessBaseReg(READ_ONE,R_TIMER1,&regValue);
              else if ((regId == T2CON) && (stpTimFlg == STOP_TIMER2))
                 AccessBaseReg(READ_ONE,R_TIMER2,&regValue);
              else AccessInternalReg(READ_ONE,regId,&regValue);
         }
         break;
      default :
         status = UNKNOWN_TYPE;
   }
   if (exceptBreak == GOOD) {
      status = status & 0x00ff;
      OutputStatus(status,OFF);
      if (status == OK) {
         dataLen = sizeof(regValue);
         OutData(dataLen,&regValue,ON);
      }
      outputStream[outputStreamLen++] = 0x00; /* Output stream length */
      OutEnd();
   }
   else OutputExceptReason(ON);
}

/***************************************************************************
**
**  EmuSetReg
**
**  Description: Michelle Emulation routine, to step certain step(s).
**
**  Parameters:
**     input:
**        reg_id -- integer,
**        value  -- unsigned integer,
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
****************************************************************************/
VOID EmuSetReg(REG_MODE regMode, U16 regId, U16 value) {
STATUS status;

   status = GOOD;
   StopRun();
   switch (regMode) {
      case I86_REG :
         switch (regId) {
            case R_CS :
            case R_IP :
            case R_SS :
            case R_SP :
            case R_FS :
               status = AccessBaseReg(WRITE_ONE,regId,&value);
               break;
            default :
               status = AccessCpuReg(WRITE_ONE,regId,&value);
         }
         break;
      case INTERNAL_REG :
         if ((regId == T0CON) && (stpTimFlg == STOP_TIMER0))
            AccessBaseReg(WRITE_ONE,R_TIMER0,&value);
         else if ((regId == T1CON) && (stpTimFlg == STOP_TIMER1))
            AccessBaseReg(WRITE_ONE,R_TIMER1,&value);
         else if ((regId == T2CON) && (stpTimFlg == STOP_TIMER2))
            AccessBaseReg(WRITE_ONE,R_TIMER2,&value);
         else status = AccessInternalReg(WRITE_ONE,regId,&value);
         break;
      default :
         status = UNKNOWN_TYPE;
   }
   if (exceptBreak == GOOD) {
      status = status & 0x00ff;
      OutputStatus(status,ON);
   }
   else OutputExceptReason(ON);
}


/****************************************************************************
**
**  EmuGetCoReg
**
**  Description: Michelle emulation routine, to get values of all registers.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
*****************************************************************************/
/*VOID EmuGetCoReg(U16 regId) {
U8 regLen,dataLen;
U16 *regPtr,regData[5];

   StopRun();
   if (regId < ST0) {
      regLen = 2;
      regPtr = &r187Buf[regId];
   }
   else {
      regLen = 10;
      regPtr = r187Buf + 7 + (regId-ST0)*5;
   }
   Get187Reg();
   memcpy(regData,regPtr,regLen);

   if (exceptBreak == GOOD) {
      OutputStatus(GOOD,OFF);
      dataLen = regLen;
      OutData(dataLen,regData,ON);
      OutEnd();
   }
   else OutputExceptReason(ON);
}
*/
/****************************************************************************
**
**  EmuSetCoReg
**
**  Description: Michelle emulation routine, to step certain step(s).
**
**  Parameters:
**     input:
**        regId  --
**        value  --
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
*****************************************************************************/
/*VOID EmuSetCoReg(U16 regId, U16 *value){

   StopRun();
   if (regId < ST0) r187Buf[regId] = *value;
   else memcpy(r187Buf+7+(regId-ST0)*5,value,10);
   Set187Reg();

   if (exceptBreak == GOOD) OutputStatus(GOOD,ON);
   else OutputExceptReason(ON);
}
*/
/***************************************************************************
**
**  StepOne
**
**  Description: Michelle Emulation routine, to execute a instruction
**
**
**  Parameters:
**     input:
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
****************************************************************************/
STATUS StepOne(VOID) {
STATUS instType;
U16 baseReg[MAX_BASE_REG_NO],oldSp,signals,intFlag;

   ClrViolFlg();
   EnEmDisViol();
   AccessBaseReg(READ_ALL,noUse,baseReg);
   AccessSignals(READ_ALL,noUse,&signals);
   AccessSignals(WRITE_ONE,S_NMI,&C_OFF);
   intFlag = baseReg[R_FS] & INTERRUPT_FLAG;
   baseReg[R_FS] &= (~INTERRUPT_FLAG); // disable interrupt flag.

   oldSp = baseReg[R_SP];

   instType = CheckInst(baseReg[R_CS],baseReg[R_IP]);
   InstructionStep(baseReg);
   switch (instType) {
      case PUSHF :
      case INT3 :
         RecoverSpData(instType,baseReg[R_SS],baseReg[R_SP],oldSp,intFlag);
         baseReg[R_FS] |= intFlag;
         break;
      case CLI :
      case STI :
      case IRET :
      case POPF :
         // do nothing.
         break;
      default :
         baseReg[R_FS] |= intFlag;
   }
   AccessBaseReg(WRITE_ALL,noUse,baseReg);
   AccessSignals(WRITE_ALL,noUse,&signals);
   DisEmStop();

   return(CheckViolation());
}

/***************************************************************************
**
**  EmuStepRange
**
**  Description: Michelle Emulation routine, to execute instruction
**               from addr1 to addr2.
**
**  Parameters:
**     input:
**        addr1 -- unsigned long,
**        addr2 -- unsignde long
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
****************************************************************************/
VOID EmuStepRange(U32 addr1,U32 addr2) {
STATUS status;
U16 baseReg[MAX_BASE_REG_NO];
U32 pc,phyAddr1,phyAddr2;


   status = GOOD;
   phyAddr2 = LinearToPhysical(addr2);
   phyAddr1 = LinearToPhysical(addr1);
   if (phyAddr1 == phyAddr2) status = StepOne();
   else {
      pc = LinearToPhysical(addr1);
      while ( (pc <= phyAddr2) && (pc >= phyAddr1) ) {
         status = StepOne();
         AccessBaseReg(READ_ALL,noUse,baseReg);
         pc = ((U32)baseReg[R_CS] << 4) + (U32)baseReg[R_IP];
	 if ((exceptBreak) || (status)) break;
      }
   }
   if (exceptBreak == GOOD) OutputStatus(status,ON);
   else OutputExceptReason(ON);
}
/******************************** E O F ***********************************/

