/****************************************************************************
**
**  Name:  emuport.h
**
**  Description:
**     Michelle setup-group routines.
**     include:
**        "emuInput" and "emuOutput" to use the I/O ports.
**
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcmtat2/am186/emuport.h_v  $
** 
**    Rev 1.0   20 Mar 1998 09:20:56   Eric
** Initial revision.
** 
**    Rev 1.0   03 Dec 1996 09:27:44   gene
** Initial revision.
** 
**    Rev 1.0   10 May 1996 10:02:58   jacky
** Get file from ATL. V1.3
** 
** Initial revision.
** 
**  $Header:   S:/tbird/arcmtat2/am186/emuport.h_v   1.0   20 Mar 1998 09:20:56   Eric  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
*****************************************************************************/

#define _EMU_PORT_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif

#include <string.h>

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/


/****************************************************************************
**
**  EmuInput()
**
**  Description: Michelle input routine,
**
**  Parameters:
**     input:
**        port -- unsigned int
**
**     output:
**        return status code(error-code) in to the output processor.
**        return data -- "length" + "data"
**
*****************************************************************************/
VOID  EmuInput(U16 port, U16 len, U16 size);


/****************************************************************************
**
**  EmuOutput
**
**  Description: Michelle output routine,
**
**  Parameters:
**     input:
**        port  -- unsigned int,
**        value -- unsigned int
**
**     output:
**        return status code(error-code) in to the output processor.
**        -- O.K. for Normal return
**        -- Fatal Error code return for HW emulator error
**
*****************************************************************************/
VOID EmuOutput(U16 port, U8 *value, U16 len, U16 size);



/******************************** E O F ***********************************/

