/****************************************************************************
**
**  Name:  emutrace.h
**
**  Description:
**     Michelle trace-group routines.
**     include:
**        "Free running target CPU   -- EmuGo()"
**        "Stop target CPU           -- EmuHalt()"
**        "Clear event               -- EmuClrEvent()"
**        "Set event                 -- EmuSetEvent()"
**        "Set execution break point -- EmuSetExBkpt()"
**        "Clear trigger setting     -- EmuClrTrig()"
**        "Define trigger setting    -- EmuSetTrig()"
**        "List trace                -- EmuListTrace()"
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcmtat2/am186/emutrace.h_v  $
** 
**    Rev 1.0   20 Mar 1998 09:20:54   Eric
** Initial revision.
** 
**    Rev 1.5   24 Jan 1997 10:39:14   gene
** modified TrigOut struct
** 
**    Rev 1.4   22 Jan 1997 08:53:36   gene
** 
**    Rev 1.3   14 Jan 1997 17:55:58   gene
** 
**    Rev 1.2   20 Dec 1996 18:23:10   gene
** 
**    Rev 1.1   17 Dec 1996 17:29:30   gene
** added EEROM
** 
**    Rev 1.0   03 Dec 1996 09:27:46   gene
** Initial revision.
** 
**    Rev 1.2   12 Aug 1996 16:40:02   gene
**
**    Rev 1.1   05 Aug 1996 11:07:28   gene
** 
**    Rev 1.0   10 May 1996 10:05:20   jacky
** Get file from ATL. V1.3
** 
** Initial revision.
** 
**  $Header:   S:/tbird/arcmtat2/am186/emutrace.h_v   1.0   20 Mar 1998 09:20:54   Eric  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
*****************************************************************************/

#define _EMU_TRACE_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
			*                          *
                        ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

TRIGGER trigLevel[TRIG_NO];
TRIGGER trig; //template data

typedef struct {
   U16 addr,data;
   U8 trigoutPtn;
} TRIG_OUT;

TRIG_OUT trigOut[13]; //  0  -  7   8   9   10     11      12
                      // ev0 - ev7,tc0,tc1,extin,level0-,level1-
typedef struct {
 U16 startFrame,
     endFrame,
     frameLen;
} TRACE_INFO;

#define FRAME_LEN    16
typedef struct {
 U8 frameDat[FRAME_LEN];
} TRACE_DATA;

typedef enum {FORWARD,CENTER,BACKWARD} TRACE_FLAG;

//add 8/9/97 by Eric
typedef enum {
   CLEAR_ALL_BKPT,
   CLEAR_ONE_BKPT,
   SET_ONE_BKPT,
   CHECK_XBKPT_SET,
   TEST_COMP_RAM
} XBKPT_ACTION;

#define EVENT_NO  11

// gene 8/5/96 added for SPA functions
typedef struct {
   BOOLEAN used;
   EP_ADDR start,end;
} SPA_RANGE_NODE;

typedef struct {
   BOOLEAN used;
   EP_ADDR addr;
   //U8 status;
   U16 status;
   U16 statusMask;
   U8 num;
} SPA_CC_RANGE_NODE;

typedef struct {
   U16 count;
   U32 tmpStamp;
   U8 stampMSB;
   U32 totalStamp;
   U8 totalStampMSB;
} SPA_MA_INFO_NODE;

#define SPA_TA_TIME_NO     9
typedef struct {
   U16 count[SPA_TA_TIME_NO];
   U32 tmpStamp;
   U8 stampMSB;
   U32 totalStamp,longest,shortest;
} SPA_TA_INFO_NODE;

#define ADDR_TC0 0x0001
#define ADDR_TC1 0x0002
#define ADDR_EV0 0x0004
#define ADDR_EV1 0x0008
#define ADDR_EV2 0x0010
#define ADDR_EV3 0x0020
#define ADDR_EV4 0x0040
#define ADDR_EV5 0x0080
#define ADDR_EV6 0x0100
#define ADDR_EV7 0x0200
#define ADDR_EXT 0x0400
#define ADDR_LV0 0x0800
#define ADDR_LV1 0x1000

#define DATA_LV0       0x0001
#define DATA_LV1       0x0002
#define DATA_BRK       0x0004
#define DATA_TC0RST    0x0008
#define DATA_TC1RST    0x0010
#define DATA_TC0START  0x0020
#define DATA_TC1START  0x0040
#define DATA_TC0STOP   0x0080
#define DATA_TC1STOP   0x0100
#define DATA_TOFF      0x0200
#define DATA_TSTART    0x0400
#define DATA_TSTOP     0x0800
#define DATA_TRIGOUT   0x1000
#define DATA_TRIGOUTHZ 0x2000

			/****************************
			 *                          *
			 *    EXTERNAL VARIABLES    *
			 *                          *
			 ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/


/****************************************************************************
**
**  ReadTraceCount
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
STATUS ReadTraceCount(TRACE_INFO *traceData);

/****************************************************************************
**
**  StopEP
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
STATUS StopEP(VOID);

/****************************************************************************
**
**  EmuAbort
**
**  Description: Michelle trace-group routine, to abort the michelle.
**
**  Parameters:
**     input:
**
**     output:
**
**        return data -- "length" + "PC" + "brealFlag"
**
**
****************************************************************************/
VOID EmuAbort(VOID);

/****************************************************************************
**
**  EmuGo
**
**  Description: Michelle trace-group routine, to set the target CPU free
**               running. Default free running target CPU from current PC.
**               "mode" is to indicate the mode of free-running.
**               "mode" = 0 --> no temporary breakpoint is specified.
**               "mode" = 1 --> set temporary breakpoint at "addr" location
**
**  Parameters:
**     input:
**        mode -- int
**        addr -- unsigned long
**
**     output:
**        return status code(error-code) in to the output processor.
**        status-code = "BROKE"     --> Program broke at breakpoint.
**        status-code = "USER_HALT" --> Aborted by user.
**        status-code = "HALT"      --> Target CPU Halted.
**
**        return data -- "length" + "PC" + "breakFlag"
**
**  NOTE: The firmware should reserve an execution breakpoint to be used
**        as the temporary breakpoint implementation.
**
*****************************************************************************/
VOID EmuGo(S16 mode);

STATUS StartGo(S16 mode);

/****************************************************************************
**
**  EmuAbort
**
**  Description: Michelle trace-group routine, to abort the michelle.
**
**  Parameters:
**     input:
**
**     output:
**
**        return data -- "length" + "PC" + "brealFlag"
**
**
****************************************************************************/
VOID EmuAbort(VOID);

/****************************************************************************
**
** EmuGetCpuStatus
**
**  Description: Michelle trace-group routine, to set the target CPU free
**               running. Default free running target CPU from current PC.
**               "mode" is to indicate the mode of free-running.
**               "mode" = 1 --> no temporary breakpoint is specified.
**               "mode" = 2 --> set temporary breakpoint at "addr" location
**
**  Parameters:
**     input:
**        mode -- int
**        addr -- unsigned long
**
**     output:
**        return status code(error-code) in to the output processor.
**        status-code = "BROKE"     --> Program broke at breakpoint.
**        status-code = "USER_HALT" --> Aborted by user.
**        status-code = "HALT"      --> Target CPU Halted.
**
**        return data -- "length" + "PC" + "brealFlag"
**
**  NOTE: The firmware should reserve an execution breakpoint to be used
**        as the temporary breakpoint implementation.
**
****************************************************************************/
VOID EmuGetCpuStatus(VOID);

/****************************************************************************
**
**  EmuHalt
**
**  Description: Michelle trace-group routine, to stop the target CPU.
**               Stop execution of target CPU.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        -- O.K. for Normal return
**        -- Fatal Error code return for HW emulator error
**        return data -- "length" + "PC"
**
**  NOTE: I want to delete this function because we can support "halt"
**        in sw/driver. there is no necessarity to have a task to do so
**        in fw. (Do get register for one-pass-process)
**
*****************************************************************************/
VOID EmuHalt(VOID);

/****************************************************************************
**
**  EmuSetEvent
**
**  Description: Michelle trace-group routine, to define a bus event.
**               Set a bus event, the "addrspec" and "dataspec" are
**               defined as followings:
**               = "0" --> address/data field is not defined
**               = "1" --> address/data field is a single value
**               = "2" --> address/data field is a range value
**               = "3" --> address/data with a mask value.
**
**               "addrhi/datahi" is a wildcard value. "0" means "don't care".
**               EX. wildcard value 0xfffffffc means bit-0 and bit-1 are
**               "don't care".
**
**  Parameters:
**     input:
**     evId     -- int,
**     addrSpec -- unsigned int,
**     addrLo   -- unsigned long,
**     addrHi   -- unsigned long,
**     dataSpec -- unsigned int,
**     dataLo   -- unsigned int,
**     dataHi   -- unsigned int,
**     stat     -- unsigned int,
**     count    -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetEvent(U16 evId, U8 *busEventData);

/****************************************************************************
**
**  EmuSetAllEvent
**
**  Description: Michelle trace-group routine, to define a bus event.
**               Set a bus event, the "addrspec" and "dataspec" are
**               defined as followings:
**               = "0" --> address/data field is not defined
**               = "1" --> address/data field is a single value
**               = "2" --> address/data field is a range value
**               = "3" --> address/data with a mask value.
**
**               "addrhi/datahi" is a wildcard value. "0" means "don't care".
**               EX. wildcard value 0xfffffffc means bit-0 and bit-1 are
**               "don't care".
**
**  Parameters:
**     input:
**     evId     -- int,
**     addrSpec -- unsigned int,
**     addrLo   -- unsigned long,
**     addrHi   -- unsigned long,
**     dataSpec -- unsigned int,
**     dataLo   -- unsigned int,
**     dataHi   -- unsigned int,
**     stat     -- unsigned int,
**     count    -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetAllEvent(U8 *busData,U8 *extData);

/****************************************************************************
**
**  EmuSetExBkpt
**
**  Description: Michelle trace-group routine, to define an execution
**               brekpoint. (Set an execution breakpoint.)
**
**  Parameters:
**     input:
**        evId  -- int,
**        addr  -- unsigned long
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetExBkpt(ADDR addr);

/***************************************************************************
**
**  EmuSetExtEvent
**
**  Description: Michelle trace-group routine, to define an execution
**               brekpoint. (Set an execution breakpoint.)
**
**  Parameters:
**     input:
**        evId --
**        addr  --
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuSetExtEvent(U16 evData);

/****************************************************************************
**
**  EmuClrEvent
**
**  Description: Michelle trace-group routine, to clear the setting of
**               event(s) -- bus or execution breakpoint.
**
**  Parameters:
**     input:
**        evId  --
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuClrEvent(U16 evId);

/****************************************************************************
**
**  EmuClrBkpt
**
**  Description: Michelle trace-group routine, to clear the setting of
**               execution breakpoint.
**
**  Parameters:
**     input:
**        addr  --
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuClrBkpt(ADDR evId);

/****************************************************************************
**
**  EmuGetEvent
**
**  Description: Michelle trace-group routine, to get the setting of
**               event(s) -- bus or execution breakpoint.
**
**  Parameters:
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuGetEvent(VOID);

/****************************************************************************
**
**  EmuListTrace
**
**  Description: Michelle trace-group routine, to list raw data from the
**               trace buffer.
**               List trace buffer content in RAW data format which is
**               similar to the output of LOSTAN command in MICE-III.
**               The "frame" is the starting listing frame. If "frame" is
**               "-1", <ew MICE will return the number of frames in the
**               trace buffer.
**
**  Parameters:
**     input:
**        frame --
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**        list trace -- ("length" + "frame_data") *
**                      (min(256, "rest_frames_ in_trace_buffer"))
**        return count -- "length" + "number"
**
*****************************************************************************/
//VOID EmuListTrace(U16 traceBufId, U32 frameNo);
VOID EmuListTrace(U16 traceBufId, S32 frameNo,QUALIFY_LIST *condition);

/***************************************************************************
**
**  EmuSetTraceBreak
**
**  Description: Michelle trace-group routine, to set the trace mode.
**
**  Parameters:
**     input:
**        mode -- U8
**
**     output:
**        "O.K." -- Normal return
**
****************************************************************************/
VOID EmuSetTraceBreak(U16 breakFull);

/***************************************************************************
**
**  EmuSetTraceBuff
**
**  Description: Michelle trace-group routine, to set the trace mode.
**
**  Parameters:
**     input:
**        mode -- U8
**
**     output:
**        "O.K." -- Normal return
**
****************************************************************************/
VOID EmuSetTraceBuff(U16 traceBufNum);

/***************************************************************************
**
**  EmuGetTraceInfo
**
**  Description: Michelle trace-group routine, to set the trace mode.
**
**  Parameters:
**     input:
**        mode -- U8
**
**     output:
**        "O.K." -- Normal return
**
****************************************************************************/
VOID EmuGetTraceInfo(VOID);

/***************************************************************************
**
**  EmuGetTraceDepth
**
**  Description:
**
**  Parameters:
**     input:
**        mode -- U8
**
**     output:
**        "O.K." -- Normal return
**
****************************************************************************/
VOID EmuGetTraceDepth(U16 traceBufId);

/****************************************************************************
**
**  EmuClrTrig
**
**  Description: Michelle trace-group routine, to clear the trigger setting.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuClrTrig(U16 levelNo);

/****************************************************************************
**
**  EmuSetTrig
**
**  Description: Michelle trace-group routine, to define the trigger setting.
**
**  Parameters:
**     input:
**        ******* this function will be defined later............
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetTrig(U16 levelNo, U8 phySet, U16 *events, U16 *actions, U16 mode);

/***************************************************************************
**
**  EmuGetAllTrig
**
**  Description: Michelle trace-group routine, to define the trigger setting.
**
**  Parameters:
**     input:
**        ******* this function will be defined later............
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuGetAllTrig(VOID);

/****************************************************************************
**
**  EmuSetTimerCounter
**
**  Description: Michelle trace-group routine, to define the trigger setting.
**
**  Parameters:
**     input:
**        ******* this function will be defined later............
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetTimerCounter(U16 tcFlag,U32 tcData0,U32 tcData1);
VOID EmuReadFrameStamp(U16 bufId,S32 frameNo);

VOID EmuSPASetRange(U8 type,U8 rangeID,EP_ADDR startAddr,EP_ADDR endAddr);
VOID EmuSPAClearRange(U8 type);
VOID SPATableInitial(VOID);
VOID EmuSetTrcOffOnFull(U16 trcOffOnFull);
VOID EmuSetTrigOutAct(ACTIVE_STATE trigOutAct);
VOID EmuTraceAction(U8 action);
VOID EmuSPAGetTAInfo(VOID);
VOID EmuSPAGetMAInfo(VOID);
VOID EmuSPAGetCCInfo(U32 startAddr,U16 len,U8 flag);
VOID SPAProgramTMANCodeCov(VOID);
VOID EmuSPAClose(VOID);
VOID EmuSPASetBkpt(U8 enable,EP_ADDR addr);
VOID EmuSPAOpen(VOID);
STATUS SetPhyTrig(S16 mode);
VOID EmuSetFROM(U8 *data);
VOID EmuGetFROM(VOID);

STATUS AccessBusEvent(ACCESS_MODE accessMode, U16 evId, BUS_EVENT *value);
VOID AccessExecEvent(ACCESS_MODE accessMode, U16 evId, EXEC_EVENT *execData);
/******************************** E O F ***********************************/
