/****************************************************************************
**
**  Name:  emutypes.h
**
**  Description:
**     Primary type declarations for "Michelle" project.
**     NOTE:  This should not be included explicitly
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/arcmtat2/am186/emutypes.h_v  $
** 
**    Rev 1.2   12 Aug 1998 10:42:14   Eric
** Add ISP function.
** 
**    Rev 1.1   30 Apr 1998 09:16:46   Eric
** 
**    Rev 1.4   24 Dec 1997 16:01:00   Liu
** 
**    Rev 1.3   09 Dec 1997 18:11:24   Liu
** 
**    Rev 1.1   22 Oct 1997 17:00:34   Liu
** 
**    Rev 1.0   14 Oct 1997 17:45:20   Liu
** Initial revision.
** 
**    Rev 1.8   30 Sep 1997 14:13:14   Liu
** 
**    Rev 1.7   23 Sep 1997 18:19:52   Liu
** 
**    Rev 1.6   23 Sep 1997 11:47:40   Liu
** 
**    Rev 1.5   12 Sep 1997 08:01:42   Liu
** 
**    Rev 1.3   09 Sep 1997 19:57:34   Liu
** 
**    Rev 1.2   05 Sep 1997 17:57:02   Liu
** 
**    Rev 1.2   20 Dec 1996 18:23:32   gene
** 
**    Rev 1.1   17 Dec 1996 17:30:22   gene
** added for MCE16C
** 
**    Rev 1.0   03 Dec 1996 09:27:46   gene
** Initial revision.
** 
**    Rev 1.2   12 Aug 1996 16:40:04   gene
** 
**    Rev 1.1   05 Aug 1996 11:07:34   gene
** 
**    Rev 1.0   10 May 1996 10:06:08   jacky
** Get file from ATL. V1.3
**
**
**
**  $Header:   S:/tbird/arcmtat2/am186/emutypes.h_v   1.2   12 Aug 1998 10:42:14   Eric  $
**
**  Copyright (C) 1992 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _EMU_BASE_TYPES_


		   /****************************
		    *                          *
		    *        DEFINITIONS       *
		    *                          *
		    ****************************/

/* basic definitions */

#define ACK                 0x6
#define NACK                0x15
#define SPACE               0x20
#define FALSE               0x00000000
#define TRUE                !FALSE
#define YES                 TRUE
#define NO                  FALSE
#define ON                  TRUE
#define OFF                 FALSE
#define SUCCESS             0
#define GOOD                SUCCESS
#define OK                  GOOD
#define RESTART				0xf5
#define MAP_END_RECORD      0xaa55
//#define BUFF_LEN             512
#define BUFF_LEN             1024 //for Am186 by Eric 12/16/97
#define NULL                 0
#define INTER_REG_ADDR 0xfffff000ul


/* Microsoft-style keywords */
#define PASCAL         pascal
#define EXPORT         FAR PASCAL
#define STATIC         static
#define CONST          const
#define PRIVATE        STATIC

/* primary typedef's */
typedef void           VOID;
typedef char           CHAR;
typedef far            FAR;
typedef near           NEAR;
typedef unsigned char  U8;
typedef signed   char  S8;
typedef unsigned int   U16;
typedef signed   int   S16;
typedef unsigned long  U32;
typedef signed   long  S32;
typedef unsigned int   LOOP_VAR;  /* used only as a loop index */
typedef U8             BOOLEAN;
typedef unsigned char  *STRING;
typedef S16            STATUS;
typedef U8             HW_STATUS;
typedef STATUS         ERROR;
typedef STATUS         RETCODE;
#define streamMaxLen    100  /* Maximum Stream Length */


enum {
   NORMAL_RUN = 0,FREE_RUN,FLY_RUN,MONITOR_RUN,TEST_RUN,
   SPA_MA_RUN, SPA_TA_RUN, SPA_CC_RUN  // gene 8/2/96 added for SPA
}RUN_MODE;

enum {
   I80C188XL = 1, I80C188EA, I80C188EB, I80C188EC,
   I80C186XL,     I80C186EA, I80C186EB, I80C186EC,
//   I80166, I80167, I80195, I80196, I80197, M68302, M68306,
   A80188EM, A80188ES, A80188ER,
   A80186EM, A80186ES, A80186ER, A80186ED
}CPU_MODULE;
   
//enum {
//   A80188EM=2, A80188ES, A80188ER,
//   A80186EM, A80186ES, A80186ER, A80186ED
//}CPU_MODULE;

//typedef enum {
//   END_TEST, MCE16A, EMM1, EMM2, EMM3, EMM4, COV_RBW_MEMORY, TRACE_BOARD
//} FUNCTION_TEST_CMD;
enum {
   END_TEST, CAN, RESET_FUNC, RAM_MAP, EMM1, EMM2, EMM3, EMM4, RAM_ACCESS,
   BKPT_RAM, BKPT_TEST, TRACE_BOARD
}FUNCTION_TEST_CMD;

enum { I80188=1, I80186} INT_CO_TYPE;
enum { A80188=1, A80186} AMD_CO_TYPE;
//enum { EM = 0x0a, ES, ER, ED = 0x0e} PHY_CPU_now;
enum { XL_EA = 1, EB, EC, EM = 0x0a, ES, ER, ED = 0x0e} PHY_CPU;

enum {MCE16C_BOARD = 0x20, MCE16B_BOARD = 0x21, MCE16E_BOARD = 0x22,
      MCE32A_BOARD = 0x40, MCE32B_BOARD = 0x41
}MCE_BOARD;

#define ADDR   U32

typedef struct Addr{
   U32 pos;
   U16 space;
}CC_ADDR;

typedef enum {
   FIRMWARE_TYPE,
   FIRMWARE_VER,
   CPU_TYPE,
   CPU_VER,
   TRACE_EXIST,
   INIT_HW_STATUS,
   FRIMWARE_MODULE,
   MAX_ID
}ID_INFO;

/* define the command ID od the Michelle firmware function */
typedef enum {
   COMMAND_START,          /* 0  -- 0x0  */
   GET_ID,                 /* 1  -- 0x1  */ // special command, must place 1st.
   CHECKSUM,               /* 2  -- 0x2  */
   CLR_EVENT,              /* 3  -- 0x3  */
   CLR_TRIG,               /* 4  -- 0x4  */
   COMPARE,                /* 5  -- 0x5  */
   COPY,                   /* 6  -- 0x6  */
   FUNCTION_TEST,          /* 7  -- 0x7  */
   ESC_COMMAND,            /* 8  -- 0x8  */
   FILL,                   /* 9  -- 0x9  */
   GET_ALL_CO_REG,         /* 10 -- 0xa  */
   GET_ALL_INTERNAL_REG,   /* 11 -- 0xb  */
   GET_ALL_REG,            /* 12 -- 0xc  */
   GET_CO_COVERAGE,        /* 13 -- 0xd  */
   GET_CO_REG,             /* 14 -- 0xe  */
   GET_CONTROL,            /* 15 -- 0xf  */
   GET_DEPTH,              /* 16 -- 0x10 */
   GET_EVENT,              /* 17 -- 0x11 */
   GET_MAP,                /* 18 -- 0x12 */
   GET_MAP_SIZE,           /* 19 -- 0x13 */
   GET_MODE,               /* 20 -- 0x14 */
   GET_READY,              /* 21 -- 0x15 */
   GET_REG,                /* 22 -- 0x16 */
   GET_SIZE,               /* 23 -- 0x17 */
   GET_STAT,               /* 24 -- 0x18 */
   GET_SYNC,               /* 25 -- 0x19 */
   GET_VERIFY,             /* 26 -- 0x1a */
   GET_WAIT,               /* 27 -- 0x1b */
   GO_COMMAND,             /* 28 -- 0x1c */
   HALT,                   /* 29 -- 0x1d */
   INPUT,                  /* 30 -- 0x1e */
   LIST_TRACE,             /* 31 -- 0x1f */
   OUTPUT,                 /* 32 -- 0x20 */
   READ_MEM_N,             /* 33 -- 0x21 */
   RESET,                  /* 34 -- 0x22 */
   SEARCH,                 /* 35 -- 0x23 */
   SET_TRACE_BUFF,         /* 36 -- 0x24 */
   SET_CONTROL,            /* 37 -- 0x25 */
   SET_CO_COVERAGE,        /* 38 -- 0x26 */
   SET_CO_REG,             /* 39 -- 0x27 */
   SET_EVENT,              /* 40 -- 0x28 */
   SET_EX_BKPT,            /* 41 -- 0x29 */
   SET_ID,                 /* 42 -- 0x2a */
   SET_MEM_N,              /* 43 -- 0x2b */
   SET_MAP,                /* 44 -- 0x2c */
   SET_MODE,               /* 45 -- 0x2d */
   SET_REG,                /* 46 -- 0x2e */
   SET_READY,              /* 47 -- 0x2f */
   SET_SIZE,               /* 48 -- 0x20 */
   SET_SYNC,               /* 49 -- 0x31 */
   SET_TRACE_BREAK,        /* 50 -- 0x32 */
   SET_TRIG,               /* 51 -- 0x33 */
   SET_TIME_COUNT,         /* 52 -- 0x34 */
   SET_VERIFY,             /* 53 -- 0x35 */
   SET_WAIT,               /* 54 -- 0x36 */
   STEP,                   /* 55 -- 0x37 */
   STEP_ONE,               /* 56 -- 0x38 */
   TEST,                   /* 57 -- 0x39 */
   SET_EXT_EVENT,          /* 58 -- 0x3a */
   SET_ALL_EVENT,          /* 59 -- 0x3b */
   SET_TIMER_REG,          /* 60 -- 0x3c */
   GET_CPU_STATUS,         /* 61 -- 0x3d */
   ABORT,                  /* 62 -- 0x3e */
   GET_TRIG,               /* 63 -- 0x3f */
   GET_LAST_BUFF,          /* 64 -- 0x40 */
   DIAGNOSTIC,             /* 65 -- 0x41 */
   SET_TRACE_OFF_FULL,     /* 66 -- 0x42 */
   SET_TRIG_OUT_ACT,       /* 67 -- 0x43 */
   TRACE_ACTION,           /* 68 -- 0x44 */
   READ_STAMP,             /* 69 -- 0x45 */
   SPA_SET_RANGE,          /* 70 -- 0x46 */
   SPA_CLEAR_RANGE,        /* 71 -- 0x47 */
   SPA_GET_MA_INFO,        /* 72 -- 0x48 */
   SPA_GET_TA_INFO,        /* 73 -- 0x49 */
   SPA_GET_CC_INFO,        /* 74 -- 0x4A */
   SPA_CLOSE,              /* 75 -- 0x4B */
   SPA_SETBKPT,            /* 76 -- 0x4C */
   SPA_OPEN,               /* 77 -- 0x4D */
   R_FLUSH_ROM,            /* 78 -- 0x4E */
   W_FLUSH_ROM,            /* 79 -- 0x4F */
   CLR_BKPT,               /* 80 -- 0x50 */  //add by Eric 9/30/97
   //Add flashrom command by Eric 3/12/98
   GET_HW_MODE,            /* 81 -- 0x51 */  
   SWITCH_FLASH,           /* 82 -- 0x52 */
   EREASE_FLASH,           /* 83 -- 0x53 */  
   PROG_FLASH,             /* 84 -- 0x54 */
   FILL_FLASH_BLANK,       /* 85 -- 0x55 */
   //EOF flashrom command
   //Add Timer control command by Eric 3/23/98
   GET_TIMER,              /* 86 -- 0x56 */
   SET_TIMER,              /* 87 -- 0x57 */
   //EOF Timer control command by Eric 3/23/98
   //Add BLASTER control command by Eric 6/29/98
   WRITE_BLASTER,          /* 88 -- 0x58 */
   READ_BLASTER,           /* 89 -- 0x59 */
   //EOF BLASTER control command by Eric 6/29/98
   MAX_COMMAND          /* All new command must add before this command. */
} COMMAND_ID;

typedef enum {
   S_BYTE = 0, /* bit 0 */
   S_WORD = 1, /* bit 1 */
   S_LONG = 2  /* bit 2 */
} SIZE;

typedef enum {
   STOP_TIMER0 = 0, /* bit 0 */
   STOP_TIMER1 = 1, /* bit 0 */
   STOP_TIMER2 = 2, /* bit 0 */
   NO_STOP     = 0xff
} TIMER;

//typedef enum {
//   S_PEREQ = 0x01,  /* bit  0 */
//   S_ERROR = 0x02,  /* bit  1 */
//   S_INT0  = 0x04,  /* bit  2 */
//   S_INT1  = 0x08,  /* bit  3 */
//   S_INT2  = 0x10,  /* bit  4 */
//   S_INT3  = 0x20,  /* bit  5 */
//   S_DRG0  = 0x40,  /* bit  6 */
//   S_DRG1  = 0x80,  /* bit  7 */
//   S_RESET = 0x100, /* bit  8 */
//   S_HOLD  = 0x200, /* bit  9 */
//   S_NMI   = 0x400, /* bit 10 */
//} SIGNAL_FLAG;

typedef enum {
   S_STROBE = 0x01,  /* bit  0 */
   S_DMA    = 0x02,  /* bit  1 */
   S_NMI    = 0x04,  /* bit  2 */
   S_RESET  = 0x10,  /* bit  4 */
   S_HOLD   = 0x20,  /* bit  5 */
   S_MASKWS = 0x40,  /* bit  6 */
   S_RDEXT  = 0x80,  /* bit  7 */
} SIGNAL_FLAG;

typedef enum {
   T_TIMER0 = 0x01,  /* bit  0 */
   T_TIMER1 = 0x02,  /* bit  1 */
   T_TIMER2 = 0x04,  /* bit  2 */
} TIMERS_FLAG;

typedef enum {
   /* status flag */
   AUXILIARY_FLAG = 0X0010,
   CARRY_FLAG     = 0x0001,
   OVERFLOW_FLAG  = 0x0800,
   SIGN_FLAG      = 0x0080,
   ZERO_FLAG      = 0x0040,
   PARITY_FLAG    = 0x0004,
   /* control flag */
   TRAP_FLAG      = 0X0100,
   INTERRUPT_FLAG = 0X0200,
   DIRECTION_FLAG = 0X0400
}I86_FLAG;

typedef enum {
   PHY_CPU_TYPE,
   ESC_FLAG,
   RUNNING,       /*  */
   LAM_EXIT,      /*  */
   EMULATIN,      /*  */
   TIME_OVER,     /*  */
   TRACEING,      /*  */
   VERIFY_FLAG,
   SIZE_FLAG,
   EMM_SIZE,
   TIMER_FLAG,
   MODE_FLAG,     /* use for keeping run_mode */
   READY_FLAG,
   WAIT_FLAG,
   SYNC_FLAG,
   TRACE_MODE,
   TRACE_BUFF,
   TRACE_BREAK,
   BUFFER_FILL,
   RESET_FLAG,
   TRACED_BUFF_NO,
   CNT1_LOW,
   CNT0_LOW,
   SYNC_IN,
   PENDING,
   EP_RUN,
   FLYING,
   PHY_TRIG_SET,
   BROKE_REASON,
   TRCOFF_FULL,
   CNT1_HIGH,
   CNT0_HIGH,

   MAX_ICE_FLAG_NO
   /* When you want to add a new flag to ICE_FLAG,
      please add before MAX_ICE_FLAG_NO. */
} ICE_FLAG;

typedef enum {
   HW_ERROR_FLAG,
   LLFW_ERROR,
   HW_ERROR,

   MAX_LLFW_FLAG_NO
   /* When you want to add a new flag to LLFW_FLAG,
      please add before MAX_LLFW_FLAG_NO. */
} LLFW_FLAG;



typedef enum {
   GO_TYPE,
   BKPT,

   MAX_STATUS_FLAG_NO
   /* When you want to add a new status flag to STATUS_FLAG,
      please add before MAX_STATUS_FLAG_NO. */
} STATUS_FLAG;

typedef enum {
   READ_ONE,         /* 0*/
   READ_ALL,        /* 1*/
   WRITE_ONE,       /* 2*/
   WRITE_ALL,       /* 3*/
   CLEAR_ONE,       /* 4*/
   CLEAR_ALL,       /* 5*/
   DISABLE_ONE,     /* 6*/
   DISABLE_ALL,     /* 7*/
   ENABLE_ONE,      /* 8*/
   ENABLE_ALL,      /* 9*/

   MAX_ACCESS_NO
   /* When you want to add a new status flag to ACCESS_MODE,
      please add before MAX_ACCESS_NO. */
}ACCESS_MODE;

typedef enum {
   I86_REG,       /*  */
   I87_REG,       /*  */
   INTERNAL_REG
}REG_MODE;

typedef enum {
   R_SS, R_SP, R_FS, R_CS, R_IP, R_AX, R_BX, R_CX, R_DX, R_BP,
   R_SI, R_DI, R_DS, R_ES,
   MAX_CPU_REG_NO
}CPU_REGISTER;
#define BASE_REG_NO   5
   /* the first to fifth i86 register only write at cpu actice. */

#define R_TIMER0            5
#define R_TIMER1            6
#define R_TIMER2            7
#define MAX_BASE_REG_NO     8  //SS,SP,FS,CS,IP,TMR0,TMR1,TMR2

/*
 CNTRLW             FFFF
 STATUSW            FFFF
 TAGW               FFFF
 IPOFF              FFFF
 CSSEL              FFFF
 DATAOFF            FFFF
 DATASEL            DFBF

               SIGNIFICAND          EXPONENT         SIGN          TAG
         15-00 31-16 47-32 63-48     78-64            79
 ST0      FFF5  0000  0000  0000      0000            0             11
 ST1      0000  0000  0000  0002      6EEE            1             11
 ST2      EDED  ECEC  EBEB  EAEA      69E9            1             11
 ST3      E8E8  E7E7  E6E6  E5E5      64E4            1             11
 ST4      E3E3  E2E2  E1E1  E0E0      5FDF            1             11
 ST5      DEDE  DDDD  DCDC  DBDB      5ADA            1             11
 ST6      D9D9  D8D8  D7D7  D6D6      55D5            1             11
 ST7      D4D4  D3D3  D2D2  D1D1      50D0            1             11
*/
typedef enum {
   CNTRLW, STATUSW, TAGW, IPOFF, CSSEL, DATAOFF, DATASEL,
   ST0, ST1, ST2, ST3, ST4, ST5, ST6, ST7,
   MAX_I87_REG_NO
}I87_REGISTER;

//;20  0        1 EOI    * POLL   1 POLSTS 1 IMASK  1 PRMSK  1 INSERV 1 REQST
//;30  1 INTSTS 1 TCUCON 1 DMACON 1 DMACON 1 I0CON  1 I1CON  1 I2CON  1 I3CON
//;40  0        0        0        0        0        0        0        0
//;50  1 T0CNT  1 T0CMPA 1 T0CMPB 1 T0CON  1 T1CNT  1 T1CMPA 1 T1CMPB 1 T1CON
//;60  1 T2CNT  1 T2CMPA 1        1 T2CON  0        0        0        0
//;70  0        0        0        0        0        0        0        0
//;80  0        0        0        0        0        0        0        0
//;90  0        0        0        0        0        0        0        0
//;A0  1 UMCS   * LMCS   * PACS   * MMCS   * MPCS   0        0        0
//;B0  0        0        0        0        0        0        0        0
//;C0  1 D0SRCL 1 D0SRCH 1 D0DSTL 1 D0DSTH 1 D0TC   1 D0CON  0        0
//;D0  1 D1SRCL 1 D1SRCH 1 D1DSTL 1 D1DSTH 1 D1TC   1 D1CON  0        0
//;E0  1 RFBASE 1 RFTIME 1 RFCON  0        0        0        0        0
//;F0  1 PWRSAV # PWRCON 0        # STEPID 0        0        0        1 RELREG
//;                  *: When it is set, indicates the corresponding register
//;                     can be access in Register Internal modify command.
//;                  #: 0 for C186XL, 1 for C186EA
//;
//80C186 EB
//;00  0        1 EOI    * POLL   1 POLSTS 1 IMASK  1 PRMSK  1 INSERV 1 REQST
//;10  1 INTSTS 1 TCUCON 1 SCUCON 1 I4CON  1 I0CON  1 I1CON  1 I2CON  1 I3CON
//;20  0        0        0        0        0        0        0        0
//;30  1 T0CNT  1 T0CMPA 1 T0CMPB 1 T0CON  1 T1CNT  1 T1CMPA 1 T1CMPB 1 T1CON
//;40  1 T2CNT  1 T2CMPA 1        1 T2CON  0        0        0        0
//;50  1 P1DIR  1 P1PIN  1 P1CON  1 P1LTCH 1 P2DIR  1 P2PIN  1 P2CON  1 P2LTCH
//;60  1 B0CMP  1 B0CNT  1 S0CON  1 S0STS  1 S0RBUF 1 S0TBUF 0        0
//;70  1 B1CMP  1 B1CNT  1 S1CON  1 S1STS  1 S1RBUF 1 S1TBUF 0        0
//;80  1 GCS0ST 1 GCS0SP 1 GCS1ST 1 GCS1SP 1 GCS2ST 1 GCS2SP 1 GCS3ST 1 GCS3SP
//;90  1 GCS4ST 1 GCS4SP 1 GCS5ST 1 GCS5SP 1 GCS6ST 1 GCS6SP 1 GCS7ST 1 GCS7SP
//;A0  1 LCSST  1 LCSSP  1 UCSST  1 UCSSP  1 RELREG 0        0        0
//;B0  1 RFBASE 1 RFTIME 1 RFCON  1 RFADDR 1 PWRCON 0        1 STEPID 0

//typedef enum {
//                  EOIR=0x21, POLLR,  POLLSR, MASKR,  PMR,    INSR,   IRR,
//   INTSR = 0x30,  TMRCR,     DMA0CR, DMA1CR, INT0CR, INT1CR, INT2CR, INT3CR,
//   CNTR0 = 0x50,  MCNTA0,    MCNTB0, MCW0,   CNTR1,  MCNTA1, MCNTB1, MCW1,
//   CNTR2 = 0x60,  MCNTA2,            MCW2 = 0x63,
//   UMCS  = 0xa0,  LMCS,      PACS,   MMCS,   MPCS,
//   DMA0SL= 0xc0,  DMA0SH,    DMA0DL, DMA0DH, DMA0TC, DMA0CW,
//   DMA1SL= 0xd0,  DMA1SH,    DMA1DL, DMA1DH, DMA1TC, DMA1CW,
//   MDRAM = 0xe0,  CDRAM,     EDRAM,
//   PDCON = 0xf0,  PWRCON,            STEPIO = 0xf3,                  RELOCR = 0xf7,
//   MAX_INTERNAL_REG_NO
//}INTERNAL_REGISTER;

typedef enum {
   IVR   = 0x20,  EOI,     POLL,   POLSTS, IMASK,  PRMSK,  INSERV, REQST,
   INTSTS= 0x30,  TCUCON,  DMA0CON,DMA1CON,I0CON,  I1CON,  I2CON , I3CON,
   T0CNT = 0x50,  T0CMPA,  T0CMPB, T0CON,  T1CNT,  T1CMPA, T1CMPB, T1CON,
   T2CNT = 0x60,  T2CMPA,          T2CON = 0x63,
   UMCS  = 0xa0,  LMCS,    PACS,   MMCS,   MPCS,
   D0SRCL= 0xc0,  D0SRCH,  D0DSTL, D0DSTH, D0TC,   D0CON,
   D1SRCL= 0xd0,  D1SRCH,  D1DSTL, D1DSTH, D1TC,   D1CON,
   RFBASE= 0xe0,  RFTIME,  RFCON,
   PWRSAV= 0xf0,  PWRCON,          STEPID = 0xf3,                  RELREG = 0xf7,
   MAX_INTERNAL_REG_NO
}XL_EA_INTERNAL_REGISTER;

typedef enum {
                    B_EOI = 0x01,B_POLL,    B_POLSTS, B_IMASK, B_PRMSK, B_INSERV,  B_REQST,
   B_INTSTS= 0x10,  B_TCUCON,    B_SCUCON,  B_I4CON,  B_I0CON, B_I1CON, B_I2CON,   B_I3CON,
   B_T0CNT = 0x30,  B_T0CMPA,    B_T0CMPB,  B_T0CON,  B_T1CNT, B_T1CMP, B_T1CMPB,  B_T1CON,
   B_T2CNT = 0x40,  B_T2CMPA,               B_T2CON = 0x43,
   B_P1DIR = 0x50,  B_P1PIN,     B_P1CON,   B_P1LTCH, B_P2DIR, B_P2PIN, B_P2CON,   B_P2LTCH,
   B_B0CMP = 0x60,  B_B0CNT,     B_S0CON,   B_S0STS,  B_S0RBU, B_S0TBU,
   B_B1CMP = 0x70,  B_B1CNT,     B_S1CON,   B_S1STS,  B_S1RBU, B_S1TBU,
   B_GCS0ST= 0x80,  B_GCS0SP,    B_GCS1ST,  B_GCS1SP, B_GCS2S, B_GCS2P, B_GCS3ST,  B_GCS3SP,
   B_GCS4ST= 0x90,  B_GCS4SP,    B_GCS5ST,  B_GCS5SP, B_GCS6S, B_GCS6P, B_GCS7ST,  B_GCS7SP,
   B_LCSST = 0xa0,  B_LCSSP,     B_UCSST,   B_UCSSP,  B_RELREG,
   B_RFBASE= 0xb0,  B_RFTIME,    B_RFCON,   B_RFADDR, B_PWRCO,          B_STEPID = 0xb6,
   MAX_EB_INTERNAL_REG_NO
}EB_INTERNAL_REGISTER;


/******************************** Struct type define **********************/

typedef struct Result {      /* Process result */
   COMMAND_ID cmdNo;
   U32  status;
   U8   returnValue[100];
}RESULT;

typedef struct {
 U16 startAddr,
     endAddr;
 U8  allocateType,
     spaceFc;
}MAP_DATA;

typedef enum { UNDEFINE_ADDR, SINGLE_ADDR, RANGE_ADDR, MASK_ADDR } ADDR_SPEC;
typedef enum { UNDEFINE_DATA = 0, SINGLE_DATA = 1, MASK_DATA = 3 } DATA_SPEC;

typedef U32 EP_ADDR;
typedef U32 EP_DATA;
typedef U32 EP_STATUS;

typedef struct {
   U32 status;
   U32 status2Low,
       status2High;
   U8  TraceBitLow,
       TraceBitHigh;
}EP_STATUS2;  //add for Am186 by Eric 11/16/97

typedef struct {
   U16 enable;
   ADDR_SPEC addrSpec;
   EP_ADDR addrLow;
   EP_ADDR addrHigh;
   DATA_SPEC dataSpec;
   EP_DATA dataLow;
   EP_DATA dataHigh;
   EP_STATUS status;
   U16       count;
   EP_ADDR addrRangeMask;   //add for Am186 by Eric 11/16/97
   U16 statusFlag;          //add for Am186 by Eric 11/16/97
   EP_STATUS2 status2;      //add for Am186 by Eric 11/16/97
}BUS_EVENT;

typedef struct {
  U16 enable;
  U32 addr; /* CS:IP */
}EXEC_EVENT;

typedef struct {
   U16  qFlag;
   U32  startAddr,
        endAddr,
        addrMask;
   U16  data,
        dataMask;
   U16  status;
   U16  traceBitData,
	traceBitWild;
}QUALIFY_LIST;

typedef struct {
   U16 traceBufId;
   S32 startFrame;
   U16 traceform;
   U16 frameLen;
}TRACE_HEAD;

enum { MA_RANGE, TA_RANGE, CC_RANGE };
typedef enum { ACTIVE_LOW, ACTIVE_HIGH, ACTIVE_HIGHZ } ACTIVE_STATE ;

#define MAX_BUS_EVENT_NO       8
//#define MAX_EXEC_EVENT_NO      2
#define MAX_EXEC_EVENT_NO      256
#define TRIG_NO    4
typedef struct {
   U8  defined;  /* not used */
   U8  phySet;
   U16 ev[11]; /* event no: 1 ~ 9 ; cnt0 ~1 : 10, 11; 0: null */
   U16 op[5];  /* not used */
   U16 arm[7]; /* not used */
   U16 act[11]; /* bit :
                    0        1       2       3       4       5
                 "BREAK", "RESET", "SEQ", "TROFF", "NEXT", "INC0",
		    6       7      8         9        10
                  "RST0", "INC1", "RST1", "EXTIN", "EXTOUT"
                */
   U16 mode;  /* backward : 0 ; forward : 1 ; center : 2; delay : 3 */
   U16 delay;
} TRIGGER;

/******************************* E O F ***********************************/
