/***************************************************************************
**
**  Name:  functest.c
**
**  Description:
**     Michelle function test program
**     include:
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcmtat2/am186/functest.c_v  $
** 
**    Rev 1.1   12 Aug 1998 10:15:38   Eric
** Add Ram test function.
** 
**    Rev 1.0   20 Mar 1998 09:20:54   Eric
** Initial revision.
** 
**    Rev 1.5   31 Jan 1997 17:41:30   gene
** fixed a bug of no trace module testing
** 
**    Rev 1.4   22 Jan 1997 18:06:42   gene
** fixed test trace fail bug
** 
**    Rev 1.3   20 Dec 1996 18:21:30   gene
** added recover info
** 
**    Rev 1.2   19 Dec 1996 08:59:58   gene
** modifid for MTAT2 TestTraceBoard
** 
**    Rev 1.1   17 Dec 1996 17:28:40   gene
** added for MCE16C
** 
**    Rev 1.0   03 Dec 1996 09:27:38   gene
** Initial revision.
** 
**    Rev 1.0   10 May 1996 10:05:44   jacky
** Get file from ATL. V1.3
** 
** Initial revision.
** 
**  $Header:   S:/tbird/arcmtat2/am186/functest.c_v   1.1   12 Aug 1998 10:15:38   Eric  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _FUNCTION_TEST_
#include "functest.h"
#endif

#ifndef _EMU_EXTERNAL_
#include "emuext.h"
#endif

#ifndef _EMU_SETUP_
#include "emusetup.h"
#endif

#ifndef _EMU_TRACE_
#include "emutrace.h"
#endif

#ifndef _EMU_MEM_
#include "emumem.h"
#endif

#ifndef _EMU_EMUL_
#include "emuemul.h"
#endif

#ifndef _EMU_LLFW_
#include "emullfw.h"
#endif

#ifndef _TRCTMAN_
#include "trctman.h"
#endif

#ifndef _TRCLIB_
#include "trclib.h"
#endif

#ifndef _EMU_LIB_
#include "emulib.h"
#endif

#ifndef _EMU_COMM_
#include "emucomm.h"
#endif

#include <memory.h>
#include <dos.h>
#include <conio.h>
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
#define     MCR     0XF004
#define     P82552B 0XF141
#define     TEST_BKPT 0x3000010Cul

#define     TRACE_FRAME_LEN  22

typedef struct {
   U32 addr1,addr2;
   U16 attr;
} MAP_STRUCT;
//MAP_STRUCT bakMap[16];
MAP_STRUCT bakMap[MAX_MAP+1]; //By Eric 12/15/97
                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
			****************************/
VOID BackupInfo(VOID);
VOID RestoreInfo(VOID);

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

U32 ConvertArray(U8 *arrayPtr, U8 len) {
U8 lp;
U32 varData;

   varData = 0;
   for (lp = 0; lp < len; lp++) {
      varData <<= 8;
      varData += arrayPtr[lp];
   }
   return(varData);
}


/***************************************************************************
**
**  TestTraceBoard
**
**  Description: Michelle main self-testing routine.
**
**  Parameters:
**     input:
**     output:
**        none
**
****************************************************************************/
#define TEST_STATUS 3
STATUS TestTraceBoard(VOID) {
U8 memData1[] = {0xEA,0,0,0,0x30}; // FFFF:0000 jmp 3000:0
U8 memData2[] ={
   0xB8,0x00,0x00,0x8E,0xD8,0xA0,0x01,0x00,
   0xA0,0x02,0x00,0xA0,0x04,0x00,0xA0,0x08,
   0x00,0xA0,0x10,0x00,0xA0,0x20,0x00,0xA0,
   0x40,0x00,0xA0,0x80,0x00,0xA0,0x00,0x01,
   0xA0,0x00,0x02,0xA0,0x00,0x04,0xA0,0x00,
   0x08,0xA0,0x00,0x10,0xA0,0x00,0x20,0xA0,
   0x00,0x40,0xA0,0x00,0x80,0xB8,0x00,0x10,
   0x8E,0xD8,0xA0,0x00,0x00,0xB8,0x00,0x20,
   0x8E,0xD8,0xA0,0x00,0x00,0xB8,0x00,0x40,
   0x8E,0xD8,0xA0,0x00,0x00,0xB8,0x00,0x80,
   0x8E,0xD8,0xA0,0x00,0x00,0xB8,0x00,0xF0,
   0x8E,0xD8,0xA0,0xFE,0xFF,0xA0,0xFD,0xFF,
   0xA0,0xFB,0xFF,0xA0,0xF7,0xFF,0xA0,0xEF,
   0xFF,0xA0,0xDF,0xFF,0xA0,0xBF,0xFF,0xA0,
   0x7F,0xFF,0xA0,0xFF,0xFE,0xA0,0xFF,0xFD,
   0xA0,0xFF,0xFB,0xA0,0xFF,0xF7,0xA0,0xFF,
   0xEF,0xA0,0xFF,0xDF,0xA0,0xFF,0xBF,0xA0,
   0xFF,0x7F,0xB8,0x00,0xE0,0x8E,0xD8,0xA0,
   0xFF,0xFF,0xB8,0x00,0xD0,0x8E,0xD8,0xA0,
   0xFF,0xFF,0xB8,0x00,0xB0,0x8E,0xD8,0xA0,
   0xFF,0xFF,0xB8,0x00,0x70,0x8E,0xD8,0xA0,
   0xFF,0xFF,0xA1,0x00,0x10,0xA1,0x02,0x10,
   0xA1,0x04,0x10,0xA1,0x06,0x10,0xA1,0x08,
   0x10,0xA1,0x0A,0x10,0xA1,0x0C,0x10,0xA1,
   0x0E,0x10,0xA1,0x10,0x10,0xA1,0x12,0x10,
   0xA1,0x14,0x10,0xA1,0x16,0x10,0xA1,0x18,
   0x10,0xA1,0x1A,0x10,0xA1,0x1C,0x10,0xA1,
   0x1E,0x10,0xA1,0x20,0x10,0xA1,0x22,0x10,
   0xA1,0x24,0x10,0xA1,0x26,0x10,0xA1,0x28,
   0x10,0xA1,0x2A,0x10,0xA1,0x2C,0x10,0xA1,
   0x2E,0x10,0xA1,0x30,0x10,0xA1,0x32,0x10,
   0xA1,0x34,0x10,0xA1,0x36,0x10,0xA1,0x38,
   0x10,0xA1,0x3A,0x10,0xA1,0x3C,0x10,0xA1,
   0x3E,0x10,0xEC,0xEE,0xF4};

U16 memData3[] ={
      0x1,   0x2,   0x4,   0x8,  0x10,  0x20,  0x40,  0x80,
    0x100, 0x200, 0x400, 0x800,0x1000,0x2000,0x4000,0x8000,
   0xFFFE,0xFFFD,0xFFFB,0xFFF7,0xFFEF,0xFFDF,0xFFBF,0xFF7F,
   0xFEFF,0xFDFF,0xFBFF,0xF7FF,0xEFFF,0xDFFF,0xBFFF,0x7FFF};

//  S, R, W, I, O, AK, H, DMA
U8 *tracePtr;//traceBuffData[48*19],,statusData[TEST_STATUS] = {0x8, 0x10, 0x2};
U8 traceBuffData[32*22];//replace 48*19 by 32*22 for Am186 12/16/97
U32 statusData[TEST_STATUS] = {0x8, 0x10, 0x2};//replace U8 for Am186 12/16/97
QUALIFY_LIST condition;
TRACE_HEAD traceHead;
STATUS status,status1;
S32 lp2,startFrame;
U16 test16Bit = 0x01,tempWord;
U32 test32Bit = 0x01;
BUS_EVENT tmpBusEvent;
TRIGGER trig;
U8 lp,tmpData;

   EmuClrTrig(1); // clear trigger level 1.
   EmuClrEvent(0); // clear all event.
   EmuSetTraceBuff(1);
   EmuSetMap(0,0,0x03); // map all external
   EmuSetMap(0,0x7ffff,0x01); /* map 0 7ffff intetnal */
   EmuSetMap(0x80000,0xfffff,0x01); /* map 80000 fffff intetnal */
   EmuSetMemN(0xffff0000,memData1,sizeof(memData1));
   EmuSetMemN(0x30000000,memData2,sizeof(memData2));
   EmuReadMemN(0x30000000,sizeof(memData2)); // test memory write. template
   EmuSetMemN(0x70001000,(U8 *)memData3,sizeof(memData3));

   memset(&tmpBusEvent,0,sizeof(BUS_EVENT));
   memset(&trig,0,sizeof(TRIGGER));                     // clear all events
   //move to TEST_STATUS loop
   //tmpBusEvent.enable = 0x8001;
   //tmpBusEvent.statusFlag = 1;  // use PowerViews' style
   //tmpBusEvent.addrRangeMask = 0xFFFFFFFFL;
   //tmpBusEvent.status2.status2Low = 0x00001000L;
   //tmpBusEvent.status2.status2High = 0x00000007L;
   trig.defined = 1;
   trig.ev[0] = 1;
   trig.act[0] = 0xC00;
   trig.ev[1] = 0;
   trig.act[1] = 0;
   memcpy(&(trigLevel[0]),&trig,sizeof(TRIGGER));

   for (lp = 0; lp < TEST_STATUS; lp++) { //test I,O cycle

//  bit 0, 1, 2, 3, 4, 5, 6, 7 : S, R, W, I, O, AK, H, DMA
      EmuClrEvent(0); // clear all event.
      tmpBusEvent.enable = 0x8001;
      tmpBusEvent.statusFlag = 1;  // use PowerViews' style
      tmpBusEvent.addrRangeMask = 0xFFFFFFFFL;
      tmpBusEvent.status2.status2Low = 0x00001000L;
      tmpBusEvent.status2.status2High = 0x00000007L;

      //tmpBusEvent.status = statusData[lp];  //replace status2 for Am186 12/17/97
      tmpBusEvent.status2.status = statusData[lp];
      EmuSetEvent(1,(U8*)&tmpBusEvent);
      //if (*(U16 *)&outputStream[0] != GOOD)
      //   return(TRACE_BOARD_FAIL); // EP stop, not ev10
      EmuSetExBkpt(TEST_BKPT);

      EmuReset();
      EmuSetReg(I86_REG,R_CS,0x3000);
      EmuSetReg(I86_REG,R_IP,0);
//      outData = 0xc03c;
//      OutputData(0xffa0,1,(U8 *)&outData,1);
//      outData = 0xc038;
//      OutputData(0xffa8,1,(U8 *)&outData,1);
//      outData = 0x81fc;
//      OutputData(0xffa6,1,(U8 *)&outData,1);
      EmuGo(TEST_RUN);
      for (lp2 = 0; lp2 < 0xffff; lp2++); //delay.
      status1 = GOOD;
      for (lp2 = 0; lp2 < 100; lp++) {
	 EmuGetCpuStatus();
	 if ((status1 = *(U16 *)&outputStream[0]) == BKPT_HALT)
	    break;
	 if (outputStream[2])
	    break; //ep stop. but not ev10
      }

      if (status1 != BKPT_HALT) { // EP stop and ev10 match
	 if (!outputStream[2])     // EP is running.
	    EmuAbort();
	 return(TRACE_BOARD_FAIL); // EP stop, not ev10
      }

//      AccessIceFlag(READ_ONE,TRACED_BUFF_NO,&lastBufNo);
//      if (lastBufNo != 0) return (!GOOD);
      EmuGetTraceDepth(0);
      startFrame = startLogFrameOfTrcBuf[0];
      traceHead.traceBufId  = 0;
      traceHead.traceform = CYCLE_TRACE;
      condition.qFlag = 0;
      traceHead.startFrame = startFrame;

      status = ListTraceBuffer(&traceHead,&condition,traceBuffData);
      if (lp < (TEST_STATUS - 1)) {
	 if (traceHead.frameLen != 1) return (!GOOD);
      } else {
	 tracePtr = traceBuffData;
//         tracePtr+=4;
// Test Address lines

	 test32Bit = 0x01;
	 do {
	    if ((*(U32 *)tracePtr & 0xffffff) != test32Bit)
	       return (!GOOD);
	    tracePtr += TRACE_FRAME_LEN;
	    test32Bit <<= 1;
	 } while (test32Bit != 0x100000);

	 traceHead.startFrame = traceHead.startFrame + 20;
	 status |= ListTraceBuffer(&traceHead,&condition,traceBuffData);
	 tracePtr = traceBuffData;
	 test32Bit = 0x01;
	 do {
	    if ((*(U32 *)tracePtr & 0xffffff) != (~test32Bit & 0xfffff))
	       return (!GOOD);
	    tracePtr += TRACE_FRAME_LEN;
	    test32Bit <<= 1;
	 } while (test32Bit != 0x100000);

// Test data lines

	 traceHead.startFrame = traceHead.startFrame + 20;
	 status |= ListTraceBuffer(&traceHead,&condition,traceBuffData);
	 tracePtr = traceBuffData;
	 test16Bit = 0x01;
	 if ((cpuFlag & 0xf0) == 0x20) { // cpu is 186 family.
	    tracePtr += 4;
	    do {
	       if (*(U16 *)tracePtr != test16Bit)
		  return (!GOOD);
	       tracePtr += TRACE_FRAME_LEN;
	       test16Bit <<= 1;
	    } while (test16Bit != 0);

	    test16Bit = 0x01;
	    do {
	       if (*(U16 *)tracePtr != ~test16Bit)
		  return (!GOOD);
	       tracePtr += TRACE_FRAME_LEN;
	       test16Bit <<= 1;
	    } while (test16Bit != 0);
	 } else { // cpu is 188 family.
	    tracePtr += 4;
	    do {
	       tempWord = (U16)(*tracePtr);
	       tmpData = *(tracePtr + TRACE_FRAME_LEN);
	       tempWord += (((U16)tmpData) << 8);
	       if (tempWord != test16Bit)  return (!GOOD);
	       tracePtr += (TRACE_FRAME_LEN * 2);
	       test16Bit <<= 1;
	    } while (test16Bit != 0);

	    traceHead.startFrame = traceHead.startFrame + 32;
	    status |= ListTraceBuffer(&traceHead,&condition,traceBuffData);
	    tracePtr = traceBuffData;
	    test16Bit = 0x01;
	    tracePtr += 4;
	    do {
	       tempWord = (U16)(*tracePtr);
	       tmpData = *(tracePtr + TRACE_FRAME_LEN);
	       tempWord += (((U16)tmpData) << 8);
               if (tempWord != ~test16Bit)  return (!GOOD);
	       tracePtr += (TRACE_FRAME_LEN * 2);
               test16Bit <<= 1;
            } while (test16Bit != 0);
         }
      }
   }

//  remove for MTAT2
//   status |= TestAddrOfVRAMs();
//   status |= TestSeqRAMs();

   return (status);
}

/***************************************************************************
**
**
**
**  Description: Michelle main self-testing routine, to have the hidden
**
**  Parameters:
**     input:
**     output:
**        none
**
****************************************************************************/
//STATUS HlTestTraceBoard(VOID) {
//        return(GOOD);
//}

/***************************************************************************
**
**  EmuFunctionTest
**
**  Description: Michelle main self-testing routine, to have the hidden
**               commands. Use the sw driver on the host site to drive
**               the fw function.
**               The driver will handle the input command format then
**               receive the result to perform with meaning.
**
**  Parameters:
**     input:
**        cmdId --
**     output:
**        none
**
****************************************************************************/
#define TEST_REG 0xF6 //Test RESET(0xF6) internal register only
STATUS EmuFunctionTest(U16 cmdId) {
U8  hltOp = 0xf4;
U16 status = GOOD;
U16 emmSize,lp,lp2,csReg,ipReg;
U16 baseReg[BASE_REG_NO];
U32 startAddr,pcReg,
    csIpValue[] = {    0x00000000, 0x00000001, 0x00000002, 0x00000004, 0x00000008,
				   0x00000010, 0x00000020, 0x00000040, 0x00000080,
                                   0x00000100, 0x00000200, 0x00000400, 0x00000800
                    // 0xffff000f, 0xffff000e, 0xffff000d, 0xffff000b, 0xffff0007,
		    //             0xfffe000f, 0xfffd000f, 0xfffb000f, 0xfff7000f,
                    //             0xffef000f, 0xffdf000f, 0xffbf000f, 0xff7f000f,
		       };
U16 dataLen = (sizeof(csIpValue)/sizeof(csIpValue[0]));
U16 test16Bit,tempWord;

   switch (cmdId) {
      case TRACE_BOARD :
	 if (emmSize == 0) return(NO_EMM);
	 if (mtatExist) {
	    if(TestTraceBoard()) return(TRACE_BOARD_FAIL);
	 }
	 else return(NO_TRACE_MODULE);
	 break;
      case EMM1 :
      case EMM2 :
      case EMM3 :
      case EMM4 :
	 EmuSetMap(0,0,0x03); /* map all external */
         AccessIceFlag(READ_ONE,EMM_SIZE,&emmSize);
	 if (emmSize == 0) return(NO_EMM);
	 else {
	    startAddr = (U32)((cmdId - EMM1) * emmSize * 0x20000) << 12;
	    switch (emmSize) {
	       case 1 :
		  EmuSetMap(0x0L,0x7FFFFL,0x01); //map internal
		  EmuTest(startAddr,0x20000L);
		  if(*(U16 *)&outputStream[0]) return(EMM_FAIL);
		  break;
	       case 2 :
		  EmuSetMap(0x0L,0xFFFFFL,0x01); //map internal
		  EmuTest(startAddr,0x40000L);
                  if(*(U16 *)&outputStream[0]) return(EMM_FAIL);
                  break;
            }
         }
         break;
      case CAN :
	 BackupInfo();
	 if (mtatExist) {
	    EmuClrTrig(1);
	    SetPhyTrig(TEST_RUN);
	 }
	 if (CanTest()) return(MCE16E_FAIL);
         break;

      case RESET_FUNC :
	 if (Reset(baseReg)) return(MCE16E_FAIL);
         if ((baseReg[R_SS] != 0) && (baseReg[R_FS] != 0xF002)
              && (baseReg[R_CS] != 0xFFFF) && (baseReg[R_IP] !=0))
            return(MCE16E_FAIL);
         break;

      case RAM_MAP :
         DisEmStop();
	 if (MapTest()) return(MCE16E_FAIL);
	 EnEmDisViol();
         break;

       // Test violation break;
       //EmuSetMap(0xff000,0xfffff,0x64); // map ff000 fffff G
       //EmuGo(2);
       //for (lp = 0; lp < 0xff; lp++);
       //EmuAbort();
       //if (CheckViolation()) return(MCE16E_FAIL);

     case RAM_ACCESS :
         test16Bit = 0x01;
         do {
            if (AccessInternalReg(WRITE_ONE,TEST_REG,&test16Bit)) return(MCE16E_FAIL);
            if (AccessInternalReg(READ_ONE,TEST_REG,&tempWord)) return(MCE16E_FAIL);
            if (tempWord != test16Bit)
               return (!GOOD);
            test16Bit <<= 1;
         } while (test16Bit != 0);

         test16Bit = 0xFFFF;
         do {
            if (AccessInternalReg(WRITE_ONE,TEST_REG,&test16Bit)) return(MCE16E_FAIL);
            if (AccessInternalReg(READ_ONE,TEST_REG,&tempWord)) return(MCE16E_FAIL);
            if (tempWord != test16Bit)
               return (!GOOD);
            test16Bit <<= 1;
         } while (test16Bit != 0);
         break;

     case BKPT_RAM :
         if (HwExBp((ADDR)noUse,0x20)) return(MCE16E_FAIL); //Test H/W Compare Ram
         break;

     case BKPT_TEST :
       // Test EA[10..0]
	 for (lp = 0; lp < dataLen; lp++) {
	    pcReg = csIpValue[lp];
	    csReg = HighWord(pcReg);
	    ipReg = LowWord(pcReg);
	    AccessBaseReg(WRITE_ONE,R_CS,&csReg);
	    AccessBaseReg(WRITE_ONE,R_IP,&ipReg);
	    EmuSetExBkpt(csIpValue[lp]);
	    status = GOOD;
	    EmuGo(TEST_RUN); // special run.
	    for(lp2 = 0;lp2 < 100;lp2++) {
	       EmuGetCpuStatus();
	       if ((status = *(U16 *)&outputStream[0]) == BKPT_HALT) break;
	       if (outputStream[2])
		  break; //ep stop. but not ev10
	    }

	    if (status == BKPT_HALT) { // EP stop and ev10 match
	       AccessBaseReg(READ_ONE,R_CS,&csReg);
	       AccessBaseReg(READ_ONE,R_IP,&ipReg);
	       if ((csReg != HighWord(pcReg)) || (ipReg != LowWord(pcReg)))
		  return(MCE16E_FAIL-lp);
	    }
	    else if (!outputStream[2]) { // EP is running.
	       EmuAbort();
	       return(MCE16E_FAIL+1);
	    }
	    else return(MCE16E_FAIL+2); // EP stop, not ev10
	 }
	 //Exbp1Disable();
	 HwExBp((ADDR)noUse,(U16)CLEAR_ALL_BKPT);

	 // test HALT
	 //if (ExecuteHalt()) status = GOOD;
	 //else status = MCE16E_FAIL+3;
	 Reset(baseReg);
	 break;
//      case COV_RBW_MEMORY :
//         if (CovMapTest()) return(COV_RBW_FAIL);
//         if (InitRecRam()) return(COV_RBW_FAIL);
//         break;
      case END_TEST :
	 RestoreInfo();
	 break;
   }
   return(GOOD);

}

/***************************************************************************
**
**  EmuDiagnostic
**
**  Description: Michelle main self-testing routine, to have the hidden
**               commands. Use the sw driver on the host site to drive
**               the fw function.
**               The driver will handle the input command format then
**               receive the result to perform with meaning.
**
**  Parameters:
**     input:
**        cmdId --
**     output:
**        none
**
****************************************************************************/
#define DMA1SL      0xFFD0
#define DMA1SH      0xFFD2
#define DMA1DL      0xFFD4
#define DMA1DH      0xFFD6
#define DMA1TC      0xFFD8
#define DMA1CW      0xFFDA
#define MK_FP(seg, ofs) ((VOID _far *) ((((U32) seg) << 16) | ((U16) ofs)))
VOID EmuDiagnostic(VOID) {
U8 brokeData[10],lp;
U32 dataAddress;

   OutputStatus(GOOD,ON);
   TransmitStream();
   outp(MCR,0);
   dataAddress = (U32)FP_SEG(brokeData) << 4 + FP_OFF(brokeData);

 //outp(DMA1SL,0x400);
 //outp(DMA1SH,0);
 //outp(DMA1DL,LowWord(dataAddress));
 //outp(DMA1DH,HighWord(dataAddress));
 //outp(DMA1TC,10);
 //outp(DMA1CW,0xB626);
 //
 //for (lp =0; lp < 10; lp++)
 //   brokeData[lp] = ~brokeData[lp];

   for (lp =0; lp < 10; lp++)
      brokeData[lp] = 0;

   outp(P82552B,((U8)inp(P82552B) | 0X80)); //set WRPRAM=H to write Program RAM
   outp(DMA1SL,LowWord(dataAddress));
   outp(DMA1SH,HighWord(dataAddress));
   outp(DMA1DL,0x400);
   outp(DMA1DH,0);
   outp(DMA1TC,10);
   outp(DMA1CW,0xB626);
   outp(P82552B,((U8)inp(P82552B) & 0X7F)); //set WRPRAM=L to write protected Program RAM

   FwReset();
}

VOID BackupInfo(VOID) {
U16 *mapPtr, i;

   EmuGetMap();
   mapPtr = (U16*)&(outputStream[2]);
   for (i = 0; *mapPtr != 0xaa55; i++) {
      memcpy(&(bakMap[i]),mapPtr,sizeof(MAP_STRUCT));
      mapPtr += (sizeof(MAP_STRUCT) / 2);  // U16 *mapPtr ;
   }
   memset(&(bakMap[i]),0,sizeof(MAP_STRUCT));
   //AccessExecEvent(READ_ALL,noUse,bakExecEvent);

   if (mtatExist) {
      AccessBusEvent(READ_ALL,noUse,bakBusEvent);
      memcpy(&bakTrig,&(trigLevel[0]),sizeof(TRIGGER));
   }
}

VOID RestoreInfo(VOID) {
   U16 i;

   EmuSetMap(0,0,0x03); /* map all external */
   for (i = 0; bakMap[i].addr2 != 0; i++) {
      EmuSetMap(bakMap[i].addr1,bakMap[i].addr2,bakMap[i].attr);
   }
   //AccessExecEvent(WRITE_ALL,noUse,bakExecEvent);
   EmuClrEvent(0); // clear all event.
   if (mtatExist) {
      AccessBusEvent(WRITE_ALL,noUse,bakBusEvent);
      memcpy(&(trigLevel[0]),&bakTrig,sizeof(TRIGGER));
   }
}
/******************************** E O F ***********************************/
