		.CHIP	80186
                .OUTPUT 2500AD
data:   segment
        org 0:0
NotReadyFlag:   db      ;1--> Not Ready,   0--> OK.
VerifyFail:     db      ;1--> Verify fail, 0--> OK.
Verify:         db      ;1--> Verify on,   0--> verify off
CpuType:        db      ;0Ah -->  Am186/188EM
                        ;0Bh -->  Am186/188ES
                        ;0Ch -->  Am186/188ER
                        ;0Eh -->  Am186ED
TimerSet:       db      ;1--> Enable ,0--> Disable
                        ;bit0--> Timer0
                        ;bit1--> Timer1
                        ;bit2--> Timer2

        org 0:7800h
canData:        ds   20h        ;register buffer
canBuf1:        ds   20h        ;working buffer
replyBuf:       ds   20h        ;
TimerBuf:       ds   20h        ;Timer setting buffer

        org 0:7c00h
canBuf2: ds     1024


data:   ends

memByteTrig:    equ     8000h
memWordTrig:    equ     8004h
ioByteTrig:     equ     8008h
ioWordTrig:     equ     800ch
canEndTrig:     equ     8010h
disHOLDTrig:    equ     8014h
relREGTrig:     equ     8000h
;----------------------------------------------------------
;  MACRO function : RdTargetByte
;  (Read memory from Traget and its access size is Byte)
;   output :  R8
;   input  :  P16 (es:[di], es:[si], ds:[di], or ds:[si])
;----------------------------------------------------------
RdTargetByte:   .MACRO  R8, P16
                mov    cs:[disHOLDTrig],al
RDTaddr#:
aa#:            equ    RDTaddr# .AND. 01h
         IFNZ   aa#              ;Is the address at odd location ?
                nop              ;Add a "nop" instruction if odd address.
         ENDIF
                jmp     short RDTB#
RDTB#:          mov     cs:[memByteTrig],al
                nop
                nop
                mov     R8,P16
                .MACEND

;----------------------------------------------------------
;  MACRO function : RdTargetWord
;  (Read memory from Traget and its access size is Word)
;   output : R16 (ax/bx/cx/dx)
;   input  : P16 (es:[di], es:[si], ds:[di] or ds:[si])
;----------------------------------------------------------
RdTargetWord:   .MACRO  R16, P16
                mov    cs:[disHOLDTrig],al
RDTWaddr#:
bb#:            equ     RDTWaddr# .AND. 01h
          IFNZ  bb#             ;check odd boundary
                nop             ;if odd adrress, add a "NOP" instruction.
          ENDIF
                jmp     short RDTW#
RDTW#:               mov     cs:[memWordTrig],al
                     nop
                     nop
                     mov     R16,P16
                .MACEND

;----------------------------------------------------------
;  MACRO function : WrTargetByte
;  (Write memory to Traget and its access size is Byte)
;   output : none
;   input  : P16 (es:[di]/es:[si]/ds:[di]/ds:[si])
;            R8  (al/bl/cl/dl)
;----------------------------------------------------------
WrTargetByte:   .MACRO   P16, R8
                mov     cs:[disHOLDTrig],al
                jmp     WRTB#
WRTB#:          mov     cs:[memByteTrig],al
                nop
                mov     P16,R8
                .MACEND

;----------------------------------------------------------
;  MACRO function : WrTargetWord
;  (Write memory to Traget and its access size is Word)
;   output : none
;   input  : P16 (es:[di]/es:[si]/ds:[di]/ds:[si])
;            R16 (ax/bx/cx/dx)
;----------------------------------------------------------
WrTargetWord:   .MACRO  P16, R16
                mov     cs:[disHOLDTrig],al
                jmp     WRTW#
WRTW#:          mov     cs:[memWordTrig],al
                nop
                mov     P16,R16
                .MACEND

;----------------------------------------------------------
;  MACRO function : InTargetByte
;  (Input data from Target and its access size is Byte)
;   output : al
;   input  : dx (port address)
;----------------------------------------------------------
InTargetByte:   .MACRO
                mov     cs:[ioByteTrig],al
                nop
                in      al,dx
                .MACEND

;----------------------------------------------------------
;  MACRO function : InTargetWord
;  (Input data from Target and its access size is Word)
;   output : ax
;   input  : dx (port address)
;----------------------------------------------------------
InTargetWord:   .MACRO
                mov     cs:[ioWordTrig],al
                nop
                in      ax,dx
                .MACEND

;----------------------------------------------------------
;  MACRO function : OutTargetByte
;  (Output data to Target and its access size is Byte)
;   output : none
;   input  : dx (port address), al (data)
;----------------------------------------------------------
OutTargetByte:   .MACRO
                mov     cs:[ioByteTrig],al
                nop
                out     dx,al
                .MACEND

;----------------------------------------------------------
;  MACRO function : OutTargetWord
;  (Output data to Target and its access size is Word)
;   output : none
;   input  : dx (port address), ax (data)
;----------------------------------------------------------
OutTargetWord:  .MACRO
                mov     cs:[ioWordTrig],al
                nop
                out     dx,ax
                .MACEND
;----------------------------------------------------------
;       Add 1000h to segment (cs/ds/es/ss)
;----------------------------------------------------------
IncSeg:         .MACRO  reg16, segmemt
                mov     reg16, segmemt
                add     reg16, 1000h
                mov     segmemt, reg16
                .MACEND



code:   segment
.assume  cs:code, ds:code
;-------------------------------------------------------------------
;       Let EP Stop (jump here by external H/W
;                               accesses a jump-here code)
;-------------------------------------------------------------------
        org    0:69h
_ephalt:
        nop
        jmp     far _nextCanProgram   ;CP should modify this destination

        org    0:70h;
_canStart:
;-------------------------------------------------------------------
; GetIf & Get registers
;-------------------------------------------------------------------
_canGetIf:
                mov     cs:canData+4,ax
                mov     cs:canData+6,bx
                mov     cs:canData+10,dx
                mov     cs:canData+16,di
                mov     cs:canData+20,es

                cmp     cs:CpuType,0bh
                jne     SaveReg1

                mov     ax,cs:[relREGTrig]
                test    ax,1000h
                jne     MEMSPACE

;-------------- IO  Access  ------------
                mov     dh,al
                mov     dl,e6h
                in      ax,dx
                mov     cs:[TimerBuf],ax
                and     ax,7FFFh
                mov     bx,ax
                mov     ax,3333h
                out     dx,ax
                mov     ax,CCCCh
                out     dx,ax
                mov     ax,bx
                out     dx,ax
SaveReg1:
                jmp     TMRSET
;-------------  Memory Access --------------
MEMSPACE:
                mov     di,00e6h
                shl     ax,4
                mov     es,ax
                RdTargetWord    ax, es:[di]
                mov     cs:[TimerBuf],ax
                and     ax,7FFFh
                mov     bx,ax
                mov     ax,3333h
                WrTargetWord    es:[di],ax
                mov     ax,CCCCh
                WrTargetWord    es:[di],ax
                WrTargetWord    es:[di],bx

TMRSET:
                mov     ax,cs:[relREGTrig]
                test    ax,1000h
                jne     TMRMEM
;-------------- IO  Access  ------------
                mov     dh,al
                mov     dl,56h
                in      ax,dx
                mov     cs:[TimerBuf+2],ax
                cmp     byte ptr cs:[TimerSet],1
                jne     TM1
                and     ax,3fffh
                out     dx,ax
TM1:
                mov     ax,cs:[relREGTrig]
                mov     dh,al
                mov     dl,5eh
                in      ax,dx
                mov     cs:[TimerBuf+4],ax
                cmp     byte ptr cs:[TimerSet],2
                jne     TM2
                and     ax,3fffh
                out     dx,ax
TM2:
                mov     ax,cs:[relREGTrig]
                mov     dh,al
                mov     dl,66h
                in      ax,dx
                mov     cs:[TimerBuf+6],ax
                cmp     byte ptr cs:[TimerSet],4
                jne     TM3
                and     ax,3fffh
                out     dx,ax
TM3:
                jmp     SaveReg
;-------------  Memory Access --------------
TMRMEM:
                shl     ax,4
                mov     es,ax
                mov     di,0056h
                RdTargetWord    ax, es:[di]
                mov     cs:[TimerBuf+2],ax
                cmp     byte ptr cs:[TimerSet],1
                jne     TM4
                and     ax,3fffh
                WrTargetWord    es:[di],ax
TM4:
                mov     di,005eh
                RdTargetWord    ax, es:[di]
                mov     cs:[TimerBuf+4],ax
                cmp     byte ptr cs:[TimerSet],2
                jne     TM5
                and     ax,3fffh
                WrTargetWord    es:[di],ax
TM5:
                mov     di,0066h
                RdTargetWord    ax, es:[di]
                mov     cs:[TimerBuf+6],ax
                cmp     byte ptr cs:[TimerSet],4
                jne     SaveReg
                and     ax,3fffh
                WrTargetWord    es:[di],ax
SaveReg:
                mov     di,cs:canData+16
                mov     es,cs:canData+20
                mov     dx,cs:canData+10
                mov     bx,cs:canData+6
                mov     ax,cs:canData+4
                mov     cs:canData,ss
                mov     cs:canData+2,sp
_getRegst:
                mov     cs:canData+4,ax
                mov     cs:canData+6,bx
                mov     cs:canData+8,cx
                mov     cs:canData+10,dx
                mov     cs:canData+12,bp
                mov     cs:canData+14,si
                mov     cs:canData+16,di
                mov     cs:canData+18,ds
                mov     cs:canData+20,es

                jmp     _ephalt

;-------------------------------------------------------------------
; Save Register
;-------------------------------------------------------------------
_saveRegst:
                mov     ax, cs:canData+4
                mov     bx, cs:canData+6
                mov     cx, cs:canData+8
                mov     dx, cs:canData+10
                mov     bp, cs:canData+12
                mov     si, cs:canData+14
                mov     di, cs:canData+16
                mov     ds, cs:canData+18
                mov     es, cs:canData+20
                jmp     _ephalt
;-------------------------------------------------------------------
;       Save PC and restore SS and SP registers
;-------------------------------------------------------------------
_canSavePc:

                mov     cs:canData+4  , ax
                mov     cs:canData+10 , dx
                mov     cs:canData+16 , di
                mov     cs:canData+20 , es


                mov     ax,cs:[relREGTrig]
                test    ax,1000h
                jne     MEM
;---------------------- IO  Access  ------------
                mov     dh,al
                mov     dl,56h
                mov     ax,cs:[TimerBuf+2]
                out     dx,ax
                mov     dl,5eh
                mov     ax,cs:[TimerBuf+4]
                out     dx,ax
                mov     dl,66h
                mov     ax,cs:[TimerBuf+6]
                out     dx,ax
;                cmp     cs:CpuType,0bh
;                jne     SPC1
;                mov     dl,e6h
;                mov     ax,3333h
;                out     dx,ax
;                mov     ax,CCCCh
;                out     dx,ax
;                mov     ax,cs:[TimerBuf]
;                out     dx,ax
;SPC1:
                jmp     SavePC
;-------------  Memory Access --------------
MEM:
                shl     ax,4
                mov     es,ax
                mov     di,0056h
                mov     ax,cs:[TimerBuf+2]
                WrTargetWord    es:[di],ax
                mov     di,005eh
                mov     ax,cs:[TimerBuf+4]
                WrTargetWord    es:[di],ax
                mov     di,0066h
                mov     ax,cs:[TimerBuf+6]
                WrTargetWord    es:[di],ax
;                cmp     cs:CpuType,0bh
;                jne     SavePC
;                mov     di,00e6h
;                mov     ax,3333h
;                WrTargetWord    es:[di],ax
;                mov     ax,CCCCh
;                WrTargetWord    es:[di],ax
;                mov     ax,cs:[TimerBuf]
;                WrTargetWord    es:[di],ax
SavePC:
                mov     ax, cs:canData+4
                mov     dx, cs:canData+10
                mov     di, cs:canData+16
                mov     cs:[disHOLDTrig],al
                mov     es, cs:canData+20
                mov     ss, cs:canData                 ;restore ss register
                mov     sp, cs:canData+2               ;restore sp register
                mov     cs:[canEndTrig],al              ;Can End trigger
                iret                                    ;EP will free run after
                                                ; this instruction.
;-------------------------------------------------------------------
;       Set Paramater for memory relation commands
;       es:di --> 1st address
;       ds:si --> 2nd address
;       dx,cx --> address length
;       bp    --> data counter
;       bx    --> temp buffer
;-------------------------------------------------------------------
_setParast:
                mov     es,cs:canBuf1           ;first address.
                mov     di,cs:canBuf1+2
                mov     dx,cs:canBuf1+4         ;address length(bytes).
                mov     cx,cs:canBuf1+06h       ;address length(bytes).
                mov     bp,cs:canBuf1+08h       ;data count.
                mov     bx,cs:canBuf1+0ah       ;temp buffer
                mov     ds,cs:canBuf1+0ch       ;another address.
                mov     si,cs:canBuf1+0eh
                jmp     _ephalt
;
;-------------------------------------------------------------------
;  read memory cx byte from es:di
;-------------------------------------------------------------------
_disByteMem:
                mov     si, offset canBuf2
DisBMLoop:
                RdTargetByte    al, es:[di] ;read memory from target/emm
                mov     cs:[si],al      ;write data to can buffer
                cmp     cs:NotReadyFlag,1   ;check not ready
                jz      DisBNotRdy

                inc     di              ;next point of target/emm
                inc     si              ;next point of can buffer
                or      di, di
                jnz     DisBM1          ;check over segment ?
                IncSeg  ax,es           ; es = es + 1000h
DisBM1:
                loop    DisBMLoop       ;check loop end ?
                jmp     _ephalt         ;EP halt
DisBNotRdy:
                mov     cs:replyBuf,di  ;save not ready address (segment)
                mov     cs:replyBuf+2, es  ;save not ready address (offset)
                jmp     _ephalt
;-------------------------------------------------------------------
;  read memory cx/2 word from es:di
;-------------------------------------------------------------------
_disWordMem:
                shr     cx,1               ;loop counter
                mov     si, offset canBuf2
DisWM1:
                RdTargetWord    ax, es:[di]
                mov     cs:[si], ax

                CMP     cs:NotReadyFlag,1   ;check not ready
                jz      DisWNotRdy
                inc     di              ;adjust target/emm pointer
                or      di,di           ;check over segment
                jnz     DisWM2
                IncSeg  ax,es           ; es = es + 1000h
DisWM2:
                inc     di
                or      di,di
                jnz     DisWM3
                IncSeg  ax,es           ; es = es + 1000h
DisWM3:
                inc     si              ;next can buffer index
                inc     si
                loop    DisWM1
                jmp     _ephalt
DisWNotRdy:
                mov     cs:replyBuf,di  ;save not ready address (segment)
                mov     cs:replyBuf+2, es  ;save not ready address (offset)
                jmp     _ephalt
;-------------------------------------------------------------------
;  Fill data to Target/EMM by size byte
;write byte dx cx times to es:di,data count in bp
;  replyBuf:
;  When Not Ready,                       When Verify Error,
;    replyBuf    --> address (offset)      replyBuf   --> address (offset)
;    replyBuf+2  --> address (segment)     replyBuf+2 --> address (segment)
;                                          replyBuf+4 --> error data
;                                          replyBuf+6 --> expect data
;
;  Note :
;  The Data length (bp) max. = canBuf2 size (1K byte).
;
;-------------------------------------------------------------------
_wrByteMem:
                xor     bx,bx           ;clear bx
WBM1:
                mov     al, cs:canBuf2[bx]
                WrTargetByte  es:[di], al
                CMP     cs:NotReadyFlag,1   ;check not ready
                jz      WrBNotRdy
                CMP     cs:Verify,0         ;check Verify Flag[on/off] ?
                jz      WBM_VerifyOff       ;jump if Verify off.
                RdTargetByte    al, es:[di] ;read memory from target/emm
                cmp     al, cs:canBuf2[bx]  ;verify data pattern
                jnz     WBM_VerifyError
WBM_VerifyOff:
                inc     bx              ;next data pattern index

                cmp     bx,bp           ;test data pattern end ?
                jnz     WBM2            ;jump if yes.
                xor     bx,bx           ;point to start location of data pattern
WBM2:
                inc     di              ;next target/emm index
                or      di,di           ;check segment boundary
                jnz     WBM3
                IncSeg  ax,es           ; es = es + 1000h
WBM3:
                sub     cx, 1           ; counter = counter - 1
                sbb     dx,0
                jnz     WBM4            ; jump if hi-word count. > 0.
                or      cx,cx           ; check low-word count. = 0 ?
                jnz     WBM4            ;
                jmp     short WBM5      ; jump if counter = 0.
WBM4:
                jmp     WBM1
WBM5:
                mov     cs:VerifyFail,0 ;set Verify OK.
                jmp     _ephalt
WrBNotRdy:
                mov     cs:replyBuf,di  ;save not ready address (segment)
                mov     cs:replyBuf+2, es  ;save not ready address (offset)
                jmp     _ephalt
WBM_VerifyError:
                mov     cs:VerifyFail,1  ;set Verify Error
                mov     cs:replyBuf,di
                mov     cs:replyBuf+2, es
                xor     ah,ah
                mov     cs:replyBuf+4, ax ;error data pattern
                mov     al, cs:canBuf2[bx]
                mov     cs:replyBuf+6, ax ;expect data pattern.
                jmp     _ephalt
;-------------------------------------------------------------------
;  Fill data to Target/EMM by size Word
;write byte dx cx/2 times to es:di,data count in bp
;  replyBuf:
;  When Not Ready,                       When Verify Error,
;    replyBuf    --> address (offset)      replyBuf   --> address (offset)
;    replyBuf+2  --> address (segment)     replyBuf+2 --> address (segment)
;                                          replyBuf+4 --> error data
;                                          replyBuf+6 --> expect data
;
;  Note :
;  The Data length (bp) max. = canBuf2 size (1K byte).
;
;-------------------------------------------------------------------
_wrWordMem:
                shr     dx,1            ;counter = counter / 2
                rcr     cx,1
                xor     bx,bx           ;clear bx
WWM1:
                mov     al, cs:canBuf2[bx]

                inc     bx              ;next data pattern index
                cmp     bx,bp           ;test data pattern end ?
                jnz     WWM10           ;jump if yes.
                xor     bx,bx           ;point to start location of data pattern
WWM10:
                mov     ah, cs:canBuf2[bx]
                inc     bx              ;next data pattern index

                cmp     bx,bp           ;test data pattern end ?
                jnz     WWM11           ;jump if yes.
                xor     bx,bx      ;point to start location of data pattern
WWM11:
                WrTargetWord  es:[di], ax
                CMP     cs:NotReadyFlag,1   ;check not ready
                jz      WrWNotRdy
                CMP     cs:Verify,0         ;check Verify Flag[on/off] ?
                jz      WWM_VerifyOff       ;jump if Verify off.
                mov     si,ax          ;save expect data to SI register
                RdTargetWord    ax, es:[di] ;read memory from target/emm
                cmp     ax, si              ;verify data pattern
                jnz     WWM_VerifyError
WWM_VerifyOff:
                inc     di              ;next target/emm index
                or      di,di           ;check segment boundary
                jnz     WWM3
                IncSeg  ax,es           ; es = es + 1000h
WWM3:
                inc     di              ;next target/emm index
                or      di,di           ;check segment boundary
                jnz     WWM30
                IncSeg  ax,es           ; es = es + 1000h
WWM30:
                sub     cx,1            ; counter = counter - 1
                sbb     dx,0
                jnz     WWM4            ; jump if hi-word count. > 0.
                or      cx,cx           ; check low-word count. = 0 ?
                jnz     WWM4            ;
                jmp     short WWM5      ; jump if counter = 0.
WWM4:
                jmp     WWM1
WWM5:
                mov     cs:VerifyFail,0 ;set Verify OK.
                jmp     _ephalt
WrWNotRdy:
                mov     cs:replyBuf,di  ;save not ready address (segment)
                mov     cs:replyBuf+2, es  ;save not ready address (offset)
                jmp     _ephalt
WWM_VerifyError:
                mov     cs:VerifyFail,1  ;set Verify Error
                mov     cs:replyBuf,di
                mov     cs:replyBuf+2, es
                mov     cs:replyBuf+4, ax ;error data pattern
                mov     cs:replyBuf+6, si ;expect data pattern.
                jmp     _ephalt
;-------------------------------------------------------------------
;    Memory Test when access size is byte.
; Start address es:di,length dx cx
; error flag in VerifyFail, 1 is error
;  replyBuf:
;  When Not Ready,                       When Verify Error,
;    replyBuf    --> address (offset)      replyBuf   --> address (offset)
;    replyBuf+2  --> address (segment)     replyBuf+2 --> address (segment)
;                                          replyBuf+4 --> error data
;                                          replyBuf+6 --> expect data
;
;-------------------------------------------------------------------
_tstByteMem:
;               ---------------------------
;                Fill test pattern to Memory
;               ---------------------------
                mov     cs:canBuf1,es   ;save input arguments.
                mov     cs:canBuf1+2,di
                mov     cs:canBuf1+4,dx
                mov     cs:canBuf1+6,cx

TSTBM_loop1:
                mov     ax,di           ;compute test pattern
                xor     ax,es
                xor     al,ah
                WrTargetByte  es:[di], al
                CMP     cs:NotReadyFlag,1   ;check not ready
                jnz     TSTBM0
                jmp     TstBNotRdy

TSTBM0:
                inc     di              ;next target/emm index
                or      di,di           ;check segment boundary
                jnz     TSTBM1
                IncSeg  ax,es           ; es = es + 1000h
TSTBM1:
                sub     cx,1            ;counter = counter - 1
                sbb     dx,0
                jnz     TSTBM2
                or      cx,cx
                jnz     TSTBM2
                jmp     short TSTBM3
TSTBM2:
                jmp     TSTBM_loop1
TSTBM3:
;               --------------------------
;                 Compare  test pattern
;               --------------------------
                mov     cx, cs:canBuf1+6 ; restore input arguments.
                mov     dx, cs:canBuf1+4
                mov     di, cs:canBuf1+2
                mov     es, cs:canBuf1
TSTBM_loop2:
                mov     ax,di           ;compute test pattern
                xor     ax,es
                xor     al,ah

                RdTargetByte    bl, es:[di] ;read memory from target/emm
                CMP     cs:NotReadyFlag,1   ;check not ready
                jz      TstBNotRdy

                cmp     bl, al          ;compare test pattern
                jnz     TSTBM_error
                not     al              ;change test patterns.

                WrTargetByte  es:[di], al
                CMP     cs:NotReadyFlag,1   ;check not ready
                jz      TstBNotRdy

                RdTargetByte    bl, es:[di] ;read memory from target/emm
                CMP     cs:NotReadyFlag,1   ;check not ready
                jz      TstBNotRdy
                cmp     bl,al           ;compare test pattern
                jnz     TSTBM_error

                inc     di              ;next target/emm index
                or      di,di           ;check segment boundary
                jnz     TSTBM4
                IncSeg  ax,es           ; es = es + 1000h
TSTBM4:
                sub     cx, 1           ;counter = counter - 1
                sbb     dx,0
                jnz     TSTBM5
                or      cx,cx
                jnz     TSTBM5
                mov     cs:VerifyFail,0 ;set TEST  OK.
                jmp     _ephalt
TSTBM5:
                jmp     TSTBM_loop2
TstBNotRdy:
                mov     cs:replyBuf,di  ;save not ready address (segment)
                mov     cs:replyBuf+2, es  ;save not ready address (offset)
                jmp     _ephalt
TSTBM_error:
                mov     cs:VerifyFail,1  ;set TEST Error
                mov     cs:replyBuf,di   ;save error address (offset)
                mov     cs:replyBuf+2, es ;    error address (segment)
                xor     bh,bh
                xor     ah,ah
                mov     cs:replyBuf+4, bx ;error data pattern
                mov     cs:replyBuf+6, ax ;expect data pattern.
                jmp     _ephalt
;-------------------------------------------------------------------
;    Memory Test when access word is byte.
; Start address es:di,length dx cx/2
; error flag in VerifyFail, 1 is error
;  replyBuf:
;  When Not Ready,                       When Verify Error,
;    replyBuf    --> address (offset)      replyBuf   --> address (offset)
;    replyBuf+2  --> address (segment)     replyBuf+2 --> address (segment)
;                                          replyBuf+4 --> error data
;                                          replyBuf+6 --> expect data
;
;-------------------------------------------------------------------
_tstWordMem:
                shr     dx,1            ; counter = counter /2
                rcr     cx,1

                mov     cs:canBuf1,es   ;save input arguments.
                mov     cs:canBuf1+2,di
                mov     cs:canBuf1+4,dx
                mov     cs:canBuf1+6,cx
;               ---------------------------
;                Fill test pattern to Memory
;               ---------------------------
TSTWM_loop1:
                mov     ax,di           ;compute test pattern
                xor     ax,es
                xor     al,ah           ;al is low byte test pattern.

                mov     si,di           ;compute high byte test pattern
                inc     si
                mov     bx,si
                xor     bx,es
                xor     bl,bh            ;bl is high byte test pattern.
                mov     ah,bl            ;ax is a word test pattern

                WrTargetWord  es:[di], ax ;write test pattern to Memory
                CMP     cs:NotReadyFlag,1   ;check not ready
                jnz     TSTWM1
                jmp     TstWNotRdy
TSTWM1:
                inc     di              ;next target/emm index
                or      di,di           ;check segment boundary
                jnz     TSTWM2
                IncSeg  ax,es           ; es = es + 1000h
TSTWM2:

                inc     di              ;next target/emm index
                or      di,di           ;check segment boundary
                jnz     TSTWM3
                IncSeg  ax,es           ; es = es + 1000h
TSTWM3:
                sub     cx,1            ;counter = counter - 1
                sbb     dx,0
                jnz     TSTWM4
                or      cx,cx
                jnz     TSTWM4
                jmp     TSTWM5
TSTWM4:
                jmp     TSTWM_loop1
TSTWM5:
;               --------------------------
;                 Compare  test pattern
;               --------------------------
                mov     cx, cs:canBuf1+6 ; restore input arguments.
                mov     dx, cs:canBuf1+4
                mov     di, cs:canBuf1+2
                mov     es, cs:canBuf1
TSTWM_loop2:
                mov     ax,di           ;compute test pattern.
                xor     ax,es
                xor     al,ah           ;al is low byte test pattern.

                mov     si,di           ;compute high test pattern.
                inc     si              ;si is high byte location
                mov     bx,si
                xor     bx,es
                xor     bl,bh           ;bl is high byte test pattern.
                mov     ah,bl      ;ax is a word test pattern.

                RdTargetWord    bx, es:[di] ;read memory from target/emm
                CMP     cs:NotReadyFlag,1   ;check not ready
                jz      TstWNotRdy
                cmp     bx,ax               ;compare test pattern
                jnz     TSTWM_error
                not     ax                  ;change test pattern

                WrTargetWord  es:[di], ax ;write test pattern to Memory
                CMP     cs:NotReadyFlag,1   ;check not ready
                jz      TstWNotRdy
                RdTargetWord    bx, es:[di] ;read memory from target/emm
                CMP     cs:NotReadyFlag,1   ;check not ready
                jz      TstWNotRdy
                cmp     bx,ax               ;compare test pattern
                jnz     TSTWM_error

                inc     di              ;next target/emm index
                or      di,di           ;check segment boundary
                jnz     TSTWM6
                IncSeg  ax,es           ; es = es + 1000h
TSTWM6:
                inc     di              ;next target/emm index
                or      di,di
                jnz     TSTWM7
                IncSeg  ax,es           ; es = es + 1000h
TSTWM7:
                sub     cx, 1           ;counter = counter - 1
                sbb     dx,0
                jnz     TSTWM8
                or      cx,cx
                jnz     TSTWM8
                mov     cs:VerifyFail,0 ;set TEST  OK.
                jmp     _ephalt

TSTWM8:
                jmp     TSTWM_loop2
TstWNotRdy:
                mov     cs:replyBuf,di  ;save not ready address (segment)
                mov     cs:replyBuf+2, es  ;save not ready address (offset)
                jmp     _ephalt
TSTWM_error:
                mov     cs:VerifyFail,1  ;set TEST Error
                mov     cs:replyBuf,di   ;save error address (offset)
                mov     cs:replyBuf+2, es ;    error address (segment)
                mov     cs:replyBuf+4, bx ;error data pattern
                mov     cs:replyBuf+6, ax ;expect data pattern.
                jmp     _ephalt
;-------------------------------------------------------------------
; byte input,port in dx,length in cx,echo data in _canBuf2
;-------------------------------------------------------------------
_inByte:
                xor     si,si           ;clear si (buffer start location)
INBYTE_loop:
                InTargetByte            ;Input Target from (dx) port to al
                mov     cs:canBuf2[si], al ;input data save to can buffer
                CMP     cs:NotReadyFlag,1   ;check not ready
                jz      INBNotRdy
                inc     si              ;next can buffert index
                inc     dx              ;next input port address
                loop    INBYTE_loop
                jmp     _ephalt
INBNotRdy:
                mov     cs:replyBuf,dx  ;save Not Ready Address
                jmp     _ephalt

;-------------------------------------------------------------------
; Word input,port in dx,length in cx,echo data in _canBuf2
;-------------------------------------------------------------------
_inWord:
                xor     si,si           ;clear si (can buffer index)
                shr     cx,1            ;counter = counter /2
INWORD_loop:
                InTargetWord            ;input target (dx) port to AX
                mov     cs:canBuf2[si], ax ;save data to can buffer
                CMP     cs:NotReadyFlag,1   ;check not ready
                jz      INWNotRdy
                inc     si              ;adjust index of can buffer
                inc     si
                inc     dx              ;adjust address of next port.
                inc     dx
                loop    INWORD_loop
                jmp     _ephalt
INWNotRdy:
                mov     cs:replyBuf,dx  ;save Not Ready Address
                jmp     _ephalt

;-------------------------------------------------------------------
;  output data to dx port, data length is cx, access size is byte,
;  data be put at canBut2.
;-------------------------------------------------------------------
_outByte:
                xor     si,si           ;INITIAL POINTER
OBT_loop:
                mov     al,cs:canBuf2[si]  ;GET OUTPUT DATA
                OutTargetByte           ;output al to dx port
                CMP     cs:NotReadyFlag,1   ;check not ready
                jz      OBTNotRdy
                inc     si              ;UPDATE SAVE BUFFER POINTER.
                loop    OBT_loop
                jmp     _ephalt
OBTNotRdy:
                mov     cs:replyBuf,dx  ;save Not Ready Address
                jmp     _ephalt

;-------------------------------------------------------------------
;  output data to dx port, data length is cx, access size is word,
;  data be put at canBut2.
;-------------------------------------------------------------------
_outWord:
                shr     cx,1            ;counter = counter/2
                xor     si,si           ;initial index of can buffer
OWD_loop:
                mov     ax,cs:canBuf2[si]  ; Get output data
                OutTargetWord           ;output al to dx port
                CMP     cs:NotReadyFlag,1   ;check not ready
                jz      OWDNotRdy
                inc     si              ;next index of can buffer
                inc     si
                loop    OWD_loop
                jmp     _ephalt         ;
OWDNotRdy:
                mov     cs:replyBuf,dx  ;save Not Ready Address
                jmp     _ephalt
;-------------------------------------------------------------------
;  On Chip Peripheral Access
;-------------------------------------------------------------------
;          canBuf2   --> RELREG  (word)
;          canBuf2+2 --> Offset  (byte)
;          canBuf2+3 --> length  (byte)  1:byte, 2:word
;          canBuf2+4 --> data   (word)
;          canBuf2+6 --> read/write  ( 1[read]/0[write] )
MIO:            equ     1000h
RW:             equ     01h
BYTE_ON:           equ     01h
_onChipReg:
                mov     cs:canData+4, ax  ;save ax
                mov     cs:canData+8, cx  ;save cx
                mov     cs:canData+10, dx ;save dx
                mov     cs:canData+16, di ;save di
                mov     cs:canData+20, es ;save es

;                mov     cl, 4
;                mov     dx, cs:canBuf2
;                and     dx, 0ff00h
;                shl     dx, cl
;                mov     es, dx             ;es, address segment
;                mov     dh, cs:canBuf2     ;address bit[15..8]
;                mov     dl, cs:canBuf2+2   ;address bit[7..0]
;                mov     di, dx             ;address offset for memory
;                test    byte ptr cs:canBuf2+1, MIO ;check Memory/IO space ?

                mov     ax,cs:[relREGTrig]
                test    ax,MIO
                jnz     ONCHIPM
;--------------------- IO access ---------------------------
                mov     dh,al
                mov     dl,cs:canBuf2+2
                test    byte ptr cs:canBuf2+6, RW
                jz      IOOUT
                cmp     byte ptr cs:canBuf2+3, BYTE_ON
                jnz     IOREADWORD
                InTargetByte            ;Input Target from (dx) port to al
                xor     ah, ah          ;save input data
                mov     cs:canBuf2+4, ax
                jmp     ONCHIPEND
IOREADWORD:
                InTargetWord            ;input target (dx) port to AX
                mov     cs:canBuf2+4, ax;save input data
                jmp     ONCHIPEND
;               ......... Output .....................
IOOUT:
                cmp     byte ptr cs:canBuf2+3, BYTE_ON
                jnz     IOOUTWORD
                mov     al, cs:canBuf2+4;get output data
                OutTargetByte           ;output al to dx port
                jmp     ONCHIPEND
IOOUTWORD:
                mov     ax, cs:canBuf2+4 ;get output data
                OutTargetWord           ;output al to dx port
                jmp     ONCHIPEND
;---------------------- Memory Access ----------------------
ONCHIPM:
                mov     di,cs:canBuf2+2
                shl     ax,4
                mov     es,ax
                test    byte ptr cs:canBuf2+6, RW
                jz      MEMWR
                cmp     byte ptr cs:canBuf2+3, BYTE_ON
                jnz     MEMRDWORD
                RdTargetByte    al, es:[di] ;read memory from target/emm
                xor     ah, ah
                mov     cs:canBuf2+4, ax    ;save read data.
                jmp     ONCHIPEND
MEMRDWORD:
                RdTargetWord    ax, es:[di] ;read memory from target/emm
                mov     cs:canBuf2+4, ax    ;save read data.
                jmp     ONCHIPEND
;               ...... Memory Write.........
MEMWR:
                cmp     byte ptr cs:canBuf2+3, BYTE_ON
                jnz     MEMWRWORD
                mov     al, cs:canBuf2+4    ;write data
                WrTargetByte  es:[di], al
                jmp     ONCHIPEND
MEMWRWORD:
                mov     ax, cs:canBuf2+4    ;write data
                WrTargetWord  es:[di], ax
ONCHIPEND:
                mov     ax,  cs:canData+4  ;restore ax
                mov     cx,  cs:canData+8  ;restore cx
                mov     dx,  cs:canData+10 ;restore dx
                mov     di,  cs:canData+16 ;restore di
                mov     es,  cs:canData+20 ;restore es
                jmp     _ephalt


;-------------------------------------------------------------------
;byte checksum,starting address ES DI, length DX CX
; Not Ready flag in NotReadyFlag,
;  replyBuf:
;  When Not Ready,
;    replyBuf    --> address (offset)
;    replyBuf+2  --> address (segment)
;    replyBuf+4  --> CheckSum (Size=Byte)
;-------------------------------------------------------------------
_chkSumByte:
                xor     bx, bx           ;clear bx
CHKSBL1:
                RdTargetByte    al, es:[di] ;read one byte data from tar/emm
                cmp     cs:NotReadyFlag,1   ;check not ready
                jz      CSBNotRdy
                add     bl, al          ;bl is checkSum.
                adc     bl, 0
                inc     di              ;next address.
                or      di,di           ;check segment boundary
                jnz     CHKSBL2
                IncSeg  ax,es           ; es = es + 1000h
CHKSBL2:
                sub     cx, 1           ;counter = counter - 1
                sbb     dx,0
                jnz     CHKSBL1
                or      cx,cx
                jnz     CHKSBL1
                mov     cs:replyBuf+4, bx
                jmp     _ephalt
CSBNotRdy:
                mov     cs:replyBuf,di  ;save not ready address (segment)
                mov     cs:replyBuf+2, es  ;save not ready address (offset)
                jmp     _ephalt

;-------------------------------------------------------------------
;Word checksum,starting address ES DI, length DX CX
; Not Ready flag in NotReadyFlag,
;  replyBuf:
;  When Not Ready,
;    replyBuf    --> address (offset)
;    replyBuf+2  --> address (segment)
;    replyBuf+4  --> CheckSum (Size=word)
;-------------------------------------------------------------------
_chkSumWord:
                xor     bx, bx
                shr     dx, 1           ; counter = counter / 2.
                rcr     cx, 1

CHKSWL1:
                RdTargetByte    al, es:[di] ;read one byte data from tar/emm
                cmp     cs:NotReadyFlag,1   ;check not ready
                jz      CSWNotRdy
                inc     di
                or      di,di           ;check segment boundary
                jnz     CHKSWL2
                IncSeg  si,es           ; es = es + 1000h
CHKSWL2:
                RdTargetByte    ah, es:[di] ;read one byte data from tar/emm
                cmp     cs:NotReadyFlag,1   ;check not ready
                jz      CSWNotRdy
                add     bx, ax          ;bl is checkSum.
                adc     bx, 0
                inc     di              ;next address.
                or      di,di           ;check segment boundary
                jnz     CHKSWL3
                IncSeg  si,es           ; es = es + 1000h
CHKSWL3:
                sub     cx, 1           ;counter = counter - 1
                sbb     dx,0
                jnz     CHKSWL1
                or      cx,cx
                jnz     CHKSWL1
                mov     cs:replyBuf+4, bx
                jmp     _ephalt
CSWNotRdy:
                mov     cs:replyBuf,di  ;save not ready address (segment)
                mov     cs:replyBuf+2, es  ;save not ready address (offset)
                jmp     _ephalt

;----------------------------------------------------
; byte search,starting address ES DI,length DX CX,data count BP
; data count temp buffer in ds,buffer pointer si,compare pattern bx=1
; data string in _canBuf2

_seaByteMem:
                xor     bx,bx                ;clear bx
                mov     ds,bp                ;save data count in ds
SBM1:
                RdTargetByte  al,es:[di]        ;read memory from target/emm
                CMP     cs:NotReadyFlag,1       ;check not ready
                jz      SeaBNotRdy
                cmp     al, cs:canBuf2[bx]      ;compare data equal ?
                jne     SBM6
                mov     cs:VerifyFail,0         ;
                cmp     bx,0
                jne     SBM2
                mov     cs:replyBuf+2,di          ;save offset  in buffer
                mov     cs:replyBuf,es            ;save segment in buffer
SBM2:
                dec     bp
                jne     SBM4
                jmp     _ephalt
SBM4:
                inc     bx
SBM3:
                inc     di
                or      di,di
                jne     SBM5
                IncSeg  ax,es
SBM5:
                sub     cx,1
                sbb     dx,0
                jne     SBM1
                or      cx,cx
                jne     SBM1
                jmp     _ephalt
SBM6:
                mov     cs:VerifyFail,1         ;
                cmp     bx,0
                je      SBM3
                dec     bx
                je      SBM1
                add     cx,bx
                adc     dx,0
                sub     di,bx
                jnc     SBM7
                mov     ax,es
                sub     ax,1000
                mov     es,ax
SBM7:
                mov     bp,ds
                xor     bx,bx
                jmp     SBM1
SeaBNotRdy:
                mov     cs:VerifyFail,1      ;
                mov     cs:replyBuf+2,di     ;save not ready address (offset)
                mov     cs:replyBuf,es       ;save not ready address (segment)
                jmp     _ephalt

;------------------------------------------------
;byte compare,starting source BP,DI,destination BX,SI,Length DX,CX
;error flag in _canTop+1, 1 is error                          

_comByteMem:
                mov     cs:VerifyFail,0      ;
CBM3:
                RdTargetByte  al,es:[di]
                CMP     cs:NotReadyFlag,1       ;check not ready
                jz      CBM4
                RdTargetByte  ah,ds:[si]
                cmp     ah,al
                jne     CBM4
                inc     di
                or      di,di
                jne     CBM1
                IncSeg  bx,es
CBM1:
                inc     si
                or      si,si
                jne     CBM2
                IncSeg  bx,ds
CBM2:
                sub     cx,1
                sbb     dx,0
                jne     CBM3
                or      cx,cx
                jne     CBM3
                jmp     _ephalt
CBM4:
                mov     cs:VerifyFail,1      ;
                mov     cs:replyBuf,es       ;save source address (segment)
                mov     cs:replyBuf+2,di     ;save source address (offset)
                mov     cs:replyBuf+4,al     ;save source data
                mov     cs:replyBuf+6,ds     ;save destination address (segment)
                mov     cs:replyBuf+8,si     ;save destination address (offset)
                mov     cs:replyBuf+10,ah    ;save destination data
                jmp     _ephalt


;------------------------------------------------
;word compare,starting source BP,DI,destination BX,SI,Length DX,CX
;error flag in _canTop+1, 1 is error                          

_comWordMem:
                mov     cs:VerifyFail,0      ;
                shr     dx, 1                ; counter = counter / 2.
                rcr     cx, 1
CWM3:
                RdTargetWord  ax,es:[di]
                cmp     cs:NotReadyFlag,1       ;check not ready
                jz      CWM4
                RdTargetWord  bx,ds:[si]
                cmp     cs:NotReadyFlag,1       ;check not ready
                jz      CWM4
                cmp     ax,bx
                jne     CWM4
                inc     di
                or      di,di
                jne     CWM1
                IncSeg  bx,es
CWM1:
                inc     di
                or      di,di
                jne     CWM5
                IncSeg  bx,es
CWM5:
                inc     si
                or      si,si
                jne     CWM2
                IncSeg  bx,ds
CWM2:
                inc     si
                or      si,si
                jne     CWM6
                IncSeg  bx,ds
CWM6:
                sub     cx,1
                sbb     dx,0
                jne     CWM3
                or      cx,cx
                jne     CWM3
                jmp     _ephalt
CWM4:
                mov     cs:VerifyFail,1      ;
                mov     cs:replyBuf,es       ;save source address (segment)
                mov     cs:replyBuf+2,di     ;save source address (offset)
                mov     cs:replyBuf+4,ax     ;save source data
                mov     cs:replyBuf+6,ds     ;save destination address (segment)
                mov     cs:replyBuf+8,si     ;save destination address (offset)
                mov     cs:replyBuf+10,bx    ;save destination data
                jmp     _ephalt

;--------------------------------------------------------------
; COPY TRANSFER ALGORITHM:
;		      ---------------------------------------------------
;		      |///////////////////////XXXXXX\\\\\\\\\\\\\\\\\\\\|
;		      ---------------------------------------------------
;		      |<------- BLOCK-A   ----|--->|			|
;					      |<------- BLOCK-B  ------>|
; FORWARD_COPY : SOURCE = BLOCK-B, DESTINATION = BLOCK-A
; BACKWARD_COPY: SOURCE = BLOCK-A, DESTINATION = BLOCK-B
;------------------------------------------------------------------------------

_preCopy:
                RdTargetByte  al,es:[di]
                cmp     cs:NotReadyFlag,1       ;check not ready
                jz      PRCMerror
                WrTargetByte  ds:[si], al
                cmp     cs:NotReadyFlag,1       ;check not ready
                jz      PRCMerror
                CMP     cs:Verify,0         ;check Verify Flag[on/off] ?
                jz      PRCM_VerifyOff       ;jump if Verify off.
                RdTargetByte  ah,ds:[si]
                cmp     ah,al
                jne     PRCMerror
PRCM_VerifyOff:
                inc     si
                or      si,si
                jne     PRCM1
                IncSeg  ax,ds
PRCM1:
                inc     di
                or      di,di
                jne     PRCM2
                IncSeg  ax,es
PRCM2:
                sub     cx,1
                sbb     dx,0
                jne     _preCopy
                or      cx,cx
                jne     _preCopy
                jmp     _ephalt
PRCMerror:
                mov     cs:VerifyFail,1      ;
                mov     cs:replyBuf,es       ;save source address (segment)
                mov     cs:replyBuf+2,di     ;save source address (offset)
                mov     cs:replyBuf+4,ds     ;save destination address (segment)
                mov     cs:replyBuf+6,si     ;save destination address (offset)
                jmp     _ephalt


;------------------------------------------------------------------------------

_postCopy:
                mov     cs:canBuf1  ,cx
                mov     cs:canBuf1+2,dx
POCM6:
                sub     cx,1
                sbb     dx,0
                jne     POCM7
                or      cx,cx
                jne     POCM7
                jmp     POCM5
POCM7:
                inc     si
                or      si,si
                jne     POCM4
                IncSeg  ax,ds
POCM4:
                inc     di
                or      di,di
                jne     POCM8
                IncSeg  ax,es
POCM8:
                jmp     POCM6
POCM5:
                mov     cx,cs:canBuf1
                mov     dx,cs:canBuf1+2
                mov     cs:canBuf1  ,es
                mov     cs:canBuf1+2,di
                mov     cs:canBuf1+4,ds
                mov     cs:canBuf1+6,si
POCM3:
                RdTargetByte  al,es:[di]
                cmp     cs:NotReadyFlag,1       ;check not ready
                jz      POCMerror
                WrTargetByte  ds:[si], al
                cmp     cs:NotReadyFlag,1       ;check not ready
                jz      POCMerror
                CMP     cs:Verify,0         ;check Verify Flag[on/off] ?
                jz      POCM_VerifyOff       ;jump if Verify off.
                RdTargetByte  ah,ds:[si]
                cmp     ah,al
                jne     POCMerror
POCM_VerifyOff:
                dec     si
                jne     POCM1
                mov     ax,ds
                sub     ax,1000h
                mov     ds,ax
POCM1:
                dec     di
                jne     POCM2
                mov     ax,es
                sub     ax,1000h
                mov     es,ax
POCM2:
                sub     cx,1
                sbb     dx,0
                jne     POCM3
                or      cx,cx
                jne     POCM3
                jmp     _ephalt
POCMerror:
                mov     cs:VerifyFail,1      ;
                mov     cs:replyBuf,es       ;save source address (segment)
                mov     cs:replyBuf+2,di     ;save source address (offset)
                mov     cs:replyBuf+4,ds     ;save destination address (segment)
                mov     cs:replyBuf+6,si     ;save destination address (offset)
                jmp     _ephalt







_nextCanProgram:                           ; &&end

code:   ends

