/****************************************************************************
**
** Name: codecov.h
**
** Description:
**   Header file for trigger and trace operation
**
** Status: PRELIMINARY
**
****************************************************************************/


#define _CODECOV_

                       /****************************
                        *                          *
                        *      INCLUDE FILES       *
                        *                          *
                        ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

#ifndef _TRCLIB_
#include "trclib.h"
#endif

                       /****************************
                        *                          *
                        *       DEFINITIONS        *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/


/*****************************************************************************
**
**  ProgramMNCodeCov
**
**  Description:
**      set TMAN to code coverage config
**  Parameters:
**    input:
**      coderange : point to structure shown as follows
**        coderange->use : this range is used or not
**        coderange->addr : set code coverage address
**        coderange->status : set code coverage status
******************************************************************************/
RETCODE ProgramMNCodeCov(SPA_CC_RANGE_NODE *coderange) ;

/*****************************************************************************
**
**  ListCodeCov
**
**  Description:
**    List code coverage data from trace memory
**
**  Parameters:
**    input:
**      adder : read data from this addr
**      len :
**      *data : a pointer to code coverage data
**
******************************************************************************/
RETCODE ListCodeCov(CC_ADDR *Addr,U16 len,U8 *data) ;
