/****************************************************************************
**
** Name: trcevent.h
**
** Description:
**   Bus event setting services header file
**
** Status: PRELIMINARY
**
** $Log:   S:/tbird/arcmtat2/am186/trace/trcevent.h_v  $
** 
**    Rev 1.0   20 Mar 1998 09:31:38   Eric
** Initial revision.
** 
**    Rev 1.1   16 Jun 1997 14:20:56   ibin
** 
**    Rev 1.0   10 May 1996 10:03:30   jacky
** Get file from ATL. V1.3
**
** $Header:   S:/tbird/arcmtat2/am186/trace/trcevent.h_v   1.0   20 Mar 1998 09:31:38   Eric  $
**
** Copyright (C) 1992 Microtek International. All rights reserved.
**
****************************************************************************/

#define _TRCEVENT_

                       /****************************
                        *                          *
                        *      INCLUDE FILES       *
                        *                          *
                        ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

                       /****************************
                        *                          *
                        *       DEFINITIONS        *
                        *                          *
                        ****************************/
typedef enum { ADDR_FIELD, DATA_FIELD, STATUS_FIELD } EVENT_FIELD;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/******************************************************************************
**
**  SetRangeAddr
**
**  Description:
**    Set upper or lower bound of range addr of one event
**
**  Parameters:
**    input:
**      addrlo : lower addr of one event
**      addrhi : upper addr of one event
**      eventID : event ID
**    output:
**      <none>
**
*******************************************************************************/
RETCODE SetRangeAddr(U32 addrlo,U32 addrhi,U8 eventID) ;

/******************************************************************************
**
**  SetSingleMask
**
**  Description:
**    Set addr, data or status field of one event to a single value or
**    a value with mask.
**    For a single value, set the input parameter "mask" to be 0xFFFFFFFF.
**
**  Parameters:
**    input:
**      field: ADDR_FIELD, DATA_FIELD or STATUS_FIELD
**      value: setting value
**      mask: setting mask
**      eventID : event ID
**    output:
**      <none>
**
*******************************************************************************/
RETCODE SetSingleMask(EVENT_FIELD field,U32 value, U32 mask, U8 eventID) ;

/******************************************************************************
**
**  WrBCOneAddr
**
**  Description:
**      Write data to Bus Compare SSRAM at singal addr.
**
**  Parameters:
**    input:
**      port: set port to write
**      addr: addr value
**      bit: which bit is mask
**      data: data value
**      eventID : event ID
**    output:
**      <none>
**
*******************************************************************************/
VOID WrBCOneAddr(U8 port,U16 addr,U16 bit,U16 data,U8 eventID) ;

/******************************************************************************
**
**  SetBCData
**
**  Description:
**      Set Bus Compare SSRAM data
**
**  Parameters:
**    input:
**      port: set port to write
**      mask: data mask value
**      set:  set data value
**    output:
**      <none>
**
*******************************************************************************/
VOID SetBCData(U8 port,U16 mask,U16 set) ;

/******************************************************************************
**
**  WrBCMaskAddr
**
**  Description:
**      Write data to Bus compare SSRAM at maskable addr.
**
**  Parameters:
**    input:
**      port: set which port to write
**      addrmask: addr mask value
**      addrset: set addr value
**      datamask: data mask value
**      dataset: set data value
**      fcnt : counter value
**    output:
**      <none>
**
*******************************************************************************/
VOID WrBCMaskAddr(U8 port,U16 addrmask,U16 addrset,U16 datamask,U16 dataset,
                  U16 fcnt) ;

/******************************************************************************
**
**  SetAllBusEvent
**
**  Description:
**    Set all bus events to MTAT-II
**
**  Parameters:
**    input:
**      events: pointer to event 0 structure and the following should
**              contain bus event 1, 2, 3, ... structure
**    output:
**      <none>
**
*******************************************************************************/
RETCODE SetAllBusEvent(BUS_EVENT *events);

RETCODE ClearAllEvent(VOID) ;
/******************************************************************************
**
**  WriteSeqRAMs
**
**  Description:
**    Write state machine data to Sequential RAM
**
**  Parameters:
**    input:
**      *buffer: pointer to the data read from Sequential RAM
**      *data: pointer to the data written into Sequential RAM
**    output:
**      if data != buffer ,return error.
**
*******************************************************************************/
RETCODE WriteSeqRAMs(U8 _far *data,U8 _far *buffer);


RETCODE SetOneEvent(BUS_EVENT *eventStruc,U8 eventID);
RETCODE SetRangeAddr(U32 addrlo,U32 addrhi,U8 eventID) ;
RETCODE SetSingleMask(EVENT_FIELD field,U32 value, U32 mask, U8 eventID) ;

VOID SetExternalTraceBit(U8 value,U8 mask,U8 eventID) ;

RETCODE SetMultiStatus(U32 status,U32 value,U32 mask,U8 eventID) ;

VOID SetBCAddr(U8 port,U16 mask,U16 set,U16 fcnt) ;
VOID SetBCData(U8 port,U16 mask,U16 set) ;

VOID WrBCRangeAddr(U8 port,U16 addr,U16 bit,U16 fcnt,U8 eventID) ;
VOID WrBCOneAddr(U8 port,U16 addr,U16 bit,U16 data,U8 eventID) ;
VOID WrBCMaskAddr(U8 port,U16 addrmask,U16 addrset,U16 datamask,U16 dataset,
                  U16 fcnt) ;
/********************************* EOF *************************************/
