/***************************************************************************
**
** Name: trcflex.c
**
** Description:
**   Services for Altera's programming
**
****************************************************************************/

                       /****************************
                        *                          *
                        *      INCLUDE FILES       *
                        *                          *
                        ****************************/

#include <string.h>
#include <dos.h>
#include <conio.h>

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif

//  #ifndef _TRCERROR_
//  #include "trcerror.h"
//  #endif

#ifndef _TRCTMAN_
#include "trctman.h"
#endif

#ifndef _TRCFLEX_
#include "trcflex.h"
#endif

#ifndef _TRCLIB_
#include "trclib.h"
#endif

                       /****************************
                        *                          *
                        *    LOCAL DEFINITIONS     *
                        *                          *
                        ****************************/

/*#define FLEX8282SIZE   5120
  #define FLEX81500SIZE  31744 */
#define FLEX8282SIZE   5120
#define FLEX81500SIZE  31639

/* I/O port address define */

#define WaitStateB0   0xF360
#define WaitStateB1   0xF364
#define WaitStateB2   0xF368
//#define WaitStateB3   0xF36C

#define pP0           0xF300
#define pP1           0xF308
#define pP2           0xF310
#define pP3           0xF318
#define pP4           0xF320
#define pMN           0xF328

#define Rdy_Done_P0   0xF320
#define Rdy_Done_P1   0xF321
#define Rdy_Done_P2   0xF322
#define Rdy_Done_P3   0xF323
#define Rdy_Done_MN   0xF324
#define Rdy_P4        0xF330
#define Done_P4       0xF334

#define WrBC          0xF338

#define NPCS5         0xF280

/* I/O port corresponding bit define */

#define bitWaitState  0x80

#define nConfigPIPE   0xC0
#define nConfigP4     0xBC
#define nConfigMN     0x7C
#define nConfigDONE   0xFC

#define bitRdynBsy    0x80
#define bitDoneP4     0x80
#define bitDonePIPE   0x40
#define bitDoneMN     0x40


U8 _based(_segname("_CODE")) PIPEByte[] = {
#include "pipe.ttf"
};

U8 _based(_segname("_CODE")) PIOByte[] = {
#include "pio.ttf"
};

U8 _based(_segname("_CODE")) P4PIPEByte[] = {
#include "pipe4.ttf"
};

U8 _based(_segname("_CODE")) P4PIOByte[] = {
#include "p4pio.ttf"
};

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

VOID FiveWaitState(VOID);
VOID ZeroWaitState(VOID);

                       /****************************
                        *                          *
                        *     EXECUTABLE CODE      *
                        *                          *
                        ****************************/
/*****************************************************************************
**
** FiveWaitState
**
*****************************************************************************/
VOID FiveWaitState(VOID) {
   outp(WaitStateB0,bitWaitState) ;
   outp(WaitStateB1,~bitWaitState) ;
   outp(WaitStateB2,bitWaitState) ;
//   outp(WaitStateB3,~bitWaitState) ;
}

/*****************************************************************************
**
** ZeroWaitState
**
*****************************************************************************/
VOID ZeroWaitState(VOID) {
   outp(WaitStateB0,~bitWaitState) ;
   outp(WaitStateB1,~bitWaitState) ;
   outp(WaitStateB2,~bitWaitState) ;
//   outp(WaitStateB3,~bitWaitState) ;
}
/*****************************************************************************
**
** FLEXProgram
**
*****************************************************************************/
RETCODE FLEXProgram(FLEX_TYPE type,U8 _far *bitStreamBuffer) {
   register U16 count ;
//   U16 count ;

   outp(WrBC,0);
   switch(type) {
      case FLEX_PIPE:
         outp(P4CtrlAX,0);  // Disable Trace Memory Output Enable
         FiveWaitState();
         outp(NPCS5,nConfigPIPE);
         Delay(100);
         outp(NPCS5,nConfigDONE);
         Delay(40);
         outp(pP0, *bitStreamBuffer);
         outp(pP1, *bitStreamBuffer);
         outp(pP2, *bitStreamBuffer);
         outp(pP3, *bitStreamBuffer);
         for (count = 1;count <= FLEX8282SIZE -1;count++) {
            while((inp(Rdy_Done_P0) & bitRdynBsy) != bitRdynBsy) ;
            outp(pP0, *(bitStreamBuffer+1));
//          while((inp(Rdy_Done_P1) & bitRdynBsy) != bitRdynBsy) ;
            outp(pP1, *(bitStreamBuffer+1));
//          while((inp(Rdy_Done_P2) & bitRdynBsy) != bitRdynBsy) ;
            outp(pP2, *(bitStreamBuffer+1));
//          while((inp(Rdy_Done_P3) & bitRdynBsy) != bitRdynBsy) ;
            outp(pP3, *(bitStreamBuffer+1));
            bitStreamBuffer++;
         }
//       if (((inp(Rdy_Done_P0) & bitDonePIPE ) == bitDonePIPE)  &&
//           ((inp(Rdy_Done_P1) & bitDonePIPE ) == bitDonePIPE)  &&
//           ((inp(Rdy_Done_P2) & bitDonePIPE ) == bitDonePIPE)  &&
//           ((inp(Rdy_Done_P3) & bitDonePIPE ) == bitDonePIPE)) {
         if ((inp(Rdy_Done_P0) & bitDonePIPE ) == bitDonePIPE)  {
            ZeroWaitState();
            return(GOOD) ;
         }
         ZeroWaitState();
         return(ERR_PIPE_DONE) ;
      break;
      case FLEX_P4:
         outp(NPCS5,nConfigP4);
         Delay(100);
         outp(NPCS5,nConfigDONE);
         Delay(40);
         FiveWaitState();
         outp(pP4, *bitStreamBuffer);
         for (count = 1;count <= FLEX8282SIZE -1;count++)
         {
            while((inp(Rdy_P4) & bitRdynBsy) != bitRdynBsy) ;
            outp(pP4, *(bitStreamBuffer+1));
            bitStreamBuffer++;
         }
         if ( (inp(Done_P4) & bitDoneP4 ) == bitDoneP4) {
            ZeroWaitState();
            return(GOOD);
         }
         ZeroWaitState();
         return(ERR_P4_DONE) ;
      break;
      case FLEX_MN:
         FiveWaitState();
         outp(NPCS5,nConfigMN);
         Delay(100);
         outp(NPCS5,nConfigDONE);
         Delay(40);
         outp(pMN, *bitStreamBuffer);
         for (count = 1;count <= FLEX81500SIZE - 1;count++) {
            while((inp(Rdy_Done_MN) & bitRdynBsy) != bitRdynBsy) ;
            outp(pMN, *(bitStreamBuffer+1));
            bitStreamBuffer++;
         }
         if ( (inp(Rdy_Done_MN) & bitDoneMN ) == bitDoneMN) {
            ZeroWaitState();
            return(GOOD);
         }
         ZeroWaitState();
         return(ERR_MN_DONE) ;
      break;
   }
}
/********************************* EOF *************************************/
