/****************************************************************************
**
**  Name: addrini.c
**
**  Description:
**     This module contains Address Server routines to access and manipulate
**		 the PWRVIEWS.INI 
**
**  $Log:   S:/tbird/mt2_186/addr/addrini.c_v  $
** 
**    Rev 1.0   16 Dec 1996 16:15:52   Judy
** Initial revision.
** 
**    Rev 1.1   16 Jun 1994 14:57:32   nghia
** Merged to trunk. Used INI services from CLIULIB.DLL
** 
**    Rev 1.0   31 May 1994 17:12:08   nghia
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_186/addr/addrini.c_v   1.0   16 Dec 1996 16:15:52   Judy  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include <stdio.h>
#include <stdlib.h>

#ifndef __STRING_H
#include "string.h"
#endif

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

#ifndef _ADDR_
#include "addr.h"
#endif

#ifndef _CPU_
#include "cpu.h"
#endif

#ifndef __ADDRINI__
#include "addrini.h"
#endif
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
/* INI section and key name */
const LPSTR toolChainSection = "Toolchain";
const LPSTR indexRegKey = "VarIndexCpu16Reg";

/* CPU16 Index extension register usage */
CHAR extRegName[MAX_STRING_SIZE];
REG_ID extRegId;
BOOLEAN usedIndexExtReg;


                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/************************************************************************
**
**  GetCpu16IndexRegUsed
**
**************************************************************************/
RETCODE GetCpu16IndexRegUsed(VOID) {
   RETCODE err;
   
   usedIndexExtReg = FALSE;
   if ((err = IniGetString(toolChainSection, indexRegKey, NULL,
                           (LPSTR)extRegName)) != GOOD)
      return err;
   // if register name is not "none"
   if (strcmpi(extRegName, "none") != 0) {
      if ((err = CpuFindRegisterId((U8 FAR*)extRegName,
                                   (REG_ID FAR*)&extRegId)) != GOOD)
         return err;
      usedIndexExtReg = TRUE;
   }
   return GOOD;
}
/********************************** E O F ***********************************/
