/****************************************************************************
** Name:  lfetch86.c
**
** Desciption:  Fetch bytes routines for ldasm86.c
**
**
** Status:  PRELIMINARY
**
** $Log:   S:/tbird/mt2_186/dadamd/lfetch86.c_v  $
** 
**    Rev 1.0   26 Jun 1997 15:25:54   cjchen
** Initial revision.
** 
**    Rev 1.1   03 Apr 1997 15:06:34   Judy
** No change.
** 
**    Rev 1.0   16 Dec 1996 16:43:38   Judy
** Initial revision.
** 
**    Rev 1.0   25 May 1994 14:18:44   nghia
** Initial revision.
**
** $Header:   S:/tbird/mt2_186/dadamd/lfetch86.c_v   1.0   26 Jun 1997 15:25:54   cjchen  $
** Copyright (C) 1994 Microtek International.  All rights reserved.
****************************************************************************/

                        /****************************
                         *                          *
                         *      INCLUDE FILES       *
                         *                          *
                         ****************************/
#ifndef _ADDR_
#include "addr.h"
#endif

#ifndef _LDASM86_
#include "ldasm86.h"
#endif

#ifndef _LFETCH86_
#include "lfetch86.h"
#endif

                        /****************************
                         *                          *
                         *    LOCAL DEFINITIONS     *
                         *                          *
                         ****************************/
STATIC U8 *CodePointer;
STATIC U8 *CodeEnd;
                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     EXECUTABLE CODE      *
                         *                          *
                         ****************************/
/***************************************************************************
**
**  InitFetch
**
***************************************************************************/
RETCODE InitFetch(U8 *MemData)
{
   CodePointer = MemData;
   CodeEnd = MemData + 15;
   return(GOOD);
}

/***************************************************************************
**
**  FetchBytes
**
***************************************************************************/
RETCODE FetchBytes(U8 Count, DASM_INFO *Info, U8 *FetchBuffer)
{
   U16 i;

   for (i=0; i<Count; i++) {
           FetchBuffer[i] = *CodePointer++;
           Info->bytesUsed++;
   }
   return(GOOD);
} /* end of FetchBytes() */

/********************************* E O F **********************************/
