/****************************************************************************
**
** Name:  ltable86.h
**
** Desciption:  Data tables for ldasm.
**
** $Log:   S:/tbird/mt2_186/dadamd/ltable86.h_v  $
** 
**    Rev 1.0   26 Jun 1997 15:25:50   cjchen
** Initial revision.
** 
**    Rev 1.0   03 Apr 1997 15:06:12   Judy
** Initial revision.
   
      Rev 1.0   16 Dec 1996 16:43:22   Judy
   Initial revision.
** 
**    Rev 1.2   10 Oct 1994 13:12:46   steve
** added RSM instruction    --- kevin
** 
**    Rev 1.1   27 May 1994 08:19:54   mindy
** added kevin's changes to get rid of warnings
** 
**    Rev 1.0   25 May 1994 14:19:06   nghia
** Initial revision.
**
** $Header:   S:/tbird/mt2_186/dadamd/ltable86.h_v   1.0   26 Jun 1997 15:25:50   cjchen  $
**
** Copyright (C) 1994  Microtek International.  All rights reserved.
****************************************************************************/
#define _LTABLE86_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
typedef CHAR     CH;

#define INVD     NULL
#define WBINVD   NULL
#define CMPXCHGB NULL
#define CMPXCHGW NULL
#define XADDB    NULL
#define XADDW    NULL
#define BSWAP0   NULL
#define BSWAP1   NULL
#define BSWAP2   NULL
#define BSWAP3   NULL
#define BSWAP4   NULL
#define BSWAP5   NULL
#define BSWAP6   NULL
#define BSWAP7   NULL
#define INVLPG   NULL

#define FIRST_TR_REG (3)

//#define CLI_ENTRY {"CLI",NULL,OpQ,1,{NULL,TRANS,NULL,NULL,NULL,NULL,NULL,NULL},NULL}
#define CLI_ENTRY {"CLI",NULL,OpQ,1,{NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL},NULL}

#define B00 NULL
#define B01 NBYTE
#define B02 NWORD
#define B04 NDWORD
#define B06 NFWORD
#define B08 NQWORD
#define B16 NWREGS
#define B32 NDREGS

/* Single operand modes and types */
STATIC OPERAND
     OpAp[] = {{AD_A,  TY_p}},
     OpEb[] = {{AD_E,  TY_b}},
     OpEv[] = {{AD_E,  TY_v}},
     OpEw[] = {{AD_E,  TY_w}},
     OpEd[] = {{AD_E,  TY_d}},
     OpEq[] = {{AD_E,  TY_q}},
     OpEt[] = {{AD_E,  TY_t}},
     OpIb[] = {{AD_I,  TY_b}},
     OpIv[] = {{AD_I,  TY_v}},
     OpIw[] = {{AD_I,  TY_w}},
     OpJb[] = {{AD_J,  TY_b}},
     OpJv[] = {{AD_J,  TY_v}},
     OpKv[] = {{AD_K,  TY_v}},
//     OpLv[] = {{AD_L,  TY_v}},
     OpMp[] = {{AD_M,  TY_p}},
     OpMv[] = {{AD_M,  TY_v}},
     OpMs[] = {{AD_M,  TY_s}},
     OpXb[] = {{AD_X,  TY_b}},
     OpXv[] = {{AD_X,  TY_v}},
     OpYb[] = {{AD_Y,  TY_b}},
     OpYv[] = {{AD_Y,  TY_v}},
     OpZb[] = {{AD_Z,  TY_b}},
     Op3[]  = {{AD_3,  TY_null}},
     OpQ[]  = {{AD_Q,  TY_null}},  /* No operands but causes queue flush */
     OpES[] = {{AD_ES, TY_null}},
     OpCS[] = {{AD_CS, TY_null}},
     OpSS[] = {{AD_SS, TY_null}},
     OpDS[] = {{AD_DS, TY_null}},
     OpFS[] = {{AD_FS, TY_null}},
     OpGS[] = {{AD_GS, TY_null}};

/* dual operand modes and types */
STATIC OPERAND
     OpCdRd[] = {{AD_C,  TY_d},
                 {AD_R,  TY_d}},

     OpDdRd[] = {{AD_D,  TY_d},
                 {AD_R,  TY_d}},

     OpEb1[]  = {{AD_E,  TY_b},
                 {AD_1,  TY_null}},

     OpEbCL[] = {{AD_E,  TY_b},
                 {AD_CL, TY_null}},

     OpEbGb[] = {{AD_E,  TY_b},
                 {AD_G,  TY_b}},

     OpEbIb[] = {{AD_E,  TY_b},
                 {AD_I,  TY_b}},

     OpEv1[]  = {{AD_E,  TY_v},
                 {AD_1,  TY_null}},

     OpEvCL[] = {{AD_E,  TY_v},
                 {AD_CL, TY_null}},

     OpEvIb[] = {{AD_E,  TY_v},
                 {AD_I,  TY_b}},

     OpEvIv[] = {{AD_E,  TY_v},
                 {AD_I,  TY_v}},

     OpEvGv[] = {{AD_E,  TY_v},
                 {AD_G,  TY_v}},

     OpEwGw[] = {{AD_E,  TY_w},
                 {AD_G,  TY_w}},

     OpEwSw[] = {{AD_E,  TY_w},
                 {AD_S,  TY_w}},

     OpGbEb[] = {{AD_G,  TY_b},
                 {AD_E,  TY_b}},

     OpGvEb[] = {{AD_G,  TY_v},
                 {AD_E,  TY_b}},

     OpGvEv[] = {{AD_G,  TY_v},
                 {AD_E,  TY_v}},

     OpGvEw[] = {{AD_G,  TY_v},
                 {AD_E,  TY_w}},

     OpGvM[]  = {{AD_G,  TY_v},
                 {AD_M,  TY_null}},

     OpGvMa[] = {{AD_G,  TY_v},
                 {AD_M,  TY_a}},

     OpIbAL[] = {{AD_I,  TY_b},
                 {AD_AL, TY_null}},

     OpIbvAX[]= {{AD_I,  TY_b},
                 {AD_vAX,TY_null}},

     OpIwIb[] = {{AD_I,  TY_w},
                 {AD_I,  TY_b}},

     OpKbIb[] = {{AD_K,  TY_b},
                 {AD_I,  TY_b}},

     OpKvIv[] = {{AD_K,  TY_v},
                 {AD_I,  TY_v}},

     OpKvvAX[]= {{AD_K,  TY_v},
                 {AD_vAX,TY_null}},

     OpObAL[] = {{AD_O,  TY_b},
                 {AD_AL, TY_null}},

     OpOvvAX[]= {{AD_O,  TY_v},
                 {AD_vAX,TY_null}},

     OpRdCd[] = {{AD_R,  TY_d},
                 {AD_C,  TY_d}},

     OpRdDd[] = {{AD_R,  TY_d},
                 {AD_D,  TY_d}},

     OpRdTd[] = {{AD_R,  TY_d},
                 {AD_T,  TY_d}},

     OpSwEw[] = {{AD_S,  TY_w},
                 {AD_E,  TY_w}},

     OpTdRd[] = {{AD_T,  TY_d},
                 {AD_R,  TY_d}},

     OpXbYb[] = {{AD_X,  TY_b},
                 {AD_Y,  TY_b}},

     OpXvYv[] = {{AD_X,  TY_v},
                 {AD_Y,  TY_v}},

     OpYbXb[] = {{AD_Y,  TY_b},
                 {AD_X,  TY_b}},

     OpYvXv[] = {{AD_Y,  TY_v},
                 {AD_X,  TY_v}},

     OpALIb[] = {{AD_AL, TY_null},
                 {AD_I,  TY_b}},

     OpALOb[] = {{AD_AL, TY_null},
                 {AD_O,  TY_b}},

     OpDXXb[] = {{AD_DX, TY_null},
                 {AD_X,  TY_b}},

     OpDXXv[] = {{AD_DX, TY_null},
                 {AD_X,  TY_v}},

     OpALDX[] = {{AD_AL, TY_null},
                 {AD_DX, TY_null}},

     OpvAXDX[]= {{AD_vAX,TY_null},
                 {AD_DX, TY_null}},

     OpvAXIv[]= {{AD_vAX,TY_null},
                 {AD_I,  TY_v}},

     OpvAXIb[]= {{AD_vAX,TY_null},
                 {AD_I,  TY_b}},

     OpvAXOv[]= {{AD_vAX,TY_null},
                 {AD_O,  TY_v}},

     OpDXAL[] = {{AD_DX, TY_null},
                 {AD_AL, TY_null}},

     OpDXvAX[]= {{AD_DX, TY_null},
                 {AD_vAX,TY_null}},

     OpYbDX[] = {{AD_Y,  TY_b},
                 {AD_DX, TY_null}},

     OpYvDX[] = {{AD_Y,  TY_v},
                 {AD_DX, TY_null}};

/* three or more operand modes and types */
STATIC OPERAND
     OpEvGvIb[] = {{AD_E,  TY_v},
                   {AD_G,  TY_v},
                   {AD_I,  TY_b}},

     OpEvGvCL[] = {{AD_E,  TY_v},
                   {AD_G,  TY_v},
                   {AD_CL, TY_null}},

     OpGvEvIb[] = {{AD_G,  TY_v},
                   {AD_E,  TY_v},
                   {AD_I,  TY_b}},

     OpGvEvIv[] = {{AD_G,  TY_v},
                   {AD_E,  TY_v},
                   {AD_I,  TY_v}};

/****************************************************************************
* Operand map for XBTS and IBTS instructions
* NO LONGER SUPPORTED BY INTEL
*    OpGvEvvAXCL[] = {{AD_G,  TY_v},
*                     {AD_E,  TY_v},
*                     {AD_vAX,TY_null},
*                     {AD_CL, TY_null}},
*
*    OpEvvAXCLGv[] = {{AD_E,  TY_v},
*                     {AD_vAX,TY_null},
*                     {AD_CL, TY_null},
*                     {AD_G,  TY_v}};
****************************************************************************/


/****************************************************************************
*  Instruction decoding Tables
*****************************************************************************
* group_optable -- group opcodes and special cases
*/

STATIC OPTABLE G0[] = {
   {"ADD", NULL, OpEbIb, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"OR",  NULL, OpEbIb, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"ADC", NULL, OpEbIb, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"SBB", NULL, OpEbIb, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"AND", NULL, OpEbIb, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"SUB", NULL, OpEbIb, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"XOR", NULL, OpEbIb, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"CMP", NULL, OpEbIb, 2, {NULL, NULL, B01, B01, B00, B00, MODRM, NULL}, MR }
};

STATIC OPTABLE G1[] = {
   {"ADD", NULL, OpEvIv, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"OR",  NULL, OpEvIv, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"ADC", NULL, OpEvIv, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"SBB", NULL, OpEvIv, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"AND", NULL, OpEvIv, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"SUB", NULL, OpEvIv, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"XOR", NULL, OpEvIv, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"CMP", NULL, OpEvIv, 2, {NULL, NULL, B02, B04, B00, B00, MODRM, NULL}, MR }
};

STATIC OPTABLE G2[] = {
   {"ADD", NULL, OpEvIb, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"OR",  NULL, OpEvIb, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"ADC", NULL, OpEvIb, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"SBB", NULL, OpEvIb, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"AND", NULL, OpEvIb, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"SUB", NULL, OpEvIb, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"XOR", NULL, OpEvIb, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"CMP", NULL, OpEvIb, 2, {NULL, NULL, B02, B04, B00, B00, MODRM, NULL}, MR }
};

STATIC OPTABLE G3[] = {
   {"ROL", NULL, OpEbIb, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"ROR", NULL, OpEbIb, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"RCL", NULL, OpEbIb, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"RCR", NULL, OpEbIb, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"SHL", NULL, OpEbIb, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"SHR", NULL, OpEbIb, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {ERR,   NULL, NULL,   0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {"SAR", NULL, OpEbIb, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW}
};

STATIC OPTABLE G4[] = {
   {"ROL", NULL, OpEvIb, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"ROR", NULL, OpEvIb, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"RCL", NULL, OpEvIb, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"RCR", NULL, OpEvIb, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"SHL", NULL, OpEvIb, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"SHR", NULL, OpEvIb, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {ERR,   NULL, NULL,   0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {"SAR", NULL, OpEvIb, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW}
};

STATIC OPTABLE G5[] = {
   {"ROL", NULL, OpEb1, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"ROR", NULL, OpEb1, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"RCL", NULL, OpEb1, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"RCR", NULL, OpEb1, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"SHL", NULL, OpEb1, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"SHR", NULL, OpEb1, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {"SAR", NULL, OpEb1, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW}
};

STATIC OPTABLE G6[] = {
   {"ROL", NULL, OpEv1, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"ROR", NULL, OpEv1, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"RCL", NULL, OpEv1, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"RCR", NULL, OpEv1, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"SHL", NULL, OpEv1, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"SHR", NULL, OpEv1, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {"SAR", NULL, OpEv1, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW}
};

STATIC OPTABLE G7[] = {
   {"ROL", NULL, OpEbCL, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"ROR", NULL, OpEbCL, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"RCL", NULL, OpEbCL, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"RCR", NULL, OpEbCL, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"SHL", NULL, OpEbCL, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"SHR", NULL, OpEbCL, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {ERR,   NULL, NULL,   0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {"SAR", NULL, OpEbCL, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW}
};

STATIC OPTABLE G8[] = {
   {"ROL", NULL, OpEvCL, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"ROR", NULL, OpEvCL, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"RCL", NULL, OpEvCL, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"RCR", NULL, OpEvCL, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"SHL", NULL, OpEvCL, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"SHR", NULL, OpEvCL, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {ERR,   NULL, NULL,   0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {"SAR", NULL, OpEvCL, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW}
};

STATIC OPTABLE G9[] = {
   {"TEST", NULL, OpEbIb,2, {NULL, NULL, B01, B01, B00, B00, MODRM, NULL}, MR },
   {ERR,    NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {"NOT",  NULL, OpEb,  1, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"NEG",  NULL, OpEb,  1, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"MUL",  NULL, OpEb,  1, {NULL, NULL, B01, B01, B00, B00, MODRM, NULL}, MR },
   {"IMUL", NULL, OpEb,  1, {NULL, NULL, B01, B01, B00, B00, MODRM, NULL}, MR },
   {"DIV",  NULL, OpEb,  1, {NULL, NULL, B01, B01, B00, B00, MODRM, NULL}, MR },
   {"IDIV", NULL, OpEb,  1, {NULL, NULL, B01, B01, B00, B00, MODRM, NULL}, MR }
};

STATIC OPTABLE GA[] = {
   {"TEST", NULL, OpEvIv,2, {NULL, NULL, B02, B04, B00, B00, MODRM, NULL}, MR },
   {ERR,    NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {"NOT",  NULL, OpEv,  1, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"NEG",  NULL, OpEv,  1, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"MUL",  NULL, OpEv,  1, {NULL, NULL, B02, B04, B00, B00, MODRM, NULL}, MR },
   {"IMUL", NULL, OpEv,  1, {NULL, NULL, B02, B04, B00, B00, MODRM, NULL}, MR },
   {"DIV",  NULL, OpEv,  1, {NULL, NULL, B02, B04, B00, B00, MODRM, NULL}, MR },
   {"IDIV", NULL, OpEv,  1, {NULL, NULL, B02, B04, B00, B00, MODRM, NULL}, MR }
};

STATIC OPTABLE GB[] = {
   {"INC",  NULL, OpEb, 1, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {"DEC",  NULL, OpEb, 1, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW},
   {ERR,    NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,    NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,    NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,    NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,    NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,    NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}
};

STATIC OPTABLE GC[] = {
   {"INC",  NULL, OpEv, 1, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"DEC",  NULL, OpEv, 1, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"CALL", NULL, OpEv, 1, {NULL,TRANS, B02, B04, B02, B04, MODRM, NULL}, MRW},
   {"CALL", NULL, OpMp, 1, {NULL,TRANS, B04, B06, B04,2*B04,NULL,  NULL}, MRW},
   {"JMP",  NULL, OpEv, 1, {NULL,TRANS, B02, B04, B00, B00, MODRM, NULL}, MR },
   {"JMP",  NULL, OpMp, 1, {NULL,TRANS, B04, B06, B00, B00, NULL,  NULL}, MR },
   {"PUSH", NULL, OpMv, 1, {NULL, NULL, B02, B04, B02, B04, NULL,  NULL}, MRW},
   {ERR,    NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}
};

STATIC OPTABLE GD[] = {
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}
};

STATIC OPTABLE GE[] = {
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}
};

STATIC OPTABLE GF[] = {
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}
};

STATIC OPTABLE GG[] = {
   {"POP", NULL, OpMv,  1, {NULL, NULL, B02, B04, B02, B04, NULL, NULL}, MRW},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}
};

/************************************************************************
*  Numeric Processor opcode tables
*  Note--Partial table: Only memory addressed instructions are included here
*/
STATIC OPTABLE D8[] = {
   {"FADD", NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FMUL", NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FCOM", NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FCOMP",NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FSUB", NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FSUBR",NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FDIV", NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FDIVR",NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}
};

STATIC OPTABLE D9[] = {
   {"FLD",   NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {ERR,     NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FST",   NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FSTP",  NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FLDENV",NULL, OpEb, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FLDCW", NULL, OpEw, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FNSTENV","FSTENV",OpEb,1,{NULL,NULL,B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FNSTCW","FSTCW", OpEw, 1,{NULL,NULL,B00, B00, B00, B00, NULL, NULL}, NULL}
};

STATIC OPTABLE DA[] = {
   {"FIADD", NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FIMUL", NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FICOM", NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FICOMP",NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FISUB", NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FISUBR",NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FIDIV", NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FIDIVR",NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}
};

STATIC OPTABLE DB[] = {
   {"FILD",  NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {ERR,     NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FIST",  NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FISTP", NULL, OpEd, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {ERR,     NULL, OpEw, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FLD",   NULL, OpEt, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {ERR,     NULL, OpEw, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FSTP",  NULL, OpEt, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}
};

STATIC OPTABLE DC[] = {
   {"FADD",  NULL, OpEq, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FMUL",  NULL, OpEq, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FCOM",  NULL, OpEq, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FCOMP", NULL, OpEq, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FSUB",  NULL, OpEq, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FSUBR", NULL, OpEq, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FDIV",  NULL, OpEq, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FDIVR", NULL, OpEq, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}
};

STATIC OPTABLE DD[] = {
   {"FLD",   NULL,   OpEq, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {ERR,     NULL,   OpEq, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FST",   NULL,   OpEq, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FSTP",  NULL,   OpEq, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FRSTOR",NULL,   OpEb, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {ERR,     NULL,   OpEb, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FNSAVE","FSAVE",OpEb, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FNSTSW","FSTSW",OpEw, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}
};

STATIC OPTABLE DE[] = {
   {"FIADD", NULL, OpEw, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FIMUL", NULL, OpEw, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FICOM", NULL, OpEw, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FICOMP",NULL, OpEw, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FISUB", NULL, OpEw, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FISUBR",NULL, OpEw, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FIDIV", NULL, OpEw, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FIDIVR",NULL, OpEw, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}
};

STATIC OPTABLE DF[] = {
   {"FILD",  NULL, OpEw, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {ERR,     NULL, OpEw, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FIST",  NULL, OpEw, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FISTP", NULL, OpEw, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FBLD",  NULL, OpEt, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FILD",  NULL, OpEq, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FBSTP", NULL, OpEt, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL},
   {"FISTP", NULL, OpEq, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}
};


/************************************************************************
*  single-byte opcodes
*/
STATIC OPTABLE  O1[] = {
   {"ADD", NULL, OpEbGb, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW}, /*00*/
   {"ADD", NULL, OpEvGv, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW}, /*01*/
   {"ADD", NULL, OpGbEb, 2, {NULL, NULL, B01, B01, B00, B00, MODRM, NULL}, MR }, /*02*/
   {"ADD", NULL, OpGvEv, 2, {NULL, NULL, B02, B04, B00, B00, MODRM, NULL}, MR }, /*03*/
   {"ADD", NULL, OpALIb, 2, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*04*/
   {"ADD", NULL, OpvAXIv,2, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*05*/
   {"PUSH",NULL, OpES,   1, {NULL, NULL, B00, B00, B02, B02, NULL,  NULL}, MW }, /*06*/
   {"POP", NULL, OpES,   1, {NULL, NULL, B02, B02, B00, B00, NULL,  NULL}, MR }, /*07*/
   {"OR",  NULL, OpEbGb, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW}, /*08*/
   {"OR",  NULL, OpEvGv, 2, {NULL, NULL, B01, B02, B01, B02, MODRM, NULL}, MRW}, /*09*/
   {"OR",  NULL, OpGbEb, 2, {NULL, NULL, B01, B01, B00, B00, MODRM, NULL}, MR }, /*0A*/
   {"OR",  NULL, OpGvEv, 2, {NULL, NULL, B01, B02, B00, B00, MODRM, NULL}, MR }, /*0B*/
   {"OR",  NULL, OpALIb, 2, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*0C*/
   {"OR",  NULL, OpvAXIv,2, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*0D*/
   {"PUSH",NULL, OpCS,   1, {NULL, NULL, B00, B00, B02, B02, NULL,  NULL}, MW }, /*0E*/
   {ERR,   NULL, NULL,   0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*0F 2-Opcode Prefix*/

   {"ADC", NULL, OpEbGb, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW}, /*10*/
   {"ADC", NULL, OpEvGv, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW}, /*11*/
   {"ADC", NULL, OpGbEb, 2, {NULL, NULL, B01, B01, B00, B00, MODRM, NULL}, MR }, /*12*/
   {"ADC", NULL, OpGvEv, 2, {NULL, NULL, B02, B04, B00, B00, MODRM, NULL}, MR }, /*13*/
   {"ADC", NULL, OpALIb, 2, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*14*/
   {"ADC", NULL, OpvAXIv,2, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*15*/
   {"PUSH",NULL, OpSS,   1, {NULL, NULL, B00, B00, B02, B02, NULL,  NULL}, MW }, /*16*/
   {"POP", NULL, OpSS,   1, {NULL, NULL, B02, B02, B00, B00, NULL,  NULL}, MR }, /*17*/
   {"SBB", NULL, OpEbGb, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW}, /*18*/
   {"SBB", NULL, OpEvGv, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW}, /*19*/
   {"SBB", NULL, OpGbEb, 2, {NULL, NULL, B01, B01, B00, B00, MODRM, NULL}, MR }, /*1A*/
   {"SBB", NULL, OpGvEv, 2, {NULL, NULL, B02, B04, B00, B00, MODRM, NULL}, MR }, /*1B*/
   {"SBB", NULL, OpALIb, 2, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*1C*/
   {"SBB", NULL, OpvAXIv,2, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*1D*/
   {"PUSH",NULL, OpDS,   1, {NULL, NULL, B00, B00, B02, B02, NULL,  NULL}, MW }, /*1E*/
   {"POP", NULL, OpDS,   1, {NULL, NULL, B02, B02, B00, B00, NULL,  NULL}, MR }, /*1F*/

   {"AND", NULL, OpEbGb, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW}, /*20*/
   {"AND", NULL, OpEvGv, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW}, /*21*/
   {"AND", NULL, OpGbEb, 2, {NULL, NULL, B01, B01, B00, B00, MODRM, NULL}, MR }, /*22*/
   {"AND", NULL, OpGvEv, 2, {NULL, NULL, B02, B04, B00, B00, MODRM, NULL}, MR }, /*23*/
   {"AND", NULL, OpALIb, 2, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*24*/
   {"AND", NULL, OpvAXIv,2, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*25*/
   {ERR,   NULL, NULL,   0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*26 ES segment override*/
   {"DAA", NULL, NULL,   0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*27*/
   {"SUB", NULL, OpEbGb, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW}, /*28*/
   {"SUB", NULL, OpEvGv, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW}, /*29*/
   {"SUB", NULL, OpGbEb, 2, {NULL, NULL, B01, B01, B00, B00, MODRM, NULL}, MR }, /*2A*/
   {"SUB", NULL, OpGvEv, 2, {NULL, NULL, B02, B04, B00, B00, MODRM, NULL}, MR }, /*2B*/
   {"SUB", NULL, OpALIb, 2, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*2C*/
   {"SUB", NULL, OpvAXIv,2, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*2D*/
   {ERR,   NULL, NULL,   0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*2E CS segment override*/
   {"DAS", NULL, NULL,   0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*2F*/

   {"XOR", NULL, OpEbGb, 2, {NULL, NULL, B01, B01, B01, B01, MODRM, NULL}, MRW}, /*30*/
   {"XOR", NULL, OpEvGv, 2, {NULL, NULL, B02, B04, B02, B04, MODRM, NULL}, MRW}, /*31*/
   {"XOR", NULL, OpGbEb, 2, {NULL, NULL, B01, B01, B00, B00, MODRM, NULL}, MR }, /*32*/
   {"XOR", NULL, OpGvEv, 2, {NULL, NULL, B02, B04, B00, B00, MODRM, NULL}, MR }, /*33*/
   {"XOR", NULL, OpALIb, 2, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*34*/
   {"XOR", NULL, OpvAXIv,2, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*35*/
   {ERR,   NULL, NULL,   0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*36 SS segment override*/
   {"AAA", NULL, NULL,   0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*37*/
   {"CMP", NULL, OpEbGb, 2, {NULL, NULL, B01, B01, B00, B00, MODRM, NULL}, MR }, /*38*/
   {"CMP", NULL, OpEvGv, 2, {NULL, NULL, B02, B04, B00, B00, MODRM, NULL}, MR }, /*39*/
   {"CMP", NULL, OpGbEb, 2, {NULL, NULL, B01, B01, B00, B00, MODRM, NULL}, MR }, /*3A*/
   {"CMP", NULL, OpGvEv, 2, {NULL, NULL, B02, B04, B00, B00, MODRM, NULL}, MR }, /*3B*/
   {"CMP", NULL, OpALIb, 2, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*3C*/
   {"CMP", NULL, OpvAXIv,2, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*3D*/
   {ERR,   NULL, NULL,   0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*3E DS segment override*/
   {"AAS", NULL, NULL,   0, {NULL, NULL, B00, B00, B00, B00, NULL,  NULL}, NULL}, /*3F*/

   {"INC", NULL, OpKv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*40*/
   {"INC", NULL, OpKv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*41*/
   {"INC", NULL, OpKv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*42*/
   {"INC", NULL, OpKv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*43*/
   {"INC", NULL, OpKv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*44*/
   {"INC", NULL, OpKv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*45*/
   {"INC", NULL, OpKv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*46*/
   {"INC", NULL, OpKv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*47*/
   {"DEC", NULL, OpKv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*48*/
   {"DEC", NULL, OpKv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*49*/
   {"DEC", NULL, OpKv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*4A*/
   {"DEC", NULL, OpKv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*4B*/
   {"DEC", NULL, OpKv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*4C*/
   {"DEC", NULL, OpKv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*4D*/
   {"DEC", NULL, OpKv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*4E*/
   {"DEC", NULL, OpKv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*4F*/

   {"PUSH",NULL, OpKv, 1, {NULL, NULL, B00, B00, B02, B04, NULL, NULL}, MW }, /*50*/
   {"PUSH",NULL, OpKv, 1, {NULL, NULL, B00, B00, B02, B04, NULL, NULL}, MW }, /*51*/
   {"PUSH",NULL, OpKv, 1, {NULL, NULL, B00, B00, B02, B04, NULL, NULL}, MW }, /*52*/
   {"PUSH",NULL, OpKv, 1, {NULL, NULL, B00, B00, B02, B04, NULL, NULL}, MW }, /*53*/
   {"PUSH",NULL, OpKv, 1, {NULL, NULL, B00, B00, B02, B04, NULL, NULL}, MW }, /*54*/
   {"PUSH",NULL, OpKv, 1, {NULL, NULL, B00, B00, B02, B04, NULL, NULL}, MW }, /*55*/
   {"PUSH",NULL, OpKv, 1, {NULL, NULL, B00, B00, B02, B04, NULL, NULL}, MW }, /*56*/
   {"PUSH",NULL, OpKv, 1, {NULL, NULL, B00, B00, B02, B04, NULL, NULL}, MW }, /*57*/
   {"POP", NULL, OpKv, 1, {NULL, NULL, B02, B04, B00, B00, NULL, NULL}, MR }, /*58*/
   {"POP", NULL, OpKv, 1, {NULL, NULL, B02, B04, B00, B00, NULL, NULL}, MR }, /*59*/
   {"POP", NULL, OpKv, 1, {NULL, NULL, B02, B04, B00, B00, NULL, NULL}, MR }, /*5A*/
   {"POP", NULL, OpKv, 1, {NULL, NULL, B02, B04, B00, B00, NULL, NULL}, MR }, /*5B*/
   {"POP", NULL, OpKv, 1, {NULL, NULL, B02, B04, B00, B00, NULL, NULL}, MR }, /*5C*/
   {"POP", NULL, OpKv, 1, {NULL, NULL, B02, B04, B00, B00, NULL, NULL}, MR }, /*5D*/
   {"POP", NULL, OpKv, 1, {NULL, NULL, B02, B04, B00, B00, NULL, NULL}, MR }, /*5E*/
   {"POP", NULL, OpKv, 1, {NULL, NULL, B02, B04, B00, B00, NULL, NULL}, MR }, /*5F*/

   {"PUSHA","PUSHAD",NULL,0,{NULL, NULL, B00, B00, B16, B32, NULL, NULL}, MW }, /*60*/
   {"POPA", "POPAD", NULL,0,{NULL, NULL, B16, B32, B00, B00, NULL, NULL}, MR }, /*61*/
   {"BOUND",NULL,OpGvMa, 2, {NULL, NULL, B04, B08, B00, B00, NULL, NULL}, MR }, /*62*/
   {ERR,   NULL,   NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*64 FS segment override*/
   {ERR,   NULL,   NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*64 FS segment override*/
   {ERR,   NULL,   NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*65 GS segment override*/
   {ERR,   NULL,   NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*66 Operand-size override*/
   {ERR,   NULL,   NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*67 Address-size override*/
   {"PUSH",NULL,   OpIv, 1, {NULL, NULL, B00, B00, B02, B04, NULL, NULL}, MW }, /*68*/
   {"IMUL",NULL,OpGvEvIv,3, {NULL, NULL, B02, B04, B00, B00, MODRM,NULL}, MR}, /*69*/
   {"PUSH",NULL,   OpIb, 1, {NULL, NULL, B00, B00, B01, B01, NULL, NULL}, MW }, /*6A*/
   {"IMUL",NULL,OpGvEvIb,3, {NULL, NULL, B02, B04, B00, B00, MODRM,NULL}, MR}, /*6B*/
   {"INS", NULL, OpYbDX, 2, {NULL, NULL, B01, B01, B01, B01, NULL, NULL}, MWIR}, /*6C*/
   {"INS", NULL, OpYvDX, 2, {NULL, NULL, B02, B04, B02, B04, NULL, NULL}, MWIR}, /*6D*/
   {"OUTS",NULL, OpDXXb, 2, {NULL, NULL, B01, B01, B01, B01, NULL, NULL}, MRIW}, /*6E*/
   {"OUTS",NULL, OpDXXv, 2, {NULL, NULL, B02, B04, B02, B04, NULL, NULL}, MRIW}, /*6F*/

   {"JO",  NULL, OpJb, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*70*/
   {"JNO", NULL, OpJb, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*71*/
   {"JB",  NULL, OpJb, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*72*/
   {"JNB", NULL, OpJb, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*73*/
   {"JZ",  NULL, OpJb, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*74*/
   {"JNZ", NULL, OpJb, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*75*/
   {"JBE", NULL, OpJb, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*76*/
   {"JNBE",NULL, OpJb, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*77*/
   {"JS",  NULL, OpJb, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*78*/
   {"JNS", NULL, OpJb, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*79*/
   {"JP",  NULL, OpJb, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*7A*/
   {"JNP", NULL, OpJb, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*7B*/
   {"JL",  NULL, OpJb, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*7C*/
   {"JNL", NULL, OpJb, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*7D*/
   {"JLE", NULL, OpJb, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*7E*/
   {"JNLE",NULL, OpJb, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*7F*/

   {(CH*)1,(CH*)G0,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*80*/
   {(CH*)1,(CH*)G1,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*81*/
   {(CH*)1,(CH*)G0,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*82*/
   {(CH*)1,(CH*)G2,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*83*/
   {"TEST",NULL, OpEbGb, 2, {NULL, NULL, B01, B01, B00, B00,MODRM, NULL}, MR }, /*84*/
   {"TEST",NULL, OpEvGv, 2, {NULL, NULL, B02, B04, B00, B00,MODRM, NULL}, MR }, /*85*/
   {"XCHG",NULL, OpEbGb, 2, {NULL, NULL, B01, B01, B01, B01,MODRM, NULL}, MRW}, /*86*/
   {"XCHG",NULL, OpEvGv, 2, {NULL, NULL, B02, B04, B02, B04,MODRM, NULL}, MRW}, /*87*/
   {"MOV", NULL, OpEbGb, 2, {NULL, NULL, B00, B00, B01, B01,MODRM, NULL}, MW }, /*88*/
   {"MOV", NULL, OpEvGv, 2, {NULL, NULL, B00, B00, B02, B04,MODRM, NULL}, MW }, /*89*/
   {"MOV", NULL, OpGbEb, 2, {NULL, NULL, B01, B01, B00, B00,MODRM, NULL}, MR }, /*8A*/
   {"MOV", NULL, OpGvEv, 2, {NULL, NULL, B02, B04, B00, B00,MODRM, NULL}, MR }, /*8B*/
   {"MOV", NULL, OpEwSw, 2, {NULL, NULL, B00, B00, B02, B02,MODRM, NULL}, MW }, /*8C*/
   {"LEA", NULL, OpGvM,  2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, MR }, /*8D*/
   {"MOV", NULL, OpSwEw, 2, {NULL, NULL, B02, B02, B00, B00,MODRM, NULL}, MR }, /*8E*/
   {(CH*)1,(CH*)GG,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*8F*/

   {"NOP",  NULL, NULL,   0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*90*/
   {"XCHG", NULL, OpKvvAX,2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*91*/
   {"XCHG", NULL, OpKvvAX,2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*92*/
   {"XCHG", NULL, OpKvvAX,2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*93*/
   {"XCHG", NULL, OpKvvAX,2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*94*/
   {"XCHG", NULL, OpKvvAX,2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*95*/
   {"XCHG", NULL, OpKvvAX,2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*96*/
   {"XCHG", NULL, OpKvvAX,2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*97*/
   {"CBW","CWDE", NULL,   0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*98*/
   {"CWD","CDQ",  NULL,   0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*99*/
   {"CALL", NULL,  OpAp,  1, {NULL,TRANS, B00, B00, B04,2*B04,NULL, NULL}, MW }, /*9A*/
   {"WAIT", NULL,  NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*9B*/
   {"PUSHF","PUSHFD",NULL,0, {NULL, NULL, B00, B00, B02, B04, NULL, NULL}, MW }, /*9C*/
   {"POPF","POPFD", NULL, 0, {NULL, NULL, B02, B04, B00, B00, NULL, NULL}, MR }, /*9D*/
   {"SAHF", NULL,  NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*9E*/
   {"LAHF", NULL,  NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*9F*/

   {"MOV",  NULL, OpALOb, 2, {NULL, NULL, B01, B01, B00, B00, NULL, NULL}, MR }, /*A0*/
   {"MOV",  NULL, OpvAXOv,2, {NULL, NULL, B02, B04, B00, B00, NULL, NULL}, MR }, /*A1*/
   {"MOV",  NULL, OpObAL, 2, {NULL, NULL, B00, B00, B01, B01, NULL, NULL}, MW }, /*A2*/
   {"MOV",  NULL, OpOvvAX,2, {NULL, NULL, B00, B00, B02, B04, NULL, NULL}, MW }, /*A3*/
   {"MOVS", NULL, OpYbXb, 2, {NULL, NULL, B01, B01, B01, B01, NULL, NULL}, MRW}, /*A4*/
   {"MOVS", NULL, OpYvXv, 2, {NULL, NULL, B02, B04, B02, B04, NULL, NULL}, MRW}, /*A5*/
   {"CMPS", NULL, OpXbYb, 2, {NULL, NULL,2*B01,2*B01,B00,B00, NULL, NULL}, MR }, /*A6*/
   {"CMPS", NULL, OpXvYv, 2, {NULL, NULL,2*B02,2*B04,B00,B00, NULL, NULL}, MR }, /*A7*/
   {"TEST", NULL, OpALIb, 2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*A8*/
   {"TEST", NULL, OpvAXIv,2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*A9*/
   {"STOS", NULL, OpYb,   1, {NULL, NULL, B00, B00, B01, B01, NULL, NULL}, MW }, /*AA*/
   {"STOS", NULL, OpYv,   1, {NULL, NULL, B00, B00, B02, B04, NULL, NULL}, MW }, /*AB*/
   {"LODS", NULL, OpXb,   1, {NULL, NULL, B01, B01, B00, B00, NULL, NULL}, MR }, /*AC*/
   {"LODS", NULL, OpXv,   1, {NULL, NULL, B02, B04, B00, B00, NULL, NULL}, MR }, /*AD*/
   {"SCAS", NULL, OpYb,   1, {NULL, NULL, B01, B01, B00, B00, NULL, NULL}, MR }, /*AE*/
   {"SCAS", NULL, OpYv,   1, {NULL, NULL, B02, B04, B00, B00, NULL, NULL}, MR }, /*AF*/

   {"MOV",  NULL, OpKbIb, 2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*B0*/
   {"MOV",  NULL, OpKbIb, 2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*B1*/
   {"MOV",  NULL, OpKbIb, 2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*B2*/
   {"MOV",  NULL, OpKbIb, 2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*B3*/
   {"MOV",  NULL, OpKbIb, 2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*B4*/
   {"MOV",  NULL, OpKbIb, 2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*B5*/
   {"MOV",  NULL, OpKbIb, 2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*B6*/
   {"MOV",  NULL, OpKbIb, 2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*B7*/
   {"MOV",  NULL, OpKvIv, 2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*B8*/
   {"MOV",  NULL, OpKvIv, 2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*B9*/
   {"MOV",  NULL, OpKvIv, 2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*BA*/
   {"MOV",  NULL, OpKvIv, 2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*BB*/
   {"MOV",  NULL, OpKvIv, 2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*BC*/
   {"MOV",  NULL, OpKvIv, 2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*BD*/
   {"MOV",  NULL, OpKvIv, 2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*BE*/
   {"MOV",  NULL, OpKvIv, 2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*BF*/

   {(CH*)1,(CH*)G3,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*C0*/
   {(CH*)1,(CH*)G4,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*C1*/
   {"RET",  NULL, OpIw,  1, {NULL,TRANS, B02, B04, B00, B00, NULL, NULL}, MR }, /*C2*/
   {"RET",  NULL, NULL,  0, {NULL,TRANS, B02, B04, B00, B00, NULL, NULL}, MR }, /*C3*/
   {"LES",  NULL, OpGvM, 2, {NULL, NULL, B04, B06, B00, B00, NULL, NULL}, MR }, /*C4*/
   {"LDS",  NULL, OpGvM, 2, {NULL, NULL, B04, B06, B00, B00, NULL, NULL}, MR }, /*C5*/
   {"MOV",  NULL, OpEbIb,2, {NULL, NULL, B00, B00, B01, B01,MODRM, NULL}, MW }, /*C6*/
   {"MOV",  NULL, OpEvIv,2, {NULL, NULL, B00, B00, B02, B04,MODRM, NULL}, MW }, /*C7*/
   {"ENTER",NULL, OpIwIb,2, {NULL, NULL, B00, B00, B00, B00, NULL, SPEC}, MW }, /*C8*/
   {"LEAVE",NULL, NULL,  0, {NULL, NULL, B02, B04, B00, B00, NULL, NULL}, MR }, /*C9*/
   {"RETF", NULL, OpIw,  1, {NULL,TRANS, B04, B06, B00, B00, NULL, NULL}, MR }, /*CA*/
   {"RETF", NULL, NULL,  0, {NULL,TRANS, B04, B06, B00, B00, NULL, NULL}, MR }, /*CB*/
   {"INT",  NULL, Op3,   1, {NULL,TRANS, B04, B08,3*B02, 10, NULL, SPEC}, MRW}, /*CC*/
   {"INT",  NULL, OpIb,  1, {NULL,TRANS, B04, B08,3*B02, 10, NULL, SPEC}, MRW}, /*CD*/
   {"INTO", NULL, NULL,  0, {NULL,TRANS, B04, B08,3*B02, 10, NULL, SPEC}, MRW}, /*CE*/
   {"IRET","IRETD",NULL, 0, {NULL,TRANS,3*B02, 10, B00, B00, NULL, SPEC}, MR }, /*CF*/

   {(CH*)1,(CH*)G5,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*D0*/
   {(CH*)1,(CH*)G6,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*D1*/
   {(CH*)1,(CH*)G7,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*D2*/
   {(CH*)1,(CH*)G8,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*D3*/
   {"AAM",  NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*D4*/
   {"AAD",  NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*D5*/
   {ERR,    NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*D6*/
   {"XLAT", NULL, OpZb,  1, {NULL, NULL, B01, B01, B00, B00, NULL, NULL}, MR }, /*D7*/
   {(CH*)1,(CH*)D8,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*D8  Numeric Processor*/
   {(CH*)1,(CH*)D9,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*D9  Numeric Processor*/
   {(CH*)1,(CH*)DA,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*DA  Numeric Processor*/
   {(CH*)1,(CH*)DB,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*DB  Numeric Processor*/
   {(CH*)1,(CH*)DC,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*DC  Numeric Processor*/
   {(CH*)1,(CH*)DD,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*DD  Numeric Processor*/
   {(CH*)1,(CH*)DE,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*DE  Numeric Processor*/
   {(CH*)1,(CH*)DF,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*DF  Numeric Processor*/

   {"LOOPNE",NULL, OpJb, 1, {COND,TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*E0*/
   {"LOOPE", NULL, OpJb, 1, {COND,TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*E1*/
   {"LOOP",  NULL, OpJb, 1, {COND,TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*E2*/
   {"JCXZ","JECXZ",OpJb, 1, {COND,TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*E3*/
   {"IN",  NULL, OpALIb, 2, {NULL, NULL, B01, B01, B00, B00, NULL, NULL}, IR }, /*E4*/
   {"IN",  NULL, OpvAXIb,2, {NULL, NULL, B02, B04, B00, B00, NULL, NULL}, IR }, /*E5*/
   {"OUT", NULL, OpIbAL, 2, {NULL, NULL, B00, B00, B01, B01, NULL, NULL}, IW }, /*E6*/
   {"OUT", NULL, OpIbvAX,2, {NULL, NULL, B00, B00, B02, B04, NULL, NULL}, IW }, /*E7*/
   {"CALL",NULL, OpJv,   1, {NULL,TRANS, B00, B00, B02, B04, NULL, NULL}, MW }, /*E8*/
   {"JMP", NULL, OpJv,   1, {NULL,TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*E9*/
   {"JMP", NULL, OpAp,   1, {NULL,TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*EA*/
   {"JMP", NULL, OpJb,   1, {NULL,TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*EB*/
   {"IN",  NULL, OpALDX, 2, {NULL, NULL, B01, B01, B00, B00, NULL, NULL}, IR }, /*EC*/
   {"IN",  NULL, OpvAXDX,2, {NULL, NULL, B02, B04, B00, B00, NULL, NULL}, IR }, /*ED*/
   {"OUT", NULL, OpDXAL, 2, {NULL, NULL, B00, B00, B01, B01, NULL, NULL}, IW }, /*EE*/
   {"OUT", NULL, OpDXvAX,2, {NULL, NULL, B00, B00, B02, B04, NULL, NULL}, IW }, /*EF*/

   {"LOCK", NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*F0*/
   {ERR,    NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*F1*/
   {"REPNE",NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*F2*/
   {"REP",  NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*F3*/
   {"HLT",  NULL, NULL,  0, {NULL,TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*F4*/
   {"CMC",  NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*F5*/
   {(CH*)1,(CH*)G9,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*F6*/
   {(CH*)1,(CH*)GA,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*F7*/
   {"CLC",  NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*F8*/
   {"STC",  NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*F9*/
   CLI_ENTRY,       /* processor specific: 386 flushes queue, 486 doesn't */
   {"STI",  NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*FB*/
   {"CLD",  NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*FC*/
   {"STD",  NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*FD*/
   {(CH*)1,(CH*)GB,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*FE*/
   {(CH*)1,(CH*)GC,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}  /*FF*/
};

STATIC OPTABLE *OpTable1[] = {
   /*0x00*/
   &O1[0],  &O1[1],  &O1[2],  &O1[3],  &O1[4],  &O1[5],  &O1[6],  &O1[7],
   &O1[8],  &O1[9],  &O1[10], &O1[11], &O1[12], &O1[13], &O1[14], &O1[15],
   /*0x10*/
   &O1[16], &O1[17], &O1[18], &O1[19], &O1[20], &O1[21], &O1[22], &O1[23],
   &O1[24], &O1[25], &O1[26], &O1[27], &O1[28], &O1[29], &O1[30], &O1[31],
   /*0x20*/
   &O1[32], &O1[33], &O1[34], &O1[35], &O1[36], &O1[37], &O1[38], &O1[39],
   &O1[40], &O1[41], &O1[42], &O1[43], &O1[44], &O1[45], &O1[46], &O1[47],
   /*0x30*/
   &O1[48], &O1[49], &O1[50], &O1[51], &O1[52], &O1[53], &O1[54], &O1[55],
   &O1[56], &O1[57], &O1[58], &O1[59], &O1[60], &O1[61], &O1[62], &O1[63],
   /*0x40*/
   &O1[64], &O1[65], &O1[66], &O1[67], &O1[68], &O1[69], &O1[70], &O1[71],
   &O1[72], &O1[73], &O1[74], &O1[75], &O1[76], &O1[77], &O1[78], &O1[79],
   /*0x50*/
   &O1[80], &O1[81], &O1[82], &O1[83], &O1[84], &O1[85], &O1[86], &O1[87],
   &O1[88], &O1[89], &O1[90], &O1[91], &O1[92], &O1[93], &O1[94], &O1[95],
   /*0x60*/
   &O1[96], &O1[97], &O1[98], &O1[99], &O1[100],&O1[101],&O1[102],&O1[103],
   &O1[104],&O1[105],&O1[106],&O1[107],&O1[108],&O1[109],&O1[110],&O1[111],
   /*0x70*/
   &O1[112],&O1[113],&O1[114],&O1[115],&O1[116],&O1[117],&O1[118],&O1[119],
   &O1[120],&O1[121],&O1[122],&O1[123],&O1[124],&O1[125],&O1[126],&O1[127],
   /*0x80*/
   &O1[128],&O1[129],&O1[130],&O1[131],&O1[132],&O1[133],&O1[134],&O1[135],
   &O1[136],&O1[137],&O1[138],&O1[139],&O1[140],&O1[141],&O1[142],&O1[143],
   /*0x90*/
   &O1[144],&O1[145],&O1[146],&O1[147],&O1[148],&O1[149],&O1[150],&O1[151],
   &O1[152],&O1[153],&O1[154],&O1[155],&O1[156],&O1[157],&O1[158],&O1[159],
   /*0xA0*/
   &O1[160],&O1[161],&O1[162],&O1[163],&O1[164],&O1[165],&O1[166],&O1[167],
   &O1[168],&O1[169],&O1[170],&O1[171],&O1[172],&O1[173],&O1[174],&O1[175],
   /*0xB0*/
   &O1[176],&O1[177],&O1[178],&O1[179],&O1[180],&O1[181],&O1[182],&O1[183],
   &O1[184],&O1[185],&O1[186],&O1[187],&O1[188],&O1[189],&O1[190],&O1[191],
   /*0xC0*/
   &O1[192],&O1[193],&O1[194],&O1[195],&O1[196],&O1[197],&O1[198],&O1[199],
   &O1[200],&O1[201],&O1[202],&O1[203],&O1[204],&O1[205],&O1[206],&O1[207],
   /*0xD0*/
   &O1[208],&O1[209],&O1[210],&O1[211],&O1[212],&O1[213],NULL    ,&O1[215],
   &O1[216],&O1[217],&O1[218],&O1[219],&O1[220],&O1[221],&O1[222],&O1[223],
   /*0xE0*/
   &O1[224],&O1[225],&O1[226],&O1[227],&O1[228],&O1[229],&O1[230],&O1[231],
   &O1[232],&O1[233],&O1[234],&O1[235],&O1[236],&O1[237],&O1[238],&O1[239],
   /*0xF0*/
   &O1[240],NULL    ,&O1[242],&O1[243],&O1[244],&O1[245],&O1[246],&O1[247],
   &O1[248],&O1[249],&O1[250],&O1[251],&O1[252],&O1[253],&O1[254],&O1[255]
};

/*****************************************************************************
* optable2 -- Two byte opcodes
*/
STATIC OPTABLE O2[] = {
   {(CH*)1,(CH*)GD,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*00*/
   {(CH*)1,(CH*)GE,NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*01*/
   {"LAR",   NULL,OpGvEv,2, {NULL, NULL, B02, B04, B00, B00, NULL, NULL}, MR }, /*02*/
   {"LSL",   NULL,OpGvEv,2, {NULL, NULL, B02, B04, B00, B00, NULL, SPEC}, MR }, /*03*/
   {ERR,     NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*04*/
   {ERR,     NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*05*/
   {"CLTS",  NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*06*/
   {ERR,     NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*07*/
   {"INVD",  NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*08*/
   {"WBINVD",NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*09*/
   {ERR,     NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*0A*/
   {ERR,     NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*0B*/
   {ERR,     NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*0C*/
   {ERR,     NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*0D*/
   {ERR,     NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*0E*/
   {ERR,     NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}  /*0F*/
};
STATIC OPTABLE O3[] =  {
   {"MOV", NULL, OpRdCd,2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*20*/
   {"MOV", NULL, OpRdDd,2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*21*/
   {"MOV", NULL, OpCdRd,2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*22*/
   {"MOV", NULL, OpDdRd,2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*23*/
   {"MOV", NULL, OpRdTd,2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*24*/
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*25*/
   {"MOV", NULL, OpTdRd,2, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*26*/
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*27*/
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*28*/
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*29*/
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*2A*/
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*2B*/
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*2C*/
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*2D*/
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*2E*/
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}  /*2F*/
};
STATIC OPTABLE O4[] =         {
   {"JO",  NULL, OpJv, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*80*/
   {"JNO", NULL, OpJv, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*81*/
   {"JB",  NULL, OpJv, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*82*/
   {"JNB", NULL, OpJv, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*83*/
   {"JZ",  NULL, OpJv, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*84*/
   {"JNZ", NULL, OpJv, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*85*/
   {"JBE", NULL, OpJv, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*86*/
   {"JNBE",NULL, OpJv, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*87*/
   {"JS",  NULL, OpJv, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*88*/
   {"JNS", NULL, OpJv, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*89*/
   {"JP",  NULL, OpJv, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*8A*/
   {"JNP", NULL, OpJv, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*8B*/
   {"JL",  NULL, OpJv, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*8C*/
   {"JNL", NULL, OpJv, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*8D*/
   {"JLE", NULL, OpJv, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*8E*/
   {"JNLE",NULL, OpJv, 1, {COND, TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*8F*/

   {"SETO",  NULL, OpEb, 1, {COND, NULL, B00, B00, B01, B01, NULL, NULL}, MW }, /*90*/
   {"SETNO", NULL, OpEb, 1, {COND, NULL, B00, B00, B01, B01, NULL, NULL}, MW }, /*91*/
   {"SETB",  NULL, OpEb, 1, {COND, NULL, B00, B00, B01, B01, NULL, NULL}, MW }, /*92*/
   {"SETNB", NULL, OpEb, 1, {COND, NULL, B00, B00, B01, B01, NULL, NULL}, MW }, /*93*/
   {"SETZ",  NULL, OpEb, 1, {COND, NULL, B00, B00, B01, B01, NULL, NULL}, MW }, /*94*/
   {"SETNZ", NULL, OpEb, 1, {COND, NULL, B00, B00, B01, B01, NULL, NULL}, MW }, /*95*/
   {"SETBE", NULL, OpEb, 1, {COND, NULL, B00, B00, B01, B01, NULL, NULL}, MW }, /*96*/
   {"SETNBE",NULL, OpEb, 1, {COND, NULL, B00, B00, B01, B01, NULL, NULL}, MW }, /*97*/
   {"SETS",  NULL, OpEb, 1, {COND, NULL, B00, B00, B01, B01, NULL, NULL}, MW }, /*98*/
   {"SETNS", NULL, OpEb, 1, {COND, NULL, B00, B00, B01, B01, NULL, NULL}, MW }, /*99*/
   {"SETP",  NULL, OpEb, 1, {COND, NULL, B00, B00, B01, B01, NULL, NULL}, MW }, /*9A*/
   {"SETNP", NULL, OpEb, 1, {COND, NULL, B00, B00, B01, B01, NULL, NULL}, MW }, /*9B*/
   {"SETL",  NULL, OpEb, 1, {COND, NULL, B00, B00, B01, B01, NULL, NULL}, MW }, /*9C*/
   {"SETNL", NULL, OpEb, 1, {COND, NULL, B00, B00, B01, B01, NULL, NULL}, MW }, /*9D*/
   {"SETLE", NULL, OpEb, 1, {COND, NULL, B00, B00, B01, B01, NULL, NULL}, MW }, /*9E*/
   {"SETNLE",NULL, OpEb, 1, {COND, NULL, B00, B00, B01, B01, NULL, NULL}, MW }, /*9F*/

   {"PUSH", NULL, OpFS, 1, {NULL,  NULL, B00, B00, B02, B02, NULL, NULL}, MW }, /*A0*/
   {"POP",  NULL, OpFS, 1, {NULL,  NULL, B02, B02, B00, B00, NULL, NULL}, MR }, /*A1*/
   {ERR,    NULL, NULL, 0, {NULL,  NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*A2*/
   {"BT",   NULL,OpEvGv,2, {NULL,  NULL, B02, B04, B00, B00, NULL, NULL}, MR }, /*A3*/
   {"SHLD", NULL,OpEvGvIb,3,{NULL, NULL, B02, B04, B02, B04,MODRM, NULL}, MRW}, /*A4*/
   {"SHLD", NULL,OpEvGvCL,3,{NULL, NULL, B02, B04, B02, B04,MODRM, NULL}, MRW}, /*A5*/
};
/****************************************************************************
  The next two instructions are no longer supported by Intel
   {"XBTS",  NULL,    OpGvEvvAXCL,4,   {0,0, 0,0,0,0,0,0,0},},   A6
   {"IBTS",  NULL,    OpEvvAXCLGv,4,   {0,0, 0,0,0,0,0,0,0},},   A7
****************************************************************************/
STATIC OPTABLE O5[] = {
   {"PUSH",NULL, OpGS,  1, {NULL, NULL, B00, B00, B02, B02, NULL, NULL}, MW }, /*A8*/
   {"POP", NULL, OpGS,  1, {NULL, NULL, B02, B02, B00, B00, NULL, NULL}, MR }, /*A9*/
   {"RSM", NULL, NULL,  0, {NULL,TRANS, B00, B00, B00, B00, NULL, NULL}, NULL}, /*AA*/
   {"BTS", NULL,OpEvGv, 2, {NULL, NULL, B02, B04, B02, B04,MODRM, NULL}, MRW}, /*AB*/
   {"SHRD",NULL,OpEvGvIb,3,{NULL, NULL, B02, B04, B02, B04,MODRM, NULL}, MRW}, /*AC*/
   {"SHRD",NULL,OpEvGvCL,3,{NULL, NULL, B02, B04, B02, B04,MODRM, NULL}, MRW}, /*AD*/
   {ERR,   NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*AE*/
   {"IMUL",NULL,OpGvEv, 2, {NULL, NULL, B02, B04, B00, B00,MODRM, NULL}, MR }, /*AF*/

   {"CMPXCHG",NULL,OpEbGb,2, {NULL, NULL, B01, B01, B01, B01,MODRM, NULL}, MRW}, /*B0*/
   {"CMPXCHG",NULL,OpEvGv,2, {NULL, NULL, B02, B04, B02, B04,MODRM, NULL}, MRW}, /*B1*/
   {"LSS",   NULL, OpGvM, 2, {NULL, NULL, B04, B06, B00, B00, NULL, NULL}, MR }, /*B2*/
   {"BTR",   NULL, OpEvGv,2, {NULL, NULL, B02, B04, B02, B04,MODRM, NULL}, MRW}, /*B3*/
   {"LFS",   NULL, OpGvM, 2, {NULL, NULL, B04, B06, B00, B00, NULL, NULL}, MR }, /*B4*/
   {"LGS",   NULL, OpGvM, 2, {NULL, NULL, B04, B06, B00, B00, NULL, NULL}, MR }, /*B5*/
   {"MOVZX", NULL, OpGvEb,2, {NULL, NULL, B01, B01, B00, B00,MODRM, NULL}, MR }, /*B6*/
   {"MOVZX", NULL, OpGvEw,2, {NULL, NULL, B01, B01, B00, B00,MODRM, NULL}, MR }, /*B7*/
   {ERR,     NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*B8*/
   {ERR,     NULL, NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*B9*/
   {(CH*)1,(CH*)GF,NULL,  0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, /*BA*/
   {"BTC",   NULL, OpEvGv,2, {NULL, NULL, B02, B04, B02, B04,MODRM, NULL}, MRW}, /*BB*/
   {"BSF",   NULL, OpGvEv,2, {NULL, NULL, B02, B04, B00, B00,MODRM, NULL}, MR }, /*BC*/
   {"BSR",   NULL, OpGvEv,2, {NULL, NULL, B02, B04, B00, B00,MODRM, NULL}, MR }, /*BD*/
   {"MOVSX", NULL, OpGvEb,2, {NULL, NULL, B01, B01, B00, B00,MODRM, NULL}, MR }, /*BE*/
   {"MOVSX", NULL, OpGvEw,2, {NULL, NULL, B02, B02, B00, B00,MODRM, NULL}, MR }  /*BF*/
};

/*  not used
STATIC OPTABLE O6[] = {
   {"XADD", NULL,OpEbGb,2, {NULL, NULL, B01, B01, B01, B01,MODRM, NULL}, MRW},  //C0
   {"XADD", NULL,OpEvGv,2, {NULL, NULL, B02, B04, B02, B04,MODRM, NULL}, MRW},  //C1
   {NULL,   NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, //C2
   {NULL,   NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, //C3
   {NULL,   NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, //C4
   {NULL,   NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, //C5
   {NULL,   NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, //C6
   {NULL,   NULL, NULL, 0, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, //C7
   {"BSWAP",NULL, OpLv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, //C8
   {"BSWAP",NULL, OpLv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, //C9
   {"BSWAP",NULL, OpLv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, //CA
   {"BSWAP",NULL, OpLv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, //CB
   {"BSWAP",NULL, OpLv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, //CC
   {"BSWAP",NULL, OpLv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, //CD
   {"BSWAP",NULL, OpLv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, //CE
   {"BSWAP",NULL, OpLv, 1, {NULL, NULL, B00, B00, B00, B00, NULL, NULL}, NULL}, //CF
}; */

STATIC OPTABLE *OpTable2[] = {
   /*0x00*/
   &O2[0],   &O2[1],  &O2[2],  &O2[3],  NULL,    NULL,    &O2[6],  NULL,
   INVD,     WBINVD,  NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
   /*0x10*/
   NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
   NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
   /*0x20*/
   &O3[0],   &O3[1],  &O3[2],  &O3[3],  &O3[4],  NULL,    &O3[6],  NULL,
   NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
   /*0x30*/
   NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
   NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
   /*0x40*/
   NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
   NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
   /*0x50*/
   NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
   NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
   /*0x60*/
   NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
   NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
   /*0x70*/
   NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
   NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
   /*0x80*/
   &O4[0],   &O4[1],  &O4[2],  &O4[3],  &O4[4],  &O4[5],  &O4[6],  &O4[7],
   &O4[8],   &O4[9],  &O4[10], &O4[11], &O4[12], &O4[13], &O4[14], &O4[15],
   /*0x90*/
   &O4[16],  &O4[17], &O4[18], &O4[19], &O4[20], &O4[21], &O4[22], &O4[23],
   &O4[24],  &O4[25], &O4[26], &O4[27], &O4[28], &O4[29], &O4[30], &O4[31],
   /*0xA0*/
   &O4[32],  &O4[33], NULL,    &O4[35], &O4[36], &O4[37], NULL,    NULL,
   &O5[0],   &O5[1],  &O5[2],  &O5[3],  &O5[4],  &O5[5],  NULL,    &O5[7],
   /*0xB0*/
   CMPXCHGB, CMPXCHGW,&O5[10], &O5[11], &O5[12], &O5[13], &O5[14], &O5[15],
   NULL,     NULL,    &O5[18], &O5[19], &O5[20], &O5[21], &O5[22], &O5[23],
   /*0xC0*/
   XADDB,    XADDW,   NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
   BSWAP0,   BSWAP1,  BSWAP2,  BSWAP3,  BSWAP4,  BSWAP5,  BSWAP6,  BSWAP7,
   /*0xD0*/
   NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
   NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
   /*0xE0*/
   NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
   NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
   /*0xF0*/
   NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
   NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
   };

/* The order of the elements in the following arrays must NOT be changed! */


STATIC CHAR *OprByteReg[]   = {"AL","CL","DL","BL","AH","CH","DH","BH"};
STATIC CHAR *OprWordReg[]   = {"AX","CX","DX","BX","SP","BP","SI","DI"};
STATIC CHAR *OprDwordReg[]  = {"EAX","ECX","EDX","EBX","ESP","EBP","ESI",
                               "EDI"};
STATIC CHAR *OprAddr16Reg[] = {"BX+SI","BX+DI","BP+SI","BP+DI","SI","DI",
                               "BP","BX"};
STATIC CHAR *OprSegReg[]    = {"ES","CS","SS","DS"};
STATIC CHAR *OprCrReg[]     = {"CR0",NULL,"CR2","CR3"};
STATIC CHAR *OprDrReg[]     = {"DR0","DR1","DR2","DR3",NULL,NULL,"DR6","DR7"};
STATIC CHAR *OprTrReg[]     = {NULL,NULL,NULL,"TR3","TR4","TR5","TR6","TR7"};
STATIC CHAR *NumProc1[]     = {"FADD","FMUL","FCOM","FCOMP","FSUB","FSUBR",
                               "FDIV","FDIVR"};
STATIC CHAR *NumProc1A[]    = {"FADD","FMUL","FCOM","FCOMP","FSUBR","FSUB",
                               "FDIVR","FDIV"};
STATIC CHAR *NumProc2[]     = {"FCHS","FABS",NULL,NULL,"FTST","FXAM",NULL,
                               NULL,"FLD1","FLDL2T","FLDL2E","FLDPI","FLDLG2",
                               "FLDLN2","FLDZ",NULL,"F2XM1","FYL2X","FPTAN",
                               "FPATAN","FXTRACT","FPREM1","FDECSTP","FINCSTP",
                               "FPREM","FYL2XP1","FSQRT","FSINCOS","FRNDINT",
                               "FSCALE","FSIN","FCOS"};
STATIC CHAR *NumProc3[]     = {"FFREE","FSTP","FST",NULL,"FUCOM","FUCOMP"};

                        /****************************
                         *                          *
                         *        PROTOTYPES        *
                         *                          *
                         ****************************/
/******************************** E O F ************************************/

