/***************************************************************************
**
** Name:  pdasm86.h
**
** Description:  Processor specific disassembler.
**
** $Log:   S:/tbird/mt2_186/dasm/pdasm86.h_v  $
** 
**    Rev 1.1   03 Apr 1997 15:06:28   Judy
** No change.
** 
**    Rev 1.0   16 Dec 1996 16:43:32   Judy
** Initial revision.
** 
**    Rev 1.3   03 Aug 1994 10:02:32   marilyn
** Added knownAddr field to the DASM_INFO struct.
** 
**    Rev 1.2   13 Jun 1994 18:45:24   marilyn
** Changes the interfaces to include ADDR_OP_SIZE where appropriate.
** DadGetDasmInstruction is exported but is not in the def file and does
** not appear to currently be in use.
** 
**    Rev 1.1   02 Jun 1994 13:53:32   mindy
** changed GetDasmInst... interface
** 
**    Rev 1.0   25 May 1994 14:19:10   nghia
** Initial revision.
**
** $Header:   S:/tbird/mt2_186/dasm/pdasm86.h_v   1.1   03 Apr 1997 15:06:28   Judy  $
**
** Copyright (C) 1994  Microtek International.  All rights reserved.
****************************************************************************/
#define _PDASM86_
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _ADDR_
#include "addr.h"
#endif

#ifndef _SDTEMPL_
#include "sdtempl.h"
#endif


                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define ADDR_FIELD 16          /* Included here to calculate MAX_DASM_TEXT */

#define MR       1                                    /* Memory read cycle */
#define MW       2                                   /* Memory write cycle */
#define MRW      3                           /* Memory read & write cycles */
#define IR       4                                       /* I/O read cycle */
#define IW       8                                      /* I/O write cycle */
#define MWIR     6                              /* Memory write & I/O read */
#define MRIW     9                              /* Memory read & I/O write */

typedef struct {              /* statistics returned by actual disassembly */
                          /* expand as necessary if additional info needed */
   BOOLEAN transfer;                       /* control transfer instruction */
   BOOLEAN conditional;                         /* conditional instruction */
   BOOLEAN knownAddr;                           /* target address is known */
   DESCRIPTOR target;                /* Target address of control transfer */
   BOOLEAN prefix;             /* Instruction Prefix (e.g. LOCK  or REP..) */
   BOOLEAN popMovSS;                                /* POP/MOV SS sequence */
   BOOLEAN callType;                              /* CALL type instruction */
   BOOLEAN retnType;                            /* Return type instruction */
   BOOLEAN operand32;                                      /* Operand size */
   U8   accessType;                                  /* Type of bus cycles */
   U16  MRCycles;                               /* # bytes per memory read */
   U16  MWCycles;                              /* # bytes per memory write */
   U16  IRCycles;                                   /* # bytes per IO read */
   U16  IWCycles;                                  /* # Bytes per IO write */
   U8   bytesUsed;                                 /* Number of bytes used */
} DASM_INFO;

                        /****************************
                         *                          *
                         *        PROTOTYPES        *
                         *                          *
                         ****************************/
/****************************************************************************
**  Ldasm
**  purpose: Ldasm returns a text buffer formatted as follows:  1 or 2 prefix
**  strings starting with '@' and null terminator, Opcode mnemonic starting
**  with '|' and null terminator, Operand string null terminated.  Operand
**  string has no prefix byte. It is the responsibility of the calling
**  routine to remove the prefix bytes and format the output as required.
**  If the text display is not required, set TextBuffer to NIL on the call.
**
**  MemData   (in):  byte stream to disassemble <= MAX_INSTR_SIZE
**  CodeMode  (in):  REAL | V86 | PROTECT16 | PROTECT32
**  StartAddress(in):Address to start disassembly
**  Sym       (in):  symbol decoding flag
**  TextBuffer(out): buffer for returned text (NIL if not used)
**                   max size = MAX_DASM_TEXT
**  DasmInfo  (out): returned status info on actual disassembly
****************************************************************************/
RETCODE Ldasm(CHAR *MemData, PMODE CodeMode, ADDR_OP_SIZE addrOpSize,
              DESCRIPTOR StartAddress, BOOLEAN Sym, CHAR *TextBuffer,
              DASM_INFO *DasmInfo);

/***************************************************************************
**
**  LdasmText
**  Description: The function is going to convert the Ldasm text format to
**    formal form
**
**    Ldasm returns a text buffer formatted as follows:
**    1. 1 or 2 prefix strings starting with '@' and null terminator,
**    2. one Opcode mnemonic starting with '|' and null terminator,
**    3. Operand string with null terminated
**    
**  text (in): generated by Ldasm
**  result(out): converted text 
**
***************************************************************************/

RETCODE LdasmText(LPSTR text, LPSTR result);

/****************************************************************************
**  DadGetDasmInstruction
**  purpose: An entry of DASM
**
**  addr (in): descriptor of start address caller allocates/deallocates
**  opSize (in): current address and operand size
**  instBytes (in): object code
**  instText (in/out): output result - caller provides storage
**  info (in/out): DASM information - caller provides storage.
****************************************************************************/
RETCODE EXPORT DadGetDasmInstruction(DESCRIPTOR addr, ADDR_OP_SIZE opSize,
                                     LPSTR instBytes,  LPSTR instText,
                                     DASM_INFO *info);

/******************************** E O F ************************************/

