/* CPU Map DLL */!!

inherit(ProvidedLibs, #MapLib, nil, 2, nil)!!

now(class(MapLib))!!

/* semiPRIVATE -- should only be called via require(MapLib)
   Define entry points and load library.  Define any structs required.
*/
Def provide(self, path)
{
  ^initialise( new(self:ancestor), path )
}
!!

now(MapLib)!!

/* 4/19/94 10:45 */
/* Start up the map dialog: now in a DLL instead of Actor. */

Def mapPresenter(self | rc myHandle)
{ 
  if pcallLock(self)
    myHandle := handle(TheToolBarPresenter);
    rc := pcall( procs[#MAPPRESENTER], myHandle);
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;

  ^rc;

}
!!

/* PUBLIC
   Call memory DLL entry point to relink EP.
*/
Def RelinkEP(self)
{
  if pcallLock(self)
    lastError := pcall(procs[#RELINKEP]);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;
  
  if (lastError <> 0)
    displayError(ErrorTextLibClass$Inst, lastError, CHECK_MODE);
    ^nil;
  endif;
  
  ^0;
}
!!
/* Call restoreCS */
Def restoreCS(self, fileName)
{
  if pcallLock(self)
    lastError := pcall(procs[#MAPRESTORECS], asciiz(fileName));
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;
  
  if (lastError <> 0)
    displayError(ErrorTextLibClass$Inst, lastError, CHECK_MODE);
    ^nil;
  endif;
  
  ^0;
}!!

/* Call saveCS */
Def saveCS(self, fileName)
{ 
  if pcallLock(self)
    lastError := pcall(procs[#MAPSAVECS], asciiz(fileName));
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;
  
  if (lastError <> 0)
    displayError(ErrorTextLibClass$Inst, lastError, CHECK_MODE);
    ^nil;
  endif;
  
  ^0;
}!!

/* Call configCS */
Def configCS(self)
{ 
  if pcallLock(self)
    lastError := pcall(procs[#MAPCONFIGCS]);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;
  
  if (lastError <> 0)
    displayError(ErrorTextLibClass$Inst, lastError, CHECK_MODE);
    ^nil;
  endif;
  
  ^0;
}!!

/* 8/4/1992 12:34 */
/* finds out if the overlay memory is present */

Def getMapPresent(self | rc)
{ 
  if pcallLock(self)
  then
    rc := pcall( procs[#GETMAPPRESENT] );
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  ^rc;

}
!!

/* 2/4/1992 17:08 */
Def addImportProcs(self)
{
  add(self, #INITCSERVER,            1, #(0, 0));
  add(self, #INITSERVER,             1, nil);
  add(self, #GETMAPBLOCKSIZE,        1, #(1));
  add(self, #GETMAPBLOCKCOUNT,       1, #(1));
  add(self, #GETMAPBLOCKGRANULARITY, 1, #(1));
  add(self, #MAPGET,                 1, #(1));
  add(self, #MAPSET,                 1, #(1));
  add(self, #MAPCLEAR,               1, nil);
  add(self, #MAPBLOCKOVERLAP,        1, #(1, 1, 1));
  add(self, #GETMAPPRESENT,          0, nil);
  add(self, #MAPCONFIGCS,            1, nil);
  add(self, #MAPSAVECS,              1, #(1));
  add(self, #MAPRESTORECS,           1, #(1));
  add(self, #MAPPRESENTER,           1, #(0));
  add(self, #RELINKEP,               1, nil);
}
!!

/* 7/21/1992 12:34 */
/* clears the map data */

Def clearMap(self | rc)
{ 
  if pcallLock(self)
  then
    rc := pcall( procs[#MAPCLEAR] );
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  ^rc;

}
!!

/* PRIVATE */
Def defineStructs(self)
{ 

/* map struct for MapGet/MapSet */ 
def (UserType, #mapData, #(
   long address
   long blockSize
   short accessRights
   long blockNumber
   byte enabled ));

}
!!

/* 7/21/1992 12:34 */
/* gets the map data from the map server */

Def getMap(self, mapInfo | rc)
{ 
  if pcallLock(self)
  then
    rc := pcall( procs[#MAPGET], data(mapInfo) );
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  ^rc;

}
!!

/* 7/21/1992 12:34 */
/* gets the smallest mapable block from the map server */

Def getMapBlockGran(self blockSize | rc)
{ 
  if pcallLock(self)
  then
    rc := pcall( procs[#GETMAPBLOCKGRANULARITY], blockSize );
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  ^rc;

}
!!

/* 7/21/1992 12:34 */
/* gets the largest mapable block from the map server */

Def getMapBlockSize(self blockSize| rc)
{ 
  if pcallLock(self)
  then
    rc := pcall( procs[#GETMAPBLOCKSIZE], blockSize );
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  ^rc;

}
!!

/* 
   Open and initialize variable server library & load trigger dll
*/
Def initialise(self, path)
{
   defineStructs(self);
   setName( self, path ) ;
   addImportProcs( self ) ;
   load( self ) ;  /* raises alert if fails: alert(System, self, #libLoad) */
   initServer( self ) ;
}
!!

/* PRIVATE */
Def initServer(self)
{

  if pcallLock(self)
  then
    lastError := pcall(procs[#INITSERVER]) ;
    pcallUNLock(self);
  else
    lastError := ERR_PCALL_RECURSION ;
  endif;
  displayError(ErrorTextLibClass$Inst,lastError,FORCE_POPUP);
  ^lastError;
}
!!

/* 7/21/1992 12:34 */
/* checks to see if the block about to be mapped matches any of the
   previously mapped blocks */

Def mapBlockOverlap(self mapInfo startOffset status| rc)
{ 
  if pcallLock(self)
  then
    rc := pcall( procs[#MAPBLOCKOVERLAP], data(mapInfo), startOffset, status);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  ^rc;

}
!!

/* 7/21/1992 15:20 */
Def newMapInfo(self)
{ 
  ^build(CStruct, #mapData);
}
!!

/* 7/21/1992 12:34 */
/* sends the map data to the map server */

Def setMap(self, mapInfo | rc)
{ 
  if pcallLock(self)
  then
    rc := pcall( procs[#MAPSET], data(mapInfo) );
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  ^rc;

}
!!
