/****************************************************************************
**
**  Name:  sdprobe.h
**
**  Description:
**     Processor-specific shared data assignments of registers and signals
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_186/inc/sdprobe.h_v  $
** 
**    Rev 1.0   16 Dec 1996 13:54:04   Judy
** Initial revision.
** 
**    Rev 1.0   27 Aug 1996 15:21:20   Judy
** Initial revision.
   
      Rev 1.0   23 Aug 1996 17:45:34   Judy
   Initial revision.
** 
**    Rev 1.24   21 Sep 1994 15:07:10   ernie
** Added HLDA signal and SD_RESERVE_DR member
** 
**    Rev 1.23   05 Sep 1994 17:23:40   mindy
** added addr space to fw_lines
** 
**    Rev 1.22   14 Jul 1994 06:57:28   mindy
** Added btm cycle enable member
** 
**    Rev 1.21   30 Jun 1994 09:02:38   mindy
** added io and data union to FW_LINES
** 
**    Rev 1.20   18 May 1994 09:39:04   dennis
** Added register and signal descriptions for 68040.
** 
**    Rev 1.19   10 May 1994 10:04:46   ernie
** Added 386 support: SD_PMODE, SD_COP_TYPE, register definitions, and
** signal definitions.
** 
**    Rev 1.18   21 Apr 1994 16:24:58   john
** Added SIM_VALID member
** 
**    Rev 1.17   30 Mar 1994 15:02:12   STEVE
** Forgot to include definition of BDM_SPEED.
** 
**    Rev 1.16   30 Mar 1994 10:38:08   ernie
** Added bdmspeed member
** 
**    Rev 1.15   04 Mar 1994 10:43:32   john
** Added definitions for CPU32+ signals
** 
**    Rev 1.14   07 Oct 1993 12:40:08   ernie
** Added SD_STEP_MASK member
** 
**    Rev 1.13   22 Jul 1993 14:46:44   mindy
** changed fw_lines to avoid crossing boundry
** 
**    Rev 1.12   22 Jul 1993 12:18:34   mindy
** made fwline area larger.
** 
**    Rev 1.11   13 Jul 1993 08:12:14   ernie
** Added bus error retry member
** 
**    Rev 1.10   26 May 1993 10:45:56   ernie
** Reduced number of characters in an sd name
** 
**    Rev 1.9   24 Mar 1993 08:27:16   ernie
** Merged branch
** 
**    Rev 1.8.1.1   05 Mar 1993 15:12:06   ernie
** Added cpu16 register names
** 
**    Rev 1.8.1.0   25 Feb 1993 08:03:46   ernie
** No change.
** 
**    Rev 1.8   16 Dec 1992 15:36:52   mindy
** moved dq to fw
** 
**    Rev 1.7   09 Dec 1992 10:40:26   mindy
** changed dq'r interface
** 
**    Rev 1.6   02 Nov 1992 12:53:32   ernie
** Added abort for dq sync function
** 
**    Rev 1.5   14 Oct 1992 14:44:44   ernie
** Added dequeuer sync-up interfaces
** 
**    Rev 1.4   14 Sep 1992 08:12:50   ernie
** Added SD_SIM_ADDRESS shared data member
** 
**    Rev 1.3   19 Aug 1992 08:18:06   ernie
** Added processor-specific shared data members for configuring chip-
** select hardware.
** 
**    Rev 1.2   05 Aug 1992 15:31:16   ernie
** Added hidden registers to register list for diagnostic purposes.
** 
**    Rev 1.1   21 Jul 1992 12:40:38   doug
** a) the pc, stack, and frame pointers must be first 3
** b) added a7 to simplify stack code (firmware handles overlaps)
** 
**    Rev 1.0   20 Jul 1992 09:44:48   doug
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_186/inc/sdprobe.h_v   1.0   16 Dec 1996 13:54:04   Judy  $
**
*****************************************************************************/
#define _SDPROBE_

#ifndef _SDTEMPL_
#include "sdtempl.h"
#endif

#ifndef _SDNUM_
#include "sdnum.h"
#endif

typedef enum {
   BDM_SLOW, BDM_FAST,
   BDM_END=0x7fff
} BDM_SPEED;

typedef enum {
  PMODE_REAL, PMODE_V86, PMODE_P16, PMODE_P32, PMODE_SMM,
  PMODE_END=0x7fff
} PMODE;

typedef enum {
   COP_NONE, COP_287, COP_387,
   COP_END=0x7fff
} COP_TYPE;

typedef struct {
   S32 frameNo;
   U32 addr;
   ADDR_SPACE space;
   BOOLEAN inst;
   BOOLEAN write;
   BOOLEAN io;       // !! have I now crossed the boundary again?
   union {
      U16 words[9];
      U8 bytes[18];
   } data;
} FW_LINES;

/* CPU32 register names */
#define SD_PC SD_REG00
#define SD_A7 SD_REG01
#define SD_A6 SD_REG02
#define SD_D0 SD_REG03
#define SD_D1 SD_REG04
#define SD_D2 SD_REG05
#define SD_D3 SD_REG06
#define SD_D4 SD_REG07
#define SD_D5 SD_REG08
#define SD_D6 SD_REG09
#define SD_D7 SD_REG0A
#define SD_A0 SD_REG0B
#define SD_A1 SD_REG0C
#define SD_A2 SD_REG0D
#define SD_A3 SD_REG0E
#define SD_A4 SD_REG0F
#define SD_A5 SD_REG10
#define SD_SR SD_REG11
#define SD_SSP SD_REG12
#define SD_USP SD_REG13
#define SD_SFC SD_REG14
#define SD_DFC SD_REG15
#define SD_VBR SD_REG16
#define SD_FAR SD_REG17
#define SD_PCC SD_REG18
#define SD_SSW SD_REG19

/* CPU16 register names */
#define SD_IP SD_REG00
#define SD_SP SD_REG01
#define SD_IZ SD_REG02
#define SD_IY SD_REG03
#define SD_IX SD_REG04
#define SD_D  SD_REG05
#define SD_E  SD_REG06
#define SD_EK SD_REG07
#define SD_CCR SD_REG08
#define SD_HR SD_REG09
#define SD_IR SD_REG0A
#define SD_AML SD_REG0B
#define SD_AMH SD_REG0C
#define SD_SL SD_REG0D
#define SD_XM SD_REG0E
#define SD_YM SD_REG0F
#define SD_PCR SD_REG10   /* raw pc register = ip+6 */

/* 386 register names */
#define SD_EIP SD_REG00
#define SD_ESP SD_REG01
#define SD_EBP SD_REG02
#define SD_EAX SD_REG03
#define SD_EBX SD_REG04
#define SD_ECX SD_REG05
#define SD_EDX SD_REG06
#define SD_ESI SD_REG07
#define SD_EDI SD_REG08
#define SD_EFLAGS   SD_REG09
#define SD_CS  SD_REG0A
#define SD_DS  SD_REG0B
#define SD_ES  SD_REG0C
#define SD_FS  SD_REG0D
#define SD_GS  SD_REG0E
#define SD_SS  SD_REG0F
#define SD_LDTR     SD_REG10
#define SD_TR       SD_REG11
#define SD_CR0      SD_REG12
#define SD_CR2      SD_REG13
#define SD_CR3      SD_REG14
#define SD_DR0      SD_REG15
#define SD_DR1      SD_REG16
#define SD_DR2      SD_REG17
#define SD_DR3      SD_REG18
#define SD_DR6      SD_REG19
#define SD_DR7      SD_REG1A
#define SD_TSSAR    SD_REG1B
#define SD_TSSBASE  SD_REG1C
#define SD_TSSLIMIT SD_REG1D
#define SD_IDTAR    SD_REG1E
#define SD_IDTBASE  SD_REG1F
#define SD_IDTLIMIT SD_REG20
#define SD_GDTAR    SD_REG21
#define SD_GDTBASE  SD_REG22
#define SD_GDTLIMIT SD_REG23
#define SD_LDTAR    SD_REG24
#define SD_LDTBASE  SD_REG25
#define SD_LDTLIMIT SD_REG26
#define SD_CSAR     SD_REG27
#define SD_CSBASE   SD_REG28
#define SD_CSLIMIT  SD_REG29
#define SD_DSAR     SD_REG2A
#define SD_DSBASE   SD_REG2B
#define SD_DSLIMIT  SD_REG2C
#define SD_ESAR     SD_REG2D
#define SD_ESBASE   SD_REG2E
#define SD_ESLIMIT  SD_REG2F
#define SD_FSAR     SD_REG30
#define SD_FSBASE   SD_REG31
#define SD_FSLIMIT  SD_REG32
#define SD_GSAR     SD_REG33
#define SD_GSBASE   SD_REG34
#define SD_GSLIMIT  SD_REG35
#define SD_SSAR     SD_REG36
#define SD_SSBASE   SD_REG37
#define SD_SSLIMIT  SD_REG38

/* Numeric definitions for registers */
#define SDN_PC SDN_REG00
#define SDN_A7 SDN_REG01
#define SDN_A6 SDN_REG02
#define SDN_D0 SDN_REG03
#define SDN_D1 SDN_REG04
#define SDN_D2 SDN_REG05
#define SDN_D3 SDN_REG06
#define SDN_D4 SDN_REG07
#define SDN_D5 SDN_REG08
#define SDN_D6 SDN_REG09
#define SDN_D7 SDN_REG0A
#define SDN_A0 SDN_REG0B
#define SDN_A1 SDN_REG0C
#define SDN_A2 SDN_REG0D
#define SDN_A3 SDN_REG0E
#define SDN_A4 SDN_REG0F
#define SDN_A5 SDN_REG10
#define SDN_SR SDN_REG11
#define SDN_SSP SDN_REG12
#define SDN_USP SDN_REG13
#define SDN_SFC SDN_REG14
#define SDN_DFC SDN_REG15
#define SDN_VBR SDN_REG16
#define SDN_FAR SDN_REG17
#define SDN_PCC SDN_REG18
#define SDN_SSW SDN_REG19

#define SDN_IP SDN_REG00
#define SDN_SP SDN_REG01
#define SDN_IZ SDN_REG02
#define SDN_IY SDN_REG03
#define SDN_IX SDN_REG04
#define SDN_D  SDN_REG05
#define SDN_E  SDN_REG06
#define SDN_EK SDN_REG07
#define SDN_CCR SDN_REG08
#define SDN_HR SDN_REG09
#define SDN_IR SDN_REG0A
#define SDN_AML SDN_REG0B
#define SDN_AMH SDN_REG0C
#define SDN_SL SDN_REG0D
#define SDN_XM SDN_REG0E
#define SDN_YM SDN_REG0F
#define SDN_PCR SDN_REG10   /* raw pc register = ip+6 */

#define SDN_EIP SDN_REG00
#define SDN_ESP SDN_REG01
#define SDN_EBP SDN_REG02
#define SDN_EAX SDN_REG03
#define SDN_EBX SDN_REG04
#define SDN_ECX SDN_REG05
#define SDN_EDX SDN_REG06
#define SDN_ESI SDN_REG07
#define SDN_EDI SDN_REG08
#define SDN_EFLAGS   SDN_REG09
#define SDN_CS  SDN_REG0A
#define SDN_DS  SDN_REG0B
#define SDN_ES  SDN_REG0C
#define SDN_FS  SDN_REG0D
#define SDN_GS  SDN_REG0E
#define SDN_SS  SDN_REG0F
#define SDN_LDTR     SDN_REG10
#define SDN_TR       SDN_REG11
#define SDN_CR0      SDN_REG12
#define SDN_CR2      SDN_REG13
#define SDN_CR3      SDN_REG14
#define SDN_DR0      SDN_REG15
#define SDN_DR1      SDN_REG16
#define SDN_DR2      SDN_REG17
#define SDN_DR3      SDN_REG18
#define SDN_DR6      SDN_REG19
#define SDN_DR7      SDN_REG1A
#define SDN_TSSAR    SDN_REG1B
#define SDN_TSSBASE  SDN_REG1C
#define SDN_TSSLIMIT SDN_REG1D
#define SDN_IDTAR    SDN_REG1E
#define SDN_IDTBASE  SDN_REG1F
#define SDN_IDTLIMIT SDN_REG20
#define SDN_GDTAR    SDN_REG21
#define SDN_GDTBASE  SDN_REG22
#define SDN_GDTLIMIT SDN_REG23
#define SDN_LDTAR    SDN_REG24
#define SDN_LDTBASE  SDN_REG25
#define SDN_LDTLIMIT SDN_REG26
#define SDN_CSAR     SDN_REG27
#define SDN_CSBASE   SDN_REG28
#define SDN_CSLIMIT  SDN_REG29
#define SDN_DSAR     SDN_REG2A
#define SDN_DSBASE   SDN_REG2B
#define SDN_DSLIMIT  SDN_REG2C
#define SDN_ESAR     SDN_REG2D
#define SDN_ESBASE   SDN_REG2E
#define SDN_ESLIMIT  SDN_REG2F
#define SDN_FSAR     SDN_REG30
#define SDN_FSBASE   SDN_REG31
#define SDN_FSLIMIT  SDN_REG32
#define SDN_GSAR     SDN_REG33
#define SDN_GSBASE   SDN_REG34
#define SDN_GSLIMIT  SDN_REG35
#define SDN_SSAR     SDN_REG36
#define SDN_SSBASE   SDN_REG37
#define SDN_SSLIMIT  SDN_REG38

/* 68040 common register names */
#define SD_PC SD_REG00
#define SD_A7 SD_REG01
#define SD_A6 SD_REG02
#define SD_D0 SD_REG03
#define SD_D1 SD_REG04
#define SD_D2 SD_REG05
#define SD_D3 SD_REG06
#define SD_D4 SD_REG07
#define SD_D5 SD_REG08
#define SD_D6 SD_REG09
#define SD_D7 SD_REG0A
#define SD_A0 SD_REG0B
#define SD_A1 SD_REG0C
#define SD_A2 SD_REG0D
#define SD_A3 SD_REG0E
#define SD_A4 SD_REG0F
#define SD_A5 SD_REG10
#define SD_SR SD_REG11
#define SD_ISP SD_REG12
#define SD_USP SD_REG13
#define SD_SFC SD_REG14
#define SD_DFC SD_REG15
#define SD_VBR SD_REG16
#define SD_CACR SD_REG17
#define SD_MSP SD_REG1C

/* 68040 common register names */
#define SDN_PC SDN_REG00
#define SDN_A7 SDN_REG01
#define SDN_A6 SDN_REG02
#define SDN_D0 SDN_REG03
#define SDN_D1 SDN_REG04
#define SDN_D2 SDN_REG05
#define SDN_D3 SDN_REG06
#define SDN_D4 SDN_REG07
#define SDN_D5 SDN_REG08
#define SDN_D6 SDN_REG09
#define SDN_D7 SDN_REG0A
#define SDN_A0 SDN_REG0B
#define SDN_A1 SDN_REG0C
#define SDN_A2 SDN_REG0D
#define SDN_A3 SDN_REG0E
#define SDN_A4 SDN_REG0F
#define SDN_A5 SDN_REG10
#define SDN_SR SDN_REG11
#define SDN_ISP SDN_REG12
#define SDN_USP SDN_REG13
#define SDN_SFC SDN_REG14
#define SDN_DFC SDN_REG15
#define SDN_VBR SDN_REG16
#define SDN_CACR SDN_REG17
#define SDN_MSP SDN_REG1C

/* EC040 register names */
#define SD_DACR0 SD_REG18
#define SD_DACR1 SD_REG19
#define SD_IACR0 SD_REG1A
#define SD_IACR1 SD_REG1B

/* EC040 register names */
#define SDN_DACR0 SDN_REG18
#define SDN_DACR1 SDN_REG19
#define SDN_IACR0 SDN_REG1A
#define SDN_IACR1 SDN_REG1B

/* LC040/040 register names */
#define SD_DTTR0 SD_REG18
#define SD_DTTR1 SD_REG19
#define SD_ITTR0 SD_REG1A
#define SD_ITTR1 SD_REG1B
#define SD_URP SD_REG1D
#define SD_SRP SD_REG1E
#define SD_TCR SD_REG1F
#define SD_MMUSR SD_REG20

/* LC040/040 register names */
#define SDN_DTTR0 SDN_REG18
#define SDN_DTTR1 SDN_REG19
#define SDN_ITTR0 SDN_REG1A
#define SDN_ITTR1 SDN_REG1B
#define SDN_URP SDN_REG1D
#define SDN_SRP SDN_REG1E
#define SDN_TCR SDN_REG1F
#define SDN_MMUSR SDN_REG20

/* 040 register names */
#define SD_FP00 SD_REG21
#define SD_FP01 SD_REG21
#define SD_FP02 SD_REG21
#define SD_FP10 SD_REG21
#define SD_FP11 SD_REG21
#define SD_FP12 SD_REG21
#define SD_FP20 SD_REG21
#define SD_FP21 SD_REG21
#define SD_FP22 SD_REG21
#define SD_FP30 SD_REG21
#define SD_FP31 SD_REG21
#define SD_FP32 SD_REG21
#define SD_FP40 SD_REG21
#define SD_FP41 SD_REG21
#define SD_FP42 SD_REG21
#define SD_FP50 SD_REG21
#define SD_FP51 SD_REG21
#define SD_FP52 SD_REG21
#define SD_FP60 SD_REG21
#define SD_FP61 SD_REG21
#define SD_FP62 SD_REG21
#define SD_FP70 SD_REG21
#define SD_FP71 SD_REG21
#define SD_FP72 SD_REG21
#define SD_FPCR SD_REG21
#define SD_FPSR SD_REG21
#define SD_FPIAR SD_REG21

/* 040 register names */
#define SDN_FP00 SDN_REG21
#define SDN_FP01 SDN_REG21
#define SDN_FP02 SDN_REG21
#define SDN_FP10 SDN_REG21
#define SDN_FP11 SDN_REG21
#define SDN_FP12 SDN_REG21
#define SDN_FP20 SDN_REG21
#define SDN_FP21 SDN_REG21
#define SDN_FP22 SDN_REG21
#define SDN_FP30 SDN_REG21
#define SDN_FP31 SDN_REG21
#define SDN_FP32 SDN_REG21
#define SDN_FP40 SDN_REG21
#define SDN_FP41 SDN_REG21
#define SDN_FP42 SDN_REG21
#define SDN_FP50 SDN_REG21
#define SDN_FP51 SDN_REG21
#define SDN_FP52 SDN_REG21
#define SDN_FP60 SDN_REG21
#define SDN_FP61 SDN_REG21
#define SDN_FP62 SDN_REG21
#define SDN_FP70 SDN_REG21
#define SDN_FP71 SDN_REG21
#define SDN_FP72 SDN_REG21
#define SDN_FPCR SDN_REG21
#define SDN_FPSR SDN_REG21
#define SDN_FPIAR SDN_REG21

/* CPU32 and CPU16 signal names */
#define SD_CLK_SIG   SD_SIG00
#define SD_RESET_SIG SD_SIG01

#define SDN_CLK_SIG   SDN_SIG00
#define SDN_RESET_SIG SDN_SIG01

/* CPU32P signal names */
#define SD_CLK_SIG   SD_SIG00
#define SD_RESETH_SIG SD_SIG01
#define SD_RESETS_SIG SD_SIG02

#define SDN_CLK_SIG   SDN_SIG00
#define SDN_RESETH_SIG SDN_SIG01
#define SDN_RESETS_SIG SDN_SIG02

/* 386 signals */
#define SD_READY_SIG  SD_SIG00
#define SD_RESET_SIG  SD_SIG01
#define SD_HOLD_SIG   SD_SIG02
#define SD_NMI_SIG    SD_SIG03
#define SD_INTR_SIG   SD_SIG04
#define SD_INT0_3_SIG SD_SIG04  /* 386EX naming */
#define SD_A20M_SIG   SD_SIG05
#define SD_INT4_7_SIG SD_SIG05  /* 386EX naming */
#define SD_NA_SIG     SD_SIG06
#define SD_SMI_SIG    SD_SIG07
#define SD_COP_SIG    SD_SIG08
#define SD_HLDA_SIG   SD_SIG09  /* 386EX hlda function */

#define SDN_READY_SIG  SDN_SIG00
#define SDN_RESET_SIG  SDN_SIG01
#define SDN_HOLD_SIG   SDN_SIG02
#define SDN_NMI_SIG    SDN_SIG03
#define SDN_INTR_SIG   SDN_SIG04
#define SDN_INT0_3_SIG SDN_SIG04  /* 386EX naming */
#define SDN_A20M_SIG   SDN_SIG05
#define SDN_INT4_7_SIG SDN_SIG05  /* 386EX naming */
#define SDN_NA_SIG     SDN_SIG06
#define SDN_SMI_SIG    SDN_SIG07
#define SDN_COP_SIG    SDN_SIG08
#define SDN_HLDA_SIG   SDN_SIG09  /* 386EX hlda function */

/* 68040 signals */
#define SD_CDIS_SIG SD_SIG00
#define SD_RSTI_SIG SD_SIG01
#define SD_TEA_SIG SD_SIG02
#define SD_IPL_SIG SD_SIG03
#define SD_MDIS_SIG SD_SIG04

/* 68040 signals */
#define SDN_CDIS_SIG SDN_SIG00
#define SDN_RSTI_SIG SDN_SIG01
#define SDN_TEA_SIG SDN_SIG02
#define SDN_IPL_SIG SDN_SIG03
#define SDN_MDIS_SIG SDN_SIG04

/* Defines for cpu32 and cpu32+ */
#define NUM_REGISTERS 0x17
#define NUM_REGISTERS_INCLUDING_HIDDEN 0x19 /* Does not include SSW */


#ifdef SHARED_DATA_MEMBERS
/*
** Processor-specific shared data member definitions
*/
#define SIZE_FW_INST   3100  /* (sizeof(FW_LINES)*100 */

#define SD_CONFIG_CS_HW_CMD "configcs hardware command"
#define SD_CONFIG_CS_HW_RESULT "configcs hardware result"
#define SD_SIM_ADDRESS "sim register bank address"
#define SD_SIM_VALID "sim valid"
#define SD_FIND_FLUSH_BUFFER  "find flush buffer"
#define SD_FIND_FLUSH_START   "find flush start"
#define SD_FIND_FLUSH_ABORT   "find flush abort"
#define SD_FIND_FLUSH_FOUND   "find flush found"
#define SD_FIND_FLUSH_INSTS   "find flush instructions"
#define SD_FIND_FLUSH_COUNT   "find flush instruction count"
#define SD_FIND_FLUSH_END     "find flush ending frame"
#define SD_DQSYNC_FETCH_FRAME "dqsync fetch frame"
#define SD_DQSYNC_EXEC_FRAME  "dqsync exec frame"
#define SD_BERR_RETRY         "bus error retry"
#define SD_STEP_MASK          "step mask"
#define SD_BDM_SPEED          "bdm speed"
#define SD_PMODE              "pmode"
#define SD_COP_TYPE           "coprocessor type"
#define SD_BTM_ENABLE         "btm cycles enable"
#define SD_RESERVE_DR         "reserve DR"

/*
** Write TRUE to the CMD member to cause firmware to read current contents
** of chip select registers.  This information is immediately used to
** reconfigure map and execution breakpoints, and is loaded into local
** storage and used for subsequent map and execution breakpoints.  Chip
** select information is also used to configure the source of DQ and
** source for A19-A23 for the trace.  The result of the operation is
** written to the result member.
*/
{1, SD_CONFIG_CS_HW_CMD,   SDN_CONFIG_CS_HW_CMD,   SIZE_BOOL,   WR, RD }
{1, SD_CONFIG_CS_HW_RESULT,SDN_CONFIG_CS_HW_RESULT,SIZE_RETCODE,RD, WR }
/*
** SD_SIM_VALID indicates the sim is accessable.  This is extremely
** important for the 330/340/360 processors.
**
** SD_SIM_ADDRESS indicates the starting address of the SIM register
** block.  For the 332, this will be either 0xfffa00 or 0x7ffa00.  This
** information is used by the event and trigger servers.
*/
{1, SD_SIM_VALID,          SDN_SIM_VALID,          SIZE_BOOL,   RD, WR }
{1, SD_SIM_ADDRESS,        SDN_SIM_ADDRESS,        SIZE_LONG,   RD, WR }

/*
** This block is for accelerating the dequeuer.  Write trace buffer
** information (logical frame numbers) to buffer and starting frame.
** Writing start kicks off the firmware.  Found indicates whether
** a flush was found. 
** Flush inst contains an array of FW_LINES of instructions or data
** accesses. Flush count is the number of "dq" lines. And finally
** flush end is the frame number of the last dq'd instruction.
*/
{1, SD_FIND_FLUSH_BUFFER,  SDN_FIND_FLUSH_BUFFER,  SIZE_WORD,   WR, RD }
{1, SD_FIND_FLUSH_START,   SDN_FIND_FLUSH_START,   SIZE_LONG,   WR, RD }
{1, SD_FIND_FLUSH_ABORT,   SDN_FIND_FLUSH_ABORT,   SIZE_BOOL,   WR, RD }
{1, SD_FIND_FLUSH_FOUND,   SDN_FIND_FLUSH_FOUND,   SIZE_BYTE,   RD, WR }
{1, SD_FIND_FLUSH_INSTS,   SDN_FIND_FLUSH_INSTS,   SIZE_FW_INST,RD, WR }
{1, SD_FIND_FLUSH_COUNT,   SDN_FIND_FLUSH_COUNT,   SIZE_WORD,   RW, RW }
{1, SD_FIND_FLUSH_END,     SDN_FIND_FLUSH_END,     SIZE_LONG,   RD, WR }
/*
** Bus error retry member.  When set TRUE, unterminated memory cycles
** are ended by asserting BERR (or READY# in 386).
*/
{1, SD_BERR_RETRY,         SDN_BERR_RETRY,         SIZE_BOOL,   WR, RD }

/*
** Step mask.  When TRUE, single steps are performed by setting the
** interrupt mask to 7, stepping, then restoring the original mask.
** Used for cpu16, cpu32 and cpu32+ only.
*/
{1, SD_STEP_MASK,          SDN_STEP_MASK,          SIZE_BOOL,   WR, RD }

{1, SD_BDM_SPEED,          SDN_BDM_SPEED,          SIZE_ENUM,   WR, RD }

/*
** pmode:  Reports the current processor mode.  386 only.
*/
{1, SD_PMODE,              SDN_PMODE,              SIZE_ENUM,   RD, RW }

/*
** Coptype: reports type of coprocessor present.
*/
{1, SD_COP_TYPE,           SDN_COP_TYPE,           SIZE_ENUM,   RD, RW }
/*
** btm enable: determines if btm cycles are turned on during emulation.
*/
{1, SD_BTM_ENABLE,         SDN_BTM_ENABLE,         SIZE_BOOL,   RW, RD }
/*
** reserve DR: TRUE if debug registers are reserved by emulator (default)
*/
{1, SD_RESERVE_DR,         SDN_RESERVE_DR,         SIZE_BOOL,   RW, RD }

#endif
