/****************************************************************************
**
**  Name: custdlg.cpp
**
**  Description:
**     Contains the LoadFileDlg class which customized Windows Common
**     File dialog boxes to be used for loading code.
**
**  $Log:   S:/tbird/mt2_186/loader/custdlg.cpv  $
** 
**    Rev 1.1   26 Feb 1997 11:49:20   Judy
** 
**    Rev 1.0   14 Jun 1996 17:25:46   Judy
** Initial revision.
** 
**    Rev 1.2   12 Oct 1994 09:19:30   nghia
** Removed processorFamily data member from LoadFileDlg class.
** 
**    Rev 1.1   11 Oct 1994 11:38:12   nghia
** Used the processorFamily to transfer information to the callback.
** 
**    Rev 1.0   14 Jul 1994 10:45:46   nghia
** Initial revision.
**
**  $Header:   S:/tbird/mt2_186/loader/custdlg.cpv   1.1   26 Feb 1997 11:49:20   Judy  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _HLPENTRY_
#include "hlpentry.h"   // Help entry declaration
#endif

#ifndef __CUSTDLG__
#include "custdlg.h"    // LoadFileDlg class declaration
#endif

#ifndef __LDRDLGS__
#include "ldrdlgs.h"    // Hook functions declaration 
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
extern HANDLE hLib;  // defined in LIBMAIN.CPP 

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

//----------------------------------------------------------------------------
//
// Class: LoadFileDlg
//
//----------------------------------------------------------------------------
                         //--------------------------//
                         // CONSTRUCTOR & DESTRUCTOR //
                         //--------------------------//
//-----------------------------------------------------------------------------
// LoadFileDlg - Ctor
//-----------------------------------------------------------------------------
LoadFileDlg::LoadFileDlg(HWND parent, U16 filterId, LPSTR initDir,
                         U32 loadFlags, ADDR_SPACE loadSpace) :
   CommFileDlg(parent, HE_DLGR_LOAD_FILE, filterId, initDir) {
   
   // init self after base is constructed
   loadOptions     = loadFlags;
   loadAddrSpace   = loadSpace;
         
   // set the correct module handle
   ofn.hInstance = hLib;
   
   // replace the COMMDLG dialog box with the customized template
   ofn.Flags |= OFN_ENABLETEMPLATE;
   ofn.lpTemplateName = MAKEINTRESOURCE(LOADFILE_DLG);
   
   // replace the different hook function for <LoadFileDlg> class
   // to handle special processing.
   ofn.lpfnHook  = LdrLoadFileDlgHookProc;
}

                         //--------------------------//
                         //    INITIALIZED METHODS   //
                         //--------------------------//

                         //--------------------------//
                         //    ACCESSING METHODS     //
                         //--------------------------//

                         //--------------------------//
                         //    OPERATOR METHODS      //
                         //--------------------------//

                         //--------------------------//
                         //    OPERATION METHODS     //
                         //--------------------------//

//-----------------------------------------------------------------------------
// SetLoadFileInfo
//-----------------------------------------------------------------------------
VOID LoadFileDlg::SetLoadFileInfo(U32 loadFlags, ADDR_SPACE loadSpace) {
   loadOptions = loadFlags;
   loadAddrSpace = loadSpace;
}

//-----------------------------------------------------------------------------
// GetLoadFileInfo
//-----------------------------------------------------------------------------
RETCODE LoadFileDlg::GetLoadFileInfo(LPSTR lpFileName, U32 *loadFlags,
                                     ADDR_SPACE *loadSpace) {
   RETCODE err;
   // call ancestor to do the work
   if ((err = GetFileName(lpFileName)) != GOOD)
      return err;
   // retrieve the new loadInformation
   *loadFlags = loadOptions;
   *loadSpace = loadAddrSpace;
   return err;
}

                         //--------------------------//
                         //       CLASS METHODS      //
                         //--------------------------//
//-----------------------------------------------------------------------------
// GetObject
//-----------------------------------------------------------------------------
LoadFileDlg* LoadFileDlg::GetObject(HWND hDlg) {
   // call ancestor to do the work
   // cast the base pointer to correct object pointer type
   return (LoadFileDlg*) CommFileDlg::GetObject(hDlg);
}
                         //--------------------------//
                         //       LOCAL METHODS      //
                         //--------------------------//


//// End of LoadFileDlg

/********************************** E O F ***********************************/
