/****************************************************************************
**
**  Name:  iniutil.h
**
**  Description:
**     This module contains utility routines to access and manipulate
**		 the PWRVIEWS.INI
**
**  Status:  PRELIMINARY | CODED | REVIEWED | TESTED
**
**  $Log:   S:/tbird/mt2_186/stkservr/iniutil.h_v  $
** 
**    Rev 1.0   16 Dec 1996 14:44:58   Judy
** Initial revision.
** 
**    Rev 1.0   16 Jul 1993 11:58:36   nghia
** Initial revision.
**
**  $Header:   S:/tbird/mt2_186/stkservr/iniutil.h_v   1.0   16 Dec 1996 14:44:58   Judy  $
**
**  Copyright (C) 1991, 1993 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/


#define MAX_STR_SIZE 255

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/******************************************************************************
**
**  IniGetPwrViewsIniPath
**
**  Description:
**     Locate the PWRVIEWS.INI file directory and store the path for INI
**     access functions.
**
**  Parameters:
**     input:
**        none
**     output:
**        none
**
******************************************************************************/
RETCODE EXPORT IniGetPwrViewsIniPath(VOID);

/******************************************************************************
**
**  IniSetAddress
**
**  Description:
**     Save the specified address descriptor to the PWRVIEWS.INI file.
**     NOTES: This routine will destroy the input AddrDesc
**
**  Parameters:
**     input:
**        sectionName (in) : Name of the section within the PWRVIEWS.INI
**        itemName (in)    : Name of the item to contains the address.
**        addrDesc (in)    : The address to save.
**     output:
**        none.
**
******************************************************************************/
RETCODE EXPORT IniSetAddress(LPSTR sectionName, LPSTR itemName,
   DESCRIPTOR addrDesc);

/******************************************************************************
**
**  IniGetAddress
**
**  Description:
**     Restore the address value of the sepcified item from
**     the PWRVIEWS.INI file.
**     NOTES: This routine will create the AddrDesc, caller destroy.  If
**     error return, no descriptor create.
**
**  Parameters:
**     input:
**        sectionName (in) : Name of the section within the PWRVIEWS.INI
**        itemName (in)    : Name of the item to get the address value.
**     output:
**        addrDesc (out)   : Address descriptor contain the restore address.
**
******************************************************************************/
RETCODE EXPORT IniGetAddress(LPSTR sectionName, LPSTR itemName,
   DESCRIPTOR *addrDesc);

/******************************************************************************
**
**  IniSetNum
**
**  Description:
**     Save the specified numerical value to the PWRVIEWS.INI file.
**
**  Parameters:
**     input:
**        sectionName (in) : Name of the section within the PWRVIEWS.INI
**        itemName (in)    : Name of the item contains the value.
**        inNum (in)       : The numeric value to save.
**     output:
**        none.
**
******************************************************************************/
RETCODE EXPORT IniSetNum(LPSTR sectionName, LPSTR itemName, U32 inNum);

/******************************************************************************
**
**  IniGetNum
**
**  Description:
**     Restore a numeric value of the specified item from the PWRVIEWS.INI file.
**
**  Parameters:
**     input:
**        sectionName (in) : Name of the section within the PWRVIEWS.INI
**        itemName (in)    : Name of the item that holds the value.
**     output:
**        outNum (out)     : The return numeric value.
**
******************************************************************************/
RETCODE EXPORT IniGetNum(LPSTR sectionName, LPSTR itemName, U32 *outNum);

/******************************************************************************
**
**  IniSetString
**
**  Description:
**     Save the input string to the specified item in the PWRVIEWS.INI file.
**     NOTES: Caller are responsible to allocate and destroy the inStr.
**            The inStr should be a string of MAX_STR_SIZE.
**
**  Parameters:
**     input:
**        sectionName (in) : Name of the section within the PWRVIEWS.INI
**        itemName (in)    : Name of the item contains the value.
**        inStr (in)       : The string to save.
**     output:
**        none.
**
******************************************************************************/
RETCODE EXPORT IniSetString(LPSTR sectionName, LPSTR itemName, LPSTR inStr);

/******************************************************************************
**
**  IniGetString
**
**  Description:
**     Restore a string from the specified item in the PWRVIEWS.INI file.
**     NOTES: Caller are responsible to allocate and destroy the outStr.
**            The outStr should be a string of MAX_STR_SIZE.
**
**  Parameters:
**     input:
**        sectionName (in) : Name of the section within the PWRVIEWS.INI
**        itemName (in)    : Name of the item that holds the string.
**     output:
**        outStr (out)     : The return string.
**
******************************************************************************/
RETCODE EXPORT IniGetString(LPSTR sectionName, LPSTR itemName, LPSTR outStr);

/******************************** E O F ***********************************/