/* class comment */!!

inherit(Window, #EventPresenter, nil, 2, nil)!!

now(class(EventPresenter))!!

/* 8/13/1996 8:39 
  Open a new Event Presenter. 
  Example: open(EventPresenter);
*/
Def open(self)
{
   /* the Event presenter in order to comply with Actor limitations
      must fake a windows object in Actor.  This object would be used to
      open, close, show a window.  The new(EventPresenter) call actually
      causes a CreateWindow call.  I do not want this window but I do 
      need this object to launch a peripheral window of my own.  Therefore,
      I destroy the created window using the handle myself and take over
      the object by brute force using a new WindowObject method SetHWnd().
      Not very nice but I have ulterior motives.
    */
   if not(exists(self))
      if not(TheEventPresenter:=new(EventPresenter,nil,nil,
            "Event",nil)) then
         ^nil;
      endif;
      Call DestroyWindow(handle(TheEventPresenter));
      setHWnd(TheEventPresenter,openEventWindow(EventLibClass$Inst,
            nil, nil));
      show(TheEventPresenter,SW_SHOW);
   endif;
   ^TheEventPresenter;

} !!

/* 8/13/1996 8:38 */

Def exists(self | handle)
{
   if TheEventPresenter
      handle := existsEventWindow(EventLibClass$Inst);
      if handle 
         setHWnd(TheEventPresenter,handle)
      else
         TheEventPresenter := nil;
      endif;
   endif;
   ^TheEventPresenter;
}!!

/* 8/13/1996 8:37 */

Def openWithPosAndState(self, sizeRect, showVal | newHWnd )
{ 
   /* the Event presenter in order to comply with Actor limitations
      must fake a windows object in Actor.  This object would be used to
      open, close, show a window.  The new(EventPresenter) call actually
      causes a CreateWindow call.  I do not want this window but I do 
      need this object to launch a peripheral window of my own.  Therefore,
      I destroy the created window using the handle myself and take over
      the object by brute force using a new WindowObject method SetHWnd().
      Not very nice but I have ulterior motives.
    */
  if not(exists(self))
      if not(TheEventPresenter := new(EventPresenter, nil, nil,
            "Event",nil)) then
         ^nil;
      endif;
      Call DestroyWindow(handle(TheEventPresenter));
      if ((newHWnd := openEventWindow(EventLibClass$Inst,
            sizeRect, WS_OVERLAPPEDWINDOW)) <> nil) then
         setHWnd(TheEventPresenter,newHWnd);
         show(TheEventPresenter,showVal);
      else
         ^nil;
      endif;
   endif;
   ^TheEventPresenter; 
   
}!!

now(EventPresenter)!!

/* 8/13/1996 8:36 */

Def close(self)
{ 
   if (exists(class(self)))
      closeEventWindow(EventLibClass$Inst);
      TheEventPresenter := nil;
   endif;
   ^GOOD;
}!!

/* 8/13/1996 8:34 
 get the location rect of the window and save it to the ini file 
*/
Def saveWindowPos(self keyName| isIconic layout windRect)
{
  if (hWnd = 0)
    ^clearLayoutEntry(Window, asString(keyName));
  endif;    
  /* Save Layout for Event window:
  ** if the window is an icon - use the previous saved layout
  **    if there is no previous saved lay out set to 0 for default size
  ** else
  **    Get the current window  position to save.
  */

  /* IsIconic returns nonzero if self is minimized */
  if (Call IsIconic(hWnd) = 0) then
    isIconic := 0;
    /* get the location of the current window position */
    Call GetWindowRect(hWnd, windRect := new(Rect));
    if (width(windRect)=0 cand height(windRect)=0)
       isIconic := 2;
    endif;
  else
    /* force the nonzero return to be 1 */
    isIconic := 1;
    if not(windRect := getPos(PreLauncher, asString(keyName))) then
      windRect := init(new(Rect),0,0,0,0);
    endif;      
  endif;

  if (windRect) then   
    layout := new(String, 18);
    if (isIconic = 2)
       layout := " ";
    else
       layout := asString(left(windRect)) + "," + asString(top(windRect)) +
            "," + asString(right(windRect)) + "," +
            asString(bottom(windRect)) + "," + asString(isIconic);
    endif;        
    saveProfileEntry(TheProfileInfoObj, "DefaultLayout", keyName, layout);
  endif;  
  ^GOOD; 
}!!