/* dump information about a fatal Actor error condition */!!

inherit(Object, #ErrorDump, nil, 2, nil)!!

now(class(ErrorDump))!!

/* Format error message text, pass along to errorDumpWindow. */
Def errorDumpPrimError(self, bp, errorNum | str, strm, index)
{
  index := subType(ErrorHandler);
  if size(str := loadString(index)) == 0
    str := "Primitive error #" + asStringRadix(index, 10);
  endif;
  if index == 10
    str := print("*** Out of static memory ***");
  endif;
  if index == 21
    strm := streamOver("");
    nextPutAll(strm, funcName(self, bpFunc(bp)));
    nextPutAll(strm, " takes ");
    printOn(args(bpFunc(bp)), strm);
    printOn(" argument(s).", strm);
    str := collection(strm);
  endif;
  ^errorDumpWindow(self, str);
}!!

/* Format error message text, pass along to errorDumpWindow. */
Def errorDumpFail(self, stackTop, selector | strm)
{
  printSmall();
  strm := streamOver("");
  sysPrintOn(receiver(ErrorHandler), strm);
  printNormal();
  printOn(loadString(346), strm);
  sysPrintOn(subType(ErrorHandler), strm);
  ^errorDumpWindow(self, collection(strm));
}!!

/* Format error message text, pass along to errorDumpWindow. */
Def errorDumpError(self, stackTop, sym | str id)
{
  if Constants cand (id := Constants[subType(ErrorHandler)])
    str := loadString(id);
  else
    str := loadString(343) + sym;
  endif;
  ^errorDumpWindow(self, str);
}!!

/* Display the error information. */
Def errorDumpWindow(self, msg | fileName dumpFile)
{
  /* create error message unless one has been passed in */
  if not(msg)
    msg := loadString(exceptionSelector(ErrorHandler));
  endif;
  
  dumpFile := new(TextFile);
  fileName := "pv.dmp";
  setName(dumpFile, fileName);
  create(dumpFile);
  writeLine(dumpFile, "A fatal error has occurred in MP/SLD: " + msg + ".");
  writeLine(dumpFile, "Please supply this information to Microtek Technical Support");
  writeLine(dumpFile, "so that this problem can be diagnosed and fixed.");
  writeLine(dumpFile, "----------------------------------------------------------");
  writeLine(dumpFile, "Note:  MP/SLD is now unstable, and should be restarted");
  writeLine(dumpFile, "==========================================================");
  writeLine(dumpFile, "MP/SLD Fatal Error: " + msg);
  writeLine(dumpFile, dateStr() + " " + timeStr());
  writeLine(dumpFile, "MP/SLD version: " +
    getPVVersionString(CLIULibraryClass$Inst));
  writeLine(dumpFile, "stack traceback:");
  do(frames(fill(Bug, stackTop())),
    {using(str)
       writeLine(dumpFile, str);
    });
  close(dumpFile);
  errorBox("MP/SLD Fatal Error",
    "A fatal error has occurred in MP/SLD.  Error information has " +
    "been written to file '" +
    fileName +
    "'.  Please forward this " +
    "information to Microtek Technical Support.  Note that " +
    "after this dialog is closed, MP/SLD will terminate.");

  0;
 }
!!

now(ErrorDump)!!