/* maintain the interface to the PVTASK DLL  */!!

inherit(Library, #TaskLib, #(lastError  /* holds last RETCODE */
taskLoaded  /* set by loadLibrary */), 2, nil)!!

now(class(TaskLib))!!

now(TaskLib)!!

/* 6/28/1993 10:59 */
Def taskExecute(self | rc )
{
   if taskLoaded then
     rc := pcall(procs[#TASKEXECUTE]);
     ^rc;
   endif;
}
!!

/* 6/28/1993 9:53 */
Def lastError(self)
{
  ^lastError;
}
!!

/* 6/17/1993 9:28
   Call Windows API FreeLibrary() on desktop library
*/
Def freeLibrary(self)
{
   free(self);
   hLib := nil;
   if TaskLibClass$Inst then
     TaskLibClass$Inst := nil;
   endif;
}!!

/* 6/17/1993 9:28
   Define all entry points for library as prototypes.
   Open and initialize task library
*/
Def loadLibrary(self, path | libSymbol)
{
   setName( self, path ) ;
   add( self , #TSKSETACTIVEAPPSTATE,   1, #(0) ) ;
   add( self , #TSKCHECKABORT,          0, #(1) ) ;
   add( self , #TASKEXECUTE,            0,  nil ) ;
   if not(load(self)) then
      /* raises alert if fails: alert(System, self, #libLoad) */
     ^nil;
   endif;

   taskLoaded := 1;
   /* make up the global name of the library start with child's class name */
   libSymbol := asSymbol(name(class(self)) + "$Inst" ) ;
   add(Actor, libSymbol, self);       /* and make it global */
}!!

/* 6/15/1993 13:31 */
/* PUBLIC   used to pass WM_ACTIVATEAPP message data to the DLL
 *   note: protected by taskLoaded flag
 */
Def setActiveAppState(self, wParam | rc)
{
  if taskLoaded
    rc := pcall( procs[#TSKSETACTIVEAPPSTATE], wParam );
    ^rc;
  endif;
  ^nil
}
!!

/*  protected by taskLoaded flag */
Def checkAbort(self | lastErr rc wordRef )
{
   wordRef := new(Struct, 2);
   if taskLoaded
     break("checkAbort in");
     lastError := pcall(procs[#TSKCHECKABORT], wordRef);
     break("checkAbort out");
   else
     ^0;    /* lib not installed.  return "no esc pressed" */
   endif;

    ^byteAt(wordRef, 0);

}
!!

/* return nil if abort key not struck.
   return 0 if abort key struck.
   ignore errors (old version returned esc struck..0)
  */
Def queryAbort(self | keyHit)
{

  keyHit := checkAbort(self);

  if (keyHit)
     if (keyHit = 1)   /* pressed */
       ^0;
     else              /* not pressed */
       ^nil;
     endif;
  endif;

  ^nil;

}
!!


