/* A Bit-Encoded Register (E.g. a Status register) */!!

inherit(Object, #BitRegister, #(currVal
prevVal
name
location  /* value location: pixel-based point */
labelLoc  /* pixel point for label */
bitsDict /* sorted dictionary of RegBit's */
sortIndex
regID), 2, nil)!!

now(class(BitRegister))!!

/* PUBLIC */
Def new(self, name, valuePt, labelPt, bitsDict, sortIndex | instance)
{
   instance := new( self:ancestor ) ;

   ^initialize( instance, name, valuePt, labelPt, bitsDict, sortIndex )
}!!

now(BitRegister)!!

/* PRIVATE */
Def bitsDict(self)
{ ^bitsDict }
!!

/* PUBLIC */
Def currVal(self)
{ ^currVal }
!!
/* PUBLIC */
Def display(self, hDC)
{
  if bitsDict
  then
    do(bitsDict,
    {using(regBit)
      display( regBit, hDC ) ;
    });
  endif ;
}
!!

/* PUBLIC */
Def displayLabel(self, hDC | label)
{
  if labelLoc
  then
    label := name( self ) ;
    if (size(label) < 3)
    then
      label := right( label, 3, " " ) ;
    endif ;

    Call TextOut( hDC, 
                  x(labelLoc), 
                  y(labelLoc), 
                  label, 
                  size(label)
                 ) ;
  endif ;
}
!!

/* PUBLIC */
Def drawLabel(self, hDC, x, y | label) /* x,y in pixels */
{
  label := name( self ) ;
  if label
  then
    Call TextOut( hDC, 
                  x, 
                  y, 
                  label, 
                  size(label)
                 ) ;
  endif ;
}
!!

/* PUBLIC */
Def id(self)
{ ^regID }
!!

/* PRIVATE */
Def initialize(self, aName, valuePt, labelPt, bitsDictionary, anIndex)
{
  name := aName ;
  location := valuePt ;
  labelLoc := labelPt ;
  bitsDict := bitsDictionary ; /* N.B.: may be nil */
  sortIndex := anIndex ;
  regID     := findRegisterID( CpuLibClass$Inst, aName ) ;
}
!!

/* PUBLIC */
Def labelLoc(self)
{ ^labelLoc }
!!

/* PUBLIC */
Def name(self)
{ ^name }
!!

/* PUBLIC */
Def prevVal(self)
{ ^prevVal }
!!

/* PUBLIC */
Def setBitsDict(self, bits)
{
  ^bitsDict := bits ;
}
!!

/* PUBLIC */
Def setLabelLoc(self, newLocationPt)
{ ^(labelLoc := newLocationPt) }
!!

/* PUBLIC */
Def setValue(self, newValue)
{
  prevVal := currVal ;
  currVal := newValue ;
  /* set the bits */
  if bitsDict
  then
    do(bitsDict,
    {using(regBit)
      setValue( regBit, newValue ) ;
    });
  endif ;
}
!!

/* PUBLIC */
Def setValueLoc(self, aPoint)
{
  ^location := aPoint ; /* point in pixel coordinates */
}
!!

/* PUBLIC */
Def sortIndex(self)
{ ^sortIndex }
!!

/* PUBLIC -- go to server & setValue(self,newVal) */
Def updateValue(self)
{
  setValue( self, getRegValue(CpuLibClass$Inst, regID) ) ;
}
!!

/* PUBLIC */
Def valueLoc(self)
{ ^location }
!!
