/* CLASS: BKPTINFO.CLS 
   Provide container to hold breakpoint information. See BkptPresenter for
   detailed usage.

   REQUIRE: BKPTPRES.CLS BKPTLIST.CLS BKPTDIAL.CLS
*/!!

inherit(Object, #BkptInfo, #(bkptID /* breakpoint ID */
bkptState /* breakpoint Enable/Disable */
bkptLife /* breakpoint Perm/Temp */
module /* module Descriptor  - nil */
lineNum /* line number -  nil */
colStart /* column start */
colEnd /* column end */
bkptAddr /* address descriptor */), 2, nil)!!

now(class(BkptInfo))!!

/* 6/15/1992 9:12 - PUBLIC 
  Create a new BkptInfo object and initialize it.
*/
Def new(self, bkptDesc | newInstance)
{
  newInstance := new(self:ancestor);
  ^initFromDescriptor(newInstance, bkptDesc);
}
!!

now(BkptInfo)!!

/* 6/15/1992 9:37 - PUBLIC
  Combine all breakpoint information as a LBString.
*/
Def asLBString(self)
{ 
   /* #module#Func#line#col Start-End */
  ^bkptStateText(self) + asString(Tab) +
   bkptLifeText(self) + asString(Tab) +
   bkptText(self) +
   asString(Tab) + asString(Tab) + asString(Tab) + 
   asString(Tab) + asString(Tab) + asString(Tab) +
   asString(Tab) + asString(Tab) + asString(Tab) +
   asString(Tab) + asString(Tab) + asString(Tab) +
   "@"+asString(bkptID);
}
!!

/* 6/15/1992 9:36 - PUBLIC
  Return breakpoint Address. Caller need to destroy addrDesc when done.
*/
Def bkptAddress(self)
{ 
  ^duplicateAddress(AddressLibClass$Inst, bkptAddr);
}
!!

/* 6/15/1992 9:35 - PUBLIC
  Return breakpoint ID
*/
Def bkptID(self)
{ ^bkptID; }
!!

/* 6/15/1992 9:49 - PRIVATE
  Return the Life info of self in text format. (0 = permanent, 1 = temporary)
*/
Def bkptLifeText(self)
{
  if bkptLife = 0 then
    ^"Perm.";
  endif;
  ^"Temp."; 
}
!!

/* 6/15/1992 9:47 - PRIVATE
  Return the state info of self in text format.
*/
Def bkptStateText(self)
{ 
  if bkptState = 0 /* ENABLE */then
    ^"Enable ";
  endif;
    ^"Disable";
}
!!

/* 6/15/1992 9:58 - PRIVATE
  return breakpoint info as text. #module#func#line | addr.
*/
Def bkptText(self | bkptText, bkptNameInfo, withZeroX)
{ 
  withZeroX := 0;
  /* Do not put 0x for Intel format */
  if (TheProcFamily <> PROC_FAMILY_X86) then
    withZeroX := 1;  
  endif;  
  
  bkptText := getAddressTextParam(AddressLibClass$Inst, bkptAddr, withZeroX, 1);
  if not(bkptNameInfo := getBkptNames(HLBreakLibClass$Inst, bkptID)) cor 
    (size(bkptNameInfo[0]) = 0) then
    /* Return the address text, if there is no module name */
    ^bkptText;
  endif;
  /* WHERE: bkptNameInfo = #(moduleNameStr, funcNameStr) */
  if bkptNameInfo[0] then bkptText := bkptText+" "+bkptNameInfo[0]; endif;
  if bkptNameInfo[1] then bkptText := bkptText + "," + bkptNameInfo[1]; endif;
  if lineNum then bkptText := bkptText + ",line"+asString(lineNum); endif;

  if colStart cand colEnd then 
    bkptText := bkptText+",col"+asString(colStart)+"-"+asString(colEnd);
  endif;  
  ^bkptText;    
}
!!

/* 6/26/1992 13:24 - PUBLIC
  Return tuple: #(colStart, colEnd)
*/
Def columns(self)
{ 
  ^tuple(colStart, colEnd);
}
!!

/* 6/15/1992 13:51 - PUBLIC
  Destroy breakpoint Info, but not from the Server.
*/
Def deleteBkptInfo(self)
{ 
  bkptID := nil;
  bkptState := nil;
  bkptLife := nil;
  module := nil;
  if bkptAddr then 
    destroyAddress(AddressLibClass$Inst, bkptAddr) 
  endif;
}
!!

/* 6/14/1992 20:30 - PRIVATE 
  Init a bkpt descriptor with its information. and return self.
*/
Def initFromDescriptor(self, bkptDesc | bkptInfo)
{ 
  bkptID := bkptDesc;
  if not(bkptInfo := getBkpt(HLBreakLibClass$Inst, bkptDesc)) then
    ^nil;
  endif;
  /* WHERE: bkptInfo = #(state, life, addrDesc) */
  bkptAddr := bkptInfo[2];
  if not(bkptInfo := getSourceBkpt(HLBreakLibClass$Inst, bkptDesc)) then
    ^nil;
  endif;
  /* WHERE: bkptInfo = #(state, life, module, linenum, colStart, colEnd) */
  bkptState := bkptInfo[0]; 
  bkptLife  := bkptInfo[1];
  module    := bkptInfo[2];
  lineNum   := bkptInfo[3];
  colStart  := bkptInfo[4];
  colEnd    := bkptInfo[5];
}
!!

/* 6/26/1992 13:23 - PUBLIC 
  Return the LineNumber of breakoint.
*/
Def lineNum(self)
{ 
  ^lineNum; 
}
!!

/* 6/15/1992 9:36 - PUBLIC
  Return breakpoint module descriptor.
*/
Def moduleDesc(self)
{ ^module; }
!!

/* EOF */
!!