/* Register Value (32 bits) */!!

inherit(Object, #Register, #(name
regID
location   /* pixel pt for value display) */
labelLoc  /* pixel point for label */
prevVal
currVal
hilighted?
sortIndex /* for ordered dictionary */
displayType  /* Display as flags or numeric */
digits
selected?
), 2, nil)!!

now(class(Register))!!

/* PUBLIC */
Def new(self, name, regID, sortIndex, type, aDigits | instance)
{
   instance := new( self:ancestor ) ;

   ^initialize( instance, name, regID, sortIndex, type, aDigits )
}
!!

/* PUBLIC */
Def newWithLocation(self, name, regID, sortIndex, type, aDigits, labelLocPt, valueLocPt 
                   | instance)
{
 instance := new( self:ancestor ) ;

 ^initWithLocation(instance, name, regID, sortIndex, type, aDigits, labelLocPt, valueLocPt)
}
!!

now(Register)!!

/* 7/22/1994 9:06 */
Def setRegSelected(self, selected)
{selected? := (selected = 1); }
!!

/* 7/22/1994 9:06 */
Def setSelected(self, selected)
{selected? := selected; }
!!

/* 7/21/1994 17:23 */
Def selected?(self)
{
^selected?
 }
!!

/* PUBLIC */
Def digits(self)
{ ^digits }
!!

/* PUBLIC */
Def currVal(self)
{ ^currVal }
!!

/* PUBLIC 
   Print text on window, given drawing context.
   Nota Bene: point xPos & yPos in pixels.
*/
Def display(self, hDC, yPos, tmHeight, tmWidth
    | origTextColor, origBkColor, txt, width)
{
  txt := textValue(self);
  if hilighted?
    origBkColor :=
      Call SetBkColor(hDC, Call GetSysColor(COLOR_HIGHLIGHT));
    origTextColor :=
      Call SetTextColor(hDC, Call GetSysColor(COLOR_HIGHLIGHTTEXT));
    Call TextOut(hDC, 
                 x(location), 
                 yPos, 
                 txt, 
                 size(txt) );
    Call SetBkColor(hDC, origBkColor);
    Call SetTextColor(hDC, origTextColor);
  else /* not hilighted */
    Call SetBkColor(hDC, Call GetSysColor(COLOR_WINDOW));
    Call SetTextColor(hDC, Call GetSysColor(COLOR_WINDOWTEXT));
    Call TextOut(hDC, 
                 x(location), 
                 yPos, 
                 txt, 
                 size(txt) );
  endif;
  
  if selected?
    width := digits(self) * tmWidth;
    Call PatBlt(hDC, 
          x(location), 
          yPos,
          width,       /* width */
          tmHeight,    /* height */
          DSTINVERT);
  endif;
}
!!

/* PUBLIC */
Def displayLabel(self, hDC, yPos | label)
{
  if (labelLoc cand (displayType = 0))
  then
    label := name( self ) ;
    Call TextOut( hDC, 
                  x(labelLoc), 
                  yPos, 
                  label, 
                  size(label)
                 ) ;
  endif ;
}
!!

/* PUBLIC */
Def drawLabel(self, hDC, x, y | label) /* x,y in pixels */
{
  label := name( self ) ;
  if label
  then
    Call TextOut( hDC, 
                  x, 
                  y, 
                  label, 
                  size(label)
                 ) ;
  endif ;
}

!!

/* PUBLIC */
Def hilighted?(self)
{ ^hilighted? }
!!

/* PUBLIC */
Def id(self)
{ ^regID }
!!

/* PRIVATE */
Def initialize(self, aName, aRegID, index, type, aDigits)
{
  name      := aName ;
  regID     := aRegID ;
  sortIndex := index ;
  displayType := type ;
  digits    := aDigits ;
  prevVal   := currVal  := 0L ;
  regID     := findRegisterID( CpuLibClass$Inst, aName ) ;
  selected? := nil;
/* hilighted? := nil ; */
}
!!

/* PRIVATE */
Def initWithLocation(self, aName, aRegID, index, type, aDigits, labelPt, valuePt)
{
  initialize( self, aName, aRegID, index, type, aDigits ) ;
  location := valuePt ;
  labelLoc := labelPt ;
}
!!

/* PUBLIC */
Def labelLoc(self)
{ ^labelLoc }
!!

/* PUBLIC */
Def name(self)
{ ^name }
!!
/* PUBLIC */
Def prevVal(self)
{ ^prevVal }
!!

/* PUBLIC */
Def reg2line(self)
{ ^sortIndex }
!!

/* PUBLIC */
Def setLabelLoc(self, newLocationPt)
{ ^(labelLoc := newLocationPt) }
!!

/* PUBLIC */
Def setValue(self, newValue)
{
  prevVal := currVal ;
  currVal := newValue ; 
  hilighted? := not( prevVal = currVal ) ;
}
!!

/* PUBLIC */
Def setValueLoc(self, aPoint)
{
  ^location := aPoint ; /* point in pixel coordinates */
}
!!

/* PUBLIC */
Def sortIndex(self)
{ ^sortIndex }
!!

/* PUBLIC */
Def textValue(self)
{
  if currVal
  then
    ^getRegisterValueText(CpuLibClass$Inst, regID, displayType);
  else
    ^"????????"
  endif;
}
!!

/* PUBLIC -- go to server & setValue(self,newVal) */
Def updateValue(self)
{
  setValue( self, getRegValue(CpuLibClass$Inst, regID) ) ;
}
!!

/* PUBLIC */
Def valueLoc(self)
{ ^location }
!!
