
Def printTraceBuffer(self,trace,buffer,frames,file
               | textLenRef retHandleRef curFrame title startRef endRef
                 retCode numFrames)
{ 
  if( (retCode:=prim_trcReadFrameSet(trace, frames[0])) <> 0 )
    ^retCode;
  endif;
  write(file,"Trace Buffer:  "+asString(buffer)+CR_LF);
  write(file,"Frames: "+asString(frames[0])+" to "+asString(frames[1])+CR_LF);
  write(file,CR_LF);
  add(title := new(TextCollection, 3), "");
  insertText(title,removeNulls(physicalString(trcGetHeader(trace))),0,0);
  do(size(title),
  {using(line) 
    write(file, fill(new(String, hscrollIndex),' '));
    write(file, copyFrom( title[line], 0, size(title[line])));
    write(file,CR_LF); 
  });
  
  curFrame := frames[0];
  startRef  := new( Struct, 4 ) ;
  endRef    := new( Struct, 4 ) ;
  retHandleRef := new( Struct, 4 ) ; /* alias for textAddrRef */
  textLenRef := new( Struct, 2 ) ; 
  loop
  while curFrame < frames[1]
  begin 
    numFrames := frames[1] - curFrame;
    if( numFrames > 100 ) numFrames := 100; endif;
    retCode := forwardRead(trace,numFrames,startRef,endRef,retHandleRef,
                           textLenRef);
    if( (retCode <> 0) cor 
         (TaskLibClass$Inst cand queryAbort(TaskLibClass$Inst)) 
         cor (wordAt(textLenRef,0) == 0) ) 
      curFrame := frames[1];   /* just leave with what we have */
      if(TaskLibClass$Inst cand queryAbort(TaskLibClass$Inst))
        retCode := 1; /* want calling routine to abort too */
      endif;
    else
      curFrame := longAt(endRef,0);
    endif;
    write(file, 
          physicalString(
                 copyFromLong( new(Struct, wordAt(textLenRef,0)), /* textLen */
                               longAt(retHandleRef, 0) ) )    /* textAddr */
         ) ;
    write(file,physicalString("**************************************"+CR_LF));
    cFree( MallocLibClass$Inst, longAt(retHandleRef, 0) ) ;
  endLoop;
  ^retCode;
}
!!
