/* CLASS: BKPTREGION
    Provides the visual effect of setting and clearing breakpoints for the Source
    Browser.
    REQUIRE: SOURCECB.CLS
*/!!

inherit(Window, #BkptRegion, #(pcLineNum /* current PC line Number */), 2, nil)!!

now(class(BkptRegion))!!

/* 6/24/1992 12:17 - Actor
  Return the static string for this window class name.
*/
Def wndClass(self)
{ 
  ^"BkptRegion";
}
!!

/* 6/24/1992 12:14 - Actor
  Return the style of this class.
*/
Def style(self)
{ 
  ^WS_CHILD;  /* used WS_POPUP bitOr WS_BORDER for testing */
}
!!

/* 6/24/1992 12:13 - Actor
 Create a new window class Struct. Assigns the 
 BKPT cursor style to windows of this class
 and descendants. 
*/
Def newWClass(self, className, iconName | wc)
{ wc := newWClass(self:ancestor, className, iconName);
  putWord(wc, Call LoadCursor(HInstance, asciiz("TARGET") ), 14);
  ^wc;
}
!!

now(BkptRegion)!!

/* WINDOWS (PUBLIC)
   User Click on the breakpoint region, notify sourceCB to set/clear Temporary breakpoint.
*/
Def WM_RBUTTONDOWN(self, wp, lp)
{
  clickOnBkptRegion(parent, y(asPoint(lp)), HLB_BKPT_LIFE_TEMPORARY); 
  ^0;
}!!

/* 8/21/1992 10:12 - PUBLIC (to its parent) 
  Set and draw the current PC line of the browser.
*/
Def setPCLine(self, newPCLine | hDC)
{ 
  if (pcLineNum := newPCLine) then
    /* Have to obtain the hDC before draw it */
    hDC := Call BeginPaint(getHWnd(self), paintStruct);
    drawPC(self, pcLineNum, AT_PC_HERE_FIELD, hDC);
    Call EndPaint(getHWnd(self), paintStruct);
  endif;  
}
!!

/* 8/21/1992 10:03 - Actor
  Repaint the region.  If there is a PC value then paint it.  
*/
Def paint(self, hDC)
{ 
  if pcLineNum then
    drawPC(self, pcLineNum, AT_PC_HERE_FIELD, hDC);
  endif;    
}
!!

/* 8/20/1992 12:54 */
Def drawPC(self, lineNum, pcColorTag, hDC | origBkMode, origBkColor)
{ 
  /* Draw highlight as colored background with text over */
  origBkMode  := Call SetBkMode(hDC, OPAQUE);
  origBkColor := Call GetBkColor(hDC);

  Call SetBkColor(hDC, $fieldColorDict(ATParser)[pcColorTag]);
  /* Draw the background color */
  Call TextOut(hDC, 
               1,        /* xPos */
               lineNum,  /* yPos */ 
               "    ", 
               4);

  /* Draw the PC mark */
  Call SetBkMode( hDC, TRANSPARENT ) ; /* keep colored background */
  Call TextOut( hDC, 
                0,        /* xPos */
                lineNum,  /* yPos */ 
                ">>",     /* text */
                2);
  Call SetBkColor(hDC, origBkColor);
  Call SetBkMode(hDC, origBkMode);
}
!!

/* WINDOWS (PUBLIC)
   User Click on the breakpoint region, notify sourceCB to set/clear Perm breakpoint.
*/
Def WM_LBUTTONDOWN(self, wp, lp)
{
  clickOnBkptRegion(parent, y(asPoint(lp)), HLB_BKPT_LIFE_PERMANENT); 
  ^0;
}!!

/* 6/24/1992 12:20 - Actor
  initialize self.
*/
Def init(self)
{ 
  init(self:ancestor);
  pcLineNum := nil;
}
!!