/* A list box in its own window.  Useful for select lists which stay around. */!!

inherit(Window, #ListBoxWindow, #(listBox        /* a ListBox */
oldSize       /* a Point */), 2, nil)!!

now(class(ListBoxWindow))!!

now(ListBoxWindow)!!

/* return local ListBox */
Def listBox(self)
{ ^listBox
}
!!

/* Handle resizing--set the rectangle for the list box if window
  has actually changed size. */
Def reSize(self, wP, lP | newSz delta cr)
{ if (lP <> 0L) cand (wP == SIZENORMAL cor wP == SIZEFULLSCREEN)
  then newSz := asPoint(asLong(lP));
    if not(oldSize)
    then oldSize := 0@0;
    endif;
    if x(newSz) <> x(oldSize) cor y(newSz) <> y(oldSize)
    then oldSize := newSz;
      validate( self ) ;
      delta := sizeKids( self ) ;
      if (delta <> 0)
      then
        cr := windowRect( self ) ;
        setBottom( cr, bottom(cr) - delta ) ;
        setCRect( self, cr ) ;
        moveWindow( self ) ;
      endif ;
      invalidate( self ) ;
      setFocus( self ) ;
    endif;
  endif;
  ^1
}!!

/* Set oldSize when displaying window. */
Def show(self, val)
{ oldSize := asPoint(longAt(clientRect(self), 4));
  show(self:ancestor, val);
  show(listBox, val);
}!!

/* Set the control rectangles for the child window. */
Def sizeKids(self | parentCR childCR delta)
{ if not(listBox)
  then listBox := new(ListBox, 1, self);
  endif;
  parentCR := clientRect( self ) ;
  setCRect(listBox, parentCR);
  moveWindow(listBox);
  childCR  := clientRect( listBox );
  delta := height( parentCR ) - height( childCR ) ;
  setLastSel(listBox);
  ^delta
}!!
