/* one-line text window, used as titles of child windows. */!!

inherit(TextWindow, #TitleWindow, nil, 2, nil)!!

now(class(TitleWindow))!!

now(TitleWindow)!!

/* 10/7/1994 15:24 */
/* clear the workText. */
Def clearText(self)
{
  if not(workText)
    initWorkText(self);
  endif;
  workText[0] := "";
  invalidate(self);
}!!

/* 6/2/1994 16:25 */
/* Put centered title into workText. */
Def drawTitleCenter(self, title)
{
  if not(workText)
    initWorkText(self);
  endif;
  workText[0] := center(title, xMax, " ");
  invalidate(self);
}
!!

/* 6/2/1994 16:25 */
/* Put right justified title into workText. */
Def drawTitleRight(self, title)
{
  if not(workText)
    initWorkText(self);
  endif;
  workText[0] := right(title, xMax, " ");
  invalidate(self);
}
!!

/* Put title into workText. */
Def drawTitle(self, title)
{
  if not(workText)
    initWorkText(self);
  endif;
  workText[0] := title;
  invalidate(self);
}!!

/* Initialize the workText. */
Def initWorkText(self)
{ add(workText := new(TextCollection, 1), "");
}!!