/****************************************************************************
**
**  Name:  libmain.c
**
**  Description:
**     Contains the main entry/exit point of the ADDR.DLL
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_186/addr/libmain.c_v  $
** 
**    Rev 1.0   16 Dec 1996 16:15:52   Judy
** Initial revision.
** 
**    Rev 1.8   22 Mar 1994 10:29:40   marilyn
** Update with x86 addressing support
** 
**    Rev 1.7   23 Jul 1992 09:28:06   brucea
** Removed: hLib; no longer used
** 
**    Rev 1.6   21 Jul 1992 14:30:06   brucea
** Removed: WEP
** Modified: LibMain to report error if AdrInitAddressServer returns an error
** 
**    Rev 1.5   09 Jun 1992 09:28:36   brucea
** Added: UnlockData(0) if cbHeapSize != 0 in LibMain
** 
**    Rev 1.4   15 May 1992 15:51:10   brucea
** Added: ErrInitDLL initialize error handler
** 
**    Rev 1.3   11 May 1992 11:28:46   brucea
** Removed from LibMain: call to UnlockData
** 
**    Rev 1.2   27 Feb 1992 22:18:16   brucea
** Added: AdrInitAddressServer() in LibMain
** 
**    Rev 1.1   14 Jan 1992 12:07:40   tom
** New revisions from Hsinchu.
** 
**  $Header:   S:/tbird/mt2_186/addr/libmain.c_v   1.0   16 Dec 1996 16:15:52   Judy  $
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _ADDR_
#include "addr.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
/* Handle of the DLL instance */
HANDLE hLib;

#define MODULE_NAME "addr.dll"

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/**************************************************************************
**
** LibMain
**
** Description: Main entry point of the ADDR.DLL
**
**	Parameters:
**    input:
**       hInstance:     Handle of the library instance
**       wDataSeg:      Value of Data Segment register
**       cbHeapSize:    Heap Size of the heap defined in the DEF
**       lpszCmdLine:   Command Line information (rarely used)
**
**    output:
**
***************************************************************************/
#pragma argsused
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
                       LPSTR lpszCmdLine) {

   RETCODE err;

   /* the LIBENTRY initializes the local heap by calling LocalInit() and
      then calls LibMain.  The LocalInit() locks the data segment of the
      library when initialize; therefore LibMain needs to unlock */

   if (cbHeapSize != 0) /* the DLL Data segment is MOVEABLE */
       UnlockData(0);

   hLib = hInstance;
   ErrInitDLL(MODULE_ADDRESS, MODULE_NAME);  /* set up for error text */

   err = AdrInitAddressServer();
   if (GOOD != err)
      ErrDisplayError(err, FORCE_POPUP);
    
   return(TRUE);
}

/******************************** E O F ***********************************/
