/****************************************************************************
**
**  Name:  patch86.c
**
**  Description:
**     Routines needed to interface to test fixture for the dasm and asm.
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_186/dad186/patch86.c_v  $
** 
**    Rev 1.0   16 Dec 1996 15:15:58   Judy
** Initial revision.
** 
**    Rev 1.1   13 Sep 1994 17:20:24   nghia
** Revised DummyMemRead() to support memory caching.
** 
**    Rev 1.0   25 May 1994 14:18:50   nghia
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_186/dad186/patch86.c_v   1.0   16 Dec 1996 15:15:58   Judy  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "string.h"

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _ADDR_
#include "addr.h"
#endif

#ifndef _HEAP_
#include "heap.h"
#endif

#ifndef __STDIO_H_
#include <stdio.h>
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/


#define CR      '\r'
#define LF      0x0A

S16             dasmHandle, asmHandle, dasmInit = 0, asmInit = 0;
CHAR            buf[255];

/****************************************************************************
**
**  fReadStr
**
**  Status:  PRELIMINARY
**
**  Description:
**     Read a string from file to buffer
**
**  Parameters:
**     input:
**        *hFile --> the input file handle.
**     output:
**        lBuf ----> the data will be put into buffer.
**
*****************************************************************************/
RETCODE fReadStr(U16 hFile, VOID FAR *lBuf) {
   STATIC LPSTR  dBuf ; /* one line maxinum 255 char */
   STATIC U16    i ;
   i = 0 ;
   dBuf = lBuf ;
   dBuf[0] = 0 ;
   while(_lread(hFile, &dBuf[i], 1) == 1) {
      if( dBuf[i] == CR ) {
         dBuf[i] = 0;
         return(i);
      }
      if( dBuf[i] != LF ) i++;
   }
   return(NULL) ;
}

RETCODE DummyMemRead(LPSTR buffer) {
   U16 j ;
   LPSTR cptr, bufPtr;

   // Read MAX_CODE_LENGTH bytes into buffer
   bufPtr = buffer;
   if (dasmInit == 0) {
      dasmHandle = _lopen("dasm386.tst", OF_READ);
      if (dasmHandle < 0) { /* configuration file open RETCODE */
                        /* warning the user and use default value */
         dasmInit = -1 ;
         return(-1) ;
      }
      dasmInit = 1 ;
   }

   if (dasmInit == -1) return(1) ;
   if(fReadStr(dasmHandle, buf) == NULL) { /* not eof and no file RETCODE */
      _lclose(dasmHandle) ;
      dasmInit = -1 ;
      return(2) ; /* EOF */
   }
   cptr = strtok(buf," ,\t,\n,\r") ;
   while( cptr!= NULL ) {
      sscanf(cptr, "%x", &j) ;
      *bufPtr++ = j ;
      cptr = strtok(NULL, " ,\t,\n,\r") ;
   }
   /* just return one line at a time - since test file is made up
      of one instruction per line!
    */
   return(GOOD) ;
}

RETCODE DummyGetAsmLine(LPSTR buffer) {
   if (asmInit == 0) {
      asmHandle = _lopen("asm386.tst", OF_READ);
      if (asmHandle < 0) { /* configuration file open RETCODE */
                        /* warning the user and use default value */
         asmInit = -1 ;
         return(-1) ;
      }
      asmInit = 1 ;
   }
   if (asmInit == -1)  return(1) ;

   if(fReadStr(asmHandle, buffer) == NULL) { /* not eof and no file RETCODE */
      _lclose(asmHandle) ;
      asmInit = -1 ;
      return(2) ; /* EOF */
   }
   return(GOOD) ;
}

