/***************************************************************************
**
**    Name:    dq186.h
**
**    Description:
**        Internal definitions for the dequeuer server.
**
** 
** 
**    $Header:
*/

#define _DQ186_


                        /********************
                        **                 **
                        **  Includes       **
                        **                 **
                        ********************/


                        /**********************
                        **                   **
                        **  Definitions      **
                        **                   **
                        **********************/



typedef struct {
   BOOLEAN     frameValid;
   BOOLEAN     synched;
   BOOLEAN     programFrame;
   DESCRIPTOR  frameAddr;
   U16         data;
   U32         ifetch;
   S32         frameNo;
}FRAME_TYPE;


typedef enum {
   NO_INT,
   INT_88,
   INT_86
}INT_CYCLE_TYPE;

typedef enum{
   NORMAL_INST,
   BRANCH,
   TRAP,
   ILLEGAL,
   RETURN,
   TRANSFER_INST,
   SW_INT, // find wwwrr seq. cycles
   HW_INT  // fine wAwwrr seq. cycles
}INST_TYPE;


#define MAX_FRAME_READ       0x40L  // Read 64 trace frames each times.
#define FRAME_BUFF_LEN      0x40 // Read 64 frames data each times.

#define MAX_INST_LEN          6  // 6 bytes.
#define AVG_INST_LEN          2  // 2 bytes.

typedef enum { READ_NOSKIP, READ_SKIP }FRAME_READ_MODE;

typedef enum { PROGRAM_FRAME, DATA_FRAME }FRAME_READ_TYPE;

typedef enum {F_UD = 1, F_UP = 2, F_SD = 5, F_SP = 6, F_CPU = 7}FRAME_SPACE;

typedef enum {S_PROGRAM = 0x10, S_DATA, S_DONT_CARE}SPACE_TYPE;

typedef enum { QUEUE_INST,TRACE_INST, TRACE_TRANSFER_INST }CHECK_INST_TYPE;

//typedef struct {
//   S32 frameNo;
//   U32 addr;
//   U8  statusPin;
//   U16 data;
//   U8  timeStamp,
//       spare;
//}TRC_FRAME;

typedef struct {
   S32 frameNo;
   U32 addr;
   U32 statusPin;
   U32 data;
   U8  tshGroup;        /* timestamp bit 39-32 < Judy 10/9/1996> */
   U32 tsGroup;         /* timestamp bit 31-0  <Judy 8/8/96> */
   U16 leGroup;         /* sequence level bit: bit 9-8 <Judy 10/9/1996>  */
}TRC_FRAME;

typedef struct {
   S32 frameNo;
   U32 addr;
   U32 statusPin;
   // U32 data;
   U16 data;
   U16 highData;
   U8  tshGroup;        /* timestamp bit 39-32 < Judy 10/9/1996> */
   U32 tsGroup;         /* timestamp bit 31-0  <Judy 8/8/96> */
   U16 leGroup;         /* sequence level bit: bit 9-8 <Judy 10/9/1996>  */
}DQ_FRAME;

//typedef struct {
//   S32 frameNo;
//   U32 addr;
//   U16 data;
//   U8 statusPin;
//}DQ_FRAME;

typedef struct {
    DQ_FILTER       DqFilter;
    BOOLEAN         Search;
    U16             Offset;
    LPSTR           pattern;
    DESCRIPTOR      traceId;
    FRAME_TYPE      *dqFrame;

    U16 traceBufId;         // New add record for 306 DQ
    S32 frameStart,frameEnd;
    TRC_FRAME frameArray[FRAME_BUFF_LEN];
    U16 traceArrayCount;
}DQ_STATE;



#define LOCAL   static

#define CYCLE(x)   (  (x) & 0x07  )
#define IS_BHE(x)  ( ((x) & 0x10) ? 1 : 0 )
#define ISDMA(x)   ( ((x) & 0x20) ? 1 : 0 )
#define ISFLUSH(x) ( ((x) & 0x40) ? 1 : 0 )
#define LSB(x)     (  (x) & 0x00FF  )
#define MSB(x)     ( ((x) & 0xFF00) >> 8 )

#define ACCESSSIZE88    1
#define ACCESSSIZE86    2
#define DEQSIZE88       5
#define DEQSIZE86       7
#define LISTFRAME       0
#define LISTINST        1
#define LISTSOURCE      2
#define NOBRANCH        0
#define CONDBRANCH      1
#define UNCONDBRANCH    2
#define FETCH_INST      4

#define CYCLE(x)   (  (x) & 0x07  )
#define IS_BHE(x)  ( ((x) & 0x10) ? 1 : 0 )
#define ISDMA(x)   ( ((x) & 0x20) ? 1 : 0 )
#define LSB(x)     (  (x) & 0x00FF  )
#define MSB(x)     ( ((x) & 0xFF00) >> 8 )
#define IS_S(x)    ( (((x) & 0x0F) == 0x0C) ? 1 : 0 )
typedef enum
{T_AK = 0x08,   T_INPUT = 0x09, T_OUTPUT = 0x0A, T_HALT = 0x0B,
 T_S  = 0X0C,    T_READ = 0x0D, T_WRITE  = 0x0E, T_DMA  = 0x20,
 READ_FLUSH = 0x4D, WRITE_FLUSH = 0x4E}
TRACE_STATUS_PIN;
/********************************* E O F *******************************/
