/****************************************************************************
**
**  Name:  libmain.cpp
**
**  Description:
**     Contains the main entry and exit points of the Loader DLL
**
**  $Log:   S:/tbird/mt2_186/inhex/libmain.cpv  $
** 
**    Rev 1.0   16 Dec 1996 16:46:44   Judy
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_186/inhex/libmain.cpv   1.0   16 Dec 1996 16:46:44   Judy  $
**
** Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

#ifndef _HEAP_
#include "heap.h"
#endif

#ifndef _CLISRV_
#include "clisrv.h"   // provide InitCServer() portotype
#endif

#ifndef _INIUTIL_
#include "iniutil.h"
#endif

#ifndef _CPU_
#include "cpu.h"
#endif

#ifndef _PROC_
#include "proc.h"
#endif

#ifndef _LOADER_
#include "loader.h"
#endif

#include <float.h>
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
/* Global Variables */
HWND CliServerHandle;
HANDLE Hlib;

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/**************************************************************************
**
** LibMain
**
** Description: Main entry point of the INHEX.DLL
**
**    Parameters:
**    input:
**       hInstance:     Handle of the library instance
**       wDataSeg:      Value of Data Segment register
**       cbHeapSize:    Heap Size of the heap defined in the DEF
**       lpszCmdLine:   Command Line information (rarely used)
**
**    output:
**
***************************************************************************/
#pragma argsused
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
                       LPSTR lpszCmdLine) {
PROCESSOR_FAMILY procFamily;

    /* the LIBENTRY initializes the local heap by calling LocalInit() and
    ** then calls LibMain.  The LocalInit() locks the data segment of the
    ** library when initialize; therefore LibMain needs to unlock
    */
    if (cbHeapSize != 0) /* the DLL Data segment is MOVEABLE */
       UnlockData(0);

    // save the library instance handle
    Hlib = hInstance;

    // disable floating point exceptions
    _control87(MCW_EM, MCW_EM);

    // init server with ErrText Server
    ErrInitDLL(MODULE_LOADER_INHEX, "INHEX.DLL");

   /* Check to see if the processor is X86  */
   if ((ProcReturnProcFamily(&procFamily) == GOOD) &&
       (procFamily != FAMILY_X86)) {
      CHAR processorName[MAX_NUM_LEN];

      ProcReturnProcessorName(processorName);
      LdrWarning(ER_OMF86_LOADFILE_PROC_NOT_COMPATIBLE,
                 processorName, NULL, NULL);
   }
   return(TRUE);
}

#ifndef __BORLANDC__

/**************************************************************************
**
** WEP {Windows Exit Procedure}
**
** Description: DLL exit procedure to perform cleanup for the DLL before it
**              is unloaded. - not to be used with BC++ compiler.
**
**    Parameters:
**    input:
**       nParam:     Message to indicate whether all of Windows is shutting
**                   down or just the DLL itself.
**
**    output:
**       return a 1 to indicate success
**
***************************************************************************/
int FAR PASCAL WEP(int) {
   return(TRUE);
}

#endif /* __BORLANDC__ */

/*****************************************************************************
**
**   InitCServer :
**   Register server with CLI.
**
******************************************************************************/
RETCODE EXPORT InitCServer(HWND cliHandle, HWND dllHandle) {
   CSERVER_NEW_REGISTRATION FAR * msgBufPtr;

   CliServerHandle = cliHandle;
   msgBufPtr = (CSERVER_NEW_REGISTRATION FAR *)
               TMalloc(sizeof(CSERVER_VARIABLE_VALUE));
   if (msgBufPtr == NULL) {
      return ER_OUT_OF_MEMORY;
   }
   msgBufPtr->stringResourceHandle  = dllHandle;
   msgBufPtr->serverNameIndex       = 0;  // IMPORTANT - must match INHEX.RC
   msgBufPtr->dllNameIndex          = 1;
   msgBufPtr->numberOfCommandsIndex = 2;
   msgBufPtr->commandStartIndex     = 3;
   SendMessage(cliHandle, CLI_NEW_SVR_REGISTRATION,
               CLI_NEW_SVR_REGISTRATION, (DWORD)msgBufPtr);
   return GOOD;
}  /* InitCServer */

/******************************** E O F ***********************************/
