/***************************************************************************
**
**  Name: mapdef.h
**
**  Description: Local definitions for map presenter
**
**  Status: PRELIMINARY
**
**  $Log:   S:/tbird/mt2_186/map/mapdef.h_v  $
** 
**    Rev 1.0   16 Dec 1996 14:09:38   Judy
** Initial revision.
** 
**    Rev 1.0   19 May 1994 10:28:00   tom
** Initial revision.
**
**    Rev 1.0   28 Jan 1994 13:19:12   kevin
** Initial revision.
**
**  $Header:   S:/tbird/mt2_186/map/mapdef.h_v   1.0   16 Dec 1996 14:09:38   Judy  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
****************************************************************************/
#define _MAPDEF_

#define NULL_ADDR       0xFFFFFFFF
#define MAX_RANGE       32768
#define MIN_RANGE       64
#define MAX_STR_LEN     80
#define MAX_MAPNUM      16
#define ADDMAP          0x00000040
#define EDITINTEL       0x00000100
#define EDIT68K         0x00000200
#define TARGET_MEM      0x80
#define MAX_NAME_LEN    128
#define MAX_MAPSTR_LEN  180

#define GETEDITINDEX(X) ((X)&0x0000000F)
#define ISADDDIALOG(X)  ((X)&0x00000040)
#define GETDLGTYPE(X)   ((X)&0x00000300)

#define GETTYPE(B)      (((B)&0x80)>>7)
#define GETACCESS(B)    ((B)&0x07)

#define HAS_UP(N)        ((N)&0x0008)
#define HAS_UD(N)        ((N)&0x0004)
#define HAS_SP(N)        ((N)&0x0002)
#define HAS_SD(N)        ((N)&0x0001)
#define HAS_SMM(N)       ((N)&0x0010)
#define HAS_USR(N)       ((N)&0x0020)
#define IS68KSPACE(N)    ((N)&0x000f)
#define ISINTELSPACE(N)  ((N)&0x0030)

#define ACCESS_RAM       0
#define ACCESS_ROMBRK    1
#define ACCESS_ROMNOBRK  2
#define ACCESS_NONE      3

#define GETSPACE(b5,b4,b3,b2,b1,b0) \
          (((b5)<<5)|((b4)<<4)|((b3)<<3)|((b2)<<2)|((b1)<<1)|(b0))
