/***************************************************************************
**
**  Name: mapdlg.h
**
**  Description: map presenter definitions
**
**  Status: PRELIMINARY
**
**  $Log:   S:/tbird/mt2_186/map/mapdlg.h_v  $
** 
**    Rev 1.2   05 Dec 1997 14:36:42   Winky
** 
**    Rev 1.1   01 Dec 1997 16:21:30   Winky
** add "periodic refresh" dialog
** 
**    Rev 1.0   16 Dec 1996 14:09:34   Judy
** Initial revision.
** 
**    Rev 1.1   19 May 1994 17:01:20   tom
** Match parameter types.
** 
**    Rev 1.0   19 May 1994 11:33:46   tom
** Initial revision.
**
**    Rev 1.0   28 Jan 1994 13:19:12   kevin
** Initial revision.
**
**  $Header:   S:/tbird/mt2_186/map/mapdlg.h_v   1.2   05 Dec 1997 14:36:42   Winky  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
****************************************************************************/
#define _MAPDLG_


                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

typedef struct tagMAPINFO
{
   DWORD addr;
   DWORD size;
   BYTE  type;
   WORD  space;
} MAPINFO;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/****************************************************************************
**
**  InitPresenter
**
**  Description:
**     Initialize the presenter and get system information.
**
**  Parameters:
**     var1 (in): handle of instance
**
*****************************************************************************/
RETCODE EXPORT InitPresenter(HANDLE);

/****************************************************************************
**
**  MapPresenter
**
**  Description:
**     Entry point of the presenter
**
**  Parameters:
**     var1 (in): handle of the parent window
**
*****************************************************************************/
RETCODE EXPORT MapPresenter(HWND);

//wb
RETCODE EXPORT PerPresenter(HWND);

RETCODE EXPORT MapGetPeriodStatus(U8 FAR *fRef, DWORD FAR *nSec);

RETCODE EXPORT MapGetRunAccessStatus(U8 FAR *fRun);

RETCODE EXPORT MapSetRunAccessStatus(U8 FAR fRun);
//we

/**************************************************************************
**
**  GetMapInfo
**
**  Purpose: get map information from map server
**
**  nIndex (in): bank number
**  pMapInfo (out): map information
**
***************************************************************************/
RETCODE GetMapInfo(U16, MAPINFO *);

/**************************************************************************
**
**  SetMapInfo
**
**  Purpose: send map information to map server
**
**  MapInfo (in): map information
**  bEnable (in): TRUE--enable; FALSE--disable
**  IndexNo (in): index number used only when disabling the setting
**
***************************************************************************/
RETCODE SetMapInfo(MAPINFO, BOOLEAN, U32);
