/****************************************************************************
**
**  Name:  periserv.h
**
**  Description:
**     Include file for peripheral server component.  Declarations for
**     peripheral server objects.
**
**  $Log:   S:/tbird/mt2_186/peri/periserv.h_v  $
** 
**    Rev 1.1   29 Jul 1998 12:15:16   hera
** Add GetBaseOffset function.
** 
**    Rev 1.0   16 Dec 1996 16:19:36   Judy
** Initial revision.
** 
**    Rev 1.0   11 Oct 1996 18:47:14   Judy
** Initial revision.
** 
**    Rev 1.20   11 Oct 1994 09:20:02   dennis
** Added stuff to support 386ex.
** 
**    Rev 1.19   03 May 1994 09:50:02   nghia
** Removed null TField destructor - It needs to destroy the allocated data.
** 
**    Rev 1.18   19 Apr 1994 16:40:42   nghia
** Added GetFormatValue() to TReg class.
** Added instance variables to detect Server states (Base and Dictionary)
** Added GetAddrRange() to TGroup for return the descriptor itself, not a copy
** to avoid the overhead of create and destroy address descriptor.
** 
**    Rev 1.17   23 Nov 1993 11:01:56   ron
** More U8->U16 conversions
** 
**    Rev 1.16   23 Nov 1993 10:47:58   ron
** make U8's into U16's for sizes
** 
**    Rev 1.15   15 Nov 1993 15:55:46   ron
** Added some comments that were missing from some recent additions.
** 
**    Rev 1.14   10 Nov 1993 16:05:50   ron
** fixes for 9066, 9063, 9069, 9070
** 
**    Rev 1.13   08 Nov 1993 15:59:12   ron
** bug fixes for pv2.1
** 
**    Rev 1.12   03 Nov 1993 13:43:16   ron
** ready for 2.1 initial build
** 
**    Rev 1.11   21 Oct 1993 15:15:30   ron
** bug fixes based on testing for release
** 
**    Rev 1.10   20 Oct 1993 14:14:02   ron
** ready for pv2.1 (sorta)
** 
**    Rev 1.9   15 Oct 1993 11:14:18   ron
** ready to build and debug
** 
**    Rev 1.8   14 Oct 1993 12:40:36   ron
** checkpoint
** 
**    Rev 1.7   12 Oct 1993 14:43:38   ron
** checkpoint after buffer editing
** 
**    Rev 1.6   04 Oct 1993 16:37:10   marilyn
** Integration with Ron's reader.
** 
**    Rev 1.5   28 Sep 1993 15:28:58   ron
** revised parser (using Paul's new config format)
** 
**    Rev 1.4   01 Sep 1993 14:06:02   marilyn
** Changes to interfaces for incorporating cli commands.
** 
**    Rev 1.3   30 Aug 1993 11:08:26   marilyn
** Updated formatting interface.
** 
**    Rev 1.2   14 Jul 1993 16:04:38   marilyn
** Creation of dictionaries in server class are now dynamic.  Changed some of
** the lists to doublelists.
** 
**    Rev 1.1   07 Jul 1993 16:53:04   marilyn
** Changed UpdateBlockLocation prototype to take a DESCRIPTOR as a param.
** 
**    Rev 1.0   28 Jun 1993 15:06:56   marilyn
** Initial revision.
**  
**  $Header:   S:/tbird/mt2_186/peri/periserv.h_v   1.1   29 Jul 1998 12:15:16   hera  $
**
**  Copyright (C) 1993 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _PERISERV_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#define STRICT
#define WIN31
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _PERIERRS_
#include "perierrs.h"
#endif

#ifndef _CLIULIB_
#include "cliulib.h"
#endif

#ifndef _CLASSTYP_          // TBird C++ classes
#include "classtyp.h"
#endif



// BorlandC includes
#ifndef __OWL_H
#include <owl.h>
#endif

#ifndef __DICT_H
#include <dict.h>
#endif

#ifndef __LIST_H
#include <list.h>
#endif

#ifndef _STRNG_H
#include <strng.h>
#endif

#ifndef __DBLLIST_H
#include <dbllist.h>
#endif


                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

const MAX_MNEMONIC  = 25;

const MAX_LONG_NAME  = 128;

const MAX_INFOSTR  = 256;

const MAX_PERI_DICT = 777;

const PERI_MAXSTR = 128;

const char WhiteSpace[] = " \t\r\n\b";

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

//-----------------------------------------------------------------------
//  TValue
//
//  Description:
//     Value object initialized by constructor
//-----------------------------------------------------------------------

_CLASSDEF(TValue)
class TValue : public Object {
public:
   TValue(U32 newValue=0);
   ~TValue() {};
   // GetValue : method to retrieve the value
   inline U32 GetValue();
   // SetValue : method to set the value
   inline VOID SetValue(U32 newvalue);

   // over ride pure virtual functions of Object
   virtual classType isA() const { return PeriTValueClass; };
   virtual char _FAR *nameOf() const { return("TValue"); };
   virtual hashValueType hashValue() const { return PeriTValueClass; };
   virtual int isEqual( const Object _FAR & ) const;
   virtual void printOn( ostream _FAR & ) const {};

private:
   U32 value;
};

class TRegister;              // forward declaration

//-----------------------------------------------------------------------
//  TField
//
//  Description:
//     Field object used inside of register objects to contain field
//     specific information.
//-----------------------------------------------------------------------

_CLASSDEF(TField)
class TField : public Object {
public:
   TField(HFILE hFile, U16 startLine);
   ~TField();

   // GetValue : method to retrieve value of the field
   inline U32 GetValue();

   // SetValue : method to set the value of the field
   inline VOID SetValue(U32 newValue);

   // GetSize : method to retrieve size of field in bits
   inline U16 GetSize();

   // GetName : method to retrieve a copy of the field name into a 
   // caller provided buffer. Use MAX_MNEMONIC for buffer size.
   LPSTR GetName(LPSTR nameBuffer = NULL) const;

   // GetLongName : method to retrieve a copy of the long field name into a 
   // caller provided buffer. Use MAX_MNEMONIC for buffer size.
   LPSTR GetLongName(LPSTR nameBuffer = NULL) const;

   // GetFieldLocation : method to retrieve location of the field 
   // relative to the register bits.
   inline U8 GetFieldLocation();

   // GetMinValue : method to retrieve minimum legal value of field
   inline U32 GetMinValue();

   // GetMaxValue : method to retrieve maximum legal value of field
   inline U32 GetMaxValue();

   // DontCareValue : method to find out if value indicates specific string
   inline BOOLEAN DontCareValue();

   // GetStringCnt : method to retrieve number of legal strings between
   // maximum and minumum values.
   inline U32 GetStringCnt();

   // MaskOutValue : method to return the field value from the given value
   U32 MaskOutValue(U32 regValue);

   // ShiftValue : method to return the field value shifted to match its
   //              bit value within the entire register.
   U32 ShiftValue(U32 regValue);

   // AddFieldDesc : method to add an association to the field description
   // dictionary
   VOID AddFieldDesc(Object& association);

   // LookupFieldDesc : method to look up the STRING using fieldValue as
   // the key for fieldDict.  Use MAX_INFOSTR for allocating buffer.  If
   // fieldValue is NULL then the default value of the object is used as
   // the key.
   LPSTR LookupFieldDesc(LPSTR buffer,PTValue fieldValue = NULL);

   // over ride pure virtual functions of Object
   virtual classType isA() const { return PeriTFieldClass; };
   virtual char _FAR *nameOf() const { return("TField"); };
   virtual hashValueType hashValue() const { return PeriTFieldClass; };
   virtual int isEqual( const Object _FAR & ) const;
   virtual void printOn( ostream _FAR & ) const {};

public:
   RETCODE status;   // hold the status of the last operation...
   U16     errLine;  // line of config file where problem occurred
   U8      errField; // field of line where problem occurred
   TRegister *parent;// register that contains this field

private:
   TValue value;               // field value
   S8 name[MAX_MNEMONIC];      // field mnemonic
   S8 long_name[MAX_LONG_NAME];// long field name
   U16 size;                    // field size
   U16 fieldLocation;           // field starting bit location
   U32 minValue;               // minimum value
   U32 maxValue;               // maximum value
   BOOLEAN anyValue;           // does Value match string
   U32 stringCnt;              // number or legal values
   BOOLEAN multiWrites;        // multiple write field
   Dictionary fieldDict;       // contains associations of TValue objects
                               // and STRING objects
};

class TPeriPres;              // forward declaration
class TGroup;                 // forward declaration


_CLASSDEF(TRegister)
class TRegister : public Object {


public:
   enum VIEWMODE {SUMMARY=0,VERBOSE=1,DEFAULT=2,DUMMY_VIEW=0x7FFF};

   TRegister(HFILE hFile, U32 grp, U16 line);

   inline ~TRegister();

   //*******************************************************************
   //   CountLines
   //
   //   Description:
   //      Return the number of lines in this register 
   //
   //   Parameters: none
   //******************************************************************
   U32 CountLines();

   //*******************************************************************
   //   LineToText
   //
   //   Description:
   //      Return the line (indented) for the presenter to display
   //
   //   Parameters: the line number 0..nLines - 1
   //******************************************************************
   LPSTR LineToText(U32 lLine, LPSTR buffer);

   //*******************************************************************
   //   FormatRegister
   //
   //   Description:
   //      Fill in the line (indented) for the presenter to display
   //
   //   Parameters: the buffer to fill
   //******************************************************************
   RETCODE FormatRegister(LPSTR text);

   // GetName : method to retrieve register mnemonic into a caller provided
   // buffer. Use MAX_MNEMONIC for buffer size.
   LPSTR GetName(LPSTR nameBuffer = NULL) const;

   // GetAddrOffset : method to retrieve register address offset.
   // Offset is from start of peripheral group.
   inline U32 GetAddrOffset();

   // GetGroupId : method to retrieve group id for the register.
   inline U32 GetGroupId();

   // GetSize : method to retrieve the register size in bytes -- 1,2,4
   inline U16 GetSize();

   // GetFieldCnt : method to retrieve the register field count
   inline U16 GetFieldCnt();

   // GetUnusedBitMask : method to retrieve the unused bit mask
   inline U32 GetUnusedBitMask();

   // GetWritePermission : method to retrieve register write permission
   inline BOOLEAN GetWritePermission();

   // GetWritePermission : method to retrieve register write permission
   inline BOOLEAN GetReadPermission();

   // GetMulitWritesBitMask : method to retrieve register mask to protect
   // write protected bits.
   inline U32 GetMultiWritesBitMask();

   // IsBuffer : method to determine if a transmit or receive buffer
   inline BOOLEAN IsBuffer();

   // GetDesc : method to retrieve description string into a caller
   // provided buffer.  Use MAX_INFOSTR for buffer size.
   LPSTR GetDesc(LPSTR descBuffer) const;

   // GetStatusInfo : method to retrieve status string into a caller
   // provided buffer.  Use MAX_INFOSTRING for buffer size.
   LPSTR GetStatusInfo(LPSTR statusBuffer) const;

   // IsDirty : method to determine register value validity
   inline BOOLEAN IsDirty();

   // SetDirty : method to set the dirty bit to force memory read
   inline VOID SetDirty();

   // GetValue : method to retrieve last known register value
   inline U32 GetValue();

   // SetValue : method to set the value of the register
   // only writes memory if address is valid
   RETCODE SetValue(U32 newValue, DESCRIPTOR address=NULL);

   // GetValue : method to retrieve last known buffer value
   inline LPU8 GetBufferValue();

   // GetFormatValue : method to retrieve the current self value in text form
   S16 GetFormatValue(LPSTR valueStr);
   
   // SetValue : method to set the value of the buffer
   // only writes memory if address is valid
   RETCODE SetValue(LPU8 newValueBuffer,DESCRIPTOR address=NULL);

   // IsWatched : method to determine if register is in watch list
   inline BOOLEAN IsWatched();

   // SetWatch : method to set the watch mode, FALSE=nowatch, TRUE=watch
   inline VOID SetWatch(BOOLEAN watchMode);

   // GetViewMode : method to determine view mode, SUMMARY or VERBOSE
   TRegister::VIEWMODE GetViewMode();

   // SetViewMode : method to set the view mode for a register
   inline VOID SetViewMode(TRegister::VIEWMODE viewMode);

   // AddFieldInfo : method to add TField objects to the fieldInfo list
   VOID AddFieldInfo(Object& fieldInfo);

   // GetFieldInfo : method to retrieve TField object from the fieldInfo
   // according to their stored order.
   PTField GetFieldInfo(U32 index);

   // When setting the register value, set the field values too
   VOID SetFieldValues();

   // Write only registers need to display their default value. If some
   // fields need to have specific values, set those otherwise return 0.
   U32 GetDefaultValue();

   // Determine if register value is valid. Return TRUE if valid, else FALSE
   BOOLEAN InvalidValue(U32 regVal);

   // Determine if register value is only valid in extended I/O mode.
   BOOLEAN IsExtended();

   // over ride pure virtual functions of Object
   virtual classType isA() const { return PeriTRegisterClass; };
   virtual char _FAR *nameOf() const { return("TRegister"); };
   virtual hashValueType hashValue() const { return PeriTRegisterClass; };
   virtual int isEqual( const Object _FAR & ) const { return FALSE; };
   virtual VOID printOn( ostream _FAR & ) const {};

public:
   RETCODE status;   // hold the status of the last operation...
   U16     errLine;  // line of config file where problem occurred
   U8      errField; // field of line where problem occurred
   TRegister *next;  // next register for this peripheral
   TGroup  *parent;  // peripheral that contains this register
   U32 nLines;          // count of lines to display in all components
   BOOLEAN nLinesDirty; // need to recalc
   BOOLEAN expanded;
   BOOLEAN valid;               // display ? in front of address
   BOOLEAN extended; // True if register is valid for extended I/O only

private:
   S8 name[MAX_MNEMONIC];       // register mnemonic
   U32 addrOffset;              // address offset from start of group
   U32 groupId;                 // peripheral group id
   U16 size;                     // register size in bytes
   U16 fieldCnt;                 // number of fields (number of bytes, if buffer)
   U32 unusedBitMask;           // unused bit mask
   BOOLEAN multiWrites;         // multiple write register
   U32 multiWritesBitMask;      // mask to protect no write bits
   BOOLEAN buffer;              // transmit or receive buffer?
   LPU8 bufferValue;            // bytes containing buffer value
   BOOLEAN noReads;             // if TRUE, *never* read this
   BOOLEAN noWrites;            // if TRUE, *never* write this
   String description;          // register description string
   String statusInfo;           // status line description string
   BOOLEAN dirty;               // dirty value
   TValue value;                // last known register value
   BOOLEAN watched;             // watched register
   TRegister::VIEWMODE view;    // view mode indicator
   DoubleList fieldInfo;        // list of TField objects

};


//-----------------------------------------------------------------------
//  TGroup
//
//  Description:
//     Peripheral group object used to contain group information.
//-----------------------------------------------------------------------

_CLASSDEF(TGroup)
class TGroup: public Object {
public:
   friend TPeriPres;

   TGroup(HFILE hFile, U16 line, U32 periBaseAddr);
   
   // make sure we clean up address range descriptor
   inline ~TGroup();

   //*******************************************************************
   //   CountLines
   //
   //   Description:
   //      Return the number of lines in this peripheral 
   //
   //   Parameters: none
   //******************************************************************
   U32 CountLines();

   //*******************************************************************
   //   LineToText
   //
   //   Description:
   //      Return the line (indented) for the presenter to display
   //
   //   Parameters: the line number 0..nLines - 1
   //******************************************************************
   LPSTR LineToText(U32 lLine, LPSTR buffer);

   // LineToReg: Given a virtual line number (an index into the virtual
   // listbox display of the peripheral presenter), return the register
   // that most closely corresponds to that line (if it's a field line or
   // a buffer line, return the parent register).
   PTRegister LineToReg(U32 lLine, U32 FAR *field);

   // Sort the registers in this group by address offset -- called once
   // after configuration file is read.
   VOID Sort(VOID);

   // If a register is expanded compress it (or vice versa).
   VOID ToggleDisplay(U32 lLine);

   // GetName : method to retrieve the group name into a caller provided
   // buffer.  Use MAX_MNEMONIC for buffer size.
   LPSTR GetName(LPSTR nameBuffer = NULL) const;

   // GetRange : method to retrieve the address range of the group, returns
   // an address descriptor which caller must destroy
   RETCODE GetRange(DESCRIPTOR *addrRange,const PTRegister reg);

   // GetBaseOffset : method to retrieve the offset of base address of the
   // group
   U32 GetBaseOffset(VOID);

   // GetRange : method to retrieve the address range of the group, returns
   // an address descriptor. DO NOT DESTROY THE RETURNED DESCRIPTOR
   const DESCRIPTOR GetRange(VOID);

   // ResetBase : method to set the base in the event of a runtime change
   // to the peripheral block location.
   VOID ResetBase(U32 newPeriBaseAddr);

   // SetStartOffset : method to set the starting offset in the event
   // of a runtime change.
   VOID SetStartOffset(U32 periBaseAddr,U32 newStartOffset);

   // SetEndOffset : method to set the ending offset in the event of a
   // runtime change.
   VOID SetEndOffset(U32 periBaseAddr,U32 newEndOffset);

   // GetId : method to retrieve the group object's id
   U32 GetId();

   // GetAddrSelector : method to retrieve the group address selector
   U8 GetAddrSelector();

   // SetAddrSelector : method to set the address selector
   VOID SetAddrSelector(U8 selector);

   // Open the file corresponding to this group, return it's handle
   HFILE TGroup::OpenFile(VOID);

   // return the filename corresponding to this group
   LPSTR GetFileName(VOID);

   // FindClosestRegByAddress : method to find a TRegister object in the list
   // which matches or is less than the given address desc.
   PTRegister FindClosestRegByAddress(DESCRIPTOR searchAddr);

   // over ride pure virtual functions of Object
   virtual classType isA() const { return PeriTGroupClass; };
   virtual char _FAR *nameOf() const { return("TGroup"); };
   virtual hashValueType hashValue() const { return PeriTGroupClass; };
   virtual int isEqual( const Object _FAR & ) const { return FALSE; };
   virtual VOID printOn( ostream _FAR & ) const {};

public:
   RETCODE status;      // hold the status of the last operation...
   U16     errLine;     // line of config file where problem occurred
   U8      errField;    // field of line where problem occurred
   TGroup  *next;       // pointer to next group
   PTRegister firstReg; // point to first register
   U32 index;           // element number in list, also the id
   U32 nLines;          // count of lines to display in all components
   BOOLEAN nLinesDirty; // need to recalc
   BOOLEAN expanded;    // display registers or just one line

private:
   S8 name[MAX_MNEMONIC];       // group name - SIM, TPU etc
   S8 file_name[MAX_MNEMONIC];  // file name - SIM.PCF, TPU.PCF etc
   DESCRIPTOR  addressRange;    // address range descriptor
   S32 addressBase;             // address base 
   U32 startOffset;             // starting offset of range
   U32 endOffset;               // ending offset of range
   U32 addressBase2;            // second starting offset of range
   U8  addressSelector;         // 0 = use addressBase, 1 = use addressBase2

};


//-----------------------------------------------------------------------
//  TPeriServer
//
//  Description:
//     Server object used to contain dictionaries which control
//     access to register information.
//-----------------------------------------------------------------------

_CLASSDEF(TPeriServer)
class TPeriServer : public Object {
public:

   RETCODE    status;            // status field for server initialization
   BOOLEAN    disabledCmds;
   
   TPeriServer();
   ~TPeriServer();

   //******************************************************************
   //   FlushServer
   //
   //   Description:
   //      Method to flush all objects for the server without destroying
   //      any of the dictionaries.   Utilized by the destructor and a
   //      hidden cli command, PCliOpen.
   //
   //   Parameters: none
   //******************************************************************
   VOID FlushServer();


   //******************************************************************
   //   SetReMap
   //
   //   Description:
   //      Method to set the processor REMAPCFG register to allow access
   //      to all registers.
   //
   //   Parameters: none
   //******************************************************************
   VOID SetReMap();

   //******************************************************************
   //   ResetReMap
   //
   //   Description:
   //      Method to reset the processor REMAPCFG register to its saved
   //      state.
   //
   //   Parameters: none
   //******************************************************************
   VOID ResetReMap();

   //******************************************************************
   //   UpdatePeriBaseAddress
   //
   //   Description:
   //      Method to update on request the peripheral block location.
   //
   //   Parameters: none
   //******************************************************************
   VOID UpdatePeriBaseAddress();

   //******************************************************************
   //   GetGroupCount
   //
   //   Description:
   //      Method to retrieve number of peripheral groups.
   //
   //   Parameters: none
   //******************************************************************
   inline U8 GetGroupCount() const;

   //********************************************************************
   //   GetGroupInfo
   //
   //   Description:
   //      Method to retrieve a copy of the TGroup object.
   //
   //   Parameters:
   //      grId (in): group identifier
   //*******************************************************************
   PTGroup GetGroupInfo(U32 grId) const;

   //********************************************************************
   //   GetGroupByAddress
   //
   //   Description:
   //      Method to retrieve a copy of the TGroup object which contains
   //      the given search address descriptor.
   //
   //   Parameters:
   //      searchAddr (in): address descriptor to map to a group range
   //*******************************************************************
   PTGroup GetGroupByAddress(DESCRIPTOR searchAddr) const;

   //********************************************************************
   //   GetGroupGTAddress
   //
   //   Description:
   //      Method to retrieve a copy of the TGroup object which has
   //      an address range > the given search address descriptor.
   //
   //   Parameters:
   //      searchAddr (in): address descriptor to compare to group range
   //*******************************************************************
   PTGroup GetGroupGTAddress(DESCRIPTOR searchAddr) const;

   //********************************************************************
   //   GetGroupByName
   //
   //   Description:
   //      Method to retrieve a pointer to the TGroup object which matches
   //      the given search name.
   //
   //   Parameters:
   //      groupName (in): LPSTR to group name searching for match
   //********************************************************************
   PTGroup GetGroupByName(LPSTR groupName) const;

   // Return a pointer to the register that matches the given name.
   PTRegister GetRegByName(LPSTR regName) const;

   // Return the line number (virtual listbox index) that corresponds to the
   // first line of the register.
   U32 RegToLine(PTRegister reg);

   // Return the line number (virtual listbox index) that corresponds to the
   // first line (the name of the peripheral).
   U32 GroupToLine(PTGroup grp);

   // Expand all means to set the expanded flag of all peripherals and 
   // registers.
   RETCODE ExpandAll(VOID);

   // Expand all means to unset the expanded flag of all peripherals and 
   // registers.
   RETCODE CompressAll(VOID);

   // Reset MBAR to the saved value.
   RETCODE RestoreMBAR();

   // Save the contents of MBAR, then set the valid bit (temporarily).
   RETCODE SaveMBAR();

   // Return TRUE if the valid bit of the MBAR register is set.
   BOOLEAN MBARValid(U32 MBarValue);

   // Set the value of the MBAR register (in cpu space).
   RETCODE SetMBAR(U32 val) ;

   // Return the value of the MBAR register.
   U32 GetMBAR();

   // Return TRUE if it has an MBAR register (i.e. it is a 330, 340, or 360)
   BOOLEAN HasMBAR();

  // Return TRUE if the processor is an Intle (386EX, 386DX, 386CX, 386SX)
    BOOLEAN IsIntel();

  // Return the value of the REMAPCFG register
   U16 GetReMapCfg();

   // GetRegisterAddress : method to retrieve an address descriptor for
   // a register at its current location.  Descriptor must be destroyed by
   // the caller.
   RETCODE GetRegisterAddress(const PTRegister reg,DESCRIPTOR *desc);

   //******************************************************************
   //   SetRegValue
   //
   //   Description:
   //      Called after a register edit has completed by an OK of the
   //      edit dialog.  Process new value and write to memory.
   //
   //   Parameters:
   //      reg (in): the register 
   //      newValue (in): the new value
   //*****************************************************************
   RETCODE SetRegValue(PTRegister reg, U32 newValue);

   //******************************************************************
   //   SetRegValue
   //
   //   Description:
   //      Called after a buffer edit has completed by an OK of the
   //      edit buffer dialog.  Process new value and write to memory.
   //
   //   Parameters:
   //      reg (in): the register 
   //      newValueBuffer (in): ptr to the new value buffer
   //*****************************************************************
   RETCODE SetRegValue(PTRegister reg, LPU8 newValueBuffer);

   //*****************************************************************
   //   SetRegViewMode
   //
   //   Description:
   //      Set the register view mode for all registers.
   //
   //   Parameters:
   //      viewMode (in): TRegister::verbose or TRegister::summary
   //****************************************************************
   VOID SetRegViewMode(TRegister::VIEWMODE view);

   //*******************************************************************
   //   SetRegistersDirty
   //
   //   Description:
   //      Set all registers to require memory updates by marking
   //      them dirty.
   //
   //   Parameters: none
   //******************************************************************
   VOID SetRegistersDirty();

   //*******************************************************************
   //   SetSelectorAndValid
   //
   //   Description:
   //      Set the selector indicator for the group and the valid
   //      indicator for each register in the group.
   //
   //   Parameters: none
   //******************************************************************
   VOID SetSelectorAndValid();

   //*******************************************************************
   //   CountLines
   //
   //   Description:
   //      Return the number of lines in all peripherals (list box size)
   //
   //   Parameters: none
   //******************************************************************
   U32 CountLines();

   //*******************************************************************
   //   LineToText
   //
   //   Description:
   //      Return the line (indented) for the presenter to display
   //
   //   Parameters: the line number 0..CountLines - 1
   //******************************************************************
   LPSTR LineToText(U32 lLine);
   PTRegister LineToReg(U32 lLine, U32 FAR *field, BOOLEAN FAR *isPeriph);

   VOID ToggleDisplay(U32 lLine);

   //*********************************************************************
   //   FormatRegister
   //
   //   Description:
   //      Format the indicated register in the appropriate mode.
   //      That is register address, mnemonic, value, and description.
   //
   //   Parameters:
   //      reg (in):  the register
   //      formatViewMode (in) : over riding format mode
   //      markFields (in):  include field encoding in the text
   //      text(out):  malloced string buffer containing the formatted text
   //      numLines(out):  number of lines contained in the string buffer
   //**********************************************************************
   RETCODE FormatRegister(PTRegister reg,TRegister::VIEWMODE formatView,
      BOOLEAN markFields,BOOLEAN showAddr,BOOLEAN showDesc,
      LPSTR *text,U16 *numLines);

   //*********************************************************************
   //   SetDebug, GetDebug
   //
   //   Description:
   //      CLI Command _peridebug calls these to enable or disable read/write
   //   operations.
   //*********************************************************************
   inline VOID SetDebug(BOOL val) {debugMode = val;}
   inline BOOL GetDebug(VOID) {return debugMode;}

   // over ride pure virtual functions of Object
   virtual classType isA() const { return PeriTPeriServerClass; };
   virtual char _FAR *nameOf() const { return("TPeriServer"); };
   virtual hashValueType hashValue() const { return PeriTPeriServerClass; };
   virtual int isEqual( const Object _FAR & ) const { return FALSE; };
   virtual VOID printOn( ostream _FAR & ) const {};

   // InitDictionaries : method to verify processor and read the appropriate
   // configuration file to initialize empty dictionaries.  Also utilized by
   // hidden cli command PCliOpen
   RETCODE InitDictionaries(const LPSTR periFile, LPSTR buffer, BOOLEAN ignoreProc);
   
   U32        periBaseAddress;   // address base of peripherals
   DESCRIPTOR SDDesc;            // shared data registration on
                                 // SDN_SIM_ADDRESS

   BOOLEAN    periBaseValid;     // address base valid?
   BOOLEAN    periDictValid;     // dictionary valid?
   
   // Init : initialize the dll, register for events, create Dictionaries.
   RETCODE Init();
   RETCODE InitEvents();
   RETCODE InitServer();
   
    // FormatVerbose : method to format a register object into display text
   // using the verbose display format.
   RETCODE FormatVerbose(const PTRegister reg,BOOLEAN markFields,
         BOOLEAN showAddr,BOOLEAN showDesc,LPSTR *text,U16 *numLines);

   // FormatSummary : method to format a register object into display text
   // using the summary display format
   RETCODE FormatSummary(const PTRegister reg,BOOLEAN markFields,
	 BOOLEAN showAddr,BOOLEAN showDesc,LPSTR *text,U16 *numLines);

   // ReadWord : method to get a token from the configuration file
   LPSTR ReadWord(const int hFile, LPSTR storage);

   // ReadString : method to get "a string" from the configuration file
   LPSTR ReadString(const int hFile, LPSTR storage);

   // ReadTGroup : method to retrieve group info from the configuration
   // file
   RETCODE ReadTGroup(const int hFile,PTGroup *group);

   // ReadTRegister : method to retrieve register info from the
   // configuration file
   RETCODE ReadTRegister(const int hFile,U32 *groupIndex,PTRegister *reg);

   // ReadTField : method to retrieve field info from the
   // configuration file
   RETCODE ReadTField(const int hFile,PTField *field);

   // ReadRegValue : method to retrieve new register value from memory
   RETCODE ReadRegValue(const PTRegister reg,DESCRIPTOR desc=NULL);

   // CheckForEOF : check the provided buffer to see if it matches the
   // EOF marker for the configuration file "CFG_END"
   BOOLEAN CheckForEOF(LPSTR buffer);

   // Whether we read/write memory or not
   BOOL debugMode;
};

#ifdef __cplusplus
extern "C" {
#endif
//**********************************************************************
//   PeriCallback
//
//   Description:
//      Callback function  for the event handler.
//
//   Parameters:
//      eventNum (in): event number to process
//**********************************************************************
RETCODE EXPORT PeriCallback(U32 eventNum);

//**********************************************************************
//   PeriUpdateBlockLocation
//
//   Description:
//      Callback function  for the shared data server to notify us if
//      the location of the peripheral block changes.
//
//   Parameters:  none
//**********************************************************************
VOID EXPORT PeriUpdateBlockLocation(DESCRIPTOR);


#ifdef __cplusplus
}
#endif

/******************************** E O F ***********************************/
