/****************************************************************************
**
**  Name:  pvtest.c
**
**  Description:
**     Confidence test driver
**
**  $Log:   S:/tbird/mt2_186/pvtest/pvtest.c_v  $
** 
**    Rev 1.1   27 Mar 1998 15:15:16   Eric
** No change.
** 
**    Rev 1.0   16 Dec 1996 16:45:28   Judy
** Initial revision.
** 
**    Rev 1.0   10 May 1994 09:53:02   ernie
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_186/pvtest/pvtest.c_v   1.1   27 Mar 1998 15:15:16   Eric  $
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef _ADDR_
#include "addr.h"
#endif
#ifndef _BASEWIND_
#include "basewind.h"
#endif
#ifndef _CLISRV_
#include "clisrv.h"
#endif
#ifndef _HEAP_
#include "heap.h"
#endif
#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif
#ifndef _LOCAL_
#include "local.h"
#endif
#ifndef _PVTEST_
#include "pvtest.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

typedef struct {
   char name[MAX_MAPPED_NAME];
   U16  value;
} TEST_MAPPING;

STATIC HANDLE cliServerHandle = (HANDLE)NULL;
static HANDLE hLib;
static TEST_MAPPING testTable[MAX_TESTS];
static U16 numTests;
U16 testList[MAX_TESTLIST];
U16 numTestItems;

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/
RETCODE PRIVATE CacheNames(VOID);
RETCODE EXPORT ConfigTestCallback(LPSTR key, LPSTR value, BOOLEAN *abort,
   VOID *data);

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

#pragma argsused
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
      LPSTR lpszCmdLine) {
   if (cbHeapSize != 0) /* the DLL Data segment is MOVEABLE */
      UnlockData(0);
   /*
   ** Read and cache test names
   */
   CacheNames();
   ErrInitDLL(MODULE_PVTEST,"pvtest.dll");
   hLib = hInstance;
   return(TRUE);
}

RETCODE EXPORT InitCServer(HANDLE cliHandle, HANDLE dllHandle) {

   CSERVER_NEW_REGISTRATION FAR *msgBufPtr;

   cliServerHandle = cliHandle;
   msgBufPtr =
      (CSERVER_NEW_REGISTRATION FAR *)TMalloc(sizeof(CSERVER_VARIABLE_VALUE));
   if (msgBufPtr == NULL) {
      return(ER_OUT_OF_MEMORY);
   }
   msgBufPtr->stringResourceHandle = dllHandle;

   msgBufPtr->serverNameIndex = 30;
   msgBufPtr->dllNameIndex = 31;
   msgBufPtr->numberOfCommandsIndex = 32;
   msgBufPtr->commandStartIndex = 33;
   SendMessage(cliHandle, CLI_NEW_SVR_REGISTRATION, CLI_NEW_SVR_REGISTRATION,
      (DWORD)msgBufPtr);
   TFree((LPSTR)msgBufPtr);
   return(GOOD);
}

RETCODE SendCliMessage(LPSTR msgPtr) {

   HANDLE               msgBufHandle;
   CSERVER_RESULTS FAR  *msgBufPtr;
   U16                  msgTextSize, loop ;

   msgTextSize = lstrlen(msgPtr);
   if ((msgBufHandle =
      GlobalAlloc(GMEM_MOVEABLE,
                  (sizeof(CSERVER_RESULTS) + msgTextSize + 2)))
      == (HANDLE)NULL) {
      return(ER_OUT_OF_MEMORY);
   }
   else if((msgBufPtr=(CSERVER_RESULTS *)GlobalLock(msgBufHandle)) == NULL) {
      GlobalFree(msgBufHandle);
      return(ER_WINDOWS_MEMLOCK);
   }
   msgBufPtr->target               = 0;    /*@@ CLI: not yet def'ed @@*/
   msgBufPtr->variantCode          = CLI_SERVER_RESULTS;
   msgBufPtr->resultTextLength     = msgTextSize; /* message string length */
   for (loop = 0; loop < msgTextSize; loop++ ) {
      msgBufPtr->messageText[loop]  =  *msgPtr++;
   }
   msgBufPtr->messageText[msgTextSize+1] = 0 ;

   SendMessage(cliServerHandle, CLI_SERVER_RESULTS,
               msgBufHandle, CLI_SERVER_RESULTS);
   return GOOD;
}


/****************************************************************************
**
** CacheNames
**
** Read the config file and fill in the tables of test names and
** the list of tests for the installed processor.
**
*****************************************************************************/
RETCODE PRIVATE CacheNames(VOID) {
   RETCODE err;
   LPSTR token;
   S8 name[MAX_LINE];
   S8 value[MAX_LINE];
   
   /* Get test name/number mapping */
   numTests=0;
   if ((err = ConfigFileEnumerate("[tests]", ConfigTestCallback,
      NULL, NULL)) != GOOD) return(err);

   /* Get test list for this processor */
   if (ProcInsertSystemName("[%s]",name) != GOOD) return(err);
   if ((err = ConfigFileRead(name, "tests", value)) != GOOD)
      return(err);
   token = strtok(value,",");
   while (token) {
      testList[numTestItems] = (U16)strtoul(token,NULL,0);
      numTestItems++;
      token = strtok(NULL,",");
   }
   return(TestInit());
}

#pragma argsused
RETCODE EXPORT ConfigTestCallback(LPSTR key, LPSTR value, BOOLEAN *abort,
      VOID *data) {
   strcpy(testTable[numTests].name, key);
   testTable[numTests].value = (U16)strtoul(value, NULL, 0);
   numTests++;
   return(GOOD);
}

/****************************************************************************
**
** TestGetTestName
**
*****************************************************************************/
LPSTR TestGetTestName(U16 testNumber) {
   U16 entry;
   for (entry=0; entry<numTests; entry++) {
      if (testNumber == testTable[entry].value) {
         return(testTable[entry].name);
      }
   }
   return("");
}

/****************************************************************************
**
** TestIsTestName
**
*****************************************************************************/
BOOLEAN TestIsTestName(LPSTR str, U16 *testNumber) {
   LPSTR endptr;
   U16 entry;
   BOOLEAN found=FALSE;

   /* Check for pure number */
   *testNumber = (U16)strtoul(str, &endptr, 0);
   if (*endptr == '\0') {
      found = TRUE;
   } else {
      /* Otherwise, search table for name */
      for (entry=0; entry<numTests; entry++) {
         if (stricmp(str, testTable[entry].name) == 0) {
            *testNumber = testTable[entry].value;
            found = TRUE;
            break;
         }
      }
   }
   if (!found) return(FALSE);

   /* Search test list for this test number to check for valid */
   for (entry=0; entry<numTestItems; entry++) {
      if (testList[entry] == *testNumber) return(TRUE);
   }
   return(FALSE);
}

/******************************** E O F ***********************************/
