/****************************************************************************
**
**  Name:  types.h
**
**  Description:
**     Definitions of BASIC TYPES.  This is used by the symbol manager to 
**     initialize the basic types for a processor.
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_186/symbol/types.h_v  $
** 
**    Rev 1.1   18 Apr 1997 09:29:16   Judy
** 
**    Rev 1.1   14 Jan 1997 15:32:20   Judy
** No change.
** 
**    Rev 1.0   14 Jun 1996 16:42:08   Judy
** Initial revision.
** 
**    Rev 1.4   06 Oct 1994 21:47:52   brucea
** Reduced type name table to 26 entries
** Reduced type size table to 26 entries
** 
**    Rev 1.3   03 Dec 1992 07:47:54   brucea
** Changed: UNKNOWN TYPE to Unknown Type and the pointer version of same
** 
** 
**    Rev 1.2   13 Jan 1992 17:18:30   john
** Fixed dumb bug in initialized arrays
** 
**    Rev 1.1   18 Nov 1991 15:24:12   brucea
** Cosmetic change
** 
**    Rev 1.0   12 Sep 1991 11:39:22   john
** Initial revision.
**
**  $Header:   S:/tbird/mt2_186/symbol/types.h_v   1.1   18 Apr 1997 09:29:16   Judy  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _TYPES_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define BASIC_TYPE_COUNT 26

/* This initializes the names for the basic variable types.  */

PRIVATE S8 *basicTypeName[] = {
   "Unknown Type", "void", "signed char", "unsigned char", "signed short int",
   "unsigned short int", "signed long", "unsigned long", "signed long long",
   "unsigned long long","float", "double", "long double", "long long double",
   "string", "instruction address", "int", "unsigned", "unsigned int",
   "char", "long", "short", "unsigned short", "short int", "signed short",
   "BCD float"
};
// Removed since they become loaded complex types; i.e. pointers to
// basic types.
// "\0", "\0", "\0", "\0", "\0", "\0",
// "Unknown Type *", "void *", "signed char *", "unsigned char *",
// "signed short int *", "unsigned short int *", "signed long *",
// "unsigned long *", "signed long long *", "unsigned long long *","float *",
// "double *", "long double *", "long long double *", "string *",
// "instruction address *", "int *", "unsigned *", "unsigned int *",
// "char *", "long *", "short *", "unsigned short *", "short int *",
// "signed short *", "BCD float *"
// };

/* this initializes the size in bytes of the basic variable types. */

static U8 basicTypeSize[BASIC_TYPE_COUNT] = {
   0, 0, 1, 1, 2, 2, 4, 4,
   8, 8, 4, 8,10,16, 0, 0,
   2, 2, 2, 1, 4, 2, 2, 2,
   2, 8
};
// Removed since they have become loaded complex types; i.e. pointers to
// basic types.
//       0, 0, 0, 0, 0, 0,
// 4, 4, 4, 4, 4, 4, 4, 4,
// 4, 4, 4, 4, 4, 4, 4, 4,
// 4, 4, 4, 4

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/******************************** E O F ***********************************/
