/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LocalVariableTable
extends Attribute {
    private int local_variable_table_length;
    private LocalVariable[] local_variable_table;

    public LocalVariableTable(LocalVariableTable localVariableTable) {
        this(localVariableTable.getNameIndex(), localVariableTable.getLength(), localVariableTable.getLocalVariableTable(), localVariableTable.getConstantPool());
    }

    public LocalVariableTable(int n, int n2, LocalVariable[] localVariableArray, ConstantPool constantPool) {
        super((byte)5, n, n2, constantPool);
        this.setLocalVariableTable(localVariableArray);
    }

    LocalVariableTable(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, (LocalVariable[])null, constantPool);
        this.local_variable_table_length = dataInputStream.readUnsignedShort();
        this.local_variable_table = new LocalVariable[this.local_variable_table_length];
        for (int i = 0; i < this.local_variable_table_length; ++i) {
            this.local_variable_table[i] = new LocalVariable(dataInputStream, constantPool);
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitLocalVariableTable(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.local_variable_table_length);
        for (int i = 0; i < this.local_variable_table_length; ++i) {
            this.local_variable_table[i].dump(dataOutputStream);
        }
    }

    public final LocalVariable[] getLocalVariableTable() {
        return this.local_variable_table;
    }

    public final LocalVariable getLocalVariable(int n) {
        for (int i = 0; i < this.local_variable_table_length; ++i) {
            if (this.local_variable_table[i].getIndex() != n) continue;
            return this.local_variable_table[i];
        }
        return null;
    }

    public final void setLocalVariableTable(LocalVariable[] localVariableArray) {
        this.local_variable_table = localVariableArray;
        this.local_variable_table_length = localVariableArray == null ? 0 : localVariableArray.length;
    }

    @Override
    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < this.local_variable_table_length; ++i) {
            stringBuffer.append(this.local_variable_table[i].toString());
            if (i >= this.local_variable_table_length - 1) continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        LocalVariableTable localVariableTable = (LocalVariableTable)this.clone();
        localVariableTable.local_variable_table = new LocalVariable[this.local_variable_table_length];
        for (int i = 0; i < this.local_variable_table_length; ++i) {
            localVariableTable.local_variable_table[i] = this.local_variable_table[i].copy();
        }
        localVariableTable.constant_pool = constantPool;
        return localVariableTable;
    }

    public final int getTableLength() {
        return this.local_variable_table_length;
    }
}

