/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.css.converters.BooleanConverter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.Chart;
import javafx.scene.layout.Region;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public abstract class XYChart<X, Y>
extends Chart {
    private final BitSet colorBits = new BitSet(8);
    static String DEFAULT_COLOR = "default-color";
    final Map<Series<X, Y>, Integer> seriesColorMap = new HashMap<Series<X, Y>, Integer>();
    private boolean rangeValid = false;
    private final Line verticalZeroLine = new Line();
    private final Line horizontalZeroLine = new Line();
    private final Path verticalGridLines = new Path();
    private final Path horizontalGridLines = new Path();
    private final Path horizontalRowFill = new Path();
    private final Path verticalRowFill = new Path();
    private final Region plotBackground = new Region();
    private final Group plotArea = new Group(){

        @Override
        public void requestLayout() {
        }
    };
    private final Group plotContent = new Group();
    private final Rectangle plotAreaClip = new Rectangle();
    Series<X, Y> begin = null;
    private final ListChangeListener<Series<X, Y>> seriesChanged = change -> {
        while (change.next()) {
            int n;
            if (change.getRemoved().size() > 0) {
                this.updateLegend();
            }
            for (Series series : change.getRemoved()) {
                series.setToRemove = true;
                series.setChart(null);
                this.seriesRemoved(series);
                n = this.seriesColorMap.remove(series);
                this.colorBits.clear(n);
            }
            for (int i = change.getFrom(); i < change.getTo() && !change.wasPermutated(); ++i) {
                Series series;
                series = (Series)change.getList().get(i);
                series.setChart(this);
                if (series.setToRemove) {
                    series.setToRemove = false;
                    series.getChart().seriesBeingRemovedIsAdded(series);
                }
                if (this.begin == null) {
                    this.begin = (Series)this.getData().get(i);
                    this.begin.next = null;
                } else if (i == 0) {
                    ((Series)this.getData().get((int)0)).next = this.begin;
                    this.begin = (Series)this.getData().get(0);
                } else {
                    Series<X, Y> series2 = this.begin;
                    for (int j = 0; j < i - 1 && series2 != null; ++j) {
                        series2 = series2.next;
                    }
                    if (series2 != null) {
                        ((Series)this.getData().get((int)i)).next = series2.next;
                        series2.next = (Series)this.getData().get(i);
                    }
                }
                n = this.colorBits.nextClearBit(0);
                this.colorBits.set(n, true);
                series.defaultColorStyleClass = DEFAULT_COLOR + n % 8;
                this.seriesColorMap.put(series, n % 8);
                this.seriesAdded(series, i);
            }
            if (change.getFrom() < change.getTo()) {
                this.updateLegend();
            }
            this.seriesChanged(change);
            if (!change.wasPermutated() || this.getData().size() <= 0) continue;
            this.begin = (Series)this.getData().get(0);
            Series<X, Y> series = this.begin;
            for (int i = 1; i < this.getData().size() && series != null; ++i) {
                series.next = (Series)this.getData().get(i);
                series = series.next;
            }
            series.next = null;
        }
        this.invalidateRange();
        this.requestChartLayout();
    };
    private final Axis<X> xAxis;
    private final Axis<Y> yAxis;
    private ObjectProperty<ObservableList<Series<X, Y>>> data = new ObjectPropertyBase<ObservableList<Series<X, Y>>>(){
        private ObservableList<Series<X, Y>> old;

        @Override
        protected void invalidated() {
            ObservableList observableList = (ObservableList)this.getValue();
            int n = -1;
            if (this.old != null) {
                this.old.removeListener(XYChart.this.seriesChanged);
                if (observableList != null && this.old.size() > 0) {
                    n = ((Series)this.old.get(0)).getChart().getAnimated() ? 1 : 2;
                    ((Series)this.old.get(0)).getChart().setAnimated(false);
                }
            }
            if (observableList != null) {
                observableList.addListener(XYChart.this.seriesChanged);
            }
            if (this.old != null || observableList != null) {
                int n2;
                final List list = this.old != null ? this.old : Collections.emptyList();
                int n3 = n2 = observableList != null ? observableList.size() : 0;
                if (n2 > 0 || !list.isEmpty()) {
                    XYChart.this.seriesChanged.onChanged(new NonIterableChange<Series<X, Y>>(0, n2, observableList){

                        @Override
                        public List<Series<X, Y>> getRemoved() {
                            return list;
                        }

                        @Override
                        protected int[] getPermutation() {
                            return new int[0];
                        }
                    });
                }
            } else if (this.old != null && this.old.size() > 0) {
                XYChart.this.seriesChanged.onChanged(new NonIterableChange<Series<X, Y>>(0, 0, observableList){

                    @Override
                    public List<Series<X, Y>> getRemoved() {
                        return old;
                    }

                    @Override
                    protected int[] getPermutation() {
                        return new int[0];
                    }
                });
            }
            if (observableList != null && observableList.size() > 0 && n != -1) {
                ((Series)observableList.get(0)).getChart().setAnimated(n == 1);
            }
            this.old = observableList;
        }

        @Override
        public Object getBean() {
            return XYChart.this;
        }

        @Override
        public String getName() {
            return "data";
        }
    };
    private BooleanProperty verticalGridLinesVisible = new StyleableBooleanProperty(true){

        @Override
        protected void invalidated() {
            XYChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return XYChart.this;
        }

        @Override
        public String getName() {
            return "verticalGridLinesVisible";
        }

        @Override
        public CssMetaData<XYChart<?, ?>, Boolean> getCssMetaData() {
            return StyleableProperties.VERTICAL_GRID_LINE_VISIBLE;
        }
    };
    private BooleanProperty horizontalGridLinesVisible = new StyleableBooleanProperty(true){

        @Override
        protected void invalidated() {
            XYChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return XYChart.this;
        }

        @Override
        public String getName() {
            return "horizontalGridLinesVisible";
        }

        @Override
        public CssMetaData<XYChart<?, ?>, Boolean> getCssMetaData() {
            return StyleableProperties.HORIZONTAL_GRID_LINE_VISIBLE;
        }
    };
    private BooleanProperty alternativeColumnFillVisible = new StyleableBooleanProperty(false){

        @Override
        protected void invalidated() {
            XYChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return XYChart.this;
        }

        @Override
        public String getName() {
            return "alternativeColumnFillVisible";
        }

        @Override
        public CssMetaData<XYChart<?, ?>, Boolean> getCssMetaData() {
            return StyleableProperties.ALTERNATIVE_COLUMN_FILL_VISIBLE;
        }
    };
    private BooleanProperty alternativeRowFillVisible = new StyleableBooleanProperty(true){

        @Override
        protected void invalidated() {
            XYChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return XYChart.this;
        }

        @Override
        public String getName() {
            return "alternativeRowFillVisible";
        }

        @Override
        public CssMetaData<XYChart<?, ?>, Boolean> getCssMetaData() {
            return StyleableProperties.ALTERNATIVE_ROW_FILL_VISIBLE;
        }
    };
    private BooleanProperty verticalZeroLineVisible = new StyleableBooleanProperty(true){

        @Override
        protected void invalidated() {
            XYChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return XYChart.this;
        }

        @Override
        public String getName() {
            return "verticalZeroLineVisible";
        }

        @Override
        public CssMetaData<XYChart<?, ?>, Boolean> getCssMetaData() {
            return StyleableProperties.VERTICAL_ZERO_LINE_VISIBLE;
        }
    };
    private BooleanProperty horizontalZeroLineVisible = new StyleableBooleanProperty(true){

        @Override
        protected void invalidated() {
            XYChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return XYChart.this;
        }

        @Override
        public String getName() {
            return "horizontalZeroLineVisible";
        }

        @Override
        public CssMetaData<XYChart<?, ?>, Boolean> getCssMetaData() {
            return StyleableProperties.HORIZONTAL_ZERO_LINE_VISIBLE;
        }
    };

    public Axis<X> getXAxis() {
        return this.xAxis;
    }

    public Axis<Y> getYAxis() {
        return this.yAxis;
    }

    public final ObservableList<Series<X, Y>> getData() {
        return (ObservableList)this.data.getValue();
    }

    public final void setData(ObservableList<Series<X, Y>> observableList) {
        this.data.setValue(observableList);
    }

    public final ObjectProperty<ObservableList<Series<X, Y>>> dataProperty() {
        return this.data;
    }

    public final boolean getVerticalGridLinesVisible() {
        return this.verticalGridLinesVisible.get();
    }

    public final void setVerticalGridLinesVisible(boolean bl) {
        this.verticalGridLinesVisible.set(bl);
    }

    public final BooleanProperty verticalGridLinesVisibleProperty() {
        return this.verticalGridLinesVisible;
    }

    public final boolean isHorizontalGridLinesVisible() {
        return this.horizontalGridLinesVisible.get();
    }

    public final void setHorizontalGridLinesVisible(boolean bl) {
        this.horizontalGridLinesVisible.set(bl);
    }

    public final BooleanProperty horizontalGridLinesVisibleProperty() {
        return this.horizontalGridLinesVisible;
    }

    public final boolean isAlternativeColumnFillVisible() {
        return this.alternativeColumnFillVisible.getValue();
    }

    public final void setAlternativeColumnFillVisible(boolean bl) {
        this.alternativeColumnFillVisible.setValue(bl);
    }

    public final BooleanProperty alternativeColumnFillVisibleProperty() {
        return this.alternativeColumnFillVisible;
    }

    public final boolean isAlternativeRowFillVisible() {
        return this.alternativeRowFillVisible.getValue();
    }

    public final void setAlternativeRowFillVisible(boolean bl) {
        this.alternativeRowFillVisible.setValue(bl);
    }

    public final BooleanProperty alternativeRowFillVisibleProperty() {
        return this.alternativeRowFillVisible;
    }

    public final boolean isVerticalZeroLineVisible() {
        return this.verticalZeroLineVisible.get();
    }

    public final void setVerticalZeroLineVisible(boolean bl) {
        this.verticalZeroLineVisible.set(bl);
    }

    public final BooleanProperty verticalZeroLineVisibleProperty() {
        return this.verticalZeroLineVisible;
    }

    public final boolean isHorizontalZeroLineVisible() {
        return this.horizontalZeroLineVisible.get();
    }

    public final void setHorizontalZeroLineVisible(boolean bl) {
        this.horizontalZeroLineVisible.set(bl);
    }

    public final BooleanProperty horizontalZeroLineVisibleProperty() {
        return this.horizontalZeroLineVisible;
    }

    protected ObservableList<Node> getPlotChildren() {
        return this.plotContent.getChildren();
    }

    public XYChart(Axis<X> axis, Axis<Y> axis2) {
        this.xAxis = axis;
        if (axis.getSide() == null) {
            axis.setSide(Side.BOTTOM);
        }
        axis.setEffectiveOrientation(Orientation.HORIZONTAL);
        this.yAxis = axis2;
        if (axis2.getSide() == null) {
            axis2.setSide(Side.LEFT);
        }
        axis2.setEffectiveOrientation(Orientation.VERTICAL);
        axis.autoRangingProperty().addListener((observableValue, bl, bl2) -> this.updateAxisRange());
        axis2.autoRangingProperty().addListener((observableValue, bl, bl2) -> this.updateAxisRange());
        this.getChartChildren().addAll((Node[])new Node[]{this.plotBackground, this.plotArea, axis, axis2});
        this.plotArea.setAutoSizeChildren(false);
        this.plotContent.setAutoSizeChildren(false);
        this.plotAreaClip.setSmooth(false);
        this.plotArea.setClip(this.plotAreaClip);
        this.plotArea.getChildren().addAll((Node[])new Node[]{this.verticalRowFill, this.horizontalRowFill, this.verticalGridLines, this.horizontalGridLines, this.verticalZeroLine, this.horizontalZeroLine, this.plotContent});
        this.plotContent.getStyleClass().setAll((String[])new String[]{"plot-content"});
        this.plotBackground.getStyleClass().setAll((String[])new String[]{"chart-plot-background"});
        this.verticalRowFill.getStyleClass().setAll((String[])new String[]{"chart-alternative-column-fill"});
        this.horizontalRowFill.getStyleClass().setAll((String[])new String[]{"chart-alternative-row-fill"});
        this.verticalGridLines.getStyleClass().setAll((String[])new String[]{"chart-vertical-grid-lines"});
        this.horizontalGridLines.getStyleClass().setAll((String[])new String[]{"chart-horizontal-grid-lines"});
        this.verticalZeroLine.getStyleClass().setAll((String[])new String[]{"chart-vertical-zero-line"});
        this.horizontalZeroLine.getStyleClass().setAll((String[])new String[]{"chart-horizontal-zero-line"});
        this.plotContent.setManaged(false);
        this.plotArea.setManaged(false);
        this.animatedProperty().addListener((observableValue, bl, bl2) -> {
            if (this.getXAxis() != null) {
                this.getXAxis().setAnimated((boolean)bl2);
            }
            if (this.getYAxis() != null) {
                this.getYAxis().setAnimated((boolean)bl2);
            }
        });
    }

    final int getDataSize() {
        ObservableList<Series<X, Y>> observableList = this.getData();
        return observableList != null ? observableList.size() : 0;
    }

    private void seriesNameChanged() {
        this.updateLegend();
        this.requestChartLayout();
    }

    private void dataItemsChanged(Series<X, Y> series, List<Data<X, Y>> list, int n, int n2, boolean bl) {
        for (Data<X, Y> data : list) {
            this.dataItemRemoved(data, series);
        }
        for (int i = n; i < n2; ++i) {
            Data data = (Data)series.getData().get(i);
            this.dataItemAdded(series, i, data);
        }
        this.invalidateRange();
        this.requestChartLayout();
    }

    private void dataXValueChanged(Data<X, Y> data) {
        if (data.getCurrentX() != data.getXValue()) {
            this.invalidateRange();
        }
        this.dataItemChanged(data);
        if (this.shouldAnimate()) {
            this.animate(new KeyFrame(Duration.ZERO, new KeyValue(data.currentXProperty(), data.getCurrentX())), new KeyFrame(Duration.millis(700.0), new KeyValue(data.currentXProperty(), data.getXValue(), Interpolator.EASE_BOTH)));
        } else {
            data.setCurrentX(data.getXValue());
            this.requestChartLayout();
        }
    }

    private void dataYValueChanged(Data<X, Y> data) {
        if (data.getCurrentY() != data.getYValue()) {
            this.invalidateRange();
        }
        this.dataItemChanged(data);
        if (this.shouldAnimate()) {
            this.animate(new KeyFrame(Duration.ZERO, new KeyValue(data.currentYProperty(), data.getCurrentY())), new KeyFrame(Duration.millis(700.0), new KeyValue(data.currentYProperty(), data.getYValue(), Interpolator.EASE_BOTH)));
        } else {
            data.setCurrentY(data.getYValue());
            this.requestChartLayout();
        }
    }

    private void dataExtraValueChanged(Data<X, Y> data) {
        if (data.getCurrentY() != data.getYValue()) {
            this.invalidateRange();
        }
        this.dataItemChanged(data);
        if (this.shouldAnimate()) {
            this.animate(new KeyFrame(Duration.ZERO, new KeyValue(data.currentYProperty(), data.getCurrentY())), new KeyFrame(Duration.millis(700.0), new KeyValue(data.currentYProperty(), data.getYValue(), Interpolator.EASE_BOTH)));
        } else {
            data.setCurrentY(data.getYValue());
            this.requestChartLayout();
        }
    }

    protected void updateLegend() {
    }

    void seriesBeingRemovedIsAdded(Series<X, Y> series) {
    }

    void dataBeingRemovedIsAdded(Data<X, Y> data, Series<X, Y> series) {
    }

    protected abstract void dataItemAdded(Series<X, Y> var1, int var2, Data<X, Y> var3);

    protected abstract void dataItemRemoved(Data<X, Y> var1, Series<X, Y> var2);

    protected abstract void dataItemChanged(Data<X, Y> var1);

    protected abstract void seriesAdded(Series<X, Y> var1, int var2);

    protected abstract void seriesRemoved(Series<X, Y> var1);

    protected void seriesChanged(ListChangeListener.Change<? extends Series> change) {
    }

    private void invalidateRange() {
        this.rangeValid = false;
    }

    protected void updateAxisRange() {
        Axis<X> axis = this.getXAxis();
        Axis<Y> axis2 = this.getYAxis();
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        if (axis.isAutoRanging()) {
            arrayList = new ArrayList();
        }
        if (axis2.isAutoRanging()) {
            arrayList2 = new ArrayList();
        }
        if (arrayList != null || arrayList2 != null) {
            for (Series series : this.getData()) {
                for (Data data : series.getData()) {
                    if (arrayList != null) {
                        arrayList.add(data.getXValue());
                    }
                    if (arrayList2 == null) continue;
                    arrayList2.add(data.getYValue());
                }
            }
            if (arrayList != null) {
                axis.invalidateRange(arrayList);
            }
            if (arrayList2 != null) {
                axis2.invalidateRange(arrayList2);
            }
        }
    }

    protected abstract void layoutPlotChildren();

    @Override
    protected final void layoutChartChildren(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        Object object;
        int n;
        double d8;
        if (this.getData() == null) {
            return;
        }
        if (!this.rangeValid) {
            this.rangeValid = true;
            if (this.getData() != null) {
                this.updateAxisRange();
            }
        }
        d = this.snapPosition(d);
        d2 = this.snapPosition(d2);
        Axis<X> axis = this.getXAxis();
        ObservableList<Axis.TickMark<X>> observableList = axis.getTickMarks();
        Axis<Y> axis2 = this.getYAxis();
        ObservableList<Axis.TickMark<Y>> observableList2 = axis2.getTickMarks();
        if (axis == null || axis2 == null) {
            return;
        }
        double d9 = 0.0;
        double d10 = 30.0;
        double d11 = 0.0;
        double d12 = 0.0;
        for (int i = 0; i < 5 && (d8 = axis.prefHeight(d9 = this.snapSize(d3 - (d11 = axis2.prefWidth(d12 = this.snapSize(d4 - d10)))))) != d10; ++i) {
            d10 = d8;
        }
        d9 = Math.ceil(d9);
        d10 = Math.ceil(d10);
        d11 = Math.ceil(d11);
        d12 = Math.ceil(d12);
        double d13 = 0.0;
        switch (axis.getEffectiveSide()) {
            case TOP: {
                axis.setVisible(true);
                d13 = d + 1.0;
                d += d10;
                break;
            }
            case BOTTOM: {
                axis.setVisible(true);
                d13 = d + d12;
            }
        }
        double d14 = 0.0;
        switch (axis2.getEffectiveSide()) {
            case LEFT: {
                axis2.setVisible(true);
                d14 = d2 + 1.0;
                d2 += d11;
                break;
            }
            case RIGHT: {
                axis2.setVisible(true);
                d14 = d2 + d9;
            }
        }
        axis.resizeRelocate(d2, d13, d9, d10);
        axis2.resizeRelocate(d14, d, d11, d12);
        axis.requestAxisLayout();
        axis.layout();
        axis2.requestAxisLayout();
        axis2.layout();
        this.layoutPlotChildren();
        double d15 = axis.getZeroPosition();
        double d16 = axis2.getZeroPosition();
        if (Double.isNaN(d15) || !this.isVerticalZeroLineVisible()) {
            this.verticalZeroLine.setVisible(false);
        } else {
            this.verticalZeroLine.setStartX(d2 + d15 + 0.5);
            this.verticalZeroLine.setStartY(d);
            this.verticalZeroLine.setEndX(d2 + d15 + 0.5);
            this.verticalZeroLine.setEndY(d + d12);
            this.verticalZeroLine.setVisible(true);
        }
        if (Double.isNaN(d16) || !this.isHorizontalZeroLineVisible()) {
            this.horizontalZeroLine.setVisible(false);
        } else {
            this.horizontalZeroLine.setStartX(d2);
            this.horizontalZeroLine.setStartY(d + d16 + 0.5);
            this.horizontalZeroLine.setEndX(d2 + d9);
            this.horizontalZeroLine.setEndY(d + d16 + 0.5);
            this.horizontalZeroLine.setVisible(true);
        }
        this.plotBackground.resizeRelocate(d2, d, d9, d12);
        this.plotAreaClip.setX(d2);
        this.plotAreaClip.setY(d);
        this.plotAreaClip.setWidth(d9 + 1.0);
        this.plotAreaClip.setHeight(d12 + 1.0);
        this.plotContent.setLayoutX(d2);
        this.plotContent.setLayoutY(d);
        this.plotContent.requestLayout();
        this.verticalGridLines.getElements().clear();
        if (this.getVerticalGridLinesVisible()) {
            for (n = 0; n < observableList.size(); ++n) {
                object = (Axis.TickMark)observableList.get(n);
                d7 = axis.getDisplayPosition(((Axis.TickMark)object).getValue());
                if (d7 == d15 && this.isVerticalZeroLineVisible() || !(d7 > 0.0) || !(d7 <= d9)) continue;
                this.verticalGridLines.getElements().add(new MoveTo(d2 + d7 + 0.5, d));
                this.verticalGridLines.getElements().add(new LineTo(d2 + d7 + 0.5, d + d12));
            }
        }
        this.horizontalGridLines.getElements().clear();
        if (this.isHorizontalGridLinesVisible()) {
            for (n = 0; n < observableList2.size(); ++n) {
                object = (Axis.TickMark)observableList2.get(n);
                d7 = axis2.getDisplayPosition(((Axis.TickMark)object).getValue());
                if (d7 == d16 && this.isHorizontalZeroLineVisible() || !(d7 >= 0.0) || !(d7 < d12)) continue;
                this.horizontalGridLines.getElements().add(new MoveTo(d2, d + d7 + 0.5));
                this.horizontalGridLines.getElements().add(new LineTo(d2 + d9, d + d7 + 0.5));
            }
        }
        this.verticalRowFill.getElements().clear();
        if (this.isAlternativeColumnFillVisible()) {
            int n2;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            object = new ArrayList();
            for (n2 = 0; n2 < observableList.size(); ++n2) {
                d6 = axis.getDisplayPosition(((Axis.TickMark)observableList.get(n2)).getValue());
                if (d6 == d15) {
                    arrayList.add(d6);
                    object.add(d6);
                    continue;
                }
                if (d6 < d15) {
                    arrayList.add(d6);
                    continue;
                }
                object.add(d6);
            }
            Collections.sort(arrayList);
            Collections.sort(object);
            for (n2 = 1; n2 < arrayList.size(); n2 += 2) {
                if (n2 + 1 >= arrayList.size()) continue;
                d6 = (Double)arrayList.get(n2);
                d5 = (Double)arrayList.get(n2 + 1);
                this.verticalRowFill.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(d2 + d6, d), new LineTo(d2 + d6, d + d12), new LineTo(d2 + d5, d + d12), new LineTo(d2 + d5, d), new ClosePath()});
            }
            for (n2 = 0; n2 < object.size(); n2 += 2) {
                if (n2 + 1 >= object.size()) continue;
                d6 = (Double)object.get(n2);
                d5 = (Double)object.get(n2 + 1);
                this.verticalRowFill.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(d2 + d6, d), new LineTo(d2 + d6, d + d12), new LineTo(d2 + d5, d + d12), new LineTo(d2 + d5, d), new ClosePath()});
            }
        }
        this.horizontalRowFill.getElements().clear();
        if (this.isAlternativeRowFillVisible()) {
            int n3;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            object = new ArrayList<Double>();
            for (n3 = 0; n3 < observableList2.size(); ++n3) {
                d6 = axis2.getDisplayPosition(((Axis.TickMark)observableList2.get(n3)).getValue());
                if (d6 == d16) {
                    arrayList.add(d6);
                    object.add(d6);
                    continue;
                }
                if (d6 < d16) {
                    arrayList.add(d6);
                    continue;
                }
                object.add(d6);
            }
            Collections.sort(arrayList);
            Collections.sort(object);
            for (n3 = 1; n3 < arrayList.size(); n3 += 2) {
                if (n3 + 1 >= arrayList.size()) continue;
                d6 = (Double)arrayList.get(n3);
                d5 = (Double)arrayList.get(n3 + 1);
                this.horizontalRowFill.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(d2, d + d6), new LineTo(d2 + d9, d + d6), new LineTo(d2 + d9, d + d5), new LineTo(d2, d + d5), new ClosePath()});
            }
            for (n3 = 0; n3 < object.size(); n3 += 2) {
                if (n3 + 1 >= object.size()) continue;
                d6 = (Double)object.get(n3);
                d5 = (Double)object.get(n3 + 1);
                this.horizontalRowFill.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(d2, d + d6), new LineTo(d2 + d9, d + d6), new LineTo(d2 + d9, d + d5), new LineTo(d2, d + d5), new ClosePath()});
            }
        }
    }

    int getSeriesIndex(Series<X, Y> series) {
        int n = 0;
        Series<X, Y> series2 = this.begin;
        while (series2 != null && series2 != series) {
            ++n;
            series2 = series2.next;
        }
        return n;
    }

    int getSeriesSize() {
        int n = 0;
        Series<X, Y> series = this.begin;
        while (series != null) {
            ++n;
            series = series.next;
        }
        return n;
    }

    protected final void removeSeriesFromDisplay(Series<X, Y> series) {
        if (series != null) {
            series.setToRemove = false;
        }
        if (this.begin == series) {
            this.begin = series.next;
        } else {
            Series<X, Y> series2 = this.begin;
            while (series2 != null && series2.next != series) {
                series2 = series2.next;
            }
            if (series2 != null) {
                series2.next = series.next;
            }
        }
    }

    protected final Iterator<Series<X, Y>> getDisplayedSeriesIterator() {
        return new Iterator<Series<X, Y>>(){
            private boolean start = true;
            private Series<X, Y> current;
            {
                this.current = XYChart.this.begin;
            }

            @Override
            public boolean hasNext() {
                if (this.start) {
                    return this.current != null;
                }
                return this.current.next != null;
            }

            @Override
            public Series<X, Y> next() {
                if (this.start) {
                    this.start = false;
                } else if (this.current != null) {
                    this.current = this.current.next;
                }
                return this.current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("We don't support removing items from the displayed series list.");
            }
        };
    }

    protected final X getCurrentDisplayedXValue(Data<X, Y> data) {
        return data.getCurrentX();
    }

    protected final void setCurrentDisplayedXValue(Data<X, Y> data, X x) {
        data.setCurrentX(x);
    }

    protected final ObjectProperty<X> currentDisplayedXValueProperty(Data<X, Y> data) {
        return data.currentXProperty();
    }

    protected final Y getCurrentDisplayedYValue(Data<X, Y> data) {
        return data.getCurrentY();
    }

    protected final void setCurrentDisplayedYValue(Data<X, Y> data, Y y) {
        data.setCurrentY(y);
    }

    protected final ObjectProperty<Y> currentDisplayedYValueProperty(Data<X, Y> data) {
        return data.currentYProperty();
    }

    protected final Object getCurrentDisplayedExtraValue(Data<X, Y> data) {
        return data.getCurrentExtraValue();
    }

    protected final void setCurrentDisplayedExtraValue(Data<X, Y> data, Object object) {
        data.setCurrentExtraValue(object);
    }

    protected final ObjectProperty<Object> currentDisplayedExtraValueProperty(Data<X, Y> data) {
        return data.currentExtraValueProperty();
    }

    protected final Iterator<Data<X, Y>> getDisplayedDataIterator(final Series<X, Y> series) {
        return new Iterator<Data<X, Y>>(){
            private boolean start = true;
            private Data<X, Y> current;
            {
                this.current = series.begin;
            }

            @Override
            public boolean hasNext() {
                if (this.start) {
                    return this.current != null;
                }
                return this.current.next != null;
            }

            @Override
            public Data<X, Y> next() {
                if (this.start) {
                    this.start = false;
                } else if (this.current != null) {
                    this.current = this.current.next;
                }
                return this.current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("We don't support removing items from the displayed data list.");
            }
        };
    }

    protected final void removeDataItemFromDisplay(Series<X, Y> series, Data<X, Y> data) {
        ((Series)series).removeDataItemRef(data);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return XYChart.getClassCssMetaData();
    }

    public static final class Data<X, Y> {
        private boolean setToRemove = false;
        private Series<X, Y> series;
        private ObjectProperty<X> xValue = new ObjectPropertyBase<X>(this){
            final /* synthetic */ Data this$0;
            {
                this.this$0 = data;
            }

            @Override
            protected void invalidated() {
                this.get();
                if (this.this$0.series != null) {
                    XYChart xYChart = this.this$0.series.getChart();
                    if (xYChart != null) {
                        xYChart.dataXValueChanged(this.this$0);
                    }
                } else {
                    this.this$0.setCurrentX(this.get());
                }
            }

            @Override
            public Object getBean() {
                return this.this$0;
            }

            @Override
            public String getName() {
                return "XValue";
            }
        };
        private ObjectProperty<Y> yValue = new ObjectPropertyBase<Y>(this){
            final /* synthetic */ Data this$0;
            {
                this.this$0 = data;
            }

            @Override
            protected void invalidated() {
                this.get();
                if (this.this$0.series != null) {
                    XYChart xYChart = this.this$0.series.getChart();
                    if (xYChart != null) {
                        xYChart.dataYValueChanged(this.this$0);
                    }
                } else {
                    this.this$0.setCurrentY(this.get());
                }
            }

            @Override
            public Object getBean() {
                return this.this$0;
            }

            @Override
            public String getName() {
                return "YValue";
            }
        };
        private ObjectProperty<Object> extraValue = new ObjectPropertyBase<Object>(this){
            final /* synthetic */ Data this$0;
            {
                this.this$0 = data;
            }

            @Override
            protected void invalidated() {
                XYChart xYChart;
                this.get();
                if (this.this$0.series != null && (xYChart = this.this$0.series.getChart()) != null) {
                    xYChart.dataExtraValueChanged(this.this$0);
                }
            }

            @Override
            public Object getBean() {
                return this.this$0;
            }

            @Override
            public String getName() {
                return "extraValue";
            }
        };
        private ObjectProperty<Node> node = new SimpleObjectProperty<Node>(this, "node");
        private ObjectProperty<X> currentX = new SimpleObjectProperty<X>(this, "currentX");
        private ObjectProperty<Y> currentY = new SimpleObjectProperty<Y>(this, "currentY");
        private ObjectProperty<Object> currentExtraValue = new SimpleObjectProperty<Object>(this, "currentExtraValue");
        protected Data<X, Y> next = null;

        void setSeries(Series<X, Y> series) {
            this.series = series;
        }

        public final X getXValue() {
            return (X)this.xValue.get();
        }

        public final void setXValue(X x) {
            this.xValue.set(x);
            if (this.currentX.get() == null || this.series != null && this.series.getChart() == null) {
                this.currentX.setValue(x);
            }
        }

        public final ObjectProperty<X> XValueProperty() {
            return this.xValue;
        }

        public final Y getYValue() {
            return (Y)this.yValue.get();
        }

        public final void setYValue(Y y) {
            this.yValue.set(y);
            if (this.currentY.get() == null || this.series != null && this.series.getChart() == null) {
                this.currentY.setValue(y);
            }
        }

        public final ObjectProperty<Y> YValueProperty() {
            return this.yValue;
        }

        public final Object getExtraValue() {
            return this.extraValue.get();
        }

        public final void setExtraValue(Object object) {
            this.extraValue.set(object);
        }

        public final ObjectProperty<Object> extraValueProperty() {
            return this.extraValue;
        }

        public final Node getNode() {
            return (Node)this.node.get();
        }

        public final void setNode(Node node) {
            this.node.set(node);
        }

        public final ObjectProperty<Node> nodeProperty() {
            return this.node;
        }

        final X getCurrentX() {
            return (X)this.currentX.get();
        }

        final void setCurrentX(X x) {
            this.currentX.set(x);
        }

        final ObjectProperty<X> currentXProperty() {
            return this.currentX;
        }

        final Y getCurrentY() {
            return (Y)this.currentY.get();
        }

        final void setCurrentY(Y y) {
            this.currentY.set(y);
        }

        final ObjectProperty<Y> currentYProperty() {
            return this.currentY;
        }

        final Object getCurrentExtraValue() {
            return this.currentExtraValue.getValue();
        }

        final void setCurrentExtraValue(Object object) {
            this.currentExtraValue.setValue(object);
        }

        final ObjectProperty<Object> currentExtraValueProperty() {
            return this.currentExtraValue;
        }

        public Data() {
        }

        public Data(X x, Y y) {
            this.setXValue(x);
            this.setYValue(y);
            this.setCurrentX(x);
            this.setCurrentY(y);
        }

        public Data(X x, Y y, Object object) {
            this.setXValue(x);
            this.setYValue(y);
            this.setExtraValue(object);
            this.setCurrentX(x);
            this.setCurrentY(y);
            this.setCurrentExtraValue(object);
        }

        public String toString() {
            return "Data[" + this.getXValue() + "," + this.getYValue() + "," + this.getExtraValue() + "]";
        }
    }

    public static final class Series<X, Y> {
        String defaultColorStyleClass;
        boolean setToRemove = false;
        Data<X, Y> begin = null;
        Series<X, Y> next = null;
        private final ListChangeListener<Data<X, Y>> dataChangeListener = new ListChangeListener<Data<X, Y>>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Data<X, Y>> change) {
                XYChart xYChart = this.getChart();
                while (change.next()) {
                    int n;
                    Data data4;
                    Data data2;
                    if (change.wasPermutated()) {
                        data2 = this;
                        if (data2 == null || ((Series)((Object)data2)).getData() == null) {
                            return;
                        }
                        data4 = begin;
                        for (n = 0; n < ((Series)((Object)data2)).getData().size(); ++n) {
                            Data data3 = (Data)((Series)((Object)data2)).getData().get(n);
                            if (n == 0) {
                                data4 = begin = data3;
                                begin.next = null;
                                continue;
                            }
                            data4.next = data3;
                            data3.next = null;
                            data4 = data3;
                        }
                        return;
                    }
                    for (Data data4 : change.getRemoved()) {
                        data4.setToRemove = true;
                    }
                    if (change.getAddedSize() > 0) {
                        data2 = begin;
                        while (data2 != null) {
                            if (data2.setToRemove) {
                                if (xYChart != null) {
                                    xYChart.dataBeingRemovedIsAdded(data2, this);
                                }
                                data2.setToRemove = false;
                            }
                            data2 = data2.next;
                        }
                    }
                    for (int i = change.getFrom(); i < change.getTo(); ++i) {
                        ((Data)this.getData().get(i)).setSeries(this);
                        if (begin == null) {
                            begin = (Data)this.getData().get(i);
                            begin.next = null;
                            continue;
                        }
                        if (i == 0) {
                            ((Data)this.getData().get((int)0)).next = begin;
                            begin = (Data)this.getData().get(0);
                            continue;
                        }
                        data4 = begin;
                        for (n = 0; n < i - 1; ++n) {
                            data4 = data4.next;
                        }
                        ((Data)this.getData().get((int)i)).next = data4.next;
                        data4.next = (Data)this.getData().get(i);
                    }
                    data2 = this.checkCycleInList();
                    if (data2 != null && !data2.setToRemove) {
                        this.eliminateLoop(data2);
                        throw new IllegalArgumentException("Duplicate data added or same data added to more than one chart ");
                    }
                    if (xYChart == null) continue;
                    xYChart.dataItemsChanged(this, change.getRemoved(), change.getFrom(), change.getTo(), change.wasPermutated());
                }
            }
        };
        private final ReadOnlyObjectWrapper<XYChart<X, Y>> chart = new ReadOnlyObjectWrapper(this, "chart");
        private final StringProperty name = new StringPropertyBase(){

            @Override
            protected void invalidated() {
                this.get();
                if (this.getChart() != null) {
                    this.getChart().seriesNameChanged();
                }
            }

            @Override
            public Object getBean() {
                return this;
            }

            @Override
            public String getName() {
                return "name";
            }
        };
        private ObjectProperty<Node> node = new SimpleObjectProperty<Node>(this, "node");
        private final ObjectProperty<ObservableList<Data<X, Y>>> data = new ObjectPropertyBase<ObservableList<Data<X, Y>>>(){
            private ObservableList<Data<X, Y>> old;

            @Override
            protected void invalidated() {
                ObservableList observableList = (ObservableList)this.getValue();
                if (this.old != null) {
                    this.old.removeListener(dataChangeListener);
                }
                if (observableList != null) {
                    observableList.addListener(dataChangeListener);
                }
                if (this.old != null || observableList != null) {
                    int n;
                    final List list = this.old != null ? this.old : Collections.emptyList();
                    int n2 = n = observableList != null ? observableList.size() : 0;
                    if (n > 0 || !list.isEmpty()) {
                        dataChangeListener.onChanged(new NonIterableChange<Data<X, Y>>(0, n, observableList){

                            @Override
                            public List<Data<X, Y>> getRemoved() {
                                return list;
                            }

                            @Override
                            protected int[] getPermutation() {
                                return new int[0];
                            }
                        });
                    }
                } else if (this.old != null && this.old.size() > 0) {
                    dataChangeListener.onChanged(new NonIterableChange<Data<X, Y>>(0, 0, observableList){

                        @Override
                        public List<Data<X, Y>> getRemoved() {
                            return old;
                        }

                        @Override
                        protected int[] getPermutation() {
                            return new int[0];
                        }
                    });
                }
                this.old = observableList;
            }

            @Override
            public Object getBean() {
                return this;
            }

            @Override
            public String getName() {
                return "data";
            }
        };

        private Data<X, Y> checkCycleInList() {
            Data<X, Y> data = null;
            Data<X, Y> data2 = null;
            data = data2 = this.begin;
            while (data != null && data2 != null) {
                data2 = data2.next;
                if (data2 == data) {
                    return data;
                }
                if (data2 == null) {
                    return null;
                }
                data2 = data2.next;
                if (data2 == data) {
                    return data2;
                }
                data = data.next;
            }
            return null;
        }

        private void eliminateLoop(Data<X, Y> data) {
            Data<X, Y> data2 = data;
            Data<X, Y> data3 = this.begin;
            while (data3.next != data2.next) {
                data3 = data3.next;
                data2 = data2.next;
            }
            Data data4 = data3.next;
            data3 = data4;
            while (data3.next != data4) {
                data3 = data3.next;
            }
            data3.next = null;
        }

        public final XYChart<X, Y> getChart() {
            return (XYChart)this.chart.get();
        }

        private void setChart(XYChart<X, Y> xYChart) {
            this.chart.set(xYChart);
        }

        public final ReadOnlyObjectProperty<XYChart<X, Y>> chartProperty() {
            return this.chart.getReadOnlyProperty();
        }

        public final String getName() {
            return (String)this.name.get();
        }

        public final void setName(String string) {
            this.name.set(string);
        }

        public final StringProperty nameProperty() {
            return this.name;
        }

        public final Node getNode() {
            return (Node)this.node.get();
        }

        public final void setNode(Node node) {
            this.node.set(node);
        }

        public final ObjectProperty<Node> nodeProperty() {
            return this.node;
        }

        public final ObservableList<Data<X, Y>> getData() {
            return (ObservableList)this.data.getValue();
        }

        public final void setData(ObservableList<Data<X, Y>> observableList) {
            this.data.setValue(observableList);
        }

        public final ObjectProperty<ObservableList<Data<X, Y>>> dataProperty() {
            return this.data;
        }

        public Series() {
            this(FXCollections.observableArrayList());
        }

        public Series(ObservableList<Data<X, Y>> observableList) {
            this.setData(observableList);
            for (Data data : observableList) {
                data.setSeries(this);
            }
        }

        public Series(String string, ObservableList<Data<X, Y>> observableList) {
            this(observableList);
            this.setName(string);
        }

        public String toString() {
            return "Series[" + this.getName() + "]";
        }

        private void removeDataItemRef(Data<X, Y> data) {
            if (data != null) {
                ((Data)data).setToRemove = false;
            }
            if (this.begin == data) {
                this.begin = data.next;
            } else {
                Data<X, Y> data2 = this.begin;
                while (data2 != null && data2.next != data) {
                    data2 = data2.next;
                }
                if (data2 != null) {
                    data2.next = data.next;
                }
            }
        }

        int getItemIndex(Data<X, Y> data) {
            int n = 0;
            Data<X, Y> data2 = this.begin;
            while (data2 != null && data2 != data) {
                ++n;
                data2 = data2.next;
            }
            return n;
        }

        int getDataSize() {
            int n = 0;
            Data<X, Y> data = this.begin;
            while (data != null) {
                ++n;
                data = data.next;
            }
            return n;
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<XYChart<?, ?>, Boolean> HORIZONTAL_GRID_LINE_VISIBLE = new CssMetaData<XYChart<?, ?>, Boolean>("-fx-horizontal-grid-lines-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(XYChart<?, ?> xYChart) {
                return ((XYChart)xYChart).horizontalGridLinesVisible == null || !((XYChart)xYChart).horizontalGridLinesVisible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(XYChart<?, ?> xYChart) {
                return (StyleableProperty)((Object)xYChart.horizontalGridLinesVisibleProperty());
            }
        };
        private static final CssMetaData<XYChart<?, ?>, Boolean> HORIZONTAL_ZERO_LINE_VISIBLE = new CssMetaData<XYChart<?, ?>, Boolean>("-fx-horizontal-zero-line-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(XYChart<?, ?> xYChart) {
                return ((XYChart)xYChart).horizontalZeroLineVisible == null || !((XYChart)xYChart).horizontalZeroLineVisible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(XYChart<?, ?> xYChart) {
                return (StyleableProperty)((Object)xYChart.horizontalZeroLineVisibleProperty());
            }
        };
        private static final CssMetaData<XYChart<?, ?>, Boolean> ALTERNATIVE_ROW_FILL_VISIBLE = new CssMetaData<XYChart<?, ?>, Boolean>("-fx-alternative-row-fill-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(XYChart<?, ?> xYChart) {
                return ((XYChart)xYChart).alternativeRowFillVisible == null || !((XYChart)xYChart).alternativeRowFillVisible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(XYChart<?, ?> xYChart) {
                return (StyleableProperty)((Object)xYChart.alternativeRowFillVisibleProperty());
            }
        };
        private static final CssMetaData<XYChart<?, ?>, Boolean> VERTICAL_GRID_LINE_VISIBLE = new CssMetaData<XYChart<?, ?>, Boolean>("-fx-vertical-grid-lines-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(XYChart<?, ?> xYChart) {
                return ((XYChart)xYChart).verticalGridLinesVisible == null || !((XYChart)xYChart).verticalGridLinesVisible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(XYChart<?, ?> xYChart) {
                return (StyleableProperty)((Object)xYChart.verticalGridLinesVisibleProperty());
            }
        };
        private static final CssMetaData<XYChart<?, ?>, Boolean> VERTICAL_ZERO_LINE_VISIBLE = new CssMetaData<XYChart<?, ?>, Boolean>("-fx-vertical-zero-line-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(XYChart<?, ?> xYChart) {
                return ((XYChart)xYChart).verticalZeroLineVisible == null || !((XYChart)xYChart).verticalZeroLineVisible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(XYChart<?, ?> xYChart) {
                return (StyleableProperty)((Object)xYChart.verticalZeroLineVisibleProperty());
            }
        };
        private static final CssMetaData<XYChart<?, ?>, Boolean> ALTERNATIVE_COLUMN_FILL_VISIBLE = new CssMetaData<XYChart<?, ?>, Boolean>("-fx-alternative-column-fill-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(XYChart<?, ?> xYChart) {
                return ((XYChart)xYChart).alternativeColumnFillVisible == null || !((XYChart)xYChart).alternativeColumnFillVisible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(XYChart<?, ?> xYChart) {
                return (StyleableProperty)((Object)xYChart.alternativeColumnFillVisibleProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList arrayList = new ArrayList(Chart.getClassCssMetaData());
            arrayList.add(HORIZONTAL_GRID_LINE_VISIBLE);
            arrayList.add(HORIZONTAL_ZERO_LINE_VISIBLE);
            arrayList.add(ALTERNATIVE_ROW_FILL_VISIBLE);
            arrayList.add(VERTICAL_GRID_LINE_VISIBLE);
            arrayList.add(VERTICAL_ZERO_LINE_VISIBLE);
            arrayList.add(ALTERNATIVE_COLUMN_FILL_VISIBLE);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

