/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.Logging;
import com.sun.javafx.css.CssError;
import com.sun.javafx.css.FontFace;
import com.sun.javafx.css.Rule;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.SelectorPartitioning;
import com.sun.javafx.css.StyleCache;
import com.sun.javafx.css.StyleClassSet;
import com.sun.javafx.css.StyleConverterImpl;
import com.sun.javafx.css.StyleMap;
import com.sun.javafx.css.Stylesheet;
import com.sun.javafx.css.parser.CSSParser;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javafx.application.Application;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SubScene;
import javafx.scene.image.Image;
import javafx.scene.text.Font;
import javafx.stage.Window;
import sun.util.logging.PlatformLogger;

public final class StyleManager {
    private static PlatformLogger LOGGER;
    static final Map<Parent, CacheContainer> cacheContainerMap;
    final List<StylesheetContainer> userAgentStylesheetContainers = new ArrayList<StylesheetContainer>();
    final List<StylesheetContainer> platformUserAgentStylesheetContainers = new ArrayList<StylesheetContainer>();
    boolean hasDefaultUserAgentStylesheet = false;
    final Map<String, StylesheetContainer> stylesheetContainerMap = new HashMap<String, StylesheetContainer>();
    final Map<String, Image> imageCache = new HashMap<String, Image>();
    private Key key = null;
    private static ObservableList<CssError> errors;
    private static List<String> cacheMapKey;

    private static PlatformLogger getLogger() {
        if (LOGGER == null) {
            LOGGER = Logging.getCSSLogger();
        }
        return LOGGER;
    }

    public static StyleManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private StyleManager() {
    }

    CacheContainer getCacheContainer(Styleable styleable, SubScene subScene) {
        Object object;
        if (styleable == null && subScene == null) {
            return null;
        }
        Parent parent = null;
        if (subScene != null) {
            parent = subScene.getRoot();
        } else if (styleable instanceof Node) {
            object = (Node)styleable;
            Scene scene = ((Node)object).getScene();
            if (scene != null) {
                parent = scene.getRoot();
            }
        } else if (styleable instanceof Window && (object = ((Window)((Object)styleable)).getScene()) != null) {
            parent = ((Scene)object).getRoot();
        }
        if (parent == null) {
            return null;
        }
        object = cacheContainerMap.get(parent);
        if (object == null) {
            object = new CacheContainer();
            cacheContainerMap.put(parent, (CacheContainer)object);
        }
        return object;
    }

    public StyleCache getSharedCache(Styleable styleable, SubScene subScene, StyleCache.Key key) {
        CacheContainer cacheContainer = this.getCacheContainer(styleable, subScene);
        if (cacheContainer == null) {
            return null;
        }
        Map map = cacheContainer.getStyleCache();
        if (map == null) {
            return null;
        }
        StyleCache styleCache = (StyleCache)map.get(key);
        if (styleCache == null) {
            styleCache = new StyleCache();
            map.put(new StyleCache.Key(key), styleCache);
        }
        return styleCache;
    }

    public StyleMap getStyleMap(Styleable styleable, SubScene subScene, int n) {
        if (n == -1) {
            return StyleMap.EMPTY_MAP;
        }
        CacheContainer cacheContainer = this.getCacheContainer(styleable, subScene);
        if (cacheContainer == null) {
            return StyleMap.EMPTY_MAP;
        }
        return cacheContainer.getStyleMap(n);
    }

    public void forget(Scene scene) {
        Object object;
        if (scene == null) {
            return;
        }
        this.forget(scene.getRoot());
        String string = null;
        if (scene.getUserAgentStylesheet() != null && !(string = scene.getUserAgentStylesheet().trim()).isEmpty()) {
            int n = this.userAgentStylesheetContainers.size();
            for (int i = 0; i < n; ++i) {
                object = this.userAgentStylesheetContainers.get(i);
                if (!string.equals(((StylesheetContainer)object).fname)) continue;
                ((StylesheetContainer)object).parentUsers.remove(scene.getRoot());
                if (((StylesheetContainer)object).parentUsers.list.size() != 0) continue;
                this.userAgentStylesheetContainers.remove(i);
            }
        }
        Set<Map.Entry<String, StylesheetContainer>> set = this.stylesheetContainerMap.entrySet();
        Iterator<Map.Entry<String, StylesheetContainer>> iterator = set.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            StylesheetContainer stylesheetContainer = object.getValue();
            Iterator iterator2 = stylesheetContainer.parentUsers.list.iterator();
            while (iterator2.hasNext()) {
                Reference reference = iterator2.next();
                Parent parent = (Parent)reference.get();
                if (parent != null && parent.getScene() != scene && parent.getScene() != null) continue;
                reference.clear();
                iterator2.remove();
            }
            if (!stylesheetContainer.parentUsers.list.isEmpty()) continue;
            iterator.remove();
        }
    }

    public void stylesheetsChanged(Scene scene, ListChangeListener.Change<String> change) {
        Object object;
        Set<Map.Entry<Parent, CacheContainer>> set = cacheContainerMap.entrySet();
        for (Map.Entry<Parent, CacheContainer> object2 : set) {
            object = object2.getKey();
            CacheContainer cacheContainer = object2.getValue();
            if (((Node)object).getScene() != scene) continue;
            cacheContainer.clearCache();
        }
        change.reset();
        while (change.next()) {
            if (!change.wasRemoved()) continue;
            for (String string : change.getRemoved()) {
                this.stylesheetRemoved(scene, string);
                object = this.stylesheetContainerMap.get(string);
                if (object == null) continue;
                ((StylesheetContainer)object).invalidateChecksum();
            }
        }
    }

    private void stylesheetRemoved(Scene scene, String string) {
        this.stylesheetRemoved(scene.getRoot(), string);
    }

    public void forget(Parent parent) {
        Iterator iterator;
        ObservableList<String> observableList;
        if (parent == null) {
            return;
        }
        Set<Map.Entry<Parent, CacheContainer>> set = cacheContainerMap.entrySet();
        Iterator<Map.Entry<Parent, CacheContainer>> iterator2 = set.iterator();
        while (iterator2.hasNext()) {
            observableList = iterator2.next();
            iterator = (Parent)observableList.getKey();
            CacheContainer object2 = (CacheContainer)observableList.getValue();
            if (parent != iterator) continue;
            iterator2.remove();
            object2.clearCache();
        }
        observableList = parent.getStylesheets();
        if (observableList != null && !observableList.isEmpty()) {
            for (String string : observableList) {
                this.stylesheetRemoved(parent, string);
            }
        }
        iterator = this.stylesheetContainerMap.values().iterator();
        while (iterator.hasNext()) {
            StylesheetContainer stylesheetContainer = (StylesheetContainer)iterator.next();
            stylesheetContainer.parentUsers.remove(parent);
            if (!stylesheetContainer.parentUsers.list.isEmpty()) continue;
            iterator.remove();
            if (stylesheetContainer.selectorPartitioning != null) {
                stylesheetContainer.selectorPartitioning.reset();
            }
            String string = stylesheetContainer.fname;
            this.cleanUpImageCache(string);
        }
    }

    public void stylesheetsChanged(Parent parent, ListChangeListener.Change<String> change) {
        change.reset();
        while (change.next()) {
            if (!change.wasRemoved()) continue;
            for (String string : change.getRemoved()) {
                this.stylesheetRemoved(parent, string);
                StylesheetContainer stylesheetContainer = this.stylesheetContainerMap.get(string);
                if (stylesheetContainer == null) continue;
                stylesheetContainer.invalidateChecksum();
            }
        }
    }

    private void stylesheetRemoved(Parent parent, String string) {
        StylesheetContainer stylesheetContainer = this.stylesheetContainerMap.get(string);
        if (stylesheetContainer == null) {
            return;
        }
        stylesheetContainer.parentUsers.remove(parent);
        if (stylesheetContainer.parentUsers.list.isEmpty()) {
            this.removeStylesheetContainer(stylesheetContainer);
        }
    }

    public void forget(SubScene subScene) {
        if (subScene == null) {
            return;
        }
        Parent parent = subScene.getRoot();
        if (parent == null) {
            return;
        }
        this.forget(parent);
        String string = null;
        if (subScene.getUserAgentStylesheet() != null && !(string = subScene.getUserAgentStylesheet().trim()).isEmpty()) {
            int n = this.userAgentStylesheetContainers.size();
            for (int i = 0; i < n; ++i) {
                StylesheetContainer object = this.userAgentStylesheetContainers.get(i);
                if (!string.equals(object.fname)) continue;
                object.parentUsers.remove(subScene.getRoot());
                if (object.parentUsers.list.size() != 0) continue;
                this.userAgentStylesheetContainers.remove(i);
            }
        }
        Set<Map.Entry<String, StylesheetContainer>> set = this.stylesheetContainerMap.entrySet();
        for (Map.Entry<String, StylesheetContainer> entry : set) {
            StylesheetContainer stylesheetContainer = entry.getValue();
            Iterator iterator = stylesheetContainer.parentUsers.list.iterator();
            block2: while (iterator.hasNext()) {
                Reference reference = iterator.next();
                Parent parent2 = (Parent)reference.get();
                if (parent2 == null) continue;
                for (Parent parent3 = parent2; parent3 != null; parent3 = parent3.getParent()) {
                    if (parent != parent3.getParent()) continue;
                    reference.clear();
                    iterator.remove();
                    this.forget(parent2);
                    continue block2;
                }
            }
        }
    }

    private void removeStylesheetContainer(StylesheetContainer stylesheetContainer) {
        Object object;
        Object object2;
        if (stylesheetContainer == null) {
            return;
        }
        String string = stylesheetContainer.fname;
        this.stylesheetContainerMap.remove(string);
        if (stylesheetContainer.selectorPartitioning != null) {
            stylesheetContainer.selectorPartitioning.reset();
        }
        for (Map.Entry<Parent, CacheContainer> entry : cacheContainerMap.entrySet()) {
            Object object3;
            object2 = entry.getValue();
            if (object2 == null || ((CacheContainer)object2).cacheMap == null || ((CacheContainer)object2).cacheMap.isEmpty()) continue;
            object = new ArrayList();
            for (Map.Entry entry2 : ((CacheContainer)object2).cacheMap.entrySet()) {
                object3 = (List)entry2.getKey();
                if (!(object3 != null ? object3.contains(string) : string == null)) continue;
                object.add(object3);
            }
            if (object.isEmpty()) continue;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry2;
                entry2 = (List)((Object)iterator.next());
                object3 = (Map)((CacheContainer)object2).cacheMap.remove(entry2);
                if (object3 == null) continue;
                object3.clear();
            }
        }
        this.cleanUpImageCache(string);
        List list = stylesheetContainer.parentUsers.list;
        for (int i = list.size() - 1; 0 <= i; --i) {
            object2 = (Reference)list.remove(i);
            object = (Parent)((Reference)object2).get();
            ((Reference)object2).clear();
            if (object == null || ((Node)object).getScene() == null) continue;
            ((Node)object).impl_reapplyCSS();
        }
    }

    public Image getCachedImage(String string) {
        Image image;
        block8: {
            image = null;
            if (this.imageCache.containsKey(string)) {
                image = this.imageCache.get(string);
            } else {
                try {
                    image = new Image(string);
                    if (image.isError()) {
                        PlatformLogger platformLogger = StyleManager.getLogger();
                        if (platformLogger != null && platformLogger.isLoggable(PlatformLogger.Level.WARNING)) {
                            platformLogger.warning("Error loading image: " + string);
                        }
                        image = null;
                    }
                    this.imageCache.put(string, image);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    PlatformLogger platformLogger = StyleManager.getLogger();
                    if (platformLogger != null && platformLogger.isLoggable(PlatformLogger.Level.WARNING)) {
                        platformLogger.warning(illegalArgumentException.getLocalizedMessage());
                    }
                }
                catch (NullPointerException nullPointerException) {
                    PlatformLogger platformLogger = StyleManager.getLogger();
                    if (platformLogger == null || !platformLogger.isLoggable(PlatformLogger.Level.WARNING)) break block8;
                    platformLogger.warning(nullPointerException.getLocalizedMessage());
                }
            }
        }
        return image;
    }

    private void cleanUpImageCache(String string) {
        if (string == null && this.imageCache.isEmpty()) {
            return;
        }
        String string2 = string.trim();
        if (string2.isEmpty()) {
            return;
        }
        int n = string2.lastIndexOf(47);
        String string3 = n > 0 ? string2.substring(0, n) : string2;
        int n2 = string3.length();
        String[] stringArray = new String[this.imageCache.size()];
        int n3 = 0;
        Set<Map.Entry<String, Image>> set = this.imageCache.entrySet();
        for (Map.Entry<String, Image> entry : set) {
            String string4 = entry.getKey();
            n = string4.lastIndexOf(47);
            String string5 = n > 0 ? string4.substring(0, n) : string4;
            int n4 = string5.length();
            boolean bl = n4 > n2 ? string5.startsWith(string3) : string3.startsWith(string5);
            if (!bl) continue;
            stringArray[n3++] = string4;
        }
        for (int i = 0; i < n3; ++i) {
            Map.Entry<String, Image> entry;
            entry = this.imageCache.remove(stringArray[i]);
        }
    }

    private static URL getURL(String string) {
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        try {
            URI uRI = new URI(string.trim());
            if (!uRI.isAbsolute()) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                String string2 = uRI.getPath();
                URL uRL = null;
                uRL = string2.startsWith("/") ? classLoader.getResource(string2.substring(1)) : classLoader.getResource(string2);
                return uRL;
            }
            return uRI.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] calculateCheckSum(String string) {
        if (string == null) return new byte[0];
        if (string.isEmpty()) {
            return new byte[0];
        }
        try {
            URL uRL = StyleManager.getURL(string);
            if (uRL == null) return new byte[0];
            if (!"file".equals(uRL.getProtocol())) return new byte[0];
            try (InputStream inputStream = uRL.openStream();){
                DigestInputStream digestInputStream = new DigestInputStream(inputStream, MessageDigest.getInstance("MD5"));
                while (digestInputStream.read() != -1) {
                }
                byte[] byArray = digestInputStream.getMessageDigest().digest();
                return byArray;
            }
        }
        catch (IOException | IllegalArgumentException | SecurityException | NoSuchAlgorithmException exception) {
            // empty catch block
        }
        return new byte[0];
    }

    private static Stylesheet loadStylesheet(String string) {
        try {
            return StyleManager.loadStylesheetUnPrivileged(string);
        }
        catch (AccessControlException accessControlException) {
            if (StyleManager.getLogger().isLoggable(PlatformLogger.Level.INFO)) {
                StyleManager.getLogger().info("Could not load the stylesheet, trying with FilePermissions : " + string);
            }
            if (string.length() < 7 && string.indexOf("!/") < string.length() - 7) {
                return null;
            }
            try {
                String string2;
                String string3;
                URI uRI;
                String string4;
                URI uRI2 = new URI(string);
                if ("jar".equals(uRI2.getScheme()) && (string4 = (uRI = AccessController.doPrivileged(() -> StyleManager.class.getProtectionDomain().getCodeSource().getLocation().toURI())).getSchemeSpecificPart()).equals(string3 = (string2 = uRI2.getSchemeSpecificPart()).substring(string2.indexOf(47), string2.indexOf("!/")))) {
                    String string5 = string.substring(string.indexOf("!/") + 2);
                    if (string.endsWith(".css") || string.endsWith(".bss")) {
                        JarEntry jarEntry;
                        FilePermission filePermission = new FilePermission(string4, "read");
                        PermissionCollection permissionCollection = filePermission.newPermissionCollection();
                        permissionCollection.add(filePermission);
                        AccessControlContext accessControlContext = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissionCollection)});
                        JarFile jarFile = null;
                        try {
                            jarFile = AccessController.doPrivileged(() -> new JarFile(string4), accessControlContext);
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            return null;
                        }
                        if (jarFile != null && (jarEntry = jarFile.getJarEntry(string5)) != null) {
                            return AccessController.doPrivileged(() -> StyleManager.loadStylesheetUnPrivileged(string), accessControlContext);
                        }
                    }
                }
                return null;
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
            catch (PrivilegedActionException privilegedActionException) {
                return null;
            }
        }
    }

    private static Stylesheet loadStylesheetUnPrivileged(String string) {
        block20: {
            Boolean bl = AccessController.doPrivileged(() -> {
                String string2 = System.getProperty("binary.css");
                return !string.endsWith(".bss") && string2 != null ? !Boolean.valueOf(string2).booleanValue() : Boolean.FALSE;
            });
            try {
                Object object;
                String string2 = bl != false ? ".css" : ".bss";
                URL uRL = null;
                Stylesheet stylesheet = null;
                if (!string.endsWith(".css") && !string.endsWith(".bss")) {
                    uRL = StyleManager.getURL(string);
                    bl = true;
                } else {
                    object = string.substring(0, string.length() - 4);
                    uRL = StyleManager.getURL((String)object + string2);
                    if (uRL == null && (bl = Boolean.valueOf(bl == false)).booleanValue()) {
                        uRL = StyleManager.getURL((String)object + ".css");
                    }
                    if (uRL != null && !bl.booleanValue()) {
                        try {
                            stylesheet = Stylesheet.loadBinary(uRL);
                        }
                        catch (IOException iOException) {
                            stylesheet = null;
                        }
                        if (stylesheet == null && (bl = Boolean.valueOf(bl == false)).booleanValue()) {
                            uRL = StyleManager.getURL(string);
                        }
                    }
                }
                if (uRL != null && bl.booleanValue()) {
                    stylesheet = CSSParser.getInstance().parse(uRL);
                }
                if (stylesheet == null) {
                    if (errors != null) {
                        object = new CssError("Resource \"" + string + "\" not found.");
                        errors.add((CssError)object);
                    }
                    if (StyleManager.getLogger().isLoggable(PlatformLogger.Level.WARNING)) {
                        StyleManager.getLogger().warning(String.format("Resource \"%s\" not found.", string));
                    }
                }
                if (stylesheet != null) {
                    block5: for (FontFace fontFace : stylesheet.getFontFaces()) {
                        for (FontFace.FontFaceSrc fontFaceSrc : fontFace.getSources()) {
                            if (fontFaceSrc.getType() != FontFace.FontFaceSrcType.URL) continue;
                            Font font = Font.loadFont(fontFaceSrc.getSrc(), 10.0);
                            if (font != null) continue block5;
                            StyleManager.getLogger().info("Could not load @font-face font [" + fontFaceSrc.getSrc() + "]");
                            continue block5;
                        }
                    }
                }
                return stylesheet;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (errors != null) {
                    CssError cssError = new CssError("Stylesheet \"" + string + "\" not found.");
                    errors.add(cssError);
                }
                if (StyleManager.getLogger().isLoggable(PlatformLogger.Level.INFO)) {
                    StyleManager.getLogger().info("Could not find stylesheet: " + string);
                }
            }
            catch (IOException iOException) {
                if (errors != null) {
                    CssError cssError = new CssError("Could not load stylesheet: " + string);
                    errors.add(cssError);
                }
                if (!StyleManager.getLogger().isLoggable(PlatformLogger.Level.INFO)) break block20;
                StyleManager.getLogger().info("Could not load stylesheet: " + string);
            }
        }
        return null;
    }

    public void addUserAgentStylesheet(String string) {
        this.addUserAgentStylesheet(null, string);
    }

    public void addUserAgentStylesheet(Scene scene, String string) {
        if (string == null) {
            throw new IllegalArgumentException("null arg url");
        }
        String string2 = string.trim();
        if (string2.isEmpty()) {
            return;
        }
        int n = this.platformUserAgentStylesheetContainers.size();
        for (int i = 0; i < n; ++i) {
            StylesheetContainer stylesheetContainer = this.platformUserAgentStylesheetContainers.get(i);
            if (!string2.equals(stylesheetContainer.fname)) continue;
            return;
        }
        CssError.setCurrentScene(scene);
        Stylesheet stylesheet = StyleManager.loadStylesheet(string2);
        this.platformUserAgentStylesheetContainers.add(new StylesheetContainer(string2, stylesheet));
        if (stylesheet != null) {
            stylesheet.setOrigin(StyleOrigin.USER_AGENT);
        }
        this.userAgentStylesheetsChanged();
        CssError.setCurrentScene(null);
    }

    public void addUserAgentStylesheet(Scene scene, Stylesheet stylesheet) {
        if (stylesheet == null) {
            throw new IllegalArgumentException("null arg ua_stylesheet");
        }
        String string = stylesheet.getUrl();
        String string2 = string != null ? string.trim() : "";
        int n = this.platformUserAgentStylesheetContainers.size();
        for (int i = 0; i < n; ++i) {
            StylesheetContainer stylesheetContainer = this.platformUserAgentStylesheetContainers.get(i);
            if (!string2.equals(stylesheetContainer.fname)) continue;
            return;
        }
        CssError.setCurrentScene(scene);
        this.platformUserAgentStylesheetContainers.add(new StylesheetContainer(string2, stylesheet));
        if (stylesheet != null) {
            stylesheet.setOrigin(StyleOrigin.USER_AGENT);
        }
        this.userAgentStylesheetsChanged();
        CssError.setCurrentScene(null);
    }

    public void setDefaultUserAgentStylesheet(String string) {
        this.setDefaultUserAgentStylesheet(null, string);
    }

    public void setDefaultUserAgentStylesheet(Scene scene, String string) {
        String string2;
        String string3 = string2 = string != null ? string.trim() : null;
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("null arg url");
        }
        int n = this.platformUserAgentStylesheetContainers.size();
        for (int i = 0; i < n; ++i) {
            StylesheetContainer stylesheetContainer = this.platformUserAgentStylesheetContainers.get(i);
            if (!string2.equals(stylesheetContainer.fname)) continue;
            if (i > 0) {
                this.platformUserAgentStylesheetContainers.remove(i);
                if (this.hasDefaultUserAgentStylesheet) {
                    this.platformUserAgentStylesheetContainers.set(0, stylesheetContainer);
                } else {
                    this.platformUserAgentStylesheetContainers.add(0, stylesheetContainer);
                }
            }
            return;
        }
        CssError.setCurrentScene(scene);
        Stylesheet stylesheet = StyleManager.loadStylesheet(string2);
        StylesheetContainer stylesheetContainer = new StylesheetContainer(string2, stylesheet);
        if (this.platformUserAgentStylesheetContainers.size() == 0) {
            this.platformUserAgentStylesheetContainers.add(stylesheetContainer);
        } else if (this.hasDefaultUserAgentStylesheet) {
            this.platformUserAgentStylesheetContainers.set(0, stylesheetContainer);
        } else {
            this.platformUserAgentStylesheetContainers.add(0, stylesheetContainer);
        }
        this.hasDefaultUserAgentStylesheet = true;
        if (stylesheet != null) {
            stylesheet.setOrigin(StyleOrigin.USER_AGENT);
        }
        this.userAgentStylesheetsChanged();
        CssError.setCurrentScene(null);
    }

    public void removeUserAgentStylesheet(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null arg url");
        }
        String string2 = string.trim();
        if (string2.isEmpty()) {
            return;
        }
        boolean bl = false;
        for (int i = this.platformUserAgentStylesheetContainers.size() - 1; i >= 0; --i) {
            if (string2.equals(Application.getUserAgentStylesheet())) continue;
            StylesheetContainer stylesheetContainer = this.platformUserAgentStylesheetContainers.get(i);
            if (!string2.equals(stylesheetContainer.fname)) continue;
            this.platformUserAgentStylesheetContainers.remove(i);
            bl = true;
        }
        if (bl) {
            this.userAgentStylesheetsChanged();
        }
    }

    public void setDefaultUserAgentStylesheet(Stylesheet stylesheet) {
        if (stylesheet == null) {
            throw new IllegalArgumentException("null arg ua_stylesheet");
        }
        String string = stylesheet.getUrl();
        String string2 = string != null ? string.trim() : "";
        int n = this.platformUserAgentStylesheetContainers.size();
        for (int i = 0; i < n; ++i) {
            StylesheetContainer stylesheetContainer = this.platformUserAgentStylesheetContainers.get(i);
            if (!string2.equals(stylesheetContainer.fname)) continue;
            if (i > 0) {
                this.platformUserAgentStylesheetContainers.remove(i);
                if (this.hasDefaultUserAgentStylesheet) {
                    this.platformUserAgentStylesheetContainers.set(0, stylesheetContainer);
                } else {
                    this.platformUserAgentStylesheetContainers.add(0, stylesheetContainer);
                }
            }
            return;
        }
        StylesheetContainer stylesheetContainer = new StylesheetContainer(string2, stylesheet);
        if (this.platformUserAgentStylesheetContainers.size() == 0) {
            this.platformUserAgentStylesheetContainers.add(stylesheetContainer);
        } else if (this.hasDefaultUserAgentStylesheet) {
            this.platformUserAgentStylesheetContainers.set(0, stylesheetContainer);
        } else {
            this.platformUserAgentStylesheetContainers.add(0, stylesheetContainer);
        }
        this.hasDefaultUserAgentStylesheet = true;
        stylesheet.setOrigin(StyleOrigin.USER_AGENT);
        this.userAgentStylesheetsChanged();
        CssError.setCurrentScene(null);
    }

    private void userAgentStylesheetsChanged() {
        for (CacheContainer object : cacheContainerMap.values()) {
            object.clearCache();
        }
        StyleConverterImpl.clearCache();
        for (Parent parent : cacheContainerMap.keySet()) {
            if (parent == null) continue;
            parent.impl_reapplyCSS();
        }
    }

    private List<StylesheetContainer> processStylesheets(List<String> list, Parent parent) {
        ArrayList<StylesheetContainer> arrayList = new ArrayList<StylesheetContainer>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            String string = list.get(i);
            StylesheetContainer stylesheetContainer = null;
            if (this.stylesheetContainerMap.containsKey(string)) {
                stylesheetContainer = this.stylesheetContainerMap.get(string);
                if (!arrayList.contains(stylesheetContainer)) {
                    if (stylesheetContainer.checksumInvalid) {
                        object = StyleManager.calculateCheckSum(string);
                        if (!Arrays.equals((byte[])object, stylesheetContainer.checksum)) {
                            this.removeStylesheetContainer(stylesheetContainer);
                            Stylesheet stylesheet = StyleManager.loadStylesheet(string);
                            stylesheetContainer = new StylesheetContainer(string, stylesheet, (byte[])object);
                            this.stylesheetContainerMap.put(string, stylesheetContainer);
                        } else {
                            stylesheetContainer.checksumInvalid = false;
                        }
                    }
                    arrayList.add(stylesheetContainer);
                }
                stylesheetContainer.parentUsers.add(parent);
                continue;
            }
            object = StyleManager.loadStylesheet(string);
            stylesheetContainer = new StylesheetContainer(string, (Stylesheet)object);
            stylesheetContainer.parentUsers.add(parent);
            this.stylesheetContainerMap.put(string, stylesheetContainer);
            arrayList.add(stylesheetContainer);
        }
        return arrayList;
    }

    private List<StylesheetContainer> gatherParentStylesheets(Parent parent) {
        if (parent == null) {
            return Collections.emptyList();
        }
        List<String> list = parent.impl_getAllParentStylesheets();
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        CssError.setCurrentScene(parent.getScene());
        List<StylesheetContainer> list2 = this.processStylesheets(list, parent);
        CssError.setCurrentScene(null);
        return list2;
    }

    private List<StylesheetContainer> gatherSceneStylesheets(Scene scene) {
        if (scene == null) {
            return Collections.emptyList();
        }
        ObservableList<String> observableList = scene.getStylesheets();
        if (observableList == null || observableList.isEmpty()) {
            return Collections.emptyList();
        }
        CssError.setCurrentScene(scene);
        List<StylesheetContainer> list = this.processStylesheets(observableList, scene.getRoot());
        CssError.setCurrentScene(null);
        return list;
    }

    public StyleMap findMatchingStyles(Node node, SubScene subScene, Set<PseudoClass>[] setArray) {
        Object object;
        boolean bl;
        Scene scene = node.getScene();
        if (scene == null) {
            return StyleMap.EMPTY_MAP;
        }
        CacheContainer cacheContainer = this.getCacheContainer(node, subScene);
        if (cacheContainer == null) {
            assert (false) : node.toString();
            return StyleMap.EMPTY_MAP;
        }
        Parent parent = node instanceof Parent ? (Parent)node : node.getParent();
        List<StylesheetContainer> list = this.gatherParentStylesheets(parent);
        boolean bl2 = !list.isEmpty();
        List<StylesheetContainer> list2 = this.gatherSceneStylesheets(scene);
        boolean bl3 = !list2.isEmpty();
        String string = node.getStyle();
        boolean bl4 = string != null && !string.trim().isEmpty();
        String string2 = scene.getUserAgentStylesheet();
        boolean bl5 = string2 != null && !string2.trim().isEmpty();
        String string3 = subScene != null ? subScene.getUserAgentStylesheet() : null;
        boolean bl6 = bl = string3 != null && !string3.trim().isEmpty();
        if (!(bl4 || bl2 || bl3 || bl5 || bl || !this.platformUserAgentStylesheetContainers.isEmpty())) {
            return StyleMap.EMPTY_MAP;
        }
        String string4 = node.getTypeSelector();
        String string5 = node.getId();
        ObservableList<String> observableList = node.getStyleClass();
        if (this.key == null) {
            this.key = new Key();
        }
        this.key.className = string4;
        this.key.id = string5;
        int n = observableList.size();
        for (int i = 0; i < n; ++i) {
            object = (String)observableList.get(i);
            if (object == null || ((String)object).isEmpty()) continue;
            this.key.styleClasses.add(StyleClassSet.getStyleClass((String)object));
        }
        Map map = cacheContainer.getCacheMap(list);
        Cache cache = (Cache)map.get(this.key);
        if (cache != null) {
            this.key.styleClasses.clear();
        } else {
            object = new ArrayList();
            if (bl || bl5) {
                String string6 = bl ? subScene.getUserAgentStylesheet().trim() : scene.getUserAgentStylesheet().trim();
                StylesheetContainer stylesheetContainer = null;
                int n2 = this.userAgentStylesheetContainers.size();
                for (int i = 0; i < n2; ++i) {
                    stylesheetContainer = this.userAgentStylesheetContainers.get(i);
                    if (string6.equals(stylesheetContainer.fname)) break;
                    stylesheetContainer = null;
                }
                if (stylesheetContainer == null) {
                    Stylesheet stylesheet = StyleManager.loadStylesheet(string6);
                    if (stylesheet != null) {
                        stylesheet.setOrigin(StyleOrigin.USER_AGENT);
                    }
                    stylesheetContainer = new StylesheetContainer(string6, stylesheet);
                    this.userAgentStylesheetContainers.add(stylesheetContainer);
                }
                if (stylesheetContainer.selectorPartitioning != null) {
                    Parent parent2 = bl ? subScene.getRoot() : scene.getRoot();
                    stylesheetContainer.parentUsers.add(parent2);
                    List<Selector> list3 = stylesheetContainer.selectorPartitioning.match(string5, string4, this.key.styleClasses);
                    object.addAll(list3);
                }
            } else if (!this.platformUserAgentStylesheetContainers.isEmpty()) {
                int n3 = this.platformUserAgentStylesheetContainers.size();
                for (int i = 0; i < n3; ++i) {
                    StylesheetContainer stylesheetContainer = this.platformUserAgentStylesheetContainers.get(i);
                    if (stylesheetContainer == null || stylesheetContainer.selectorPartitioning == null) continue;
                    List<Selector> list4 = stylesheetContainer.selectorPartitioning.match(string5, string4, this.key.styleClasses);
                    object.addAll(list4);
                }
            }
            if (!list2.isEmpty()) {
                int n4 = list2.size();
                for (int i = 0; i < n4; ++i) {
                    StylesheetContainer stylesheetContainer = list2.get(i);
                    if (stylesheetContainer == null || stylesheetContainer.selectorPartitioning == null) continue;
                    List<Selector> list5 = stylesheetContainer.selectorPartitioning.match(string5, string4, this.key.styleClasses);
                    object.addAll(list5);
                }
            }
            if (bl2) {
                int n5 = list == null ? 0 : list.size();
                for (int i = 0; i < n5; ++i) {
                    StylesheetContainer stylesheetContainer = list.get(i);
                    if (stylesheetContainer.selectorPartitioning == null) continue;
                    List<Selector> list6 = stylesheetContainer.selectorPartitioning.match(string5, string4, this.key.styleClasses);
                    object.addAll(list6);
                }
            }
            cache = new Cache((List<Selector>)object);
            map.put(this.key, cache);
            this.key = null;
        }
        object = cache.getStyleMap(cacheContainer, node, setArray, bl4);
        return object;
    }

    public static ObservableList<CssError> errorsProperty() {
        if (errors == null) {
            errors = FXCollections.observableArrayList();
        }
        return errors;
    }

    public static ObservableList<CssError> getErrors() {
        return errors;
    }

    static {
        cacheContainerMap = new WeakHashMap<Parent, CacheContainer>();
        errors = null;
    }

    private static class Cache {
        private final List<Selector> selectors;
        private final Map<Key, Integer> cache;

        Cache(List<Selector> list) {
            this.selectors = list;
            this.cache = new HashMap<Key, Integer>();
        }

        private StyleMap getStyleMap(CacheContainer cacheContainer, Node node, Set<PseudoClass>[] setArray, boolean bl) {
            int n;
            Selector selector;
            Object object;
            if ((this.selectors == null || this.selectors.isEmpty()) && !bl) {
                return StyleMap.EMPTY_MAP;
            }
            int n2 = this.selectors.size();
            long[] lArray = new long[n2 / 64 + 1];
            boolean bl2 = true;
            for (int i = 0; i < n2; ++i) {
                long l;
                object = this.selectors.get(i);
                if (!((Selector)object).applies(node, setArray, 0)) continue;
                int n3 = i / 64;
                lArray[n3] = l = lArray[n3] | 1L << i;
                bl2 = false;
            }
            if (bl2 && !bl) {
                return StyleMap.EMPTY_MAP;
            }
            String string = node.getStyle();
            object = new Key(lArray, string);
            if (this.cache.containsKey(object)) {
                Integer n4 = this.cache.get(object);
                StyleMap styleMap = n4 != null ? cacheContainer.getStyleMap(n4) : StyleMap.EMPTY_MAP;
                return styleMap;
            }
            ArrayList<Selector> arrayList = new ArrayList<Selector>();
            if (bl && (selector = cacheContainer.getInlineStyleSelector(string)) != null) {
                arrayList.add(selector);
            }
            for (n = 0; n < lArray.length; ++n) {
                if (lArray[n] == 0L) continue;
                int n5 = n * 64;
                for (int i = 0; i < 64; ++i) {
                    long l = 1L << i;
                    if ((l & lArray[n]) != l) continue;
                    Selector selector2 = this.selectors.get(n5 + i);
                    arrayList.add(selector2);
                }
            }
            n = cacheContainer.nextSmapId();
            this.cache.put((Key)object, n);
            StyleMap styleMap = new StyleMap(n, arrayList);
            cacheContainer.addStyleMap(styleMap);
            return styleMap;
        }

        private static class Key {
            final long[] key;
            final String inlineStyle;

            Key(long[] lArray, String string) {
                this.key = lArray;
                this.inlineStyle = string != null && string.trim().isEmpty() ? null : string;
            }

            public String toString() {
                return Arrays.toString(this.key) + (this.inlineStyle != null ? "* {" + this.inlineStyle + "}" : "");
            }

            public int hashCode() {
                int n = 3;
                n = 17 * n + Arrays.hashCode(this.key);
                if (this.inlineStyle != null) {
                    n = 17 * n + this.inlineStyle.hashCode();
                }
                return n;
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                Key key = (Key)object;
                if (this.inlineStyle == null ? key.inlineStyle != null : !this.inlineStyle.equals(key.inlineStyle)) {
                    return false;
                }
                return Arrays.equals(this.key, key.key);
            }
        }
    }

    static class CacheContainer {
        private Map<StyleCache.Key, StyleCache> styleCache;
        private Map<List<String>, Map<Key, Cache>> cacheMap;
        private List<StyleMap> styleMapList;
        private Map<String, Selector> inlineStylesCache;
        private int styleMapId = 0;
        private int baseStyleMapId = 0;

        CacheContainer() {
        }

        private Map<StyleCache.Key, StyleCache> getStyleCache() {
            if (this.styleCache == null) {
                this.styleCache = new HashMap<StyleCache.Key, StyleCache>();
            }
            return this.styleCache;
        }

        private Map<Key, Cache> getCacheMap(List<StylesheetContainer> list) {
            if (this.cacheMap == null) {
                this.cacheMap = new HashMap<List<String>, Map<Key, Cache>>();
            }
            if (list == null || list.isEmpty()) {
                Map<Key, Cache> map = this.cacheMap.get(null);
                if (map == null) {
                    map = new HashMap<Key, Cache>();
                    this.cacheMap.put(null, map);
                }
                return map;
            }
            int n = list.size();
            if (cacheMapKey == null) {
                cacheMapKey = new ArrayList(n);
            }
            for (int i = 0; i < n; ++i) {
                StylesheetContainer stylesheetContainer = list.get(i);
                if (stylesheetContainer == null || stylesheetContainer.fname == null || stylesheetContainer.fname.isEmpty()) continue;
                cacheMapKey.add(stylesheetContainer.fname);
            }
            Map<Key, Cache> map = this.cacheMap.get(cacheMapKey);
            if (map == null) {
                map = new HashMap<Key, Cache>();
                this.cacheMap.put(cacheMapKey, map);
                cacheMapKey = null;
            } else {
                cacheMapKey.clear();
            }
            return map;
        }

        private List<StyleMap> getStyleMapList() {
            if (this.styleMapList == null) {
                this.styleMapList = new ArrayList<StyleMap>();
            }
            return this.styleMapList;
        }

        private int nextSmapId() {
            this.styleMapId = this.baseStyleMapId + this.getStyleMapList().size();
            return this.styleMapId;
        }

        private void addStyleMap(StyleMap styleMap) {
            this.getStyleMapList().add(styleMap);
        }

        public StyleMap getStyleMap(int n) {
            int n2 = n - this.baseStyleMapId;
            if (0 <= n2 && n2 < this.getStyleMapList().size()) {
                return this.getStyleMapList().get(n2);
            }
            return StyleMap.EMPTY_MAP;
        }

        private void clearCache() {
            if (this.cacheMap != null) {
                this.cacheMap.clear();
            }
            if (this.styleCache != null) {
                this.styleCache.clear();
            }
            if (this.styleMapList != null) {
                this.styleMapList.clear();
            }
            this.baseStyleMapId = this.styleMapId;
            if (this.baseStyleMapId > 0x6FFFFFF9) {
                this.styleMapId = 0;
                this.baseStyleMapId = 0;
            }
        }

        private Selector getInlineStyleSelector(String string) {
            Stylesheet stylesheet;
            if (string == null || string.trim().isEmpty()) {
                return null;
            }
            if (this.inlineStylesCache != null && this.inlineStylesCache.containsKey(string)) {
                return this.inlineStylesCache.get(string);
            }
            if (this.inlineStylesCache == null) {
                this.inlineStylesCache = new HashMap<String, Selector>();
            }
            if ((stylesheet = CSSParser.getInstance().parse("*{" + string + "}")) != null) {
                Selector selector;
                stylesheet.setOrigin(StyleOrigin.INLINE);
                List<Rule> list = stylesheet.getRules();
                Rule rule = list != null && !list.isEmpty() ? list.get(0) : null;
                List<Selector> list2 = rule != null ? rule.getUnobservedSelectorList() : null;
                Selector selector2 = selector = list2 != null && !list2.isEmpty() ? list2.get(0) : null;
                if (selector != null) {
                    selector.setOrdinal(-1);
                    this.inlineStylesCache.put(string, selector);
                    return selector;
                }
            }
            this.inlineStylesCache.put(string, null);
            return null;
        }
    }

    private static class InstanceHolder {
        static final StyleManager INSTANCE = new StyleManager();

        private InstanceHolder() {
        }
    }

    private static class Key {
        String className;
        String id;
        final StyleClassSet styleClasses = new StyleClassSet();

        private Key() {
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Key) {
                Key key = (Key)object;
                if (this.className == null ? key.className != null : !this.className.equals(key.className)) {
                    return false;
                }
                if (this.id == null ? key.id != null : !this.id.equals(key.id)) {
                    return false;
                }
                return this.styleClasses.equals(key.styleClasses);
            }
            return true;
        }

        public int hashCode() {
            int n = 7;
            n = 29 * n + (this.className != null ? this.className.hashCode() : 0);
            n = 29 * n + (this.id != null ? this.id.hashCode() : 0);
            n = 29 * n + this.styleClasses.hashCode();
            return n;
        }
    }

    static class RefList<K> {
        final List<Reference<K>> list = new ArrayList<Reference<K>>();

        RefList() {
        }

        void add(K k) {
            for (int i = this.list.size() - 1; 0 <= i; --i) {
                Reference<K> reference = this.list.get(i);
                K k2 = reference.get();
                if (k2 == null) {
                    this.list.remove(i);
                    continue;
                }
                if (k2 != k) continue;
                return;
            }
            this.list.add(new WeakReference<K>(k));
        }

        void remove(K k) {
            for (int i = this.list.size() - 1; 0 <= i; --i) {
                Reference<K> reference = this.list.get(i);
                K k2 = reference.get();
                if (k2 == null) {
                    this.list.remove(i);
                    continue;
                }
                if (k2 != k) continue;
                this.list.remove(i);
                return;
            }
        }

        boolean contains(K k) {
            for (int i = this.list.size() - 1; 0 <= i; --i) {
                Reference<K> reference = this.list.get(i);
                K k2 = reference.get();
                if (k2 != k) continue;
                return true;
            }
            return false;
        }
    }

    static class StylesheetContainer {
        final String fname;
        final Stylesheet stylesheet;
        final SelectorPartitioning selectorPartitioning;
        final RefList<Parent> parentUsers;
        final List<Image> imageCache;
        final int hash;
        final byte[] checksum;
        boolean checksumInvalid = false;

        StylesheetContainer(String string, Stylesheet stylesheet) {
            this(string, stylesheet, stylesheet != null ? StyleManager.calculateCheckSum(stylesheet.getUrl()) : new byte[]{});
        }

        StylesheetContainer(String string, Stylesheet stylesheet, byte[] byArray) {
            this.fname = string;
            this.hash = string != null ? string.hashCode() : 127;
            this.stylesheet = stylesheet;
            if (stylesheet != null) {
                this.selectorPartitioning = new SelectorPartitioning();
                List<Rule> list = stylesheet.getRules();
                int n = list == null || list.isEmpty() ? 0 : list.size();
                for (int i = 0; i < n; ++i) {
                    Rule rule = list.get(i);
                    List<Selector> list2 = rule.getUnobservedSelectorList();
                    int n2 = list2 == null || list2.isEmpty() ? 0 : list2.size();
                    for (int j = 0; j < n2; ++j) {
                        Selector selector = list2.get(j);
                        this.selectorPartitioning.partition(selector);
                    }
                }
            } else {
                this.selectorPartitioning = null;
            }
            this.parentUsers = new RefList();
            this.imageCache = new ArrayList<Image>();
            this.checksum = byArray;
        }

        void invalidateChecksum() {
            this.checksumInvalid = this.checksum.length > 0;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            StylesheetContainer stylesheetContainer = (StylesheetContainer)object;
            return !(this.fname == null ? stylesheetContainer.fname != null : !this.fname.equals(stylesheetContainer.fname));
        }

        public String toString() {
            return this.fname;
        }
    }
}

