/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdk.nashorn.internal.codegen.Label;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.CatchNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.Statement;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

@Immutable
public final class TryNode
extends Statement {
    private final Block body;
    private final List<Block> catchBlocks;
    private final Block finallyBody;
    private final Label exit;
    private Symbol exception;
    private Symbol finallyCatchAll;

    public TryNode(int lineNumber, long token, int finish, Block body, List<Block> catchBlocks, Block finallyBody) {
        super(lineNumber, token, finish);
        this.body = body;
        this.catchBlocks = catchBlocks;
        this.finallyBody = finallyBody;
        this.exit = new Label("exit");
    }

    private TryNode(TryNode tryNode, Block body, List<Block> catchBlocks, Block finallyBody) {
        super(tryNode);
        this.body = body;
        this.catchBlocks = catchBlocks;
        this.finallyBody = finallyBody;
        this.exit = new Label(tryNode.exit);
    }

    @Override
    public Node ensureUniqueLabels(LexicalContext lc) {
        return new TryNode(this, this.body, this.catchBlocks, this.finallyBody);
    }

    @Override
    public boolean isTerminal() {
        if (this.body.isTerminal()) {
            for (Block catchBlock : this.getCatchBlocks()) {
                if (catchBlock.isTerminal()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterTryNode(this)) {
            Block newFinallyBody = this.finallyBody == null ? null : (Block)this.finallyBody.accept(visitor);
            Block newBody = (Block)this.body.accept(visitor);
            return visitor.leaveTryNode(this.setBody(newBody).setFinallyBody(newFinallyBody).setCatchBlocks(Node.accept(visitor, Block.class, this.catchBlocks)).setException(this.exception).setFinallyCatchAll(this.finallyCatchAll));
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("try ");
    }

    public Block getBody() {
        return this.body;
    }

    public TryNode setBody(Block body) {
        if (this.body == body) {
            return this;
        }
        return new TryNode(this, body, this.catchBlocks, this.finallyBody);
    }

    public List<CatchNode> getCatches() {
        ArrayList<CatchNode> catches = new ArrayList<CatchNode>(this.catchBlocks.size());
        for (Block catchBlock : this.catchBlocks) {
            catches.add((CatchNode)catchBlock.getStatements().get(0));
        }
        return Collections.unmodifiableList(catches);
    }

    public List<Block> getCatchBlocks() {
        return Collections.unmodifiableList(this.catchBlocks);
    }

    public TryNode setCatchBlocks(List<Block> catchBlocks) {
        if (this.catchBlocks == catchBlocks) {
            return this;
        }
        return new TryNode(this, this.body, catchBlocks, this.finallyBody);
    }

    public Symbol getException() {
        return this.exception;
    }

    public TryNode setException(Symbol exception) {
        this.exception = exception;
        return this;
    }

    public Symbol getFinallyCatchAll() {
        return this.finallyCatchAll;
    }

    public TryNode setFinallyCatchAll(Symbol finallyCatchAll) {
        this.finallyCatchAll = finallyCatchAll;
        return this;
    }

    public Label getExit() {
        return this.exit;
    }

    public Block getFinallyBody() {
        return this.finallyBody;
    }

    public TryNode setFinallyBody(Block finallyBody) {
        if (this.finallyBody == finallyBody) {
            return this;
        }
        return new TryNode(this, this.body, this.catchBlocks, finallyBody);
    }
}

