/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.win;

import com.sun.glass.ui.PlatformAccessible;
import com.sun.glass.ui.View;
import com.sun.glass.ui.win.WinTextRangeProvider;
import com.sun.glass.ui.win.WinVariant;
import com.sun.javafx.scene.accessibility.Accessible;
import com.sun.javafx.scene.accessibility.Action;
import com.sun.javafx.scene.accessibility.Attribute;
import com.sun.javafx.scene.accessibility.Role;
import java.util.function.Function;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyCombination;

final class WinAccessible
extends PlatformAccessible {
    private static int idCount = 1;
    private static final int UIA_BoundingRectanglePropertyId = 30001;
    private static final int UIA_ProcessIdPropertyId = 30002;
    private static final int UIA_ControlTypePropertyId = 30003;
    private static final int UIA_LocalizedControlTypePropertyId = 30004;
    private static final int UIA_NamePropertyId = 30005;
    private static final int UIA_AcceleratorKeyPropertyId = 30006;
    private static final int UIA_AccessKeyPropertyId = 30007;
    private static final int UIA_HasKeyboardFocusPropertyId = 30008;
    private static final int UIA_IsKeyboardFocusablePropertyId = 30009;
    private static final int UIA_IsEnabledPropertyId = 30010;
    private static final int UIA_AutomationIdPropertyId = 30011;
    private static final int UIA_ClassNamePropertyId = 30012;
    private static final int UIA_HelpTextPropertyId = 30013;
    private static final int UIA_ClickablePointPropertyId = 30014;
    private static final int UIA_CulturePropertyId = 30015;
    private static final int UIA_IsControlElementPropertyId = 30016;
    private static final int UIA_IsContentElementPropertyId = 30017;
    private static final int UIA_LabeledByPropertyId = 30018;
    private static final int UIA_IsPasswordPropertyId = 30019;
    private static final int UIA_NativeWindowHandlePropertyId = 30020;
    private static final int UIA_ItemTypePropertyId = 30021;
    private static final int UIA_IsOffscreenPropertyId = 30022;
    private static final int UIA_OrientationPropertyId = 30023;
    private static final int UIA_FrameworkIdPropertyId = 30024;
    private static final int UIA_ValueValuePropertyId = 30045;
    private static final int UIA_RangeValueValuePropertyId = 30047;
    private static final int UIA_ExpandCollapseExpandCollapseStatePropertyId = 30070;
    private static final int UIA_ToggleToggleStatePropertyId = 30086;
    private static final int UIA_AriaRolePropertyId = 30101;
    private static final int UIA_ProviderDescriptionPropertyId = 30107;
    private static final int UIA_InvokePatternId = 10000;
    private static final int UIA_SelectionPatternId = 10001;
    private static final int UIA_ValuePatternId = 10002;
    private static final int UIA_RangeValuePatternId = 10003;
    private static final int UIA_ScrollPatternId = 10004;
    private static final int UIA_ExpandCollapsePatternId = 10005;
    private static final int UIA_GridPatternId = 10006;
    private static final int UIA_GridItemPatternId = 10007;
    private static final int UIA_SelectionItemPatternId = 10010;
    private static final int UIA_TablePatternId = 10012;
    private static final int UIA_TableItemPatternId = 10013;
    private static final int UIA_TextPatternId = 10014;
    private static final int UIA_TogglePatternId = 10015;
    private static final int UIA_TransformPatternId = 10016;
    private static final int UIA_ScrollItemPatternId = 10017;
    private static final int UIA_ItemContainerPatternId = 10019;
    private static final int UIA_ButtonControlTypeId = 50000;
    private static final int UIA_CheckBoxControlTypeId = 50002;
    private static final int UIA_ComboBoxControlTypeId = 50003;
    private static final int UIA_EditControlTypeId = 50004;
    private static final int UIA_HyperlinkControlTypeId = 50005;
    private static final int UIA_ImageControlTypeId = 50006;
    private static final int UIA_ListItemControlTypeId = 50007;
    private static final int UIA_ListControlTypeId = 50008;
    private static final int UIA_MenuControlTypeId = 50009;
    private static final int UIA_MenuBarControlTypeId = 50010;
    private static final int UIA_MenuItemControlTypeId = 50011;
    private static final int UIA_ProgressBarControlTypeId = 50012;
    private static final int UIA_RadioButtonControlTypeId = 50013;
    private static final int UIA_ScrollBarControlTypeId = 50014;
    private static final int UIA_SliderControlTypeId = 50015;
    private static final int UIA_TabControlTypeId = 50018;
    private static final int UIA_TabItemControlTypeId = 50019;
    private static final int UIA_TextControlTypeId = 50020;
    private static final int UIA_ToolBarControlTypeId = 50021;
    private static final int UIA_TreeControlTypeId = 50023;
    private static final int UIA_TreeItemControlTypeId = 50024;
    private static final int UIA_GroupControlTypeId = 50026;
    private static final int UIA_ThumbControlTypeId = 50027;
    private static final int UIA_DataGridControlTypeId = 50028;
    private static final int UIA_DataItemControlTypeId = 50029;
    private static final int UIA_SplitButtonControlTypeId = 50031;
    private static final int UIA_WindowControlTypeId = 50032;
    private static final int UIA_PaneControlTypeId = 50033;
    private static final int UIA_TableControlTypeId = 50036;
    private static final int NavigateDirection_Parent = 0;
    private static final int NavigateDirection_NextSibling = 1;
    private static final int NavigateDirection_PreviousSibling = 2;
    private static final int NavigateDirection_FirstChild = 3;
    private static final int NavigateDirection_LastChild = 4;
    private static final int RowOrColumnMajor_RowMajor = 0;
    private static final int RowOrColumnMajor_ColumnMajor = 1;
    private static final int RowOrColumnMajor_Indeterminate = 2;
    private static final int UIA_MenuOpenedEventId = 20003;
    private static final int UIA_AutomationPropertyChangedEventId = 20004;
    private static final int UIA_AutomationFocusChangedEventId = 20005;
    private static final int UIA_MenuClosedEventId = 20007;
    private static final int UIA_SelectionItem_ElementRemovedFromSelectionEventId = 20011;
    private static final int UIA_SelectionItem_ElementSelectedEventId = 20012;
    private static final int UIA_Text_TextSelectionChangedEventId = 20014;
    private static final int UIA_Text_TextChangedEventId = 20015;
    private static final int UIA_MenuModeStartEventId = 20018;
    private static final int UIA_MenuModeEndEventId = 20019;
    private static final int SupportedTextSelection_None = 0;
    private static final int SupportedTextSelection_Single = 1;
    private static final int SupportedTextSelection_Multiple = 2;
    private static final int ExpandCollapseState_Collapsed = 0;
    private static final int ExpandCollapseState_Expanded = 1;
    private static final int ExpandCollapseState_PartiallyExpanded = 2;
    private static final int ExpandCollapseState_LeafNode = 3;
    private static final int ScrollAmount_LargeDecrement = 0;
    private static final int ScrollAmount_SmallDecrement = 1;
    private static final int ScrollAmount_NoAmount = 2;
    private static final int ScrollAmount_LargeIncrement = 3;
    private static final int ScrollAmount_SmallIncrement = 4;
    private static final int UIA_ScrollPatternNoScroll = -1;
    private static final int ToggleState_Off = 0;
    private static final int ToggleState_On = 1;
    private static final int ToggleState_Indeterminate = 2;
    private static final int UiaAppendRuntimeId = 3;
    private long peer = this._createGlassAccessible();
    private int id;
    WinTextRangeProvider documentRange;
    WinTextRangeProvider selectionRange;
    boolean documentRangeValid;
    boolean selectionRangeValid;
    private int lastIndex = 0;

    private static native void _initIDs();

    private native long _createGlassAccessible();

    private native void _destroyGlassAccessible(long var1);

    private static native long UiaRaiseAutomationEvent(long var0, int var2);

    private static native long UiaRaiseAutomationPropertyChangedEvent(long var0, int var2, WinVariant var3, WinVariant var4);

    private static native boolean UiaClientsAreListening();

    private WinAccessible(Accessible accessible) {
        super(accessible);
    }

    static WinAccessible createAccessible(Accessible accessible) {
        return null;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.selectionRange != null) {
            this.selectionRange.dispose();
            this.selectionRange = null;
        }
        if (this.documentRange != null) {
            this.documentRange.dispose();
            this.documentRange = null;
        }
        if (this.peer != 0L) {
            this._destroyGlassAccessible(this.peer);
            this.peer = 0L;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void sendNotification(Attribute attribute) {
        if (this.isDisposed()) {
            return;
        }
        switch (attribute) {
            case FOCUS_NODE: {
                if (this.getView() != null) {
                    long l = this.GetFocus();
                    if (l == 0L) return;
                    WinAccessible.UiaRaiseAutomationEvent(l, 20005);
                    return;
                }
                Node node2 = (Node)this.getAttribute(Attribute.FOCUS_NODE, new Object[0]);
                if (node2 != null) {
                    WinAccessible.UiaRaiseAutomationEvent(this.getAccessible(node2), 20005);
                    return;
                }
                Scene scene = (Scene)this.getAttribute(Attribute.SCENE, new Object[0]);
                if (scene == null) return;
            }
            case SELECTED_PAGE: {
                Node node3 = (Node)this.getAttribute(Attribute.SELECTED_PAGE, new Object[0]);
                if (node3 == null) return;
                WinAccessible.UiaRaiseAutomationEvent(this.getAccessible(node3), 20005);
                return;
            }
            case SELECTED_TAB: {
                Node node4 = (Node)this.getAttribute(Attribute.SELECTED_TAB, new Object[0]);
                if (node4 == null) return;
                WinAccessible.UiaRaiseAutomationEvent(this.getAccessible(node4), 20005);
                return;
            }
            case SELECTED_CELLS: {
                ObservableList observableList = (ObservableList)this.getAttribute(Attribute.SELECTED_CELLS, new Object[0]);
                if (observableList == null) return;
                observableList.stream().forEach(node -> WinAccessible.UiaRaiseAutomationEvent(this.getAccessible((Node)node), 20005));
                return;
            }
            case SELECTED_ROWS: {
                ObservableList observableList = (ObservableList)this.getAttribute(Attribute.SELECTED_ROWS, new Object[0]);
                if (observableList == null) return;
                observableList.stream().forEach(node -> WinAccessible.UiaRaiseAutomationEvent(this.getAccessible((Node)node), 20005));
                return;
            }
            case INDETERMINATE: {
                if (this.getAttribute(Attribute.ROLE, new Object[0]) != Role.CHECKBOX) return;
                this.notifyToggleState();
                return;
            }
            case SELECTED: {
                Object object = this.getAttribute(Attribute.ROLE, new Object[0]);
                if (object == Role.CHECKBOX || object == Role.RADIO_BUTTON) {
                    this.notifyToggleState();
                    return;
                }
                Boolean bl = (Boolean)this.getAttribute(Attribute.SELECTED, new Object[0]);
                if (bl == null) return;
                if (bl.booleanValue()) {
                    WinAccessible.UiaRaiseAutomationEvent(this.peer, 20012);
                    return;
                }
                WinAccessible.UiaRaiseAutomationEvent(this.peer, 20011);
                return;
            }
            case FOCUSED: {
                return;
            }
            case VALUE: {
                Double d = (Double)this.getAttribute(Attribute.VALUE, new Object[0]);
                if (d == null) return;
                WinVariant winVariant = new WinVariant();
                winVariant.vt = (short)5;
                winVariant.dblVal = 0.0;
                WinVariant winVariant2 = new WinVariant();
                winVariant2.vt = (short)5;
                winVariant2.dblVal = d;
                WinAccessible.UiaRaiseAutomationPropertyChangedEvent(this.peer, 30047, winVariant, winVariant2);
                return;
            }
            case SELECTION_START: 
            case SELECTION_END: {
                boolean bl;
                if (this.selectionRange == null) return;
                Integer n = (Integer)this.getAttribute(Attribute.SELECTION_START, new Object[0]);
                boolean bl2 = n != null && n.intValue() != this.selectionRange.getStart();
                Integer n2 = (Integer)this.getAttribute(Attribute.SELECTION_END, new Object[0]);
                boolean bl3 = bl = n2 != null && n2.intValue() != this.selectionRange.getEnd();
                if (!bl2 && !bl) return;
                this.selectionRangeValid = false;
                WinAccessible.UiaRaiseAutomationEvent(this.peer, 20014);
                return;
            }
            case TITLE: {
                String string = (String)this.getAttribute(Attribute.TITLE, new Object[0]);
                if (string != null) {
                    WinVariant winVariant = new WinVariant();
                    winVariant.vt = (short)8;
                    winVariant.bstrVal = "";
                    WinVariant winVariant3 = new WinVariant();
                    winVariant3.vt = (short)8;
                    winVariant3.bstrVal = string;
                    WinAccessible.UiaRaiseAutomationPropertyChangedEvent(this.peer, 30045, winVariant, winVariant3);
                }
                if (this.selectionRange == null && this.documentRange == null) return;
                WinAccessible.UiaRaiseAutomationEvent(this.peer, 20015);
                this.documentRangeValid = false;
                this.selectionRangeValid = false;
                return;
            }
            case EXPANDED: {
                Boolean bl = (Boolean)this.getAttribute(Attribute.EXPANDED, new Object[0]);
                if (bl == null) return;
                WinVariant winVariant = new WinVariant();
                winVariant.vt = (short)3;
                winVariant.lVal = bl != false ? 0 : 1;
                WinVariant winVariant4 = new WinVariant();
                winVariant4.vt = (short)3;
                winVariant4.lVal = bl != false ? 1 : 0;
                WinAccessible.UiaRaiseAutomationPropertyChangedEvent(this.peer, 30070, winVariant, winVariant4);
                return;
            }
            case PARENT: {
                return;
            }
            default: {
                WinAccessible.UiaRaiseAutomationEvent(this.peer, 20004);
            }
        }
    }

    void notifyToggleState() {
        int n = this.get_ToggleState();
        WinVariant winVariant = new WinVariant();
        winVariant.vt = (short)3;
        winVariant.lVal = n;
        WinVariant winVariant2 = new WinVariant();
        winVariant2.vt = (short)3;
        winVariant2.lVal = n;
        WinAccessible.UiaRaiseAutomationPropertyChangedEvent(this.peer, 30086, winVariant, winVariant2);
    }

    @Override
    protected long getNativeAccessible() {
        return this.peer;
    }

    @Override
    protected Object getAttribute(Attribute attribute, Object ... objectArray) {
        return super.getAttribute(attribute, objectArray);
    }

    @Override
    protected void executeAction(Action action, Object ... objectArray) {
        super.executeAction(action, objectArray);
    }

    private long getContainer(Role role) {
        Node node = this.getContainerNode(role);
        return node == null ? 0L : this.getAccessible(node);
    }

    private Node getContainerNode() {
        if (this.isDisposed()) {
            return null;
        }
        Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
        if (role != null) {
            switch (role) {
                case TABLE_ROW: 
                case TABLE_CELL: {
                    return this.getContainerNode(Role.TABLE_VIEW);
                }
                case LIST_ITEM: {
                    return this.getContainerNode(Role.LIST_VIEW);
                }
                case TAB_ITEM: {
                    return this.getContainerNode(Role.TAB_PANE);
                }
                case PAGE: {
                    return this.getContainerNode(Role.PAGINATION);
                }
                case TREE_ITEM: {
                    return this.getContainerNode(Role.TREE_VIEW);
                }
                case TREE_TABLE_ITEM: {
                    return this.getContainerNode(Role.TREE_TABLE_VIEW);
                }
                case TREE_TABLE_CELL: {
                    return this.getContainerNode(Role.TREE_TABLE_VIEW);
                }
            }
        }
        return null;
    }

    private int getControlType() {
        Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
        if (role == null) {
            return 50026;
        }
        switch (role) {
            case CONTEXT_MENU: {
                return 50009;
            }
            case MENU_ITEM: {
                return 50011;
            }
            case BUTTON: 
            case MENU_BUTTON: 
            case TOGGLE_BUTTON: 
            case INCREMENT_BUTTON: 
            case DECREMENT_BUTTON: {
                return 50000;
            }
            case SPLIT_MENU_BUTTON: {
                return 50031;
            }
            case PAGINATION: 
            case TAB_PANE: {
                return 50018;
            }
            case TAB_ITEM: 
            case PAGE: {
                return 50019;
            }
            case SLIDER: {
                return 50015;
            }
            case PARENT: {
                return this.getView() != null ? 50032 : 50033;
            }
            case TEXT: {
                return 50020;
            }
            case TEXT_FIELD: 
            case PASSWORD_FIELD: 
            case TEXT_AREA: {
                return 50020;
            }
            case TABLE_VIEW: {
                return 50036;
            }
            case LIST_VIEW: {
                return 50008;
            }
            case LIST_ITEM: {
                return 50007;
            }
            case TABLE_CELL: 
            case TREE_TABLE_CELL: {
                return 50029;
            }
            case IMAGE: {
                return 50006;
            }
            case RADIO_BUTTON: {
                return 50013;
            }
            case CHECKBOX: {
                return 50002;
            }
            case COMBOBOX: {
                return 50003;
            }
            case HYPERLINK: {
                return 50005;
            }
            case TREE_TABLE_VIEW: 
            case TREE_VIEW: {
                return 50023;
            }
            case TREE_ITEM: 
            case TREE_TABLE_ITEM: {
                return 50024;
            }
            case PROGRESS_INDICATOR: {
                return 50012;
            }
            case TOOLBAR: {
                return 50021;
            }
            case TITLED_PANE: {
                return 50026;
            }
            case SCROLL_PANE: {
                return 50033;
            }
            case SCROLL_BAR: {
                return 50014;
            }
            case THUMB: {
                return 50027;
            }
            case MENU_BAR: {
                return 50010;
            }
            case DATE_PICKER: {
                return 50033;
            }
        }
        return 0;
    }

    long GetPatternProvider(int n) {
        if (this.isDisposed()) {
            return 0L;
        }
        Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
        boolean bl = false;
        switch (role) {
            case MENU_ITEM: {
                boolean bl2 = bl = n == 10000;
                if (bl) break;
                Object object = this.getAttribute(Attribute.MENU_ITEM_TYPE, new Object[0]);
                if (object == Role.CONTEXT_MENU) {
                    bl |= n == 10005;
                }
                if (object != Role.CHECKBOX && object != Role.RADIO_BUTTON) break;
                bl |= n == 10015;
                break;
            }
            case BUTTON: 
            case MENU_BUTTON: 
            case INCREMENT_BUTTON: 
            case DECREMENT_BUTTON: 
            case HYPERLINK: {
                bl = n == 10000;
                break;
            }
            case TAB_ITEM: 
            case PAGE: {
                bl = n == 10010;
                break;
            }
            case PAGINATION: 
            case TAB_PANE: {
                bl = n == 10001;
                break;
            }
            case SCROLL_PANE: {
                bl = n == 10004;
                break;
            }
            case TABLE_VIEW: 
            case TREE_TABLE_VIEW: {
                bl = n == 10001 || n == 10006 || n == 10012 || n == 10004;
                break;
            }
            case TREE_VIEW: {
                bl = n == 10001 || n == 10004;
                break;
            }
            case LIST_VIEW: {
                bl = n == 10001 || n == 10006 || n == 10004;
                break;
            }
            case TABLE_CELL: 
            case TREE_TABLE_CELL: {
                bl = n == 10010 || n == 10007 || n == 10013 || n == 10017;
                break;
            }
            case LIST_ITEM: {
                bl = n == 10010 || n == 10007 || n == 10017;
                break;
            }
            case TREE_ITEM: {
                bl = n == 10010 || n == 10005 || n == 10017;
                break;
            }
            case TREE_TABLE_ITEM: {
                bl = n == 10010 || n == 10005 || n == 10007 || n == 10013 || n == 10017;
                break;
            }
            case TEXT_FIELD: 
            case TEXT_AREA: {
                bl = n == 10014 || n == 10002;
                break;
            }
            case TEXT: {
                break;
            }
            case SPLIT_MENU_BUTTON: {
                bl = n == 10000 || n == 10005;
                break;
            }
            case RADIO_BUTTON: {
                bl = n == 10010;
                break;
            }
            case CHECKBOX: {
                bl = n == 10015;
                break;
            }
            case TOGGLE_BUTTON: {
                bl = n == 10015;
                break;
            }
            case TOOLBAR: 
            case TITLED_PANE: {
                bl = n == 10005;
                break;
            }
            case COMBOBOX: {
                bl = n == 10005 || n == 10002;
                break;
            }
            case SLIDER: 
            case PROGRESS_INDICATOR: 
            case SCROLL_BAR: {
                bl = n == 10003;
                break;
            }
            case THUMB: {
                bl = n == 10016;
                break;
            }
        }
        return bl ? this.getNativeAccessible() : 0L;
    }

    long get_HostRawElementProvider() {
        if (this.isDisposed()) {
            return 0L;
        }
        View view = this.getView();
        return view != null ? view.getNativeView() : 0L;
    }

    WinVariant GetPropertyValue(int n) {
        if (this.isDisposed()) {
            return null;
        }
        WinVariant winVariant = null;
        switch (n) {
            case 30003: {
                int n2 = this.getControlType();
                if (n2 == 0) break;
                winVariant = new WinVariant();
                winVariant.vt = (short)3;
                winVariant.lVal = n2;
                break;
            }
            case 30007: {
                String string = (String)this.getAttribute(Attribute.MNEMONIC, new Object[0]);
                if (string == null) break;
                winVariant = new WinVariant();
                winVariant.vt = (short)8;
                winVariant.bstrVal = "Alt" + string.toLowerCase();
                break;
            }
            case 30006: {
                KeyCombination keyCombination = (KeyCombination)this.getAttribute(Attribute.ACCELERATOR, new Object[0]);
                if (keyCombination == null) break;
                winVariant = new WinVariant();
                winVariant.vt = (short)8;
                winVariant.bstrVal = keyCombination.toString().replaceAll("Shortcut", "Ctrl");
                break;
            }
            case 30005: {
                Node node;
                String string;
                Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
                if (role == null) {
                    role = Role.NODE;
                }
                switch (role) {
                    case COMBOBOX: {
                        string = null;
                        break;
                    }
                    default: {
                        string = (String)this.getAttribute(Attribute.TITLE, new Object[0]);
                    }
                }
                if (string != null && string.length() != 0 || (node = (Node)this.getAttribute(Attribute.LABELED_BY, new Object[0])) != null) {
                    // empty if block
                }
                if (string == null || string.length() == 0) break;
                winVariant = new WinVariant();
                winVariant.vt = (short)8;
                winVariant.bstrVal = string;
                break;
            }
            case 30013: {
                String string = (String)this.getAttribute(Attribute.TOOLTIP, new Object[0]);
                if (string == null) break;
                winVariant = new WinVariant();
                winVariant.vt = (short)8;
                winVariant.bstrVal = string;
                break;
            }
            case 30008: {
                Scene scene;
                Boolean bl = (Boolean)this.getAttribute(Attribute.FOCUSED, new Object[0]);
                if (!Boolean.FALSE.equals(bl) || (scene = (Scene)this.getAttribute(Attribute.SCENE, new Object[0])) != null) {
                    // empty if block
                }
                winVariant = new WinVariant();
                winVariant.vt = (short)11;
                winVariant.boolVal = bl != null ? bl : false;
                break;
            }
            case 30016: 
            case 30017: {
                winVariant = new WinVariant();
                winVariant.vt = (short)11;
                winVariant.boolVal = this.getView() != null || !this.isIgnored();
                break;
            }
            case 30010: {
                Boolean bl = (Boolean)this.getAttribute(Attribute.ENABLED, new Object[0]);
                winVariant = new WinVariant();
                winVariant.vt = (short)11;
                winVariant.boolVal = bl != null ? bl : true;
                break;
            }
            case 30009: {
                winVariant = new WinVariant();
                winVariant.vt = (short)11;
                winVariant.boolVal = true;
                break;
            }
            case 30019: {
                Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
                winVariant = new WinVariant();
                winVariant.vt = (short)11;
                winVariant.boolVal = role == Role.PASSWORD_FIELD;
                break;
            }
            case 30011: {
                winVariant = new WinVariant();
                winVariant.vt = (short)8;
                winVariant.bstrVal = "JavaFX" + this.id;
                break;
            }
            case 30107: {
                winVariant = new WinVariant();
                winVariant.vt = (short)8;
                winVariant.bstrVal = "JavaFXProvider";
                break;
            }
        }
        return winVariant;
    }

    float[] get_BoundingRectangle() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.getView() != null) {
            return null;
        }
        Bounds bounds = (Bounds)this.getAttribute(Attribute.BOUNDS, new Object[0]);
        if (bounds != null) {
            return new float[]{(float)bounds.getMinX(), (float)bounds.getMinY(), (float)bounds.getWidth(), (float)bounds.getHeight()};
        }
        return null;
    }

    long get_FragmentRoot() {
        if (this.isDisposed()) {
            return 0L;
        }
        Scene scene = (Scene)this.getAttribute(Attribute.SCENE, new Object[0]);
        if (scene == null) {
            return 0L;
        }
        Accessible accessible = null;
        if (accessible == null) {
            return 0L;
        }
        WinAccessible winAccessible = (WinAccessible)accessible.impl_getDelegate();
        if (winAccessible == null || winAccessible.isDisposed()) {
            return 0L;
        }
        return winAccessible.getNativeAccessible();
    }

    long[] GetEmbeddedFragmentRoots() {
        if (this.isDisposed()) {
            return null;
        }
        return null;
    }

    int[] GetRuntimeId() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.getView() != null) {
            return null;
        }
        return new int[]{3, this.id};
    }

    private long NavigateListView(WinAccessible winAccessible, int n) {
        Object object;
        Node node = winAccessible.getContainerNode();
        if (node == null) {
            return 0L;
        }
        Accessible accessible = null;
        if (accessible == null) {
            return 0L;
        }
        Integer n2 = (Integer)accessible.getAttribute(Attribute.ROW_COUNT, new Object[0]);
        if (n2 == null || n2 == 0) {
            return 0L;
        }
        Integer n3 = (Integer)winAccessible.getAttribute(Attribute.INDEX, new Object[0]);
        if (n3 == null) {
            return 0L;
        }
        switch (n) {
            case 1: {
                object = n3;
                Integer n4 = n3 = Integer.valueOf(n3 + 1);
                break;
            }
            case 2: {
                object = n3;
                Integer n5 = n3 = Integer.valueOf(n3 - 1);
                break;
            }
            case 3: {
                n3 = 0;
                break;
            }
            case 4: {
                n3 = n2 - 1;
            }
        }
        object = (Node)accessible.getAttribute(Attribute.ROW_AT_INDEX, n3);
        return this.getAccessible((Node)object);
    }

    long Navigate(int n2) {
        if (this.isDisposed()) {
            return 0L;
        }
        Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
        boolean bl = role == Role.TREE_ITEM || role == Role.TREE_TABLE_ITEM;
        Node node = null;
        switch (n2) {
            case 0: {
                if (this.getView() != null) {
                    return 0L;
                }
                if (bl) {
                    node = (Node)this.getAttribute(Attribute.TREE_ITEM_PARENT, new Object[0]);
                    if (node != null) break;
                    if (role == Role.TREE_ITEM) {
                        return this.getContainer(Role.TREE_VIEW);
                    }
                    return this.getContainer(Role.TREE_TABLE_VIEW);
                }
                node = (Node)this.getAttribute(Attribute.PARENT, new Object[0]);
                if (node != null) break;
                Scene scene = (Scene)this.getAttribute(Attribute.SCENE, new Object[0]);
                if (scene == null) {
                    return 0L;
                }
                Accessible accessible = null;
                if (accessible == null) {
                    return 0L;
                }
                WinAccessible winAccessible = (WinAccessible)accessible.impl_getDelegate();
                if (winAccessible == null || winAccessible.isDisposed()) {
                    return 0L;
                }
                return winAccessible.getNativeAccessible();
            }
            case 1: 
            case 2: {
                Function<Integer, Node> function;
                Object object;
                if (role == Role.LIST_ITEM) {
                    return this.NavigateListView(this, n2);
                }
                Node node2 = (Node)this.getAttribute(bl ? Attribute.TREE_ITEM_PARENT : Attribute.PARENT, new Object[0]);
                if (node2 == null) break;
                Accessible accessible = null;
                int n3 = 0;
                if (bl) {
                    object = (Integer)accessible.getAttribute(Attribute.TREE_ITEM_COUNT, new Object[0]);
                    if (object == null) {
                        return 0L;
                    }
                    n3 = (Integer)object;
                    function = n -> (Node)accessible.getAttribute(Attribute.TREE_ITEM_AT_INDEX, n);
                } else {
                    object = (ObservableList)accessible.getAttribute(Attribute.CHILDREN, new Object[0]);
                    if (object == null) {
                        return 0L;
                    }
                    n3 = object.size();
                    function = arg_0 -> WinAccessible.lambda$Navigate$136((ObservableList)object, arg_0);
                }
                object = (WinAccessible)accessible.impl_getDelegate();
                int n4 = ((WinAccessible)object).lastIndex;
                int n5 = -1;
                if (0 <= n4 && n4 < n3 && this.getAccessible(function.apply(n4)) == this.peer) {
                    n5 = n4;
                } else {
                    for (int i = 0; i < n3; ++i) {
                        if (this.getAccessible(function.apply(i)) != this.peer) continue;
                        n5 = i;
                        break;
                    }
                }
                if (n5 == -1) break;
                n5 = n2 == 1 ? ++n5 : --n5;
                if (0 > n5 || n5 >= n3) break;
                node = function.apply(n5);
                ((WinAccessible)object).lastIndex = n5;
                break;
            }
            case 3: 
            case 4: {
                this.lastIndex = -1;
                if (role == Role.TREE_VIEW || role == Role.TREE_TABLE_VIEW) {
                    this.lastIndex = 0;
                    node = (Node)this.getAttribute(Attribute.ROW_AT_INDEX, 0);
                    break;
                }
                if (bl) {
                    Integer n6 = (Integer)this.getAttribute(Attribute.TREE_ITEM_COUNT, new Object[0]);
                    if (n6 == null || n6 <= 0) break;
                    this.lastIndex = n2 == 3 ? 0 : n6 - 1;
                    node = (Node)this.getAttribute(Attribute.TREE_ITEM_AT_INDEX, this.lastIndex);
                    break;
                }
                ObservableList observableList = (ObservableList)this.getAttribute(Attribute.CHILDREN, new Object[0]);
                if (observableList != null && observableList.size() > 0) {
                    this.lastIndex = n2 == 3 ? 0 : observableList.size() - 1;
                    node = (Node)observableList.get(this.lastIndex);
                }
                if (node == null) break;
            }
        }
        return this.getAccessible(node);
    }

    void SetFocus() {
        if (this.isDisposed()) {
            return;
        }
    }

    long ElementProviderFromPoint(double d, double d2) {
        if (this.isDisposed()) {
            return 0L;
        }
        Node node = (Node)this.getAttribute(Attribute.NODE_AT_POINT, new Point2D(d, d2));
        return this.getAccessible(node);
    }

    long GetFocus() {
        Node node = (Node)this.getAttribute(Attribute.FOCUS_NODE, new Object[0]);
        if (node == null) {
            return 0L;
        }
        Node node2 = null;
        if (node2 != null) {
            return this.getAccessible(node2);
        }
        return this.getAccessible(node);
    }

    void AdviseEventAdded(int n, long l) {
    }

    void AdviseEventRemoved(int n, long l) {
    }

    void Invoke() {
        if (this.isDisposed()) {
            return;
        }
        this.executeAction(Action.FIRE, new Object[0]);
    }

    long[] GetSelection() {
        if (this.isDisposed()) {
            return null;
        }
        Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
        switch (role) {
            case TABLE_ROW: 
            case TABLE_VIEW: 
            case TREE_TABLE_VIEW: {
                ObservableList observableList = (ObservableList)this.getAttribute(Attribute.SELECTED_CELLS, new Object[0]);
                if (observableList == null) break;
                return observableList.stream().mapToLong(node -> this.getAccessible((Node)node)).toArray();
            }
            case LIST_VIEW: 
            case TREE_VIEW: {
                ObservableList observableList = (ObservableList)this.getAttribute(Attribute.SELECTED_ROWS, new Object[0]);
                if (observableList == null) break;
                return observableList.stream().mapToLong(node -> this.getAccessible((Node)node)).toArray();
            }
            case PAGINATION: {
                Node node2 = (Node)this.getAttribute(Attribute.SELECTED_PAGE, new Object[0]);
                if (node2 == null) break;
                return new long[]{this.getAccessible(node2)};
            }
            case TAB_PANE: {
                Node node3 = (Node)this.getAttribute(Attribute.SELECTED_TAB, new Object[0]);
                if (node3 == null) break;
                return new long[]{this.getAccessible(node3)};
            }
            case TEXT_FIELD: 
            case TEXT_AREA: {
                if (this.selectionRange == null) {
                    this.selectionRange = new WinTextRangeProvider(this);
                }
                if (!this.selectionRangeValid) {
                    int n = (Integer)this.getAttribute(Attribute.SELECTION_START, new Object[0]);
                    int n2 = -1;
                    int n3 = -1;
                    if (n >= 0 && (n2 = ((Integer)this.getAttribute(Attribute.SELECTION_END, new Object[0])).intValue()) >= n) {
                        String string = (String)this.getAttribute(Attribute.TITLE, new Object[0]);
                        n3 = string.length();
                    }
                    if (n3 != -1 && n2 <= n3) {
                        this.selectionRange.setRange(n, n2);
                    } else {
                        this.selectionRange.setRange(0, 0);
                    }
                    this.selectionRangeValid = true;
                }
                return new long[]{this.selectionRange.getNativeProvider()};
            }
        }
        return null;
    }

    boolean get_CanSelectMultiple() {
        if (this.isDisposed()) {
            return false;
        }
        Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
        if (role != null) {
            switch (role) {
                case TABLE_VIEW: 
                case LIST_VIEW: 
                case TREE_TABLE_VIEW: 
                case TREE_VIEW: {
                    return Boolean.TRUE.equals(this.getAttribute(Attribute.MULTIPLE_SELECTION, new Object[0]));
                }
            }
        }
        return false;
    }

    boolean get_IsSelectionRequired() {
        return !this.isDisposed();
    }

    void SetValue(double d) {
        if (this.isDisposed()) {
            return;
        }
        Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
        if (role != null) {
            switch (role) {
                case SLIDER: 
                case SCROLL_BAR: {
                    this.executeAction(Action.SET_VALUE, d);
                    break;
                }
            }
        }
    }

    double get_Value() {
        if (this.isDisposed()) {
            return 0.0;
        }
        Double d = (Double)this.getAttribute(Attribute.VALUE, new Object[0]);
        return d != null ? d : 0.0;
    }

    boolean get_IsReadOnly() {
        if (this.isDisposed()) {
            return false;
        }
        Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
        if (role != null) {
            switch (role) {
                case SLIDER: 
                case TEXT_FIELD: 
                case TEXT_AREA: 
                case SCROLL_BAR: {
                    return false;
                }
                case COMBOBOX: {
                    return Boolean.FALSE.equals(this.getAttribute(Attribute.EDITABLE, new Object[0]));
                }
            }
        }
        return true;
    }

    double get_Maximum() {
        if (this.isDisposed()) {
            return 0.0;
        }
        Double d = (Double)this.getAttribute(Attribute.MAX_VALUE, new Object[0]);
        return d != null ? d : 0.0;
    }

    double get_Minimum() {
        if (this.isDisposed()) {
            return 0.0;
        }
        Double d = (Double)this.getAttribute(Attribute.MIN_VALUE, new Object[0]);
        return d != null ? d : 0.0;
    }

    double get_LargeChange() {
        if (this.isDisposed()) {
            return 0.0;
        }
        return 10.0;
    }

    double get_SmallChange() {
        if (this.isDisposed()) {
            return 0.0;
        }
        return 3.0;
    }

    void SetValueString(String string) {
        if (this.isDisposed()) {
            return;
        }
        Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
        if (role != null) {
            switch (role) {
                case TEXT_FIELD: 
                case TEXT_AREA: {
                    this.executeAction(Action.SET_TITLE, string);
                    break;
                }
            }
        }
    }

    String get_ValueString() {
        if (this.isDisposed()) {
            return null;
        }
        return (String)this.getAttribute(Attribute.TITLE, new Object[0]);
    }

    void Select() {
        if (this.isDisposed()) {
            return;
        }
        Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
        if (role != null) {
            switch (role) {
                case BUTTON: 
                case TOGGLE_BUTTON: 
                case INCREMENT_BUTTON: 
                case DECREMENT_BUTTON: 
                case RADIO_BUTTON: {
                    this.executeAction(Action.FIRE, new Object[0]);
                    break;
                }
                default: {
                    this.executeAction(Action.SELECT, new Object[0]);
                }
            }
        }
    }

    void AddToSelection() {
        if (this.isDisposed()) {
            return;
        }
        this.executeAction(Action.ADD_TO_SELECTION, new Object[0]);
    }

    void RemoveFromSelection() {
        if (this.isDisposed()) {
            return;
        }
        this.executeAction(Action.REMOVE_FROM_SELECTION, new Object[0]);
    }

    boolean get_IsSelected() {
        if (this.isDisposed()) {
            return false;
        }
        return Boolean.TRUE.equals(this.getAttribute(Attribute.SELECTED, new Object[0]));
    }

    long get_SelectionContainer() {
        Node node = this.getContainerNode();
        return node == null ? 0L : this.getAccessible(node);
    }

    long[] GetVisibleRanges() {
        if (this.isDisposed()) {
            return null;
        }
        return new long[]{this.get_DocumentRange()};
    }

    long RangeFromChild(long l) {
        if (this.isDisposed()) {
            return 0L;
        }
        return 0L;
    }

    long RangeFromPoint(double d, double d2) {
        if (this.isDisposed()) {
            return 0L;
        }
        Integer n = (Integer)this.getAttribute(Attribute.OFFSET_AT_POINT, new Point2D(d, d2));
        if (n != null) {
            WinTextRangeProvider winTextRangeProvider = new WinTextRangeProvider(this);
            winTextRangeProvider.setRange(n, n);
            return winTextRangeProvider.getNativeProvider();
        }
        return 0L;
    }

    long get_DocumentRange() {
        if (this.isDisposed()) {
            return 0L;
        }
        if (this.documentRange == null) {
            this.documentRange = new WinTextRangeProvider(this);
        }
        if (!this.documentRangeValid) {
            String string = (String)this.getAttribute(Attribute.TITLE, new Object[0]);
            this.documentRange.setRange(0, string.length());
            this.documentRangeValid = true;
        }
        return this.documentRange.getNativeProvider();
    }

    int get_SupportedTextSelection() {
        if (this.isDisposed()) {
            return 0;
        }
        return 1;
    }

    int get_ColumnCount() {
        if (this.isDisposed()) {
            return 0;
        }
        Integer n = (Integer)this.getAttribute(Attribute.COLUMN_COUNT, new Object[0]);
        return n != null ? n : 1;
    }

    int get_RowCount() {
        if (this.isDisposed()) {
            return 0;
        }
        Integer n = (Integer)this.getAttribute(Attribute.ROW_COUNT, new Object[0]);
        return n != null ? n : 0;
    }

    long GetItem(int n, int n2) {
        if (this.isDisposed()) {
            return 0L;
        }
        Node node = (Node)this.getAttribute(Attribute.CELL_AT_ROW_COLUMN, n, n2);
        return this.getAccessible(node);
    }

    int get_Column() {
        if (this.isDisposed()) {
            return 0;
        }
        Integer n = (Integer)this.getAttribute(Attribute.COLUMN_INDEX, new Object[0]);
        return n != null ? n : 0;
    }

    int get_ColumnSpan() {
        if (this.isDisposed()) {
            return 0;
        }
        return 1;
    }

    long get_ContainingGrid() {
        if (this.isDisposed()) {
            return 0L;
        }
        Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
        if (role != null) {
            switch (role) {
                case TABLE_ROW: 
                case TABLE_CELL: {
                    return this.getContainer(Role.TABLE_VIEW);
                }
                case LIST_ITEM: {
                    return this.getContainer(Role.LIST_VIEW);
                }
                case TREE_TABLE_ITEM: 
                case TREE_TABLE_CELL: {
                    return this.getContainer(Role.TREE_TABLE_VIEW);
                }
            }
        }
        return 0L;
    }

    int get_Row() {
        if (this.isDisposed()) {
            return 0;
        }
        Integer n = null;
        Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
        if (role != null) {
            switch (role) {
                case TABLE_ROW: 
                case TABLE_CELL: 
                case TREE_TABLE_ITEM: 
                case TREE_TABLE_CELL: {
                    n = (Integer)this.getAttribute(Attribute.ROW_INDEX, new Object[0]);
                    break;
                }
                case LIST_ITEM: {
                    n = (Integer)this.getAttribute(Attribute.INDEX, new Object[0]);
                    break;
                }
            }
        }
        return n != null ? n : 0;
    }

    int get_RowSpan() {
        if (this.isDisposed()) {
            return 0;
        }
        return 1;
    }

    long[] GetColumnHeaders() {
        if (this.isDisposed()) {
            return null;
        }
        return null;
    }

    long[] GetRowHeaders() {
        if (this.isDisposed()) {
            return null;
        }
        return null;
    }

    int get_RowOrColumnMajor() {
        if (this.isDisposed()) {
            return 0;
        }
        return 0;
    }

    long[] GetColumnHeaderItems() {
        Accessible accessible;
        if (this.isDisposed()) {
            return null;
        }
        Integer n = (Integer)this.getAttribute(Attribute.COLUMN_INDEX, new Object[0]);
        if (n == null) {
            return null;
        }
        Node node = null;
        Node node2 = (Node)this.getAttribute(Attribute.PARENT, new Object[0]);
        while (node2 != null) {
            accessible = null;
            Role role = (Role)((Object)accessible.getAttribute(Attribute.ROLE, new Object[0]));
            if (role == Role.TABLE_VIEW || role == Role.TREE_TABLE_VIEW) {
                node = node2;
                break;
            }
            node2 = (Node)accessible.getAttribute(Attribute.PARENT, new Object[0]);
        }
        if (node == null) {
            return null;
        }
        accessible = null;
        return new long[]{this.getAccessible((Node)((Object)accessible))};
    }

    long[] GetRowHeaderItems() {
        if (this.isDisposed()) {
            return null;
        }
        return null;
    }

    void Toggle() {
        if (this.isDisposed()) {
            return;
        }
        this.executeAction(Action.FIRE, new Object[0]);
    }

    int get_ToggleState() {
        if (this.isDisposed()) {
            return 0;
        }
        if (Boolean.TRUE.equals(this.getAttribute(Attribute.INDETERMINATE, new Object[0]))) {
            return 2;
        }
        boolean bl = Boolean.TRUE.equals(this.getAttribute(Attribute.SELECTED, new Object[0]));
        return bl ? 1 : 0;
    }

    void Collapse() {
        if (this.isDisposed()) {
            return;
        }
        Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
        if (role == Role.TOOLBAR) {
            Node node = (Node)this.getAttribute(Attribute.OVERFLOW_BUTTON, new Object[0]);
            if (node != null) {
                // empty if block
            }
            return;
        }
        this.executeAction(Action.COLLAPSE, new Object[0]);
    }

    void Expand() {
        if (this.isDisposed()) {
            return;
        }
        Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
        if (role == Role.TOOLBAR) {
            Node node = (Node)this.getAttribute(Attribute.OVERFLOW_BUTTON, new Object[0]);
            if (node != null) {
                // empty if block
            }
            return;
        }
        this.executeAction(Action.EXPAND, new Object[0]);
    }

    int get_ExpandCollapseState() {
        Object object;
        if (this.isDisposed()) {
            return 0;
        }
        Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
        if (role != Role.TOOLBAR || (object = (Node)this.getAttribute(Attribute.OVERFLOW_BUTTON, new Object[0])) != null) {
            // empty if block
        }
        if (Boolean.TRUE.equals(object = this.getAttribute(Attribute.LEAF, new Object[0]))) {
            return 3;
        }
        object = this.getAttribute(Attribute.EXPANDED, new Object[0]);
        boolean bl = Boolean.TRUE.equals(object);
        return bl ? 1 : 0;
    }

    boolean get_CanMove() {
        Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
        switch (role) {
            case THUMB: {
                return true;
            }
        }
        return false;
    }

    boolean get_CanResize() {
        return false;
    }

    boolean get_CanRotate() {
        return false;
    }

    void Move(double d, double d2) {
        this.executeAction(Action.MOVE, d, d2);
    }

    void Resize(double d, double d2) {
    }

    void Rotate(double d) {
    }

    void Scroll(int n, int n2) {
        Node node;
        if (this.isDisposed()) {
            return;
        }
        if (this.get_VerticallyScrollable()) {
            node = (Node)this.getAttribute(Attribute.VERTICAL_SCROLLBAR, new Object[0]);
        }
        if (this.get_HorizontallyScrollable()) {
            node = (Node)this.getAttribute(Attribute.HORIZONTAL_SCROLLBAR, new Object[0]);
        }
    }

    void SetScrollPercent(double d, double d2) {
        Node node;
        if (this.isDisposed()) {
            return;
        }
        if (d2 != -1.0 && this.get_VerticallyScrollable()) {
            node = (Node)this.getAttribute(Attribute.VERTICAL_SCROLLBAR, new Object[0]);
        }
        if (d != -1.0 && this.get_HorizontallyScrollable()) {
            node = (Node)this.getAttribute(Attribute.HORIZONTAL_SCROLLBAR, new Object[0]);
        }
    }

    boolean get_HorizontallyScrollable() {
        if (this.isDisposed()) {
            return false;
        }
        Node node = (Node)this.getAttribute(Attribute.HORIZONTAL_SCROLLBAR, new Object[0]);
        if (node == null) {
            return false;
        }
        Object var2_2 = null;
        return Boolean.TRUE.equals(var2_2);
    }

    double get_HorizontalScrollPercent() {
        if (this.isDisposed()) {
            return 0.0;
        }
        if (!this.get_HorizontallyScrollable()) {
            return -1.0;
        }
        Node node = (Node)this.getAttribute(Attribute.HORIZONTAL_SCROLLBAR, new Object[0]);
        if (node != null) {
            // empty if block
        }
        return 0.0;
    }

    double get_HorizontalViewSize() {
        if (this.isDisposed()) {
            return 0.0;
        }
        if (!this.get_HorizontallyScrollable()) {
            return 100.0;
        }
        Node node = (Node)this.getAttribute(Attribute.CONTENTS, new Object[0]);
        if (node == null) {
            return 100.0;
        }
        Bounds bounds = null;
        if (bounds == null) {
            return 0.0;
        }
        Bounds bounds2 = (Bounds)this.getAttribute(Attribute.BOUNDS, new Object[0]);
        if (bounds2 == null) {
            return 0.0;
        }
        return bounds2.getWidth() / bounds.getWidth() * 100.0;
    }

    boolean get_VerticallyScrollable() {
        if (this.isDisposed()) {
            return false;
        }
        Node node = (Node)this.getAttribute(Attribute.VERTICAL_SCROLLBAR, new Object[0]);
        if (node == null) {
            return false;
        }
        Object var2_2 = null;
        return Boolean.TRUE.equals(var2_2);
    }

    double get_VerticalScrollPercent() {
        if (this.isDisposed()) {
            return 0.0;
        }
        if (!this.get_VerticallyScrollable()) {
            return -1.0;
        }
        Node node = (Node)this.getAttribute(Attribute.VERTICAL_SCROLLBAR, new Object[0]);
        if (node != null) {
            // empty if block
        }
        return 0.0;
    }

    /*
     * Enabled aggressive block sorting
     */
    double get_VerticalViewSize() {
        if (this.isDisposed()) {
            return 0.0;
        }
        if (!this.get_VerticallyScrollable()) {
            return 100.0;
        }
        double d = 0.0;
        Bounds bounds = (Bounds)this.getAttribute(Attribute.BOUNDS, new Object[0]);
        if (bounds == null) {
            return 0.0;
        }
        double d2 = bounds.getHeight();
        Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
        if (role == Role.SCROLL_PANE) {
            Node node = (Node)this.getAttribute(Attribute.CONTENTS, new Object[0]);
            if (node == null) {
                // empty if block
            }
        } else {
            Integer n = 0;
            switch (role) {
                case TABLE_VIEW: 
                case LIST_VIEW: 
                case TREE_TABLE_VIEW: 
                case TREE_VIEW: {
                    n = (Integer)this.getAttribute(Attribute.ROW_COUNT, new Object[0]);
                    break;
                }
            }
            if (n == null) {
                return 0.0;
            }
            double d3 = d = (double)(n * 24);
        }
        if (d == 0.0) {
            return 0.0;
        }
        double d4 = d2 / d * 100.0;
        return d4;
    }

    void ScrollIntoView() {
        if (this.isDisposed()) {
            return;
        }
        Integer n = (Integer)this.getAttribute(Attribute.INDEX, new Object[0]);
        if (n == null) {
            n = (Integer)this.getAttribute(Attribute.ROW_INDEX, new Object[0]);
        }
        Node node = this.getContainerNode();
        if (n == null || node != null) {
            // empty if block
        }
    }

    private static /* synthetic */ Node lambda$Navigate$136(ObservableList observableList, Integer n) {
        return (Node)observableList.get(n);
    }
}

