/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.util.Collections;
import java.util.List;
import jdk.nashorn.api.scripting.JSObject;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.ScriptFunctionImpl;
import jdk.nashorn.internal.parser.Parser;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ParserException;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.Undefined;

public final class NativeFunction {
    private static PropertyMap $nasgenmap$;

    private NativeFunction() {
        throw new UnsupportedOperationException();
    }

    public static String toString(Object self) {
        if (!(self instanceof ScriptFunction)) {
            throw ECMAErrors.typeError("not.a.function", ScriptRuntime.safeToString(self));
        }
        return ((ScriptFunction)self).toSource();
    }

    public static Object apply(Object self, Object thiz, Object array) {
        if (!(self instanceof ScriptFunction) && !(self instanceof JSObject)) {
            throw ECMAErrors.typeError("not.a.function", ScriptRuntime.safeToString(self));
        }
        Object[] args = null;
        if (array instanceof ScriptObject) {
            ScriptObject sobj = (ScriptObject)array;
            Object len = sobj.getLength();
            int n = (int)JSType.toUint32(len);
            args = new Object[n];
            for (int i = 0; i < args.length; ++i) {
                args[i] = sobj.get(i);
            }
        } else if (array instanceof Object[]) {
            args = (Object[])array;
        } else if (array instanceof List) {
            List list = (List)array;
            args = new Object[list.size()];
            list.toArray(args);
        } else if (array == null || array == ScriptRuntime.UNDEFINED) {
            args = ScriptRuntime.EMPTY_ARRAY;
        } else if (array instanceof JSObject) {
            JSObject jsObj = (JSObject)array;
            Object len = jsObj.hasMember("length") ? jsObj.getMember("length") : Integer.valueOf(0);
            int n = (int)JSType.toUint32(len);
            args = new Object[n];
            for (int i = 0; i < args.length; ++i) {
                args[i] = jsObj.hasSlot(i) ? jsObj.getSlot(i) : ScriptRuntime.UNDEFINED;
            }
        } else {
            throw ECMAErrors.typeError("function.apply.expects.array", new String[0]);
        }
        if (self instanceof ScriptFunction) {
            return ScriptRuntime.apply((ScriptFunction)self, thiz, args);
        }
        if (self instanceof JSObject) {
            return ((JSObject)self).call(thiz, args);
        }
        throw new AssertionError((Object)"should not reach here");
    }

    public static Object call(Object self, Object ... args) {
        Object[] arguments;
        Undefined thiz;
        if (!(self instanceof ScriptFunction) && !(self instanceof JSObject)) {
            throw ECMAErrors.typeError("not.a.function", ScriptRuntime.safeToString(self));
        }
        Undefined undefined = thiz = args.length == 0 ? ScriptRuntime.UNDEFINED : args[0];
        if (args.length > 1) {
            arguments = new Object[args.length - 1];
            System.arraycopy(args, 1, arguments, 0, arguments.length);
        } else {
            arguments = ScriptRuntime.EMPTY_ARRAY;
        }
        if (self instanceof ScriptFunction) {
            return ScriptRuntime.apply((ScriptFunction)self, thiz, arguments);
        }
        if (self instanceof JSObject) {
            return ((JSObject)self).call(thiz, arguments);
        }
        throw new AssertionError((Object)"should not reach here");
    }

    public static ScriptFunction bind(Object self, Object ... args) {
        Object[] arguments;
        Undefined thiz;
        if (!(self instanceof ScriptFunction)) {
            throw ECMAErrors.typeError("not.a.function", ScriptRuntime.safeToString(self));
        }
        Undefined undefined = thiz = args.length == 0 ? ScriptRuntime.UNDEFINED : args[0];
        if (args.length > 1) {
            arguments = new Object[args.length - 1];
            System.arraycopy(args, 1, arguments, 0, arguments.length);
        } else {
            arguments = ScriptRuntime.EMPTY_ARRAY;
        }
        return ((ScriptFunctionImpl)self).makeBoundFunction(thiz, arguments);
    }

    public static String toSource(Object self) {
        if (!(self instanceof ScriptFunction)) {
            throw ECMAErrors.typeError("not.a.function", ScriptRuntime.safeToString(self));
        }
        return ((ScriptFunction)self).toSource();
    }

    public static ScriptFunction function(boolean newObj, Object self, Object ... args) {
        String funcBody;
        StringBuilder sb = new StringBuilder();
        sb.append("(function (");
        if (args.length > 0) {
            StringBuilder paramListBuf = new StringBuilder();
            for (int i = 0; i < args.length - 1; ++i) {
                paramListBuf.append(JSType.toString(args[i]));
                if (i >= args.length - 2) continue;
                paramListBuf.append(",");
            }
            funcBody = JSType.toString(args[args.length - 1]);
            String paramList = paramListBuf.toString();
            if (!paramList.isEmpty()) {
                NativeFunction.checkFunctionParameters(paramList);
                sb.append(paramList);
            }
        } else {
            funcBody = null;
        }
        sb.append(") {\n");
        if (args.length > 0) {
            NativeFunction.checkFunctionBody(funcBody);
            sb.append(funcBody);
            sb.append('\n');
        }
        sb.append("})");
        Global global = Global.instance();
        return (ScriptFunction)Global.directEval(global, sb.toString(), global, "<function>", global.isStrictContext());
    }

    private static void checkFunctionParameters(String params) {
        Source src = Source.sourceFor("<function>", params);
        Parser parser = new Parser(Global.getEnv(), src, new Context.ThrowErrorManager());
        try {
            parser.parseFormalParameterList();
        }
        catch (ParserException pe) {
            pe.throwAsEcmaException();
        }
    }

    private static void checkFunctionBody(String funcBody) {
        Source src = Source.sourceFor("<function>", funcBody);
        Parser parser = new Parser(Global.getEnv(), src, new Context.ThrowErrorManager());
        try {
            parser.parseFunctionBody();
        }
        catch (ParserException pe) {
            pe.throwAsEcmaException();
        }
    }

    static {
        NativeFunction.$clinit$();
    }

    public static void $clinit$() {
        $nasgenmap$ = PropertyMap.newMap(Collections.EMPTY_LIST);
    }
}

