/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import sun.invoke.WrapperInstance;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;

public class MethodHandleProxies {
    private MethodHandleProxies() {
    }

    @CallerSensitive
    public static <T> T asInterfaceInstance(final Class<T> clazz, final MethodHandle methodHandle) {
        Object object;
        Object object2;
        MethodHandle methodHandle2;
        Object object3;
        Object object4;
        if (!clazz.isInterface() || !Modifier.isPublic(clazz.getModifiers())) {
            throw new IllegalArgumentException("not a public interface: " + clazz.getName());
        }
        if (System.getSecurityManager() != null) {
            object4 = Reflection.getCallerClass();
            object3 = object4 != null ? ((Class)object4).getClassLoader() : null;
            ReflectUtil.checkProxyPackageAccess((ClassLoader)object3, clazz);
            methodHandle2 = MethodHandleProxies.maybeBindCaller(methodHandle, object4);
        } else {
            methodHandle2 = methodHandle;
        }
        object4 = clazz.getClassLoader();
        if (object4 == null) {
            object3 = Thread.currentThread().getContextClassLoader();
            Object object5 = object4 = object3 != null ? object3 : ClassLoader.getSystemClassLoader();
        }
        if ((object3 = MethodHandleProxies.getSingleNameMethods(clazz)) == null) {
            throw new IllegalArgumentException("not a single-method interface: " + clazz.getName());
        }
        MethodHandle[] methodHandleArray = new MethodHandle[((Method[])object3).length];
        for (int i = 0; i < ((Method[])object3).length; ++i) {
            object2 = object3[i];
            object = MethodType.methodType(((Method)object2).getReturnType(), ((Method)object2).getParameterTypes());
            MethodHandle methodHandle3 = methodHandle2.asType((MethodType)object);
            methodHandle3 = methodHandle3.asType(methodHandle3.type().changeReturnType(Object.class));
            methodHandleArray[i] = methodHandle3.asSpreader(Object[].class, ((MethodType)object).parameterCount());
        }
        InvocationHandler invocationHandler = new InvocationHandler((Method[])object3, methodHandleArray){
            final /* synthetic */ Method[] val$methods;
            final /* synthetic */ MethodHandle[] val$vaTargets;
            {
                this.val$methods = methodArray;
                this.val$vaTargets = methodHandleArray;
            }

            private Object getArg(String string) {
                if (string == "getWrapperInstanceTarget") {
                    return methodHandle;
                }
                if (string == "getWrapperInstanceType") {
                    return clazz;
                }
                throw new AssertionError();
            }

            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                for (int i = 0; i < this.val$methods.length; ++i) {
                    if (!method.equals(this.val$methods[i])) continue;
                    return this.val$vaTargets[i].invokeExact(objectArray);
                }
                if (method.getDeclaringClass() == WrapperInstance.class) {
                    return this.getArg(method.getName());
                }
                if (MethodHandleProxies.isObjectMethod(method)) {
                    return MethodHandleProxies.callObjectMethod(this, method, objectArray);
                }
                throw new InternalError("bad proxy method: " + method);
            }
        };
        if (System.getSecurityManager() != null) {
            object = object4;
            object2 = AccessController.doPrivileged(new PrivilegedAction<Object>((ClassLoader)object, clazz, invocationHandler){
                final /* synthetic */ ClassLoader val$loader;
                final /* synthetic */ Class val$intfc;
                final /* synthetic */ InvocationHandler val$ih;
                {
                    this.val$loader = classLoader;
                    this.val$intfc = clazz;
                    this.val$ih = invocationHandler;
                }

                @Override
                public Object run() {
                    return Proxy.newProxyInstance(this.val$loader, new Class[]{this.val$intfc, WrapperInstance.class}, this.val$ih);
                }
            });
        } else {
            object2 = Proxy.newProxyInstance((ClassLoader)object4, new Class[]{clazz, WrapperInstance.class}, invocationHandler);
        }
        return clazz.cast(object2);
    }

    private static MethodHandle maybeBindCaller(MethodHandle methodHandle, Class<?> clazz) {
        if (clazz == null || clazz.getClassLoader() == null) {
            return methodHandle;
        }
        MethodHandle methodHandle2 = MethodHandleImpl.bindCaller(methodHandle, clazz);
        if (methodHandle.isVarargsCollector()) {
            MethodType methodType = methodHandle2.type();
            int n = methodType.parameterCount();
            return methodHandle2.asVarargsCollector(methodType.parameterType(n - 1));
        }
        return methodHandle2;
    }

    public static boolean isWrapperInstance(Object object) {
        return object instanceof WrapperInstance;
    }

    private static WrapperInstance asWrapperInstance(Object object) {
        try {
            if (object != null) {
                return (WrapperInstance)object;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        throw new IllegalArgumentException("not a wrapper instance");
    }

    public static MethodHandle wrapperInstanceTarget(Object object) {
        return MethodHandleProxies.asWrapperInstance(object).getWrapperInstanceTarget();
    }

    public static Class<?> wrapperInstanceType(Object object) {
        return MethodHandleProxies.asWrapperInstance(object).getWrapperInstanceType();
    }

    private static boolean isObjectMethod(Method method) {
        switch (method.getName()) {
            case "toString": {
                return method.getReturnType() == String.class && method.getParameterTypes().length == 0;
            }
            case "hashCode": {
                return method.getReturnType() == Integer.TYPE && method.getParameterTypes().length == 0;
            }
            case "equals": {
                return method.getReturnType() == Boolean.TYPE && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class;
            }
        }
        return false;
    }

    private static Object callObjectMethod(Object object, Method method, Object[] objectArray) {
        assert (MethodHandleProxies.isObjectMethod(method)) : method;
        switch (method.getName()) {
            case "toString": {
                return object.getClass().getName() + "@" + Integer.toHexString(object.hashCode());
            }
            case "hashCode": {
                return System.identityHashCode(object);
            }
            case "equals": {
                return object == objectArray[0];
            }
        }
        return null;
    }

    private static Method[] getSingleNameMethods(Class<?> clazz) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        String string = null;
        for (Method method : clazz.getMethods()) {
            if (MethodHandleProxies.isObjectMethod(method) || !Modifier.isAbstract(method.getModifiers())) continue;
            String string2 = method.getName();
            if (string == null) {
                string = string2;
            } else if (!string.equals(string2)) {
                return null;
            }
            arrayList.add(method);
        }
        if (string == null) {
            return null;
        }
        return arrayList.toArray(new Method[arrayList.size()]);
    }
}

