/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.RTTexture;
import com.sun.prism.Texture;
import com.sun.prism.impl.BufferUtil;
import com.sun.prism.impl.Disposer;
import com.sun.prism.impl.ManagedResource;
import java.nio.IntBuffer;
import java.util.concurrent.atomic.AtomicInteger;

final class UploadingPainter
extends ViewPainter
implements Runnable {
    private Application app = Application.GetApplication();
    private Pixels pix;
    private IntBuffer textureBits;
    private IntBuffer pixBits;
    private final AtomicInteger uploadCount = new AtomicInteger(0);
    private RTTexture rttexture;
    private volatile float pixScaleFactor = 1.0f;

    UploadingPainter(GlassScene glassScene) {
        super(glassScene);
    }

    void disposeRTTexture() {
        if (this.rttexture != null) {
            this.rttexture.dispose();
            this.rttexture = null;
        }
    }

    public void setPixelScaleFactor(float f) {
        this.pixScaleFactor = f;
    }

    @Override
    public float getPixelScaleFactor() {
        return this.pixScaleFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        renderLock.lock();
        boolean bl = false;
        boolean bl2 = false;
        try {
            Graphics graphics;
            boolean bl3;
            bl = this.validateStageGraphics();
            if (!bl) {
                if (QuantumToolkit.verbose) {
                    System.err.println("UploadingPainter: validateStageGraphics failed");
                }
                this.paintImpl(null);
                return;
            }
            if (this.factory == null) {
                this.factory = GraphicsPipeline.getDefaultResourceFactory();
            }
            if (this.factory == null || !this.factory.isDeviceReady()) {
                return;
            }
            float f = this.pixScaleFactor;
            boolean bl4 = bl3 = this.pix == null || f != this.pix.getScaleUnsafe() || this.viewWidth != this.penWidth || this.viewHeight != this.penHeight;
            if (!bl3) {
                this.rttexture.lock();
                if (this.rttexture.isSurfaceLost()) {
                    this.rttexture.unlock();
                    this.sceneState.getScene().entireSceneNeedsRepaint();
                    bl3 = true;
                }
            }
            int n = Math.round((float)this.viewWidth * f);
            int n2 = Math.round((float)this.viewHeight * f);
            if (bl3) {
                this.disposeRTTexture();
                this.rttexture = this.factory.createRTTexture(n, n2, Texture.WrapMode.CLAMP_NOT_NEEDED);
                if (this.rttexture == null) {
                    return;
                }
                this.penWidth = this.viewWidth;
                this.penHeight = this.viewHeight;
                this.textureBits = null;
                this.pixBits = null;
                this.freshBackBuffer = true;
            }
            if ((graphics = this.rttexture.createGraphics()) == null) {
                this.disposeRTTexture();
                this.sceneState.getScene().entireSceneNeedsRepaint();
                return;
            }
            graphics.scale(f, f);
            this.paintImpl(graphics);
            this.freshBackBuffer = false;
            int[] nArray = this.rttexture.getPixels();
            if (nArray != null) {
                if (this.pixBits == null || this.uploadCount.get() > 0) {
                    this.pixBits = IntBuffer.allocate(n * n2);
                }
                System.arraycopy(nArray, 0, this.pixBits.array(), 0, n * n2);
                this.pix = this.app.createPixels(n, n2, this.pixBits, f);
            } else {
                if (this.textureBits == null || this.uploadCount.get() > 0) {
                    this.textureBits = BufferUtil.newIntBuffer(n * n2);
                }
                if (this.textureBits != null) {
                    if (this.rttexture.readPixels(this.textureBits)) {
                        this.pix = this.app.createPixels(n, n2, this.textureBits, f);
                    } else {
                        this.sceneState.getScene().entireSceneNeedsRepaint();
                        this.disposeRTTexture();
                        this.pix = null;
                    }
                }
            }
            if (this.rttexture != null) {
                this.rttexture.unlock();
            }
            if (this.pix != null) {
                this.uploadCount.incrementAndGet();
                this.sceneState.uploadPixels(this.pix, this.uploadCount);
            }
        }
        catch (Throwable throwable) {
            bl2 = true;
            throwable.printStackTrace(System.err);
        }
        finally {
            if (this.rttexture != null && this.rttexture.isLocked()) {
                this.rttexture.unlock();
            }
            Disposer.cleanUp();
            this.sceneState.getScene().setPainting(false);
            ManagedResource.freeDisposalRequestedAndCheckResources(bl2);
            renderLock.unlock();
        }
    }
}

