/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.prism.GraphicsResource;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.ResourcePool;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class ManagedResource<T>
implements GraphicsResource {
    private static final boolean trackLockSources = false;
    private static final int FOREVER = 1024;
    private static WeakLinkedList resourceHead = new WeakLinkedList();
    protected T resource;
    private final ResourcePool<T> pool;
    private int lockcount;
    private int employcount;
    ArrayList<Throwable> lockedFrom;
    private boolean permanent;
    private boolean mismatchDetected;
    private boolean disposalRequested = false;
    private int age;

    public static void cleanup(ResourcePool resourcePool, PruningLevel pruningLevel) {
        ManagedResource.cleanup(resourcePool, pruningLevel, 1024);
    }

    public static boolean cleanup(ResourcePool resourcePool, long l) {
        if (resourcePool.used() + l <= resourcePool.target()) {
            return true;
        }
        ManagedResource.cleanup(resourcePool, PruningLevel.OBSOLETE, 1024);
        if (resourcePool.used() + l <= resourcePool.target()) {
            return true;
        }
        ManagedResource.cleanup(resourcePool, PruningLevel.UNUSED_FOREVER, 1024);
        if (resourcePool.used() + l <= resourcePool.target()) {
            return true;
        }
        ManagedResource.cleanup(resourcePool, PruningLevel.UNUSED_FOREVER, 512);
        if (resourcePool.used() + l <= resourcePool.target()) {
            return true;
        }
        ManagedResource.cleanup(resourcePool, PruningLevel.UNUSED_FOREVER, 256);
        if (resourcePool.used() + l <= resourcePool.target()) {
            return true;
        }
        ManagedResource.cleanup(resourcePool, PruningLevel.UNINTERESTING, 1024);
        if (resourcePool.used() + l <= resourcePool.target()) {
            return true;
        }
        System.gc();
        ManagedResource.cleanup(resourcePool, PruningLevel.ALL_UNLOCKED, 1024);
        if (resourcePool.used() + l <= resourcePool.max()) {
            return true;
        }
        System.gc();
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ManagedResource.cleanup(resourcePool, PruningLevel.ALL_UNLOCKED, 1024);
        return resourcePool.used() + l <= resourcePool.max();
    }

    private static boolean _isgone(ManagedResource managedResource) {
        if (managedResource == null) {
            return true;
        }
        if (managedResource.disposalRequested) {
            managedResource.free();
            managedResource.resource = null;
            managedResource.disposalRequested = false;
            return true;
        }
        return !managedResource.isValid();
    }

    private static void cleanup(ResourcePool resourcePool, PruningLevel pruningLevel, int n) {
        if (PrismSettings.poolDebug) {
            switch (pruningLevel) {
                case OBSOLETE: {
                    System.err.print("Pruning");
                    break;
                }
                case UNUSED_FOREVER: {
                    System.err.print("Cleaning up unused in " + n);
                    break;
                }
                case UNINTERESTING: {
                    System.err.print("Cleaning up uninteresting");
                    break;
                }
                case ALL_UNLOCKED: {
                    System.err.print("Aggressively cleaning up");
                    break;
                }
                default: {
                    throw new InternalError("Unrecognized pruning level: " + (Object)((Object)pruningLevel));
                }
            }
            System.err.println(" pool: " + resourcePool);
            ManagedResource.printSummary(false);
        }
        long l = resourcePool.used();
        WeakLinkedList weakLinkedList = resourceHead;
        WeakLinkedList weakLinkedList2 = weakLinkedList.next;
        while (weakLinkedList2 != null) {
            ManagedResource managedResource = weakLinkedList2.getResource();
            if (ManagedResource._isgone(managedResource)) {
                if (PrismSettings.poolDebug) {
                    System.err.println("pruning: " + managedResource + " (" + weakLinkedList2.size + ")" + (managedResource == null ? "" : (managedResource.isPermanent() ? " perm" : "") + (managedResource.isLocked() ? " lock" : "") + (managedResource.isInteresting() ? " int" : "")));
                }
                weakLinkedList2.pool.recordFree(weakLinkedList2.size);
                weakLinkedList.next = weakLinkedList2 = weakLinkedList2.next;
                continue;
            }
            if (!(pruningLevel == PruningLevel.OBSOLETE || managedResource.getPool() != resourcePool || managedResource.isPermanent() || managedResource.isLocked() || pruningLevel != PruningLevel.ALL_UNLOCKED && (pruningLevel != PruningLevel.UNINTERESTING || managedResource.isInteresting()) && managedResource.age < n)) {
                if (PrismSettings.poolDebug) {
                    System.err.println("disposing: " + managedResource + " (" + weakLinkedList2.size + ") age=" + managedResource.age + (managedResource.isPermanent() ? " perm" : "") + (managedResource.isLocked() ? " lock" : "") + (managedResource.isInteresting() ? " int" : ""));
                }
                managedResource.free();
                managedResource.resource = null;
                weakLinkedList2.pool.recordFree(weakLinkedList2.size);
                weakLinkedList.next = weakLinkedList2 = weakLinkedList2.next;
                continue;
            }
            weakLinkedList = weakLinkedList2;
            weakLinkedList2 = weakLinkedList2.next;
        }
        if (PrismSettings.poolDebug) {
            long l2 = resourcePool.used();
            System.err.println("cleaned up " + (l - l2) + " from pool: " + resourcePool);
            ManagedResource.printSummary(false);
        }
    }

    public static void freeDisposalRequestedAndCheckResources(boolean bl) {
        boolean bl2 = false;
        WeakLinkedList weakLinkedList = resourceHead;
        WeakLinkedList weakLinkedList2 = weakLinkedList.next;
        while (weakLinkedList2 != null) {
            ManagedResource managedResource = weakLinkedList2.getResource();
            if (ManagedResource._isgone(managedResource)) {
                weakLinkedList2.pool.recordFree(weakLinkedList2.size);
                weakLinkedList.next = weakLinkedList2 = weakLinkedList2.next;
                continue;
            }
            if (!managedResource.isPermanent()) {
                int n;
                if (managedResource.isLocked() && !managedResource.mismatchDetected) {
                    if (bl) {
                        managedResource.unlockall();
                    } else {
                        managedResource.mismatchDetected = true;
                        bl2 = true;
                    }
                }
                if ((n = managedResource.age) < 1024) {
                    managedResource.age = n + 1;
                }
            }
            weakLinkedList = weakLinkedList2;
            weakLinkedList2 = weakLinkedList2.next;
        }
        if (PrismSettings.poolStats || bl2) {
            if (bl2) {
                System.err.println("Outstanding resource locks detected:");
            }
            ManagedResource.printSummary();
        }
    }

    public static void printSummary() {
        ManagedResource.printSummary(true);
    }

    public static void printSummary(boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        long l = 0L;
        int n7 = 0;
        HashMap<ResourcePool, ResourcePool> hashMap = new HashMap<ResourcePool, ResourcePool>();
        WeakLinkedList weakLinkedList = ManagedResource.resourceHead.next;
        while (weakLinkedList != null) {
            ManagedResource managedResource = weakLinkedList.getResource();
            ++n7;
            if (managedResource == null || !managedResource.isValid() || managedResource.disposalRequested) {
                ++n;
            } else {
                ResourcePool resourcePool = managedResource.getPool();
                if (!hashMap.containsKey(resourcePool)) {
                    hashMap.put(resourcePool, resourcePool);
                    double d = (double)resourcePool.used() * 100.0 / (double)resourcePool.max();
                    double d2 = (double)resourcePool.managed() * 100.0 / (double)resourcePool.max();
                    String string = String.format("%s: %,d used (%.1f%%), %,d managed (%.1f%%), %,d total", resourcePool, resourcePool.used(), d, resourcePool.managed(), d2, resourcePool.max());
                    System.err.println(string);
                }
                l += (long)managedResource.age;
                if (managedResource.age >= 1024) {
                    ++n6;
                }
                if (managedResource.mismatchDetected) {
                    ++n5;
                }
                if (managedResource.isPermanent()) {
                    ++n3;
                } else if (managedResource.isLocked()) {
                    ++n2;
                }
                if (managedResource.isInteresting()) {
                    ++n4;
                }
            }
            weakLinkedList = weakLinkedList.next;
        }
        double d = (double)l / (double)n7;
        System.err.println(n7 + " total resources being managed");
        System.err.println(String.format("average resource age is %.1f frames", d));
        ManagedResource.printpoolpercent(n6, n7, "at maximum supported age");
        ManagedResource.printpoolpercent(n3, n7, "marked permanent");
        ManagedResource.printpoolpercent(n5, n7, "have had mismatched locks");
        ManagedResource.printpoolpercent(n2, n7, "locked");
        ManagedResource.printpoolpercent(n4, n7, "contain interesting data");
        ManagedResource.printpoolpercent(n, n7, "disappeared");
        System.err.println();
    }

    private static void printpoolpercent(int n, int n2, String string) {
        double d = (double)n * 100.0 / (double)n2;
        String string2 = String.format("%,d resources %s (%.1f%%)", n, string, d);
        System.err.println(string2);
    }

    protected ManagedResource(T t, ResourcePool<T> resourcePool) {
        this.resource = t;
        this.pool = resourcePool;
        this.link();
        this.lock();
    }

    private void link() {
        resourceHead.insert(this);
    }

    private void unlink() {
        WeakLinkedList weakLinkedList = resourceHead;
        WeakLinkedList weakLinkedList2 = weakLinkedList.next;
        while (weakLinkedList2 != null) {
            ManagedResource managedResource = weakLinkedList2.getResource();
            if (managedResource == null || managedResource == this) {
                weakLinkedList2.pool.recordFree(weakLinkedList2.size);
                weakLinkedList.next = weakLinkedList2 = weakLinkedList2.next;
                if (managedResource != this) continue;
                break;
            }
            weakLinkedList = weakLinkedList2;
            weakLinkedList2 = weakLinkedList2.next;
        }
    }

    public final T getResource() {
        this.assertLocked();
        return this.resource;
    }

    public final ResourcePool getPool() {
        return this.pool;
    }

    public boolean isValid() {
        return this.resource != null && !this.disposalRequested;
    }

    public final boolean isLocked() {
        return this.lockcount > 0;
    }

    public final int getLockCount() {
        return this.lockcount;
    }

    public final void assertLocked() {
        if (this.lockcount <= 0) {
            throw new IllegalStateException("Operation requires resource lock");
        }
    }

    public final boolean isPermanent() {
        return this.permanent;
    }

    public final boolean isInteresting() {
        return this.employcount > 0;
    }

    public final int getInterestCount() {
        return this.employcount;
    }

    public void free() {
    }

    @Override
    public final void dispose() {
        if (this.pool.isManagerThread()) {
            if (this.resource != null) {
                this.free();
                this.disposalRequested = false;
                this.resource = null;
                this.unlink();
            }
        } else {
            this.disposalRequested = true;
        }
    }

    public final void makePermanent() {
        this.assertLocked();
        this.permanent = true;
    }

    public final T lock() {
        ++this.lockcount;
        this.age = 0;
        return this.resource;
    }

    private void unlockall() {
        this.lockcount = 0;
    }

    public final void unlock() {
        this.assertLocked();
        --this.lockcount;
    }

    public final void contentsUseful() {
        this.assertLocked();
        ++this.employcount;
    }

    public final void contentsNotUseful() {
        if (this.employcount <= 0) {
            throw new IllegalStateException("Resource obsoleted too many times");
        }
        --this.employcount;
    }

    public static enum PruningLevel {
        OBSOLETE,
        UNUSED_FOREVER,
        UNINTERESTING,
        ALL_UNLOCKED;

    }

    static class WeakLinkedList {
        final WeakReference<ManagedResource> theResourceRef;
        final ResourcePool pool;
        final long size;
        WeakLinkedList next;

        WeakLinkedList() {
            this.theResourceRef = null;
            this.pool = null;
            this.size = 0L;
        }

        WeakLinkedList(ManagedResource managedResource, WeakLinkedList weakLinkedList) {
            this.theResourceRef = new WeakReference<ManagedResource>(managedResource);
            this.pool = managedResource.pool;
            this.size = this.pool.size(managedResource.resource);
            this.pool.recordAllocated(this.size);
            this.next = weakLinkedList;
        }

        void insert(ManagedResource managedResource) {
            this.next = new WeakLinkedList(managedResource, this.next);
        }

        ManagedResource getResource() {
            return (ManagedResource)this.theResourceRef.get();
        }
    }
}

