/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.types.Range;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.TemporarySymbols;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.Debug;
import jdk.nashorn.internal.runtime.options.Options;

public final class Symbol
implements Comparable<Symbol> {
    public static final int IS_TEMP = 1;
    public static final int IS_GLOBAL = 2;
    public static final int IS_VAR = 3;
    public static final int IS_PARAM = 4;
    public static final int IS_CONSTANT = 5;
    public static final int KINDMASK = 7;
    public static final int IS_SCOPE = 16;
    public static final int IS_THIS = 32;
    public static final int CAN_BE_UNDEFINED = 64;
    public static final int IS_ALWAYS_DEFINED = 256;
    public static final int CAN_BE_PRIMITIVE = 512;
    public static final int IS_LET = 1024;
    public static final int IS_INTERNAL = 2048;
    public static final int IS_FUNCTION_SELF = 4096;
    public static final int IS_SPECIALIZED_PARAM = 8192;
    public static final int IS_SHARED = 16384;
    public static final int IS_FUNCTION_DECLARATION = 32768;
    private final String name;
    private int flags;
    private Type type;
    private int slot;
    private int fieldIndex;
    private int useCount;
    private Range range;
    private static final Set<String> TRACE_SYMBOLS;
    private static final Set<String> TRACE_SYMBOLS_STACKTRACE;

    protected Symbol(String name, int flags, Type type, int slot) {
        this.name = name;
        this.flags = flags;
        this.type = type;
        this.slot = slot;
        this.fieldIndex = -1;
        this.range = Range.createUnknownRange();
        this.trace("CREATE SYMBOL");
    }

    public Symbol(String name, int flags) {
        this(name, flags, Type.UNKNOWN, -1);
    }

    public Symbol(String name, int flags, Type type) {
        this(name, flags, type, -1);
    }

    private Symbol(Symbol base, String name, int flags) {
        this.flags = flags;
        this.name = name;
        this.fieldIndex = base.fieldIndex;
        this.slot = base.slot;
        this.type = base.type;
        this.useCount = base.useCount;
        this.range = base.range;
    }

    private static String align(String string, int max) {
        StringBuilder sb = new StringBuilder();
        sb.append(string.substring(0, Math.min(string.length(), max)));
        while (sb.length() < max) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public final Type getSymbolType() {
        return this.type;
    }

    void print(PrintWriter stream) {
        String printName = Symbol.align(this.name, 20);
        String printType = Symbol.align(this.type.toString(), 10);
        String printSlot = Symbol.align(this.slot == -1 ? "none" : "" + this.slot, 10);
        String printFlags = "";
        switch (this.flags & 7) {
            case 1: {
                printFlags = "temp " + printFlags;
                break;
            }
            case 2: {
                printFlags = "global " + printFlags;
                break;
            }
            case 3: {
                printFlags = "var " + printFlags;
                break;
            }
            case 4: {
                printFlags = "param " + printFlags;
                break;
            }
            case 5: {
                printFlags = "CONSTANT " + printFlags;
                break;
            }
        }
        if (this.isScope()) {
            printFlags = printFlags + "scope ";
        }
        if (this.isInternal()) {
            printFlags = printFlags + "internal ";
        }
        if (this.isLet()) {
            printFlags = printFlags + "let ";
        }
        if (this.isThis()) {
            printFlags = printFlags + "this ";
        }
        if (!this.canBeUndefined()) {
            printFlags = printFlags + "always_def ";
        }
        if (this.canBePrimitive()) {
            printFlags = printFlags + "can_be_prim ";
        }
        stream.print(printName + ": " + printType + ", " + printSlot + ", " + printFlags);
        stream.println();
    }

    public boolean less(int other) {
        return (this.flags & 7) < (other & 7);
    }

    public void setNeedsSlot(boolean needsSlot) {
        this.setSlot(needsSlot ? 0 : -1);
    }

    public int slotCount() {
        return this.type.isCategory2() ? 2 : 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(' ').append('(').append(this.getSymbolType().getTypeClass().getSimpleName()).append(')');
        if (this.hasSlot()) {
            sb.append(' ').append('(').append("slot=").append(this.slot).append(')');
        }
        if (this.isScope()) {
            if (this.isGlobal()) {
                sb.append(" G");
            } else {
                sb.append(" S");
            }
        }
        if (this.canBePrimitive()) {
            sb.append(" P?");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(Symbol other) {
        return this.name.compareTo(other.name);
    }

    public boolean hasSlot() {
        return this.slot >= 0;
    }

    public boolean isTemp() {
        return (this.flags & 7) == 1;
    }

    public boolean isScope() {
        assert ((this.flags & 7) != 2 || (this.flags & 0x10) == 16) : "global without scope flag";
        return (this.flags & 0x10) == 16;
    }

    public boolean isShared() {
        return (this.flags & 0x4000) == 16384;
    }

    public boolean isFunctionDeclaration() {
        return (this.flags & 0x8000) == 32768;
    }

    public Symbol createUnshared(String newName) {
        assert (this.isShared());
        return new Symbol(this, newName, this.flags & 0xFFFFBFFF);
    }

    public void setIsScope() {
        if (!this.isScope()) {
            this.trace("SET IS SCOPE");
            assert (!this.isShared());
            this.flags |= 0x10;
        }
    }

    public void setIsShared() {
        if (!this.isShared()) {
            assert (this.isTemp());
            this.trace("SET IS SHARED");
            this.flags |= 0x4000;
        }
    }

    public void setIsFunctionDeclaration() {
        if (!this.isFunctionDeclaration()) {
            this.trace("SET IS FUNCTION DECLARATION");
            this.flags |= 0x8000;
        }
    }

    public boolean isVar() {
        return (this.flags & 7) == 3;
    }

    public boolean isGlobal() {
        return (this.flags & 7) == 2;
    }

    public boolean isParam() {
        return (this.flags & 7) == 4;
    }

    public boolean isAlwaysDefined() {
        return this.isParam() || (this.flags & 0x100) == 256;
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public boolean isNonGenericReturn() {
        return this.getName().equals(CompilerConstants.RETURN.symbolName()) && this.type != Type.OBJECT;
    }

    public boolean isSpecializedParam() {
        return (this.flags & 0x2000) == 8192;
    }

    public boolean canBePrimitive() {
        return (this.flags & 0x200) == 512;
    }

    public boolean canBeUndefined() {
        return (this.flags & 0x40) == 64;
    }

    public void setCanBeUndefined() {
        assert (this.type.isObject()) : this.type;
        if (this.isAlwaysDefined()) {
            return;
        }
        if (!this.canBeUndefined()) {
            assert (!this.isShared());
            this.flags |= 0x40;
        }
    }

    public void setCanBePrimitive(Type type) {
        if (!this.canBePrimitive()) {
            assert (!this.isShared());
            this.flags |= 0x200;
        }
    }

    public boolean isConstant() {
        return (this.flags & 7) == 5;
    }

    public boolean isInternal() {
        return (this.flags & 0x800) != 0;
    }

    public boolean isThis() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isLet() {
        return (this.flags & 0x400) == 1024;
    }

    public void setIsLet() {
        if (!this.isLet()) {
            assert (!this.isShared());
            this.flags |= 0x400;
        }
    }

    public boolean isFunctionSelf() {
        return (this.flags & 0x1000) == 4096;
    }

    public int getFieldIndex() {
        assert (this.fieldIndex != -1) : "fieldIndex must be initialized " + this.fieldIndex;
        return this.fieldIndex;
    }

    public void setFieldIndex(int fieldIndex) {
        if (this.fieldIndex != fieldIndex) {
            assert (!this.isShared());
            this.fieldIndex = fieldIndex;
        }
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        if (this.flags != flags) {
            assert (!this.isShared());
            this.flags = flags;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getSlot() {
        return this.slot;
    }

    public void increaseUseCount() {
        ++this.useCount;
    }

    public int getUseCount() {
        return this.useCount;
    }

    public void setSlot(int slot) {
        if (slot != this.slot) {
            assert (!this.isShared());
            this.trace("SET SLOT " + slot);
            this.slot = slot;
        }
    }

    public void setType(Class<?> type) {
        assert (!type.isPrimitive() && !Number.class.isAssignableFrom(type)) : "Class<?> types can only be subclasses of object";
        this.setType(Type.typeFor(type));
    }

    public void setType(Type type) {
        this.setTypeOverride(Type.widest(this.type, type));
    }

    public boolean wouldChangeType(Type newType) {
        return Type.widest(this.type, newType) != this.type;
    }

    public void setTypeOverride(Type type) {
        Type old = this.type;
        if (old != type) {
            assert (!this.isShared());
            this.trace("TYPE CHANGE: " + old + "=>" + type + " == " + type);
            this.type = type;
        }
    }

    public Symbol setTypeOverrideShared(Type type, TemporarySymbols ts) {
        if (this.getSymbolType() != type) {
            if (this.isShared()) {
                assert (!this.hasSlot());
                return ts.getTypedTemporarySymbol(type);
            }
            this.setTypeOverride(type);
        }
        return this;
    }

    public static void setSymbolIsScope(LexicalContext lc, Symbol symbol) {
        symbol.setIsScope();
        if (!symbol.isGlobal()) {
            lc.setBlockNeedsScope(lc.getDefiningBlock(symbol));
        }
    }

    private void trace(String desc) {
        if (TRACE_SYMBOLS != null && (TRACE_SYMBOLS.isEmpty() || TRACE_SYMBOLS.contains(this.name))) {
            Context.err(Debug.id(this) + " SYMBOL: '" + this.name + "' " + desc);
            if (TRACE_SYMBOLS_STACKTRACE != null && (TRACE_SYMBOLS_STACKTRACE.isEmpty() || TRACE_SYMBOLS_STACKTRACE.contains(this.name))) {
                new Throwable().printStackTrace(Context.getCurrentErr());
            }
        }
    }

    static {
        StringTokenizer st;
        String trace;
        String stacktrace = Options.getStringProperty("nashorn.compiler.symbol.stacktrace", null);
        if (stacktrace != null) {
            trace = stacktrace;
            TRACE_SYMBOLS_STACKTRACE = new HashSet<String>();
            st = new StringTokenizer(stacktrace, ",");
            while (st.hasMoreTokens()) {
                TRACE_SYMBOLS_STACKTRACE.add(st.nextToken());
            }
        } else {
            trace = Options.getStringProperty("nashorn.compiler.symbol.trace", null);
            TRACE_SYMBOLS_STACKTRACE = null;
        }
        if (trace != null) {
            TRACE_SYMBOLS = new HashSet<String>();
            st = new StringTokenizer(trace, ",");
            while (st.hasMoreTokens()) {
                TRACE_SYMBOLS.add(st.nextToken());
            }
        } else {
            TRACE_SYMBOLS = null;
        }
    }
}

