/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.control.Logging;
import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import java.util.WeakHashMap;
import javafx.scene.Node;
import javafx.scene.control.FocusModel;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class TreeCellBehavior
extends CellBehaviorBase<TreeCell<?>> {
    private static final WeakHashMap<TreeView, Integer> map = new WeakHashMap();
    private boolean latePress = false;
    private final boolean isEmbedded = PlatformUtil.isEmbedded();
    private boolean wasSelected = false;

    static int getAnchor(TreeView treeView) {
        FocusModel focusModel = treeView.getFocusModel();
        if (focusModel == null) {
            return -1;
        }
        return TreeCellBehavior.hasAnchor(treeView) ? map.get(treeView).intValue() : focusModel.getFocusedIndex();
    }

    static void setAnchor(TreeView treeView, int n) {
        if (treeView != null && n < 0) {
            map.remove(treeView);
        } else {
            map.put(treeView, n);
        }
    }

    static boolean hasAnchor(TreeView treeView) {
        return map.containsKey(treeView) && map.get(treeView) != -1;
    }

    public TreeCellBehavior(TreeCell treeCell) {
        super(treeCell);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl = ((TreeCell)this.getControl()).isSelected();
        if (((TreeCell)this.getControl()).isSelected()) {
            this.latePress = true;
            return;
        }
        this.doSelect(mouseEvent);
        if (this.isEmbedded && bl) {
            this.wasSelected = ((TreeCell)this.getControl()).isSelected();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.latePress) {
            this.latePress = false;
            this.doSelect(mouseEvent);
        }
        this.wasSelected = false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.latePress = false;
        TreeView treeView = ((TreeCell)this.getControl()).getTreeView();
        if (treeView == null || treeView.getSelectionModel() == null) {
            return;
        }
        if (this.isEmbedded && !this.wasSelected && ((TreeCell)this.getControl()).isSelected()) {
            treeView.getSelectionModel().clearSelection(((TreeCell)this.getControl()).getIndex());
        }
    }

    private void doSelect(MouseEvent mouseEvent) {
        MouseButton mouseButton;
        TreeCell treeCell = (TreeCell)this.getControl();
        TreeView treeView = treeCell.getTreeView();
        if (treeView == null) {
            return;
        }
        if (treeCell.isEmpty() || !treeCell.contains(mouseEvent.getX(), mouseEvent.getY())) {
            PlatformLogger platformLogger = Logging.getControlsLogger();
            if (!treeCell.isEmpty() || platformLogger.isLoggable(900)) {
                // empty if block
            }
            return;
        }
        int n = treeCell.getIndex();
        boolean bl = treeCell.isSelected();
        MultipleSelectionModel multipleSelectionModel = treeView.getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = treeView.getFocusModel();
        if (focusModel == null) {
            return;
        }
        Node node = treeCell.getDisclosureNode();
        if (node != null && node.getBoundsInParent().contains(mouseEvent.getX(), mouseEvent.getY())) {
            if (treeCell.getTreeItem() != null) {
                treeCell.getTreeItem().setExpanded(!treeCell.getTreeItem().isExpanded());
            }
            return;
        }
        if (mouseEvent.isShiftDown()) {
            if (!map.containsKey(treeView)) {
                TreeCellBehavior.setAnchor(treeView, focusModel.getFocusedIndex());
            }
        } else {
            map.remove(treeView);
        }
        if ((mouseButton = mouseEvent.getButton()) == MouseButton.PRIMARY || mouseButton == MouseButton.SECONDARY && !bl) {
            if (multipleSelectionModel.getSelectionMode() == SelectionMode.SINGLE) {
                this.simpleSelect(mouseEvent);
            } else if (mouseEvent.isControlDown() || mouseEvent.isMetaDown()) {
                if (bl) {
                    multipleSelectionModel.clearSelection(n);
                    focusModel.focus(n);
                } else {
                    multipleSelectionModel.select(n);
                }
            } else if (mouseEvent.isShiftDown()) {
                int n2 = TreeCellBehavior.getAnchor(treeView);
                int n3 = Math.min(n2, n);
                int n4 = Math.max(n2, n);
                multipleSelectionModel.clearSelection();
                multipleSelectionModel.selectRange(n3, n4 + 1);
                focusModel.focus(n);
            } else {
                this.simpleSelect(mouseEvent);
            }
        }
    }

    private void simpleSelect(MouseEvent mouseEvent) {
        TreeView treeView = ((TreeCell)this.getControl()).getTreeView();
        TreeItem treeItem = ((TreeCell)this.getControl()).getTreeItem();
        int n = ((TreeCell)this.getControl()).getIndex();
        MultipleSelectionModel multipleSelectionModel = treeView.getSelectionModel();
        boolean bl = multipleSelectionModel.isSelected(n);
        treeView.getSelectionModel().clearAndSelect(n);
        if (mouseEvent.getButton() == MouseButton.PRIMARY) {
            if (mouseEvent.getClickCount() == 1 && bl) {
                treeView.edit(treeItem);
            } else if (mouseEvent.getClickCount() == 1) {
                treeView.edit(null);
            } else if (mouseEvent.getClickCount() == 2) {
                if (treeItem.isLeaf()) {
                    treeView.edit(treeItem);
                } else {
                    treeItem.setExpanded(!treeItem.isExpanded());
                }
            }
        }
    }
}

